#include <iostream>
#include <cmath>     // atan
using std::ostream; using std::cout; using std::endl;

class Figura {
protected:
    static const double PI;
public:
    virtual double getPole() const      = 0;
    virtual double getObwod() const     = 0;
    virtual void   info(ostream&) const = 0;
    static  double totalPole(Figura* tab[], int size) {
        double suma = 0;
        for (int i = 0; i < size; ++i)
            suma += tab[i]->getPole();
        return suma;
    }
    static  Figura* maxObwod(Figura* tab[], int size) {
        int ind = 0;
        for (int i = 0; i < size; ++i)
            if (tab[i]->getObwod() >
                    tab[ind]->getObwod())
                ind = i;
        return tab[ind];
    }
};
const double Figura::PI = 4*atan(1.);
void Figura::info(ostream& str) const {
    str << "Figura: ";
}

class Kolo : public Figura {
    double promien;
public:
    Kolo(double r) : promien(r){ }
    double getPole()  const { return PI*promien*promien; }
    double getObwod() const { return 2*PI*promien; }
    void   info(ostream& str) const {
        Figura::info(str);
        str << "kolo o promieniu  " << promien;
    }
};

class Kwadrat : public Figura {
    double bok;
public:
    Kwadrat(double s) : bok(s) { }
    double getPole() const { return bok*bok; }
    double getObwod() const { return 4*bok; }
    void   info(ostream& str) const {
        Figura::info(str);
        str << "kwadrat o boku    " << bok;
    }
};

int main() {
    Figura* tab[] = { new Kolo(1.), new Kwadrat(1.),
                      new Kolo(2.), new Kwadrat(3.)
                    };
    int size = sizeof(tab)/sizeof(tab[0]);
    for (int i = 0; i < size; ++i) {
        tab[i]->info(cout);
        cout << endl;
    }
    Figura* maxobw = Figura::maxObwod(tab,size);
    cout << "Suma pol: " << Figura::totalPole(tab,size)
         << "\nFigura o najwiekszym obwodzie: ";
    maxobw->info(cout);
    cout <<  "\n ma obwod "
         << maxobw->getObwod() << endl;
    for (size_t i=0; i < std::size(tab); ++i) delete tab[i];
}
