from matplotlib import pyplot as plt
from PIL import Image, ImageDraw
import torch
import torchvision as tv

model = torch.nn.Sequential(
    torch.nn.Conv2d(1, 2, 1))

count = torch.randint(10, ()).item()
POSITIONS = torch.randint(64, (count, 2))
image = Image.new('L', (64, 64))
draw = ImageDraw.Draw(image)
for index in range(count):
    draw.ellipse([tuple(POSITIONS[index] - 4), tuple(POSITIONS[index] + 4)], fill = 255)
DATA = tv.transforms.functional.to_tensor(image).unsqueeze(0)
TARGET = DATA.type(torch.int64)

ACTIVATION = model(DATA)

VALUE = ACTIVATION.argmax(1)

plt.imshow(DATA[0, 0])

plt.show()
