from matplotlib import pyplot as plt
import torch
import torchvision as tv

set0 = tv.datasets.MNIST("../MNIST", train = True, download = True,
                         transform = tv.transforms.ToTensor())
loader0 = torch.utils.data.DataLoader(set0, batch_size = 100)

for DATA, TARGET in loader0:
    GRID = tv.utils.make_grid(DATA, nrow = 10)
    plt.imshow(GRID.permute(1, 2, 0))
    print(TARGET, flush = True)
    plt.show()
    input()
