from PIL import Image, ImageDraw
import torch
import torchvision as tv

model = torch.nn.Sequential(
    torch.nn.Conv2d(1, 8, 5), #60
    torch.nn.ReLU(),
    torch.nn.MaxPool2d(2), #30
    torch.nn.Flatten(),
    torch.nn.Linear(8 * 30 * 30, 256),
    torch.nn.ReLU(),
    torch.nn.Linear(256, 10))
variables = model.parameters()

batch = 1000
optimizer = torch.optim.Adam(variables)
for epoch in range(1000):
    optimizer.zero_grad()
    DATA = torch.empty(batch, 1, 64, 64)
    TARGET = torch.empty(batch, dtype = torch.int64)
    for sample in range(batch):
        count = torch.randint(10, ()).item()
        POSITIONS = torch.randint(64, (count, 2))
        image = Image.new('L', (64, 64))
        draw = ImageDraw.Draw(image)
        for index in range(count):
            draw.ellipse([tuple(POSITIONS[index] - 4), tuple(POSITIONS[index] + 4)], fill = 255)
        DATA[sample] = tv.transforms.functional.to_tensor(image)
        TARGET[sample] = count
    ACTIVATION = model(DATA)
    LOSS = torch.nn.functional.cross_entropy(ACTIVATION, TARGET)
    VALUE = ACTIVATION.argmax(1)
    ACCURACY = torch.eq(VALUE, TARGET).float().mean()
    LOSS.backward()
    optimizer.step()
    print("%4d %12.3f %4.3f" % (epoch, LOSS, ACCURACY), flush = True)

#accuracy: 937
