import torch
import torchvision as tv

samples0, samples1 = 60000, 10000
features = 784
classes = 10

source0 = tv.datasets.MNIST("../MNIST", train = True, download = True)
source1 = tv.datasets.MNIST("../MNIST", train = False, download = True)
DATA0 = source0.data.flatten(1).float()
DATA1 = source1.data.flatten(1).float()
TARGET0 = source0.targets
TARGET1 = source1.targets

size1 = 1024
BIAS1 = torch.zeros(1, size1, requires_grad = True)
WEIGHT1 = torch.zeros(features, size1, requires_grad = True)
BIAS = torch.zeros(1, classes, requires_grad = True)
WEIGHT = torch.zeros(size1, classes, requires_grad = True)
torch.nn.init.xavier_normal_(WEIGHT1)
variables = [BIAS, WEIGHT, BIAS1, WEIGHT1]

def model(SIGNAL):
    SIGNAL = BIAS1 + SIGNAL @ WEIGHT1
    SIGNAL = torch.nn.functional.relu(SIGNAL)
    SIGNAL = BIAS + SIGNAL @ WEIGHT
    return SIGNAL

batch = 100
optimizer = torch.optim.SGD(variables, lr = 0.1)
for epoch in range(100):
    LOSS0 = torch.zeros(())
    ACCURACY0 = torch.zeros(())
    count0 = 0
    for index in range(0, samples0, batch):
        optimizer.zero_grad()
        DATA = DATA0[index : index + batch]
        TARGET = TARGET0[index : index + batch]
        count = TARGET.size(0)
        ACTIVATION = model(DATA)
        LOSS = torch.nn.functional.cross_entropy(ACTIVATION, TARGET)
        LOSS0 += LOSS * count
        VALUE = torch.argmax(ACTIVATION, 1)
        ACCURACY0 += torch.sum(VALUE == TARGET)
        count0 += count
        LOSS.backward()
        optimizer.step()
    LOSS0 /= count0
    ACCURACY0 /= count0
    with torch.no_grad():
        LOSS1 = torch.zeros(())
        ACCURACY1 = torch.zeros(())
        count1 = 0
        for index in range(0, samples1, batch):
            DATA = DATA1[index : index + batch]
            TARGET = TARGET1[index : index + batch]
            ACTIVATION = model(DATA)
            LOSS1 += torch.nn.functional.cross_entropy(ACTIVATION, TARGET, reduction = "sum")
            VALUE = torch.argmax(ACTIVATION, 1)
            ACCURACY1 += torch.sum(VALUE == TARGET)
            count1 += TARGET.size(0)
        LOSS1 /= count1
        ACCURACY1 /= count1
    print("%4d %12.3f %4.3f %12.3f %4.3f" % \
          (epoch, LOSS0, ACCURACY0, LOSS1, ACCURACY1), flush = True)
