Text	segment	para 'CODE'
	org	100h
	assume	cs:Text
start:	push	cs		; set DS=CS
	pop	ds
	call	chk_mem		; check if high memory allocated for RPL
	push	bx		; save RPL segment to be freed
	mov	al,cs:[5dh]
	cmp	al,'M'
	jz	no_drv
	call	chk_tiv
	call	pkt_enb
	mov	ah,3Eh		; close boot image file
	int	64h		; (maybe disconnect closes it?)
	mov	dl,8		; and disconnect from all servers
discnl:	mov	ax,0F101h
	int	64h
	dec	dl
	jnz	discnl
	call	pkt_dsb
	xor	dx,dx
	mov	ds,dx
	mov	ax,2564h
	int	21h
	ifdef	keep65
	mov	al,cs:[5dh]
	cmp	al,'D'
	jz	no_drv
	endif
	mov	ax,2565h
	int	21h
no_drv:	pop	es
	mov	al,cs:[5dh]
	cmp	al,'D'
	jz	no_mem
	mov	ah,49h
	int	21h
no_mem:	call	msgex
	db	1,'Cleanup complete.',0Dh,0Ah,'$'

getimsk	proc	near
	cli
	mov	dx,021h
pktiimp	equ	word ptr [$-2]
	in	al,dx
	ret
getimsk	endp

pkt_enb	proc	near
	cli
	call	swapint
	call	getimsk
	and	al,not 4
pktiums	equ	byte ptr [$-1]
	out	dx,al
	ret
pkt_enb	endp

pkt_dsb	proc	near
	call	getimsk
	or	al,4
pktimsk	equ	byte ptr [$-1]
	out	dx,al
swapint	proc	near
	xor	bx,bx
	mov	es,bx
	mov	bl,0Ah
pktivec	equ	byte ptr [$-1]
	add	bx,bx
	add	bx,bx
	mov	ax,0FFF0h
pkivofs	equ	word ptr [$-2]
	xchg	ax,es:[bx]
	mov	pkivofs,ax
	mov	ax,0F000h
pkivseg	equ	word ptr [$-2]
	xchg	ax,es:[bx+2]
	mov	pkivseg,ax
	ret
swapint	endp
pkt_dsb	endp

chk_tiv	proc	near
	mov	ax,3564h	; check terminate info vector
	int	21h
	mov	ax,es
	or	ax,bx
	jz	noterm
	cmp	byte ptr es:[bx],0E8h
	jnz	noterm
	add	bx,3
	add	bx,es:[bx-2]
	cmp	byte ptr es:[bx],0BBh
	jnz	noterm
	cmp	word ptr es:[bx+3],0FA9Ch
	jnz	noterm
	cmp	byte ptr es:[bx+5],09Ah
	jnz	noterm
	cmp	byte ptr es:[bx+10],0C3h
	jnz	noterm
	mov	ax,es:[bx-8]
	mov	pktivec,al
	mov	ax,es:[bx-6]
	mov	pktimsk,al
	not	al
	mov	pktiums,al
	mov	byte ptr pktiimp,ah
	les	ax,es:[bx-4]
	mov	pkivofs,ax
	mov	pkivseg,es
	ret
noterm:	call	msgex
	db	2,'No terminate vector!',0Dh,0Ah,'$'
chk_tiv	endp

chk_mem	proc	near
	mov	bx,-1		; extend mem to max to know how much DOS have
	mov	ah,4Ah
	int	21h
	mov	ah,4Ah
	int	21h
	jc	chkmer
	mov	ax,es
	add	bx,ax		; top of DOS memory
	int	12h
	mov	cl,6
	shl	ax,cl		; top of BIOS memory
	cmp	ax,bx		; same?
	jz	noneed		; .. yes, no hidden drivers to remove
	xor	di,di		; make sure the MCB is for RPL
	mov	es,bx
	cld
	mov	si,offset Text:pattern
	mov	cx,3
	rep	cmpsb
	jnz	chkmer		; .. mismatch
	add	di,5
	mov	cx,8
	rep	cmpsb
	jnz	chkmer		; .. mismatch
	inc	bx
	ret
chkmer:	call	msgex
	db	2,'Cleanup error - bad memory!',0Dh,0Ah,'$'
noneed:	call	msgex
	db	1,'No need for cleanup.',0Dh,0Ah,'$'
pattern	db	'Z',8,0,'RPL',5 dup(0)
chk_mem	endp

	if	0
termpkt	proc	near
; access_type:	AH=2,AL=if_class,BX=if_type,DL=if_number,
;		DS:SI->type,CX=sizeof(type),ES:DI->int (far *receiver)();
;	r:	AX=handle
;		receiver: set ES=DI=0 to reject packet
; terminate:	AH=5,BX=handle
; example access_type: AX=0201,BX=-1,DL=1,CX=2
	mov	ax,3565h	; make sure packet driver present here
	int	21h
	mov	si,offset Text:PktSign
	mov	cx,9
	lea	di,[bx+3]
	cld
	repz	cmpsb
	jnz	nopkt
	mov	ax,0201h	; access Novell type packets
	mov	bx,-1
	mov	dl,1
	mov	cl,2		; CX was 0
	push	cs
	pop	es
	mov	di,offset pktrcvr
	int	65h
	jc	pkter
	xchg	ax,bx
	mov	ah,5
	int	65h
	jc	pktte
	ret
nopkt:	call	msgex
	db	2,'No packet driver.',0Dh,0Ah,'$'
pkter:	call	msgex
	db	2,'Fail to access packet driver!',0Dh,0Ah,'$'
pktte:	call	msgex
	db	2,'Fail to terminate packet driver!',0Dh,0Ah,'$'
PktSign	db	"PKT DRVR",0,0FFh,0FFh
pktrcvr	proc	far
	xor	di,di
	mov	es,di
	ret
pktrcvr	endp
termpkt	endp
	endif

msgex	label	near
	pop	si
	push	cs
	pop	ds
	lodsb
	xchg	ax,si
	xchg	ax,dx
	mov	ah,9
	int	21h
	xchg	ax,si
	mov	ah,4Ch
	int	21h

Text	ends
	end	start
