/* MPDFNB - Make Patched Driver For NetBoot
- remove 0-s from end of bootrom.bin
- put byte filename length, filename (in SYS:LOGIN for NW boot)
- put bytes 0xcd 0x20
- put commandline: byte length, length chars, 0x0d
- put the driver
- make sure total size is at most 63kB (need stack) */

#include <stdio.h>
#include <string.h>

char	jtboot[]="bootrom.bin", patched[]="patched.com",
	usage[]="MPDFNB - Make Patched Driver For NetBoot; Jerzy Tarasiuk\n"
		"Usage: MPDFNB server-filename driver driver-args\n";
char	drvargs[129];

FILE *inpf,*pdrf;

main(int ac, char **av) {
	unsigned l,t; int c;
	if(ac<3) { fprintf(stderr,usage); return -1; }

	/* process driver args */
	for(t=1,c=3; c<ac; c++) {
		drvargs[t++]=' '; t+=strlen(strcpy(drvargs+t,av[c]));
	} drvargs[t--]='\r'; drvargs[0]=t;

	/* copy my bootrom */
	if((inpf=fopen(jtboot,"rb"))==NULL) {
		strcpy(strchr(jtboot,'.'),".com");
		if((inpf=fopen(jtboot,"rb"))==NULL)
			{ jtbfe: perror(jtboot); return -1; }
	}
	if((pdrf=fopen(patched,"wb"))==NULL) { perror(patched); return -1; }
	for(l=t=0; (c=getc(inpf))!=EOF; )
		if(putc(c,pdrf)==EOF || ++l==0) goto wrf; else if(c) t=l;
	if(ferror(inpf)) goto jtbfe; fclose(inpf);
	if(fseek(pdrf,t,SEEK_SET)!=0) goto wrf;

	/* put filename length and the filename */
	if(fputc(l=strlen(av[1]),pdrf)==EOF || ++t==0
	|| (t+=l)<l || fputs(av[1],pdrf)==EOF
	/* put CD 20 */
	|| fputc(0xcd,pdrf)==EOF || ++t==0
	|| fputc(0x20,pdrf)==EOF || ++t==0) goto wrf;
	/* put driver args... how much space need? */
	for(c=-1; c<=drvargs[0]; )
		if(fputc(drvargs[++c],pdrf)==EOF || ++t==0) goto wrf;

	/* put the driver */
	if((inpf=fopen(av[2],"rb"))==NULL) { perror(av[2]); goto del; }
	while((c=getc(inpf))!=EOF)
		if(putc(c,pdrf)==EOF || ++t==0) goto wrf;
	/* make sure total size is small enough */
	if(t>=0xfe00 || fclose(pdrf)!=0) goto wrf;
	printf("%s ready, size=%u\n",patched,t); return 0;
wrf:	perror(patched);
del:	fclose(pdrf); unlink(patched); return -1;
}
