;++++	BootSect - bootsector program for MSDOS-type filesystem
;	Jerzy Tarasiuk				17-Oct-1996
;----	This code is copylefted (GNU General Public License applies)

;+++	BootSect - bootsector program for MSDOS-type filesystem
;	entry	should load this code to address 0:7C00h
;		and trasfer control to begin of the code
;		(usually BIOS does exactly it with bootsector)
;		disk parameter block (bytes 0Bh..3Dh) must be set
;		(including BootDrive byte at begin+24h, numbers
;		 of sectors per track, heads, FAT size)
;		and byte FatEntrySize (at begin+1FDh) must be set
;		to 3/4 for 12/16-bit FAT (no other FAT sizes)
;	exit	if a file named at label FileName (begin+1F2h)
;		is found in root directory of the disk,
;		the file is loaded immediately above the sector,
;		and control is transferred to its first byte, with
;		the segment/offset of this address normalized
;		(the offset is as small as possible, usually zero)
;		the stack is immediately before the boot sector,
;		and contains the following:
;		- size of the file loaded into memory (dword)
;		- position of the sector containing the directory
;		  entry which matched the file loaded (word; the
;		  position is negative, relative to data area)
;		- number of sectors used by root directory (word)
;		- CX and DX registers as they were on start
;		if the file isn't found, or disk error occurs,
;		an error diagnosis is shown and program hangs.
;	word immediately preceding the file name contains offset
;	of procedure which reads file given its first cluster
;	in AX, starting from address ES:BX, to 8000:0 or EOF.
;---

dblword		struc
lw		dw	?
hw		dw	?
dblword		ends

DirNtry		struc
de_fname	db	8+3 dup(?)
de_fattr	db	?
de_res1		db	10 dup(?)
de_ftime	dd	?
de_fclus	dw	?
de_fsize	dd	?
DirNtry		ends

DirEntrySize	=	20h

Text		segment	para 'CODE'
		org	7C00h
		assume	cs:Text
StartOfCode	label	byte
NearJump:	jmp	StartBoot
		if	StartOfCode+3-this byte
		nop
		endif
		db	"LoadBoot"
Bytes4Sector	dw	0200h
Sectors4Cluster	db	1
ReservedSectors	dw	1

NumberOfFats	db	2
RootDirEntries	dw	256
TotalSectors	dw	2400
MediaDescriptor	db	0F9h
Sectors4OneFat	dw	7
Sectors4Track	dw	15
HeadCount	dw	2
HiddenSectors	dd	0

TotalSectorsL	dd	0
BootDrive	db	80h,0
MiscFlags	db	29h
SerialNumber	dd	?
VolumeLabel	db	size de_fname dup (?)
FatType		db	"FAT12   "
EndOfParameters	label	byte

StartBoot	label	near
		mov	di,cs
		mov	ss,di
		mov	sp,offset StartOfCode
		xor	bx,bx
		mov	ds,bx
		lds	si,ds:[1Eh*4]
		mov	ax,Sectors4Track
		mov	ds:[si+4],al
		mov	ds,di
		assume	ds:Text
		mov	es,di
		mov	bx,sp
		push	dx
		push	cx
		call	AdvanceESBX
		mov	si,Bytes4Sector
		mov	ax,DirEntrySize
		mov	cx,RootDirEntries
		mul	cx
		dec	si
		add	ax,si
		adc	dl,dh		; assume root directory<16MB ;-)
		inc	si
		div	si		; ax = root dir size in sectors
		push	ax		; store to w[StartOfCode-6]
		neg	ax
StartBoot_1:	push	ax
		push	cx
		mov	dx,-1
		call	ReadDataSector
		mov	di,bx
		pop	cx
StartBoot_2:	push	cx
		mov	si,offset FileName
		mov	cx,size de_fname
		cld
		repz	cmpsb
		jz	StartBoot_3
		add	di,cx
		add	di,DirEntrySize-size de_fname
		mov	ax,Bytes4Sector
		add	ax,bx
		cmp	di,ax
		pop	cx
		loopnz	StartBoot_2
		pop	ax
		inc	cx
		inc	ax
		loopnz	StartBoot_1
		call	ErrorStop
		db	"Boot file not found$"
StartBoot_3:	pop	ax
		push	es:[di-size de_fname].de_fsize.hw
		push	es:[di-size de_fname].de_fsize.lw
		mov	ax,es:[di-size de_fname].de_fclus
		push	es		; put return address on stack
		push	bx

ReadClusters	proc	far		; read cluster chain starting from AX
		mov	di,bx		; changes: ES,AX,BX,CX,DX,SI,DI
		add	di,Bytes4Sector
		push	di
		mov	si,-1
ReadClusters_1:	cld
		stosw
		xchg	ax,dx
		mov	al,Text:FatEntrySize	; 3/4 for 12/16 bit FAT
		cbw
		mul	dx		; DXAX=2*offset from start of FAT
		shr	dx,1
		rcr	ax,1		; DXAX=offset, CF set if half byte
		pushf
		div	Bytes4Sector	; AX=sector, DX=offset in sector
		push	ax
		push	dx
		cmp	ax,si
		jz	ReadClusters_2
		call	ReadFatSector	; read the sector
ReadClusters_2:	pop	si		; SI=offset in sector
		mov	ax,es:[bx+si]	; AX=cluster... is it complete
		inc	si		; SI=offset of upper byte
		cmp	si,Bytes4Sector
		pop	si		; SI=sector
		jb	ReadClusters_3	; .. within sector, OK
		push	ax		; oh, the high byte is in next sector
		inc	si		; SI=the next sector
		push	si
		xchg	ax,si
		call	ReadFatSector	; read it
		pop	si
		pop	ax		; AL is already OK
		mov	ah,es:[bx]	; load AH from first byte of the sector
ReadClusters_3:	popf			; now: are we at half byte?
		jnc	ReadClusters_4	; .. no
		mov	cl,4		; .. yes, shift DX
		shr	ax,cl
ReadClusters_4:	cmp	byte ptr Text:FatEntrySize,4
		sbb	dh,dh		; 0 if 16, FF if 12-bit FAT
		and	dh,0F0h		; 0 if 16, F0 if 12-bit FAT
		or	ah,dh		; need clear top 4 bits if 12-bit
		xor	ah,dh
		mov	dl,9		; 0009 or F009 (-FFF7 or -0FF7)
		add	dx,ax		; CF set if new cluster too big
		jnc	ReadClusters_1
		pop	dx
		xor	ax,ax
		push	ax
ReadClusters_5:	dec	di
		dec	di
		push	es:[di]
		cmp	di,dx
		ja	ReadClusters_5
ReadClusters_6:	pop	dx
		test	dx,dx
		jz	ReadClusters_9
		mov	cl,Sectors4Cluster
		mov	ch,0
ReadClusters_7:	mov	al,Sectors4Cluster
		mov	ah,0
		push	dx
		push	cx
		dec	dx
		mul	dx
		sub	ax,cx
		sbb	dl,dh		; fortunately the MUL always sets DH=0
		call	ReadDataSector
		call	AdvanceESBX
		pop	cx
		pop	dx
		loop	ReadClusters_7
		jns	ReadClusters_6
ReadClusters_8:	pop	dx
		test	dx,dx
		jnz	ReadClusters_8
ReadClusters_9:	ret
ReadClusters	endp

ReadDataSector	proc	near		; entry: DXAX - sector (r.to data area)
		push	dx		;	 ES:BX - buffer address
		push	ax		; changes: AX,CX,DX,SI
		mov	al,NumberOfFats
		cbw			; assume <128 FAT copies ;-)
		mul	Sectors4OneFat
		add	ax,word ptr ds:[StartOfCode-6]
		adc	dl,dh
ReadSector_0:	xchg	ax,si
		mov	ax,Sectors4Track
		mul	byte ptr HeadCount
		xchg	ax,si
		add	ax,ReservedSectors
		adc	dl,dh		; assume reserved+FATs+dir<16MB ;-)
		pop	cx
		add	ax,cx
		pop	cx
		adc	dx,cx
		add	ax,HiddenSectors.lw
		adc	dx,HiddenSectors.hw
		div	si		; ax=cylinder, dx=sector_on_cyl
		xchg	al,ah
		ror	al,1
		ror	al,1
		inc	ax
		xchg	ax,cx
		xchg	ax,dx
		div	byte ptr Sectors4Track
		mov	dh,al
		add	cl,ah
		mov	dl,BootDrive
		mov	si,10
ReadSector_1:	mov	ax,0201h
		int	13h
		jnc	ReadSector_2
		dec	si
		jnz	ReadSector_1
		call	ErrorStop
		db	"Disk read error$"
ReadSector_2:	ret
ReadFatSector	label	near		; entry: AX=FAT sector (from 0)
		xor	dx,dx
		push	dx
		push	dx
		jmp	ReadSector_0
ReadDataSector	endp

ErrorStop	proc	near		; display message following call
		pop	si		; no return: hangs
		mov	bx,0Fh
ErrorStop_1:	lodsb
		cmp	al,'$'
		jz	$
		mov	ah,0Eh
		int	10h
		jmp	ErrorStop_1
ErrorStop	endp

AdvanceESBX	proc	near		; advance ES:BX by Bytes4Sector & norm.
		add	bx,Bytes4Sector	; changes: ES,AX,BX,CX
		mov	cl,4		; (final AX=ES, flags from setting AX)
		mov	ax,bx
		and	bx,0Fh
		shr	ax,cl
		mov	cx,es
		add	ax,cx
		mov	es,ax
		ret
AdvanceESBX	endp

		org	StartOfCode+200h-10h
		dw	ReadClusters
FileName	db	"BOOTFILEBIN"
		org	StartOfCode+200h-3
FatEntrySize	db	4
BootSignature	db	55h,0AAh
Text		ends
		end
