	title	EXEC.SYS - a "device driver" to invoke .COM or .EXE

;----	EXEC.SYS - a "device driver" to invoke .COM or .EXE
;
;	Jerzy Tarasiuk				04-Nov-1999
;
;	This code is intended to be public domain, under terms of the
;	GNU General Public License statement (in short, everyone can
;	copy, use or modify it, but should give source code and inform
;	everyone who gets the code that he/she has the rights).
;	A copy of the GNU General Public License should be distributed
;	along with this program; if not, write to the Free Software
;	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.;

NameLng	=	128

	extrn	_stktop:word

Text	segment	para 'CODE'

	assume	CS:Text
	extrn	_main:far
	public	_exec_help

;	Device Header
;
	dd	-1			; next device pointer
	dw	8000h			; character device
	dw	strat			; pointer to strategy routine
	dw	inter			; pointer to interrupt routine
dvn	db	"DumDrvr "		; device name

;	Request Header
;
reqhdr	struc
rh_l	db	?			; request length
rh_u	db	?			; device unit
rh_c	db	?			; command
rh_s	dw	?			; status
rh_r	db	?,?,?,?,?,?,?,?		; 8-byte reserved area
rh_n	db	?			; number of units
rh_eo	dw	?			; end of driver
rh_es	dw	?
rh_a	dd	?			; argument address
rh_d	db	?			; drive number
reqhdr	ends

;	Driver reply codes:
;
ErrUnkn	=	8103h			; unknown command
Done_OK	=	0100h			; done, OK

;	DOS function codes:
;
ChrOut	=	02h
StrOut	=	09h
Create	=	3Ch
Open	=	3Dh
Close	=	3Eh
Read	=	3Fh
Write	=	40h
Erase	=	41h
GetTim	=	5700h
SetTim	=	5701h

;	character codes
;
LF	=	0Ah
CR	=	0Dh
blank	=	' '

rptr	label	dword
rofs	dw	?			; request offset
rseg	dw	?			; request segment

o_sp	dw	?
o_ss	dw	?
x_sp	dw	?

strat	proc	far			; strategy routine
	mov	rofs,BX
	mov	rseg,ES
	ret
strat	endp

inter	proc	far			; interrupt routine
	push	AX
	push	BX
	push	CX
	push	DX
	push	SI
	push	DI
	push	BP
	push	DS
	push	ES
	xor	AX,AX
	lds	BX,rptr
	cmp	[BX].rh_c,AL
	jz	i0			; (the only known is INIT)
	mov	[BX].rh_s,ErrUnkn	; unknown command
	jmp	i5			; signal error
i0:	mov	[BX].rh_n,AL
	mov	[BX].rh_eo,AX
	mov	[BX].rh_es,CS
	mov	[BX].rh_s,Done_OK	; done, OK
	les	DI,[BX].rh_a		; get arguments string
	mov	o_ss,SS
	mov	o_sp,SP
	mov	AX,seg _stktop
	mov	DS,AX
	mov	SS,AX
	mov	SP,DS:_stktop
	push	ES
	push	DI
	call	_main
	pop	CX
	pop	CX
	mov	SS,o_ss
	mov	SP,o_sp
	jcxz	i9			; if no error occured
i5:	mov	AX,0E07h		; alarm
	int	10h
	push	CS
	pop	DS
	lea	DX,errmsg
	mov	AH,StrOut
	int	21h
	lds	BX,rptr
	lds	SI,[BX].rh_a		; get arguments string
	cld
	mov	CX,NameLng
i6:	lodsb
	xchg	AX,DX
	mov	AH,ChrOut
	int	21h
	cmp	DL,LF
	loopnz	i6
	jz	i7
	mov	DL,LF
	mov	AH,ChrOut
	int	21h
i7:	mov	DL,CR
	mov	AH,ChrOut
	int	21h
i8:	mov	AH,1			; wait keypress
	int	16h
	pushf
	mov	AH,0
	int	16h
	popf
	jnz	i8
i9:	pop	ES
	pop	DS
	pop	BP
	pop	DI
	pop	SI
	pop	DX
	pop	CX
	pop	BX
	pop	AX
	ret
inter	endp

_exec_help	proc	far	; assume registers DS:DX,ES:BX to be set
		push	BP
		mov	CS:x_sp,SP
		mov	AX,4B00h
		int	21h
		mov	CX,seg _stktop
		mov	DS,CX
		mov	SS,CX
		mov	SP,x_sp
		cmc		; return -1 on success, errorcode on error
		sbb	CX,CX
		or	AX,CX
		pop	BP
		ret
_exec_help	endp

errmsg	db	'EXEC.SYS - a "device driver" to invoke .COM or .EXE',CR,LF
	db	"Copyright (C) Jerzy Tarasiuk <jt@fuw.edu.pl>"
	db	"; free software - no warranty",CR,LF
	db	"GNU General Public License applies, "
	db	"if you don't have a copy, write to",CR,LF
	db	"Free Software Foundation, Inc., 675 Mass Ave, "
	db	"Cambridge, MA 02139, USA.",CR,LF
	db	"Error caused by CONFIG.SYS line",CR,LF,"DEVICE=$"

Text	ends
	end
