      function dilog(x)
!--------------------------------------------------------------------
!
!   Purpose           - dilogarithm function of a real argument
!
!--------------------------------------------------------------------
      implicit real (16)      (a-h,o-z)
      real (16), parameter :: zero = 0.0q0
      real (16), parameter :: one  = 1.0q0
      real (16), parameter :: half = 0.5q0
      real (16), parameter :: pi = 3.141592653589793238462643383279502884q0
!
      pi2  = pi**2/6
!
      if (x.eq.zero) then
         dilog = pi2
         return
      else if (x.eq.one) then
         dilog = zero
         return
      end if
      if (abs(one-x) <= one .AND. x >= half) then
         y = -log(x)
         dilog = debay(y)
      else if (abs(x) <= one .AND. x < half) then
         y = -log(one-x)
         cc = pi2-log(one-x)*log(x)
         dilog = cc-debay(y)
      else
         xx = one/x
         y = -log(one-xx)
         cc = pi2-log(one-xx)*log(xx)
         cc = cc-debay(y)
         dilog = -half*log(xx)**2-cc
      end if
!
      return

CONTAINS

function debay(z)
!----------------------------------------------------------------------
!
!   Purpose           - calculates Debay function (for n=1) of a complex
!                         argument using Taylor's series at z=0
!
!----------------------------------------------------------------------
implicit real (16) (a-h,o-z)
real (16), save      :: b(30)
real (16), parameter :: zero = 0.0q0
real (16), parameter :: one  = 1.0q0
real (16), parameter :: fourth = 0.25q0
logical,     save      :: notinit= .true.

if (notinit) then
   b( 1) =  2.7777777777777777777777777777777777777777777777778q-02
   b( 2) = -2.7777777777777777777777777777777777777777777777778q-04
   b( 3) =  4.7241118669690098261526832955404383975812547241119q-06
   b( 4) = -9.1857730746619635508524397413286302175191064079953q-08
   b( 5) =  1.8978869988970999072009173019274029375039476049577q-09
   b( 6) = -4.0647616451442255268059093862919666745470571274397q-11
   b( 7) =  8.9216910204564525552179873167527488515142836130490q-13
   b( 8) = -1.9939295860721075687236443477937897056306947496539q-14
   b( 9) =  4.5189800296199181916504765528555932283968190144666q-16
   b(10) = -1.0356517612181247014483411542218656665960912381687q-17
   b(11) =  2.3952186210261867457402837430009803816789490019430q-19
   b(12) = -5.5817858743250093362830745056254199055670546676444q-21
   b(13) =  1.3091507554183212858123073991865923017498498387833q-22
   b(14) = -3.0874198024267402932422797648664624315955652561327q-24
   b(15) =  7.3159756527022034203579056092521485910334010636909q-26
   b(16) = -1.7408456572340007409890551477597025453408414217543q-27
   b(17) =  4.1576356446138997196178996207752266734882541595116q-29
   b(18) = -9.9621484882846221031940067024558388498548600173945q-31
   b(19) =  2.3940344248961653005211679878937495629342791569329q-32
   b(20) = -5.7683473553673900842917931618776542440723323179263q-34
   b(21) =  1.3931794796470079778278866039115483317324116256734q-35
   b(22) = -3.3721219654850894704684736352549309589797428916565q-37
   b(23) =  8.1782087775621026217647772148728342678761894624955q-39
   b(24) = -1.9870108311523859255648206692347865675418589958247q-40
   b(25) =  4.8357785180405508962870593731153782076944653694208q-42
   b(26) = -1.1786937248718384326695767537213903193540705623059q-43
   b(27) =  2.8770964081172571450019667396886617096883686589417q-45
   b(28) = -7.0320590981560280149649336675824257240019745278063q-47
   b(29) =  1.7208603145033146290899515161658919198419990913276q-48
   b(30) = -4.2160723905604454916800318192859916156937012298717q-50
   notinit = .false.
end if

z2 = z*z
sm = zero
yk = one
do k=1,30
   yk = yk*z2
   test = sm
   sm = sm+b(k)*yk
   if (test.eq.sm) exit
end do
debay = z*(one-fourth*z+sm)

return
end function debay

end function dilog

