*********1*********2*********3*********4*********5*********6*********7** 

      PROGRAM HELIUM
C
C     MINIMALIZATION OF ENERGY OF HELIUM ARBITRARY STATE
C     KOROBOV INVERSE ITERATION
C     DOUBLE BASIS SET
C     NO MASS POLARIZATION
C     QUADRUPLE  PRECISION
C     SUBPLX MINIMIZATION
     
      IMPLICIT NONE
      INTEGER M,I,N
      PARAMETER (M=12,N=300)
      INTEGER IWORK(2*M),NFE,IFLAG,MAXNFE,MODE
      REAL*8  X(M),ES,SL(M),WORK(M**2+6*M+1),FX,TOL
      REAL*16 F,DRAKE
      LOGICAL MINI
      EXTERNAL ES,SUBPLX
      COMMON DRAKE,MINI
    
      INCLUDE "X_02_1S0.DAT"

C      OPEN(UNIT=9,FILE="tmp.dat",FORM='UNFORMATTED')
C      READ(9) DRAKE   
C      DO I=1,M
C      READ(9) X(I)
C      ENDDO     
C      CLOSE(9)

      MINI = .TRUE.

      IF(MINI) THEN
       TOL = 0.0001D0
       MAXNFE = 10000
       MODE = 0
       DO I=1,M
        SL(I) = 0.1D0
       ENDDO
       CALL SUBPLX(ES,M,TOL,MAXNFE,MODE,SL,X,FX,NFE,WORK,IWORK,IFLAG)     

       WRITE(*,*) 'NFE=',NFE
       WRITE(*,*) 'IFLAG=',IFLAG
       WRITE(*,*) 'ES=',FX

       F = FX+DRAKE
       WRITE(*,*) 'N=',N
       WRITE(*,*) 'FINAL VALUES, E=',F
       DO I=1,M
        PRINT 01,I,X(I)
       ENDDO
   01  FORMAT ('      X(',I2,')=',1PD23.16)

       OPEN(UNIT=9,FILE="tmp.dat",FORM='UNFORMATTED')
       WRITE(9) DRAKE
       DO I=1,M
        WRITE(9) X(I)
        ENDDO     
       CLOSE(9)
      
      ELSE
       WRITE(*,*) 'N=',N
       FX = ES(M,X)
       F = FX+DRAKE
       WRITE(*,*) 'E=',F
      ENDIF

      END    

*********1*********2*********3*********4*********5*********6*********7** 

      FUNCTION ES(M,X)
      IMPLICIT NONE
      INTEGER N,I,ITMAX,M,J,K,IT
      PARAMETER (N=300)
      INTEGER IPIV(N)
      REAL*8  X(M),ES,ESSAVE
      REAL*16 HH(N*(N+1)/2),DN(N*(N+1)/2),WA(3*N+1)
      REAL*16 V(N),PHI(N,3),EP,EPS,DRAKE
      CHARACTER  str*36, output_file*40
      LOGICAL MINI
      SAVE IT,ESSAVE
      COMMON DRAKE,MINI
   
      IT = IT+1
      IF(IT.EQ.1) ESSAVE=100.D0
      EP = DRAKE -1.D-5
      EPS= 0.0D0
C      EPS= 1.D-28
      ITMAX = 30
      DO I=1,N
      V(I) = 1.D0
      ENDDO

      CALL PARA2(PHI,X,N) 
      CALL HAMLNORM(HH,DN,PHI,N)

C     KOROBOV TRICK
C      DO I=1,N
C      DN(I*(I+1)/2) = DN(I*(I+1)/2)*(1.D0+EPS)
C      ENDDO

      CALL invsg(HH,DN,N,EP,V,EPS,0,ITMAX,WA)

       ES = EP-DRAKE
      IF (MINI) THEN
       IF(ES.LT.ESSAVE) THEN
        ESSAVE=ES
        WRITE(*,*) 
        WRITE(*,*) 'IT=',IT
        WRITE(*,*) 'ES=',ES
        WRITE(*,*) 'E=   ',EP
        DO I=1,M
         PRINT 01,I,X(I)
        ENDDO
        OPEN(UNIT=9,FILE="tmp.dat",FORM='UNFORMATTED')
        DO I=1,M
         WRITE(9) X(I)
        ENDDO     
        CLOSE(9)
       ELSE
        WRITE(*,*) 'IT=',IT
 
       ENDIF
   01  FORMAT ('      X(',I2,')=',1PD23.16)
      ELSE
       WRITE( output_file, '( "wf_1S0_", i0,"_qu.dat" )' ) N
       OPEN(UNIT=9,FILE=output_file,FORM='UNFORMATTED')
       DO I=1,N
       WRITE(9) PHI(I,1),PHI(I,2),PHI(I,3),V(I)
       ENDDO
       CLOSE(9)
      ENDIF

      RETURN
      END

*********1*********2*********3*********4*********5*********6*********7**

      INCLUDE "ham_S0.f"

*************************************************************************
 
      SUBROUTINE PARA2(PHI,X,N)
C
C     GENERATES INITIAL 3 N NONLINEAR PARAMETERS
C
      INTEGER I,NL,N,Z    
      REAL*8 A1,A2,B1,B2,C1,C2,T1,T2,T3,X(12),DE
      REAL*16 PHI(N,3)
      REAL Y(3)
 
C     THE ASYMPTOTIC WAVE FUNCTION DECAYS ACCORDING TO DE=SQRT(2*E_DISSOCIATION)
C     THEREFORE NONLINEAR PARAMETERS SHOULD BE NOT MUCH SMALLER
C     DE SHOULD BE SET BY HAND FOR A CONSIDERED SYSTEM DE=SQRT(2(2-E))

      CALL RMARIN(6,17)
      Z=2
      SELECT CASE (Z)
      CASE(2)
       DE = 1.3D0
      CASE(3)
       DE = 2.3D0
      CASE(4)
       DE = 3.3D0
      CASE(5)
       DE = 4.3D0
      CASE DEFAULT
       STOP 'DE NOT SELECTED'
      END SELECT

      A1 = X(1)
      A2 = X(2)
      B1 = X(3)
      B2 = X(4)
      C1 = X(5)
      C2 = X(6) 
 
      DO I=1,N/2
 
 10   CONTINUE
      CALL RANMAR(Y,3)
    
      T1 = Y(1)*(A2-A1)+A1
      T2 = Y(2)*(B2-B1)+B1
      T3 = Y(3)*(C2-C1)+C1  
 
      IF((T1+T2).LT.DE .OR. (T2+T3).LT.DE .OR. (T1+T3).LT.DE) GOTO 10

       PHI(I,1) = T1
       PHI(I,2) = T2
       PHI(I,3) = T3
      ENDDO


      A1 = X(7)
      A2 = X(8)
      B1 = X(9)
      B2 = X(10)
      C1 = X(11)
      C2 = X(12) 
 
      DO I=N/2+1,N
 
 11      CONTINUE
      CALL RANMAR(Y,3)
    
      T1 = Y(1)*(A2-A1)+A1
      T2 = Y(2)*(B2-B1)+B1
      T3 = Y(3)*(C2-C1)+C1  
 
      IF((T1+T2).LT.DE .OR. (T2+T3).LT.DE .OR. (T1+T3).LT.DE) GOTO 11

       PHI(I,1) = T1
       PHI(I,2) = T2
       PHI(I,3) = T3
      ENDDO

       RETURN
      END

*************************************************************************

      subroutine RMARIN(IJ,KL)
C This is the initialization routine for the random number generator RANMAR()
C NOTE: The seed variables can have values between:    0 <= IJ <= 31328
C                                                      0 <= KL <= 30081
C The random number sequences created by these two seeds are of sufficient 
C length to complete an entire calculation with. For example, if sveral 
C different groups are working on different parts of the same calculation,
C each group could be assigned its own IJ seed. This would leave each group
C with 30000 choices for the second seed. That is to say, this random 
C number generator can create 900 million different subsequences -- with 
C each subsequence having a length of approximately 10^30.
C 
C Use IJ = 1802 & KL = 9373 to test the random number generator. The
C subroutine RANMAR should be used to generate 20000 random numbers.
C Then display the next six random numbers generated multiplied by 4096*4096
C If the random number generator is working properly, the random numbers
C should be:
C           6533892.0  14220222.0  7275067.0
C           6172232.0  8354498.0   10633180.0


      real U(97), C, CD, CM
      integer I97, J97
      logical TEST,tesst
      data TEST /.FALSE./
      common /raset1/ U, C, CD, CM, I97, J97, TESst
      tesst=test    
      if( IJ .lt. 0  .or.  IJ .gt. 31328  .or.
     *    KL .lt. 0  .or.  KL .gt. 30081 ) then
          print '(A)', ' The first random number seed must have a value 
     *between 0 and 31328'
          print '(A)',' The second seed must have a value between 0 and         
     *30081'
            stop
      endif

      i = mod(IJ/177, 177) + 2
      j = mod(IJ    , 177) + 2
      k = mod(KL/169, 178) + 1
      l = mod(KL,     169) 

      do 2 ii = 1, 97
         s = 0.0
         t = 0.5
         do 3 jj = 1, 24
            m = mod(mod(i*j, 179)*k, 179)
            i = j
            j = k
            k = m
            l = mod(53*l+1, 169)
            if (mod(l*m, 64) .ge. 32) then
               s = s + t
            endif
            t = 0.5 * t
3        continue
         U(ii) = s
2     continue

      C = 362436.0 / 16777216.0
      CD = 7654321.0 / 16777216.0
      CM = 16777213.0 /16777216.0

      I97 = 97
      J97 = 33

      TESsT = .TRUE.
      return
      end

      subroutine ranmar(RVEC, LEN)
C This is the random number generator proposed by George Marsaglia in 
C Florida State University Report: FSU-SCRI-87-50
C It was slightly modified by F. James to produce an array of pseudorandom
C numbers.
      REAL RVEC(*)
      real U(97), C, CD, CM
      integer I97, J97
      logical TEST
      common /raset1/ U, C, CD, CM, I97, J97, TEST
 
      integer ivec
 
      if( .NOT. TEST ) then
         print '(A)',' Call the init routine (RMARIN) before calling RAN 
     *MAR'  
         stop
      endif

      do 100 ivec = 1, LEN
         uni = U(I97) - U(J97)
         if( uni .lt. 0.0 ) uni = uni + 1.0
         U(I97) = uni
         I97 = I97 - 1
         if(I97 .eq. 0) I97 = 97
         J97 = J97 - 1
         if(J97 .eq. 0) J97 = 97
         C = C - CD
         if( C .lt. 0.0 ) C = C + CM
         uni = uni - C
         if( uni .lt. 0.0 ) uni = uni + 1.0
         RVEC(ivec) = uni
100   continue
      return
      end

*********1*********2*********3*********4*********5*********6*********7**
