(* Generated by SMEFTParFile routine *)
(* 28.4.2023 19:41 *)

(* Active operators included in Feynman Rules: {dphi, eB, ll, phi, phi4n1, phi4n3, phi8, phiBox, phiD, phiW, phiWB, uW} *)

(* SmeftFR v3.0 package *)
(* Contains definitions of SMEFT parameters in Warsaw basis *)

(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)
M$Parameters = {

(* INTERNAL PARAMETERS *)

(* field and gauge normalization factors *)

(* Physical Higgs H *)
Hnorm == {
  ParameterType -> Internal,
  Indices -> {},
  ComplexParameter -> False,
  Description -> "Physical Higgs normalization"
},

(* Neutral Goldstone G0 *)
G0norm == {
  ParameterType    -> Internal,
  Indices          -> {},
  ComplexParameter -> False,
  Description      -> "Neutral Goldstone normalization"
},

(* Charged Goldstone GP *)
GPnorm == {
  ParameterType    -> Internal,
  Indices          -> {},
  ComplexParameter -> False,
  Description      -> "Neutral Goldstone normalization"
},

(* Physical Z and photon *)
AZnorm == {
  ParameterType    -> Internal,
  Indices          -> {SU2W,SU2W},
  ComplexParameter -> False,
  Description      -> "Physical Z and photon mixing matrix"
},

(* Physical W *)
Wnorm == {
  ParameterType -> Internal,
  Indices -> {},
  ComplexParameter -> False,
  Description -> "W normalization"
},

(* Physical gluon *)
Gnorm == {
  ParameterType -> Internal,
  Indices -> {},
  ComplexParameter -> False,
  Description -> "Gluon normalization"
},

(* g1 normalization *)
g1norm == {
  ParameterType -> Internal,
  Indices -> {},
  ComplexParameter -> False,
  Description -> "g1 coupling normalization"
},

(* gw normalization *)
gwnorm == {
  ParameterType -> Internal,
  Indices -> {},
  ComplexParameter -> False,
Description -> "gw coupling normalization"
},

(* gs normalization *)
gsnorm == {
  ParameterType -> Internal,
  Indices -> {},
  ComplexParameter -> False,
  Description -> "gs coupling normalization"
},

(* initial SM couplings before redefinitions *)

gw == {
  ParameterType    -> Internal,
  InteractionOrder -> {QED,1},
  ComplexParameter -> False,
  Definitions      -> {gw :> gwnorm GW},
  TeX              -> Subscript[g,W],
  Description      -> "Weak SU(2) coupling constant"
},

g1 == {
  ParameterType    -> Internal,
  InteractionOrder -> {QED,1},
  ComplexParameter -> False,
  Definitions      -> {g1 :> g1norm G1},
  TeX              -> Subscript[g,1],
  Description      -> "U(1)Y coupling constant"
},

gs == {
  ParameterType    -> Internal,
  InteractionOrder -> {QCD,1},
  ComplexParameter -> False,
  Definitions      -> {gs :> gsnorm GS},
  TeX              -> Subscript[g,s],
  Description      -> "Strong sU(3) coupling constant"
},

(* effective gauge coupling constants *)

G1 == {
  ParameterType    -> Internal,
  InteractionOrder -> {QED,1},
  ComplexParameter -> False,
  TeX              -> Subscript[G,1],
  Description      -> "Effective U(1)Y coupling constant"
},

GW == {
  ParameterType    -> Internal,
  InteractionOrder -> {QED,1},
  ComplexParameter -> False,
  TeX              -> Subscript[G,W],
  Description      -> "Effective SU(2) coupling constant"
},

GS == {
  ParameterType    -> Internal,
  InteractionOrder -> {QCD,1},
  ComplexParameter -> False,
  TeX              -> Subscript[G,s],
  Description      -> "Effective SU(3) coupling constant at the Z pole"
},

aS == {
  ParameterType    -> Internal,
  InteractionOrder -> {QCD,2},
  ComplexParameter -> False,
  TeX              -> Subscript[\[Alpha],s],
  Description      -> "Effective alpha_s at the Z pole"
},

(* Higgs parameters *)

vev == {
  ParameterType    -> Internal,
  InteractionOrder -> {QED,-1},
  Description      -> "Higgs vacuum expectation value"
},

hlambda == {
  ParameterType    -> Internal,
  InteractionOrder -> {QED, 1},
  ComplexParameter -> False,
  TeX              -> \[Lambda],
  Description      -> "Higgs quartic coupling"
},

muH == {
  ParameterType    -> Internal,
  ComplexParameter -> False,
  TeX              -> \[Mu],
  Description      -> "Coefficient of the quadratic term in the Higgs potential"
},

(* particle masses *)

MW == {
  ParameterType -> Internal,
  ComplexParameter -> False,
  TeX           -> Subscript[M,W],
  Description   -> "W mass"
},

MZ == {
  ParameterType -> Internal,
  ComplexParameter -> False,
  TeX           -> Subscript[M,Z],
  Description   -> "Z mass"
},

MH == {
  ParameterType -> Internal,
  ComplexParameter -> False,
  TeX           -> Subscript[M,H],
  Description   -> "H mass"
},

(* fermion masses *)

fmv == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  Definitions      -> {fmv[i_?NumericQ, j_?NumericQ] :> 0  /; (i =!= j)},
  TeX              -> Superscript[m, \[Nu]],
  Description      -> "Neutrino masses"
},

fml == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  Definitions      -> {fml[i_?NumericQ, j_?NumericQ] :> 0  /; (i =!= j)},
  TeX              -> Superscript[m, l],
  Description      -> "Lepton tree level pole masses"
},

fmu == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  Definitions      -> {fmu[i_?NumericQ, j_?NumericQ] :> 0  /; (i =!= j)},
  TeX              -> Superscript[m, u],
  Description      -> "Up-type quark masses"
},

fmd == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  Definitions      -> {fmd[i_?NumericQ, j_?NumericQ] :> 0  /; (i =!= j)},
  TeX              -> Superscript[m, d],
  Description      -> "Down-type quark masses"
},

(* Yukawa couplings *)

yl == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  ComplexParameter -> True,
  InteractionOrder -> {QED, 1},
  TeX              -> Superscript[y, l],
  Description      -> "Lepton Yukawa coupling"
},

yu == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  ComplexParameter -> True,
  InteractionOrder -> {QED, 1},
  TeX              -> Superscript[y, u],
  Description      -> "Up-type Yukawa coupling"
},

yd == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  ComplexParameter -> True,
  InteractionOrder -> {QED, 1},
  TeX              -> Superscript[y, d],
  Description      -> "Down-type Yukawa coupling"
},

(* fermion fields rotations from Warsaw to mass basis *)

VVL == {
ParameterType -> Internal,
Indices -> {Index[Generation], Index[Generation]},
Unitary -> True,
ComplexParameter -> True,
Description -> "Left neutrino mixing matrix"
},

VLL == {
ParameterType -> Internal,
Indices -> {Index[Generation], Index[Generation]},
Unitary -> True,
ComplexParameter -> True,
Description -> "Left lepton mixing matrix"
},

VLR == {
ParameterType -> Internal,
Indices -> {Index[Generation], Index[Generation]},
Unitary -> True,
ComplexParameter -> True,
Description -> "Right lepton mixing matrix"
},

VUL == {
ParameterType -> Internal,
Indices -> {Index[Generation], Index[Generation]},
Unitary -> True,
ComplexParameter -> True,
Description -> "Left up quark mixing matrix"
},

VUR == {
ParameterType -> Internal,
Indices -> {Index[Generation], Index[Generation]},
Unitary -> True,
ComplexParameter -> True,
Description -> "Right up quark mixing matrix"
},

VDL == {
ParameterType -> Internal,
Indices -> {Index[Generation], Index[Generation]},
Unitary -> True,
ComplexParameter -> True,
Description -> "Left down quark mixing matrix"
},

VDR == {
ParameterType -> Internal,
Indices -> {Index[Generation], Index[Generation]},
Unitary -> True,
ComplexParameter -> True,
Description -> "Right down quark mixing matrix"
},


(* physical flavor mixing *)

(* CKM matrix Kq =  VUL^+ VDL + corrections *)
Kq == {
  ParameterType -> Internal,
  Indices -> {Index[Generation], Index[Generation]},
  Unitary -> True,
  ComplexParameter -> True,
  TeX           -> K,
  Description -> "CKM Matrix"
},

(* PMNS matrix Ul = VLL^+ VVL + corrections *)
Ul == {
  ParameterType -> Internal,
  Indices -> {Index[Generation], Index[Generation]},
  Unitary -> True,
  ComplexParameter -> True,
  TeX           -> U,
  Description -> "PMNS Matrix"
},

(* R_xi gauge fixing parameters in mass basis *)

xiW == {
    ParameterType -> Internal,
    ComplexParameter -> False,
    Value            -> 1,
    TeX           -> Subscript[\[Xi],W],
    Description   -> "W gauge fixing parameter"
  },

xiZ == {
    ParameterType -> Internal,
    ComplexParameter -> False,
    Value            -> 1,
    TeX           -> Subscript[\[Xi],Z],
    Description   -> "Z gauge fixing parameter"
  },

xiA == {
    ParameterType -> Internal,
    Value            -> 1,
    ComplexParameter -> False,
    TeX           -> Subscript[\[Xi],A],
    Description   -> "Photon gauge fixing parameter"
  },

xiG == {
    ParameterType -> External,
    Value            -> 1,
    ComplexParameter -> False,
    TeX           -> Subscript[\[Xi],G],
    Description   -> "Gluon gauge fixing parameter"
  },


(* input observables *)

alphas == {
  ParameterType -> External
,  Value -> 0.1176
,  InteractionOrder -> {QCD, 2}
,  TeX -> Subscript[\[Alpha], s]
,  Description -> "average alpha_s at MZ scale"
},

Gf == {
  ParameterType -> External
,  Value -> 0.000011638081097590524
,  InteractionOrder -> {QED, 2}
,  TeX -> Subscript[G, F]
,  Description -> "G_Fermi"
},

AEM == {
  ParameterType -> External
,  Value -> 0.0072973525692838015
,  InteractionOrder -> {QED, 2}
,  TeX -> Subscript[\[Alpha], em]
,  Description -> "alpha_em at p^2=0"
},

Zmass == {
  ParameterType -> External
,  Value -> 91.1876
,  TeX -> Subscript[M, Z]
,  Description -> "Pole Z boson mass"
},

Wmass == {
  ParameterType -> External
,  Value -> 80.379
,  TeX -> Subscript[M, W]
,  Description -> "Pole W boson mass"
},

Hmass == {
  ParameterType -> External
,  Value -> 125.35
,  TeX -> Subscript[M, H]
,  Description -> "Pole Higgs boson mass"
},

tmass == {
  ParameterType -> External
,  Value -> 172.76
,  TeX -> Subscript[m, t]
,  Description -> "Pole top quark mass"
},

cmass == {
  ParameterType -> External
,  Value -> 1.27
,  TeX -> Subscript[m, c]
,  Description -> "c quark mass"
},

umass == {
  ParameterType -> External
,  Value -> 0.0025499999999999997
,  TeX -> Subscript[m, u]
,  Description -> "u quark mass"
},

bmass == {
  ParameterType -> External
,  Value -> 4.7
,  TeX -> Subscript[m, b]
,  Description -> "b quark mass"
},

smass == {
  ParameterType -> External
,  Value -> 0.101
,  TeX -> Subscript[m, s]
,  Description -> "s quark mass"
},

dmass == {
  ParameterType -> External
,  Value -> 0.00504
,  TeX -> Subscript[m, d]
,  Description -> "d quark mass"
},

taumass == {
  ParameterType -> External
,  Value -> 1.77686
,  TeX -> Subscript[m, \[Tau]]
,  Description -> "tau lepton mass"
},

mumass == {
  ParameterType -> External
,  Value -> 0.1056583755
,  TeX -> Subscript[m, \[Mu]]
,  Description -> "muon mass"
},

emass == {
  ParameterType -> External
,  Value -> 0.00051099895
,  TeX -> Subscript[m, e]
,  Description -> "electron mass"
},

lamT == {
  ParameterType -> External
,  Value -> 0.22537
,  TeX -> Subscript[\[Lambda], T]
,  Description -> "Wolfenstein lambda parameter"
},

AT == {
  ParameterType -> External
,  Value -> 0.828
,  TeX -> Subscript[A, T]
,  Description -> "Wolfenstein A parameter"
},

rhoT == {
  ParameterType -> External
,  Value -> 0.194
,  TeX -> Subscript[\[Rho], T]
,  Description -> "Wolfenstein rho parameter"
},

etaT == {
  ParameterType -> External
,  Value -> 0.391
,  TeX -> Subscript[\[Eta], T]
,  Description -> "Wolfenstein eta parameter"
},

theta12 == {
  ParameterType -> External
,  Value -> 0.5836381018669038
,  TeX -> Subscript[\[Theta], 12]
,  Description -> "PMNS theta12 angle"
},

theta13 == {
  ParameterType -> External
,  Value -> 0.14957471689591406
,  TeX -> Subscript[\[Theta], 13]
,  Description -> "PMNS theta13 angle"
},

theta23 == {
  ParameterType -> External
,  Value -> 0.8587019919812102
,  TeX -> Subscript[\[Theta], 23]
,  Description -> "PMNS theta23 angle"
},

delta == {
  ParameterType -> External
,  Value -> 3.3859562021615193
,  TeX -> \[Delta]
,  Description -> "PMNS Dirac phase"
},

taumu == {
  ParameterType -> External
,  Value -> 3.337862504*^18
,  TeX -> Subscript[\[Tau], \[Mu]]
,  Description -> "muon lifetime in GeV^-1"
},

mB == {
  ParameterType -> External
,  Value -> 5.27932
,  TeX -> Superscript[m, "B+"]
,  Description -> "B^+ meson mass"
},

mBs == {
  ParameterType -> External
,  Value -> 5.36689
,  TeX -> Subscript[m, Bs]
,  Description -> "B_s meson mass"
},

mBd == {
  ParameterType -> External
,  Value -> 5.27963
,  TeX -> Subscript[m, Bd]
,  Description -> "B_d meson mass"
},

mK == {
  ParameterType -> External
,  Value -> 0.493677
,  TeX -> Superscript[m, "K+"]
,  Description -> "K^+ meson mass"
},

mPi == {
  ParameterType -> External
,  Value -> 0.13957061
,  TeX -> Superscript[m, "\[Pi]+"]
,  Description -> "pi^+ meson mass"
},

S1 == {
  ParameterType -> External
,  Value -> 2.3124
,  TeX -> Subscript[S, 1][Subscript[m, W]]
,  Description -> "S_1(m_W) as of Table 2 in 1812.08163"
},

(* dim 6 couplings in Warsaw basis *)

(* flavor independent *)

cphi == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,1},
  Definitions      -> {cphi :> Cphi},
  ComplexParameter -> False,
  TeX              -> Superscript[c, \[Phi]],
  Description      -> "Qphi WC coefficient"
},


cphiBox == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,1},
  Definitions      -> {cphiBox :> CphiBox},
  ComplexParameter -> False,
  TeX              -> Superscript[c, \[Phi]Box],
  Description      -> "QphiBox WC coefficient"
},


cphiD == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,1},
  Definitions      -> {cphiD :> CphiD},
  ComplexParameter -> False,
  TeX              -> Superscript[c, \[Phi]D],
  Description      -> "QphiD WC coefficient"
},


cphiW == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,1},
  Definitions      -> {cphiW :> CphiW},
  ComplexParameter -> False,
  TeX              -> Superscript[c, \[Phi]W],
  Description      -> "QphiW WC coefficient"
},


cphiWB == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,1},
  Definitions      -> {cphiWB :> CphiWB},
  ComplexParameter -> False,
  TeX              -> Superscript[c, \[Phi]WB],
  Description      -> "QphiWB WC coefficient"
},


cphi8 == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,2},
  Definitions      -> {cphi8 :> Cphi8},
  ComplexParameter -> False,
  TeX              -> Superscript[c, \[Phi]8],
  Description      -> "Qphi8 WC coefficient"
},


cphi4n1 == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,2},
  Definitions      -> {cphi4n1 :> Cphi4n1},
  ComplexParameter -> False,
  TeX              -> Superscript[c, \[Phi]4n1],
  Description      -> "Qphi4n1 WC coefficient"
},


cphi4n3 == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,2},
  Definitions      -> {cphi4n3 :> Cphi4n3},
  ComplexParameter -> False,
  TeX              -> Superscript[c, \[Phi]4n3],
  Description      -> "Qphi4n3 WC coefficient"
},


(* flavor dependent *)

(* 2 fermion operators *)

cdphi == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {cdphi[ff1_,ff2_] :> Module[{ind1,ind2}, VDL[ff1,ind1] Cdphi[ind1,ind2] Conjugate[VDR[ff2,ind2]] ]},
  Hermitian        -> False,
  TeX              -> Superscript[c, d\[Phi]],
  Description      -> "Qdphi WC coefficient"
},


ceB == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {ceB[ff1_,ff2_] :> Module[{ind1,ind2}, VLL[ff1,ind1] CeB[ind1,ind2] Conjugate[VLR[ff2,ind2]] ]},
  Hermitian        -> False,
  TeX              -> Superscript[c, eB],
  Description      -> "QeB WC coefficient"
},


cuW == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {cuW[ff1_,ff2_] :> Module[{ind1,ind2}, VUL[ff1,ind1] CuW[ind1,ind2] Conjugate[VUR[ff2,ind2]] ]},
  Hermitian        -> False,
  TeX              -> Superscript[c, uW],
  Description      -> "QuW WC coefficient"
},


(* 4 fermion operators *)

cll == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Definitions      -> {cll[ff1_,ff2_,ff3_,ff4_] :> Module[{ind1,ind2,ind3,ind4}, VLL[ff1,ind1] VLL[ff3,ind3] Cll[ind1,ind2,ind3,ind4] Conjugate[VLL[ff2,ind2]] Conjugate[VLL[ff4,ind4]] ]},
  TeX              -> Superscript[c, ll],
  Description      -> "Qll WC coefficient"
},


(* L or B violating operators *)

(* redefined (mass basis) WC coefficients *)

(* flavor independent *)

Cphi == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,1},
  ComplexParameter -> False,
  TeX              -> Superscript[C, \[Phi]],
  Description      -> "Qphi WC coefficient"
},


CphiBox == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,1},
  ComplexParameter -> False,
  TeX              -> Superscript[C, \[Phi]Box],
  Description      -> "QphiBox WC coefficient"
},


CphiD == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,1},
  ComplexParameter -> False,
  TeX              -> Superscript[C, \[Phi]D],
  Description      -> "QphiD WC coefficient"
},


CphiW == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,1},
  ComplexParameter -> False,
  TeX              -> Superscript[C, \[Phi]W],
  Description      -> "QphiW WC coefficient"
},


CphiWB == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,1},
  ComplexParameter -> False,
  TeX              -> Superscript[C, \[Phi]WB],
  Description      -> "QphiWB WC coefficient"
},


Cphi8 == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,2},
  ComplexParameter -> False,
  TeX              -> Superscript[C, \[Phi]8],
  Description      -> "Qphi8 WC coefficient"
},


Cphi4n1 == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,2},
  ComplexParameter -> False,
  TeX              -> Superscript[C, \[Phi]4n1],
  Description      -> "Qphi4n1 WC coefficient"
},


Cphi4n3 == {
  ParameterType    -> Internal,
  Indices          -> {},
  InteractionOrder -> {NP,2},
  ComplexParameter -> False,
  TeX              -> Superscript[C, \[Phi]4n3],
  Description      -> "Qphi4n3 WC coefficient"
},


(* flavor dependent *)

(* 2 fermion operators *)

Cdphi == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Hermitian        -> False,
  TeX              -> Superscript[C, d\[Phi]],
  Description      -> "Qdphi WC coefficient"
},


CeB == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Hermitian        -> False,
  TeX              -> Superscript[C, eB],
  Description      -> "QeB WC coefficient"
},


CuW == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  Hermitian        -> False,
  TeX              -> Superscript[C, uW],
  Description      -> "QuW WC coefficient"
},


(* 4 fermion operators *)

Cll == {
  ParameterType    -> Internal,
  Indices          -> {Index[Generation], Index[Generation], Index[Generation], Index[Generation]},
  InteractionOrder -> {NP,1},
  TeX              -> Superscript[C, ll],
  Description      -> "Qll WC coefficient"
},


(* L or B violating operators *)

(* NP scale *)

Lam == {
  ParameterType -> Internal,
  TeX           -> 1/\[CapitalLambda]^2,
  Description   -> "Effective NP scale squared"
}

}

M$InteractionOrderHierarchy = 
{{QCD, 1}, {NP, 1}, {QED, 1}}


M$InteractionOrderLimit = 
{{QCD, 99}, {NP, 2}, {QED, 99}}


