(* SmeftFR v3.0 package *)
(* Contains definitions of SM fields and quantum numbers *)


(* ************* ************ *)
(* Information *)
(* ************************** *)
M$ModelName = SMEFT$ModelName;

M$Information = {
  Authors      -> SMEFT$Authors,
  Version      -> SMEFT$Version,
  Date         -> SMEFT$Date(*,
  Institutions -> SMEFT$Institutions,
  Emails       -> SMEFT$Emails,
  URLs         -> SMEFT$URLs*)
};



(* ************************** *)
(* Gauge groups *)
(* ************************** *)
M$GaugeGroups = {
  U1Y  == {
    Abelian          -> True,
    CouplingConstant -> g1,
    GaugeBoson       -> B,
    Charge           -> Y
  },
  SU2L == {
    Abelian           -> False,
    CouplingConstant  -> gw,
    GaugeBoson        -> Wi,
    StructureConstant -> Eps,
    Representations   -> {Ta,SU2D},
    Definitions       -> {Ta[a_,b_,c_]->PauliSigma[a,b,c]/2, FSU2L[i_,j_,k_]:> I Eps[i,j,k]}
  },
  SU3C == {
    Abelian           -> False,
    CouplingConstant  -> gs,
    GaugeBoson        -> Gl,
    StructureConstant -> f,
    Representations   -> {T,Colour},
    SymmetricTensor   -> dSUN
  }
};


(* ************************** *)
(* Indices *)
(* ************************** *)

IndexRange[Index[SU2W      ]] = Unfold[Range[3]];
IndexRange[Index[SU2D      ]] = Unfold[Range[2]];
IndexRange[Index[Gluon     ]] = NoUnfold[Range[8]];
IndexRange[Index[Colour    ]] = NoUnfold[Range[3]];
IndexRange[Index[Generation]] = Range[3];

IndexStyle[SU2W,       j];
IndexStyle[SU2D,       k];
IndexStyle[Gluon,      a];
IndexStyle[Colour,     m];
IndexStyle[Generation, f];


(* ************************** *)
(* Particle classes *)
(* ************************** *)
M$ClassesDescription = {

(* Gauge bosons: physical vector fields *)
  V[1] == {
    ClassName       -> A,
    SelfConjugate   -> True,
    Mass            -> 0,
    Width           -> 0,
    ParticleName    -> "a",
    PDG             -> 22,
    PropagatorLabel -> "a",
    PropagatorType  -> W,
    PropagatorArrow -> None,
    FullName        -> "Photon"
  },
  V[2] == {
    ClassName       -> Z,
    SelfConjugate   -> True,
    Mass            -> {MZ, Internal},
    Width           -> {WZ, 2.4952},
    ParticleName    -> "Z",
    PDG             -> 23,
    PropagatorLabel -> "Z",
    PropagatorType  -> Sine,
    PropagatorArrow -> None,
    FullName        -> "Z"
  },
  V[3] == {
    ClassName        -> W,
    SelfConjugate    -> False,
    Mass             -> {MW,Internal},
    Width            -> {WW, 2.085},
    ParticleName     -> "W+",
    AntiParticleName -> "W-",
    QuantumNumbers   -> {Q -> 1},
    PDG              -> 24,
    PropagatorLabel  -> "W",
    PropagatorType   -> Sine,
    PropagatorArrow  -> Forward,
    FullName         -> "W"
  },
  V[4] == {
    ClassName        -> G,
    SelfConjugate    -> True,
    Indices          -> {Index[Gluon]},
    Mass             -> 0,
    Width            -> 0,
    ParticleName     -> "g",
    PDG              -> 21,
    PropagatorLabel  -> "g",
    PropagatorType   -> C,
    PropagatorArrow  -> None,
    FullName         -> "G"
  },

(* Ghosts: related to physical gauge bosons *)
  U[1] == {
    ClassName       -> ghA,
    SelfConjugate   -> False,
    Ghost           -> A,
    QuantumNumbers  -> {GhostNumber -> 1},
    Mass            -> 0,
    PropagatorLabel -> "uA",
    PropagatorType  -> GhostDash,
    PropagatorArrow -> Forward
  },
  U[2] == {
    ClassName       -> ghZ,
    SelfConjugate   -> False,
    Ghost           -> Z,
    QuantumNumbers  -> {GhostNumber -> 1},
    PropagatorLabel -> "uZ",
    PropagatorType  -> GhostDash,
    PropagatorArrow -> Forward
  },
  U[31] == {
    ClassName       -> ghWp,
    SelfConjugate   -> False,
    Ghost           -> W,
    QuantumNumbers  -> {GhostNumber -> 1, Q -> 1},
    PropagatorLabel -> "uWp",
    PropagatorType  -> GhostDash,
    PropagatorArrow -> Forward
  },
  U[32] == {
    ClassName       -> ghWm,
    SelfConjugate   -> False,
    Ghost           -> Wbar,
    QuantumNumbers  -> {GhostNumber -> 1, Q -> -1},
    PropagatorLabel -> "uWm",
    PropagatorType  -> GhostDash,
    PropagatorArrow -> Forward
  },
  U[4] == {
    ClassName       -> ghG,
    SelfConjugate   -> False,
    Indices         -> {Index[Gluon]},
    Ghost           -> G,
    QuantumNumbers  ->{GhostNumber -> 1},
    Mass            -> 0,
    PropagatorLabel -> "uG",
    PropagatorType  -> GhostDash,
    PropagatorArrow -> Forward
  },

(* Gauge bosons: unphysical vector fields  *)
  V[11] == {
    ClassName     -> B,
    Unphysical    -> True,
    Mass          -> 0,
    SelfConjugate -> True,
    Definitions   -> { B[si_] -> AZnorm[2,1] Z[si] + AZnorm[2,2] A[si] }
  },
  V[12] == {
    ClassName     -> Wi,
    Unphysical    -> True,
    Mass          -> 0,
    SelfConjugate -> True,
    Indices       -> {Index[SU2W]},
    FlavorIndex   -> SU2W,
    Definitions   -> { Wi[si_,1] -> Wnorm/Sqrt[2] (Wbar[si] + W[si]),
		       Wi[si_,2] -> - I Wnorm/Sqrt[2] (Wbar[si] - W[si]),
		       Wi[si_,3] -> AZnorm[1,1] Z[si] + AZnorm[1,2] A[si]
		     }
  },
  V[14] == {
    ClassName        -> Gl,
    Unphysical       -> True,
    Mass             -> 0,
    SelfConjugate    -> True,
    Indices          -> {Index[Gluon]},
    Definitions      -> { Gl[si_,a_] -> Gnorm G[si,a] }
  },

(* Ghosts: related to unphysical gauge bosons *)
  U[11] == {
    ClassName     -> ghB,
    Unphysical    -> True,
    SelfConjugate -> False,
    Ghost         -> B,
    Definitions   -> { ghB -> AZnorm[2,1] ghZ + AZnorm[2,2] ghA }
  },
  U[12] == {
    ClassName     -> ghWi,
    Unphysical    -> True,
    SelfConjugate -> False,
    Ghost         -> Wi,
    Indices       -> {Index[SU2W]},
    FlavorIndex   -> SU2W,
    Definitions   -> { ghWi[1] -> Wnorm (ghWp+ghWm)/Sqrt[2],
		       ghWi[2] -> Wnorm (ghWm-ghWp)/(I*Sqrt[2]),
		       ghWi[3] -> AZnorm[1,1] ghZ + AZnorm[1,2] ghA  }
  },

(* Fermions: physical fields *)
  F[1] == {
    ClassName        -> vl,
    ClassMembers     -> {ve,vm,vt},
    Indices          -> {Index[Generation]},
    FlavorIndex      -> Generation,
    Mass             -> mvdiag,
    Width            -> 0,
    SelfConjugate    -> False,
    QuantumNumbers   -> {LeptonNumber -> 1},
    PropagatorLabel  -> {"v", "ve", "vm", "vt"} ,
    PropagatorType   -> S,
    PropagatorArrow  -> Forward,
    PDG              -> {12,14,16},
    ParticleName     -> {"ve","vm","vt"},
    AntiParticleName -> {"ve~","vm~","vt~"},
    FullName         -> {"Electron-neutrino", "Mu-neutrino", "Tau-neutrino"}
  },
  F[2] == {
    ClassName        -> l,
    ClassMembers     -> {e, mu, ta},
    Indices          -> {Index[Generation]},
    FlavorIndex      -> Generation,
    SelfConjugate    -> False,
    Mass             -> mldiag,
    Width            -> 0,
    QuantumNumbers   -> {Q -> -1, LeptonNumber -> 1},
    PropagatorLabel  -> {"l", "e", "mu", "ta"},
    PropagatorType   -> Straight,
    PropagatorArrow  -> Forward,
    PDG              -> {11, 13, 15},
    ParticleName     -> {"e-", "mu-", "ta-"},
    AntiParticleName -> {"e+", "mu+", "ta+"},
    FullName         -> {"Electron", "Muon", "Tau"}
  },
  F[3] == {
    ClassName        -> uq,
    ClassMembers     -> {u, c, t},
    Indices          -> {Index[Generation], Index[Colour]},
    FlavorIndex      -> Generation,
    SelfConjugate    -> False,
    Mass             -> mudiag,
    Width            -> {0, 0, {WT,1.50833649}},
    QuantumNumbers   -> {Q -> 2/3},
    PropagatorLabel  -> {"uq", "u", "c", "t"},
    PropagatorType   -> Straight,
    PropagatorArrow  -> Forward,
    PDG              -> {2, 4, 6},
    ParticleName     -> {"u",  "c",  "t" },
    AntiParticleName -> {"u~", "c~", "t~"},
    FullName         -> {"u-quark", "c-quark", "t-quark"}
  },
  F[4] == {
    ClassName        -> dq,
    ClassMembers     -> {d, s, b},
    Indices          -> {Index[Generation], Index[Colour]},
    FlavorIndex      -> Generation,
    SelfConjugate    -> False,
    Mass             -> mddiag,
    Width            -> 0,
    QuantumNumbers   -> {Q -> -1/3},
    PropagatorLabel  -> {"dq", "d", "s", "b"},
    PropagatorType   -> Straight,
    PropagatorArrow  -> Forward,
    PDG              -> {1,3,5},
    ParticleName     -> {"d",  "s",  "b" },
    AntiParticleName -> {"d~", "s~", "b~"},
    FullName         -> {"d-quark", "s-quark", "b-quark"}
  },

(* Fermions: unphysical fields *)
  F[11] == {
    ClassName      -> LL,
    Unphysical     -> True,
    Indices        -> {Index[SU2D], Index[Generation]},
    FlavorIndex    -> SU2D,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> -1/2},
    Definitions    -> {
      LL[sp1_,1,ff_] :> Module[{sp2,ff1}, ProjM[sp1,sp2] VVL[ff,ff1] vl[sp2,ff1]],
      LL[sp1_,2,ff_] :> Module[{sp2,ff1}, ProjM[sp1,sp2] VLL[ff,ff1]  l[sp2,ff1]] }
  },
  F[12] == {
    ClassName      -> lR,
    Unphysical     -> True,
    Indices        -> {Index[Generation]},
    FlavorIndex    -> Generation,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> -1},
    Definitions    -> {
      lR[sp1_,ff_] :> Module[{sp2,ff1}, ProjP[sp1,sp2] VLR[ff,ff1] l[sp2,ff1]] }
  },
  F[13] == {
    ClassName      -> QL,
    Unphysical     -> True,
    Indices        -> {Index[SU2D], Index[Generation], Index[Colour]},
    FlavorIndex    -> SU2D,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> 1/6},
    Definitions    -> {
      QL[sp1_,1,ff_,cc_] :> Module[{sp2,ff1}, ProjM[sp1,sp2] VUL[ff,ff1] uq[sp2,ff1,cc]],
      QL[sp1_,2,ff_,cc_] :> Module[{sp2,ff1}, ProjM[sp1,sp2] VDL[ff,ff1] dq[sp2,ff1,cc]] }
  },
  F[14] == {
    ClassName      -> uR,
    Unphysical     -> True,
    Indices        -> {Index[Generation], Index[Colour]},
    FlavorIndex    -> Generation,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> 2/3},
    Definitions    -> {
      uR[sp1_,ff_,cc_] :> Module[{sp2,ff1}, ProjP[sp1,sp2] VUR[ff,ff1] uq[sp2,ff1,cc]] }
  },
  F[15] == {
    ClassName      -> dR,
    Unphysical     -> True,
    Indices        -> {Index[Generation], Index[Colour]},
    FlavorIndex    -> Generation,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> -1/3},
    Definitions    -> {
      dR[sp1_,ff_,cc_] :> Module[{sp2,ff1}, ProjP[sp1,sp2] VDR[ff,ff1] dq[sp2,ff1,cc]] }
  },

(* Higgs: physical scalars  *)
  S[1] == {
    ClassName       -> H,
    SelfConjugate   -> True,
    Mass            -> {MH,Internal},
    Width           -> {WH,0.00575},
    PropagatorLabel -> "H",
    PropagatorType  -> D,
    PropagatorArrow -> None,
    PDG             -> 25,
    ParticleName    -> "H",
    FullName        -> "H"
  },

(* Goldstone fields  *)
  S[2] == {
    ClassName       -> G0,
    SelfConjugate   -> True,
    Goldstone       -> Z,
    Mass            -> {MG0,Internal},
    PropagatorLabel -> "G0",
    PropagatorType  -> D,
    PropagatorArrow -> None,
    PDG             -> 250,
    ParticleName    -> "G0",
    FullName        -> "G0"
  },
  S[3] == {
    ClassName        -> GP,
    SelfConjugate    -> False,
    Goldstone        -> W,
    Mass             -> {MGP,Internal},
    QuantumNumbers   -> {Q -> 1},
    PropagatorLabel  -> "GP",
    PropagatorType   -> D,
    PropagatorArrow  -> None,
    PDG              -> 251,
    ParticleName     -> "G+",
    AntiParticleName -> "G-",
    FullName         -> "GP"
  },

(* Higgs: unphysical scalars in dim-8 lagrangian (no normalizations necessary) *)
  S[11] == {
    ClassName      -> Phi8,
    Unphysical     -> True,
    Indices        -> {Index[SU2D]},
    FlavorIndex    -> SU2D,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> 1/2},
    Definitions    -> { Phi8[1] -> GP, Phi8[2] -> (vev + H + I G0)/Sqrt[2]  }
  },

(* Higgs: unphysical scalars in SM and dim-6 lagrangian *)
  S[12] == {
    ClassName      -> Phi,
    Unphysical     -> True,
    Indices        -> {Index[SU2D]},
    FlavorIndex    -> SU2D,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> 1/2},
    Definitions    -> { Phi[1] -> GP/GPnorm, Phi[2] -> (vev + H/Hnorm + I G0/G0norm)/Sqrt[2]  }
  }
};


(* ************************** *)
(* *****     Gauge      ***** *)
(* *****   Parameters   ***** *)
(* *****   (FeynArts)   ***** *)
(* ************************** *)

GaugeXi[ V[1]  ] = GaugeXi[A];
GaugeXi[ V[2]  ] = GaugeXi[Z];
GaugeXi[ V[3]  ] = GaugeXi[W];
GaugeXi[ V[4]  ] = GaugeXi[G];
GaugeXi[ S[1]  ] = 1;
GaugeXi[ S[2]  ] = GaugeXi[Z];
GaugeXi[ S[3]  ] = GaugeXi[W];
GaugeXi[ U[1]  ] = GaugeXi[A];
GaugeXi[ U[2]  ] = GaugeXi[Z];
GaugeXi[ U[31] ] = GaugeXi[W];
GaugeXi[ U[32] ] = GaugeXi[W];
GaugeXi[ U[4]  ] = GaugeXi[G];
