(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *)
(*                                                                             *)
(*         This file has been automatically generated by FeynRules.            *)
(*                                                                             *)
(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *)


FR$ModelInformation={
  ModelName->"SMEFT",
  Authors -> {"A. Dedes, J. Rosiek, M. Ryczkowski, K. Suxho, L. Trifyllis"},
  Version -> "3.00",
  Date -> "01. 02. 2023"};

FR$ClassesTranslation={};

FR$InteractionOrderPerturbativeExpansion={{QCD, 0}, {NP, 0}, {QED, 0}};

FR$GoldstoneList={S[2], S[3]};

(*     Declared indices    *)

IndexRange[ Index[Gluon] ] = NoUnfold[ Range[ 8 ] ]

IndexRange[ Index[Generation] ] = Range[ 3 ]

IndexRange[ Index[Colour] ] = NoUnfold[ Range[ 3 ] ]

(*     Declared particles    *)

M$ClassesDescription = {
V[1] == {
    SelfConjugate -> True,
    PropagatorLabel -> "A",
    PropagatorType -> Sine,
    PropagatorArrow -> None,
    Mass -> 0,
    Indices -> {} },

V[2] == {
    SelfConjugate -> True,
    PropagatorLabel -> "Z",
    PropagatorType -> Sine,
    PropagatorArrow -> None,
    Mass -> MZ,
    Indices -> {} },

V[3] == {
    SelfConjugate -> False,
    QuantumNumbers -> {Q},
    PropagatorLabel -> "W",
    PropagatorType -> Sine,
    PropagatorArrow -> Forward,
    Mass -> MW,
    Indices -> {} },

V[4] == {
    SelfConjugate -> True,
    Indices -> {Index[Gluon]},
    PropagatorLabel -> "g",
    PropagatorType -> Cycles,
    PropagatorArrow -> None,
    Mass -> 0 },

F[1] == {
    Indices -> {Index[Generation]},
    SelfConjugate -> False,
    QuantumNumbers -> {LeptonNumber},
    PropagatorLabel -> "v",
    PropagatorType -> Straight,
    PropagatorArrow -> Forward,
    Mass -> mvdiag },

F[2] == {
    Indices -> {Index[Generation]},
    SelfConjugate -> False,
    QuantumNumbers -> {-Q, LeptonNumber},
    PropagatorLabel -> "l",
    PropagatorType -> Straight,
    PropagatorArrow -> Forward,
    Mass -> mldiag },

F[3] == {
    Indices -> {Index[Generation], Index[Colour]},
    SelfConjugate -> False,
    QuantumNumbers -> {(2*Q)/3},
    PropagatorLabel -> "uq",
    PropagatorType -> Straight,
    PropagatorArrow -> Forward,
    Mass -> mudiag },

F[4] == {
    Indices -> {Index[Generation], Index[Colour]},
    SelfConjugate -> False,
    QuantumNumbers -> {-1/3*Q},
    PropagatorLabel -> "dq",
    PropagatorType -> Straight,
    PropagatorArrow -> Forward,
    Mass -> mddiag },

S[1] == {
    SelfConjugate -> True,
    PropagatorLabel -> "H",
    PropagatorType -> ScalarDash,
    PropagatorArrow -> None,
    Mass -> MH,
    Indices -> {} },

S[2] == {
    SelfConjugate -> True,
    PropagatorLabel -> "G0",
    PropagatorType -> ScalarDash,
    PropagatorArrow -> None,
    Mass -> MG0,
    Indices -> {} },

S[3] == {
    SelfConjugate -> False,
    QuantumNumbers -> {Q},
    PropagatorLabel -> "GP",
    PropagatorType -> ScalarDash,
    PropagatorArrow -> None,
    Mass -> MGP,
    Indices -> {} },

U[1] == {
    SelfConjugate -> False,
    QuantumNumbers -> {GhostNumber},
    PropagatorLabel -> "\[Eta]A",
    PropagatorType -> GhostDash,
    PropagatorArrow -> Forward,
    Mass -> 0,
    Indices -> {} },

U[2] == {
    SelfConjugate -> False,
    QuantumNumbers -> {GhostNumber},
    PropagatorLabel -> "\[Eta]Z",
    PropagatorType -> GhostDash,
    PropagatorArrow -> Forward,
    Mass -> MgZ,
    Indices -> {} },

U[31] == {
    SelfConjugate -> False,
    QuantumNumbers -> {GhostNumber, Q},
    PropagatorLabel -> "\[Eta]Wp",
    PropagatorType -> GhostDash,
    PropagatorArrow -> Forward,
    Mass -> MgW,
    Indices -> {} },

U[32] == {
    SelfConjugate -> False,
    QuantumNumbers -> {GhostNumber, -Q},
    PropagatorLabel -> "\[Eta]Wm",
    PropagatorType -> GhostDash,
    PropagatorArrow -> Forward,
    Mass -> MgW,
    Indices -> {} },

U[4] == {
    SelfConjugate -> False,
    Indices -> {Index[Gluon]},
    QuantumNumbers -> {GhostNumber},
    PropagatorLabel -> "\[Eta]G",
    PropagatorType -> GhostDash,
    PropagatorArrow -> Forward,
    Mass -> 0 }
}


(*        Definitions       *)

GaugeXi[ V[1] ] = GaugeXi[A];
GaugeXi[ V[2] ] = GaugeXi[Z];
GaugeXi[ V[3] ] = GaugeXi[W];
GaugeXi[ V[4] ] = GaugeXi[G];
GaugeXi[ S[1] ] = 1;
GaugeXi[ S[2] ] = GaugeXi[Z];
GaugeXi[ S[3] ] = GaugeXi[W];
GaugeXi[ U[1] ] = GaugeXi[A];
GaugeXi[ U[2] ] = GaugeXi[Z];
GaugeXi[ U[31] ] = GaugeXi[W];
GaugeXi[ U[32] ] = GaugeXi[W];
GaugeXi[ U[4] ] = GaugeXi[G];

MZ[ ___ ] := MZ;
MW[ ___ ] := MW;
mvdiag[ 1 ] := 0;
mvdiag[ 2 ] := 0;
mvdiag[ 3 ] := 0;
mldiag[ 1 ] := MLE;
mldiag[ 2 ] := MLM;
mldiag[ 3 ] := MLT;
mudiag[ 1, _ ] := MQU;
mudiag[ 1 ] := MQU;
mudiag[ 2, _ ] := MQC;
mudiag[ 2 ] := MQC;
mudiag[ 3, _ ] := MQT;
mudiag[ 3 ] := MQT;
mddiag[ 1, _ ] := MQD;
mddiag[ 1 ] := MQD;
mddiag[ 2, _ ] := MQS;
mddiag[ 2 ] := MQS;
mddiag[ 3, _ ] := MQB;
mddiag[ 3 ] := MQB;
MH[ ___ ] := MH;
MG0[ ___ ] := MG0;
MGP[ ___ ] := MGP;
MgZ[ ___ ] := MgZ;
MgW[ ___ ] := MgW;


TheLabel[ V[4, {__}] ] := TheLabel[V[4]];
TheLabel[ F[1, {1}] ] := "ve";
TheLabel[ F[1, {2}] ] := "vm";
TheLabel[ F[1, {3}] ] := "vt";
TheLabel[ F[2, {1}] ] := "e";
TheLabel[ F[2, {2}] ] := "mu";
TheLabel[ F[2, {3}] ] := "ta";
TheLabel[ F[3, {1, _}] ] := "u";
TheLabel[ F[3, {1}] ] := "u";
TheLabel[ F[3, {2, _}] ] := "c";
TheLabel[ F[3, {2}] ] := "c";
TheLabel[ F[3, {3, _}] ] := "t";
TheLabel[ F[3, {3}] ] := "t";
TheLabel[ F[4, {1, _}] ] := "d";
TheLabel[ F[4, {1}] ] := "d";
TheLabel[ F[4, {2, _}] ] := "s";
TheLabel[ F[4, {2}] ] := "s";
TheLabel[ F[4, {3, _}] ] := "b";
TheLabel[ F[4, {3}] ] := "b";
TheLabel[ U[4, {__}] ] := TheLabel[U[4]];


(*      Couplings (calculated by FeynRules)      *)

M$CouplingMatrices = {

C[ S[2] , S[2] , S[2] , S[2] ] == {{(3*I)*gc1*Hmass^2*(16*Sqrt[2]*Gf^2 - 8*(Cll2x1x1x2 + 4*CphiBox + CphiD)*Gf*Lam + Sqrt[2]*(-3*Cll2x1x1x2^2 + 2*CphiD*(8*CphiBox + CphiD))*Lam^2), 0}, {(-24*I)*CphiBox*gc1*Lam*(-2*Gf + Sqrt[2]*CphiD*Lam), 0}, {(-8*I)*(2*CphiBox + CphiD)*gc1*Lam*(-2*Gf + Sqrt[2]*CphiD*Lam), 0}, {(-8*I)*(2*CphiBox + CphiD)*gc1*Lam*(-2*Gf + Sqrt[2]*CphiD*Lam), 0}, {(-8*I)*(2*CphiBox + CphiD)*gc1*Lam*(-2*Gf + Sqrt[2]*CphiD*Lam), 0}, {(-24*I)*CphiBox*gc1*Lam*(-2*Gf + Sqrt[2]*CphiD*Lam), 0}, {(-8*I)*(2*CphiBox + CphiD)*gc1*Lam*(-2*Gf + Sqrt[2]*CphiD*Lam), 0}, {(-32*I)*(Cphi4n1 + Cphi4n3)*gc1*Gf*Lam^2, 0}, {(-8*I)*(2*CphiBox + CphiD)*gc1*Lam*(-2*Gf + Sqrt[2]*CphiD*Lam), 0}, {(-32*I)*(Cphi4n1 + Cphi4n3)*gc1*Gf*Lam^2, 0}, {(-24*I)*CphiBox*gc1*Lam*(-2*Gf + Sqrt[2]*CphiD*Lam), 0}, {(-8*I)*(2*CphiBox + CphiD)*gc1*Lam*(-2*Gf + Sqrt[2]*CphiD*Lam), 0}, {(-32*I)*(Cphi4n1 + Cphi4n3)*gc1*Gf*Lam^2, 0}, {(-24*I)*CphiBox*gc1*Lam*(-2*Gf + Sqrt[2]*CphiD*Lam), 0}},

C[ S[2] , S[2] , S[3] , -S[3] ] == {{I*gc2*Hmass^2*(16*Sqrt[2]*Gf^2 - 8*(Cll2x1x1x2 + 4*CphiBox)*Gf*Lam + Sqrt[2]*(-3*Cll2x1x1x2^2 + 8*CphiBox*CphiD)*Lam^2), 0}, {(-4*I)*CphiBox*gc2*Lam*(-4*Gf + Sqrt[2]*CphiD*Lam), 0}, {(-8*I)*CphiBox*gc2*Lam*(-4*Gf + Sqrt[2]*CphiD*Lam), 0}, {(-2*I)*CphiD*gc2*Lam*(-4*Gf + Sqrt[2]*CphiD*Lam), 0}, {(-2*I)*CphiD*gc2*Lam*(-4*Gf + Sqrt[2]*CphiD*Lam), 0}, {(-4*I)*CphiBox*gc2*Lam*(-4*Gf + Sqrt[2]*CphiD*Lam), 0}, {(-2*I)*CphiD*gc2*Lam*(-4*Gf + Sqrt[2]*CphiD*Lam), 0}, {(-16*I)*Cphi4n1*gc2*Gf*Lam^2, 0}, {(-2*I)*CphiD*gc2*Lam*(-4*Gf + Sqrt[2]*CphiD*Lam), 0}, {(-16*I)*Cphi4n1*gc2*Gf*Lam^2, 0}, {(-4*I)*CphiBox*gc2*Lam*(-4*Gf + Sqrt[2]*CphiD*Lam), 0}, {(-8*I)*CphiBox*gc2*Lam*(-4*Gf + Sqrt[2]*CphiD*Lam), 0}, {(-32*I)*Cphi4n3*gc2*Gf*Lam^2, 0}, {(-4*I)*CphiBox*gc2*Lam*(-4*Gf + Sqrt[2]*CphiD*Lam), 0}},

C[ S[3] , S[3] , -S[3] , -S[3] ] == {{I*gc3*Hmass^2*(16*Sqrt[2]*Gf^2 - 8*(Cll2x1x1x2 + 4*CphiBox - CphiD)*Gf*Lam - 3*Sqrt[2]*Cll2x1x1x2^2*Lam^2), 0}, {(16*I)*CphiBox*gc3*Gf*Lam, 0}, {0, 0}, {(8*I)*(2*CphiBox + CphiD)*gc3*Gf*Lam, 0}, {(8*I)*(2*CphiBox + CphiD)*gc3*Gf*Lam, 0}, {(16*I)*CphiBox*gc3*Gf*Lam, 0}, {(8*I)*(2*CphiBox + CphiD)*gc3*Gf*Lam, 0}, {(-16*I)*(Cphi4n1 + Cphi4n3)*gc3*Gf*Lam^2, 0}, {(8*I)*(2*CphiBox + CphiD)*gc3*Gf*Lam, 0}, {(-16*I)*(Cphi4n1 + Cphi4n3)*gc3*Gf*Lam^2, 0}, {(16*I)*CphiBox*gc3*Gf*Lam, 0}, {0, 0}, {0, 0}, {(16*I)*CphiBox*gc3*Gf*Lam, 0}},

C[ S[2] , S[2] , S[1] ] == {{(-I)*gc4*Hmass^2*(-64*Gf^2 + 8*Sqrt[2]*(Cll2x1x1x2 + 4*CphiBox + CphiD)*Gf*Lam + (7*Cll2x1x1x2^2 + 16*CphiBox^2 - 24*CphiBox*CphiD - 3*CphiD^2 + 2*Cll2x1x1x2*(4*CphiBox + CphiD))*Lam^2), 0}, {(8*I)*CphiBox*gc4*Lam*(4*Sqrt[2]*Gf + (Cll2x1x1x2 + 4*CphiBox - 3*CphiD)*Lam), 0}, {(8*I)*(2*CphiBox + CphiD)*gc4*Lam*(4*Sqrt[2]*Gf + (Cll2x1x1x2 + 4*CphiBox - 3*CphiD)*Lam), 0}, {(8*I)*CphiBox*gc4*Lam*(4*Sqrt[2]*Gf + (Cll2x1x1x2 + 4*CphiBox - 3*CphiD)*Lam), 0}, {(8*I)*CphiBox*gc4*Lam*(4*Sqrt[2]*Gf + (Cll2x1x1x2 + 4*CphiBox - 3*CphiD)*Lam), 0}, {0, 0}, {0, 0}},

C[ S[3] , -S[3] , S[1] ] == {{(-I)*gc5*Hmass^2*(-64*Gf^2 + 8*Sqrt[2]*(Cll2x1x1x2 + 4*CphiBox - CphiD)*Gf*Lam + (7*Cll2x1x1x2^2 + Cll2x1x1x2*(8*CphiBox - 2*CphiD) + (-4*CphiBox + CphiD)^2)*Lam^2), 0}, {(8*I)*CphiBox*gc5*Lam*(4*Sqrt[2]*Gf + (Cll2x1x1x2 + 4*CphiBox - CphiD)*Lam), 0}, {(16*I)*CphiBox*gc5*Lam*(4*Sqrt[2]*Gf + (Cll2x1x1x2 + 4*CphiBox - CphiD)*Lam), 0}, {(8*I)*CphiBox*gc5*Lam*(4*Sqrt[2]*Gf + (Cll2x1x1x2 + 4*CphiBox - CphiD)*Lam), 0}, {(8*I)*CphiBox*gc5*Lam*(4*Sqrt[2]*Gf + (Cll2x1x1x2 + 4*CphiBox - CphiD)*Lam), 0}, {(4*I)*CphiD*gc5*Lam*(4*Sqrt[2]*Gf + (Cll2x1x1x2 + 4*CphiBox - CphiD)*Lam), 0}, {(4*I)*CphiD*gc5*Lam*(4*Sqrt[2]*Gf + (Cll2x1x1x2 + 4*CphiBox - CphiD)*Lam), 0}},

C[ S[2] , S[2] , S[1] , S[1] ] == {{I*gc6*(16*Sqrt[2]*Gf^3*Hmass^2 - 8*(Cll2x1x1x2 + CphiD)*Gf^2*Hmass^2*Lam - 24*(Cll2x1x1x2*Cphi + 4*Cphi8 + 4*Cphi*CphiBox - 2*Cphi*CphiD)*Lam^2 + Sqrt[2]*Gf*Lam*(-48*Cphi + (-3*Cll2x1x1x2^2 + 2*CphiD^2)*Hmass^2*Lam)), 0}, {(8*I)*CphiBox*gc6*Gf*Lam*(2*Gf + Sqrt[2]*(2*CphiBox - CphiD)*Lam), 0}, {(8*I)*(2*CphiBox + CphiD)*gc6*Gf*Lam*(2*Gf + Sqrt[2]*(2*CphiBox - CphiD)*Lam), 0}, {0, 0}, {0, 0}, {(8*I)*CphiBox*gc6*Gf*Lam*(2*Gf + Sqrt[2]*(2*CphiBox - CphiD)*Lam), 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {(8*I)*CphiBox*gc6*Gf*Lam*(2*Gf + Sqrt[2]*(2*CphiBox - CphiD)*Lam), 0}, {(8*I)*(2*CphiBox + CphiD)*gc6*Gf*Lam*(2*Gf + Sqrt[2]*(2*CphiBox - CphiD)*Lam), 0}, {(-32*I)*(Cphi4n1 + Cphi4n3)*gc6*Gf^2*Lam^2, 0}, {(8*I)*CphiBox*gc6*Gf*Lam*(2*Gf + Sqrt[2]*(2*CphiBox - CphiD)*Lam), 0}},

C[ S[3] , -S[3] , S[1] , S[1] ] == {{I*gc7*(16*Sqrt[2]*Gf^3*Hmass^2 - 8*Cll2x1x1x2*Gf^2*Hmass^2*Lam - 24*(Cll2x1x1x2*Cphi + 4*Cphi8 + 4*Cphi*CphiBox - Cphi*CphiD)*Lam^2 - 3*Sqrt[2]*Gf*Lam*(16*Cphi + Cll2x1x1x2^2*Hmass^2*Lam)), 0}, {(4*I)*CphiBox*gc7*Gf*Lam*(4*Gf + Sqrt[2]*(4*CphiBox - CphiD)*Lam), 0}, {(8*I)*CphiBox*gc7*Gf*Lam*(4*Gf + Sqrt[2]*(4*CphiBox - CphiD)*Lam), 0}, {(-2*I)*CphiD*gc7*Gf*Lam*(-4*Gf + Sqrt[2]*(-4*CphiBox + CphiD)*Lam), 0}, {(-2*I)*CphiD*gc7*Gf*Lam*(-4*Gf + Sqrt[2]*(-4*CphiBox + CphiD)*Lam), 0}, {(4*I)*CphiBox*gc7*Gf*Lam*(4*Gf + Sqrt[2]*(4*CphiBox - CphiD)*Lam), 0}, {(-2*I)*CphiD*gc7*Gf*Lam*(-4*Gf + Sqrt[2]*(-4*CphiBox + CphiD)*Lam), 0}, {(-16*I)*Cphi4n1*gc7*Gf^2*Lam^2, 0}, {(-2*I)*CphiD*gc7*Gf*Lam*(-4*Gf + Sqrt[2]*(-4*CphiBox + CphiD)*Lam), 0}, {(-16*I)*Cphi4n1*gc7*Gf^2*Lam^2, 0}, {(4*I)*CphiBox*gc7*Gf*Lam*(4*Gf + Sqrt[2]*(4*CphiBox - CphiD)*Lam), 0}, {(8*I)*CphiBox*gc7*Gf*Lam*(4*Gf + Sqrt[2]*(4*CphiBox - CphiD)*Lam), 0}, {(-32*I)*Cphi4n3*gc7*Gf^2*Lam^2, 0}, {(4*I)*CphiBox*gc7*Gf*Lam*(4*Gf + Sqrt[2]*(4*CphiBox - CphiD)*Lam), 0}},

C[ S[1] , S[1] , S[1] ] == {{(-3*I)*gc8*(-64*Gf^3*Hmass^2 + 8*Sqrt[2]*(Cll2x1x1x2 - 4*CphiBox + CphiD)*Gf^2*Hmass^2*Lam + 8*Sqrt[2]*(3*Cll2x1x1x2*Cphi + 8*Cphi8 + 12*Cphi*CphiBox - 3*Cphi*CphiD)*Lam^2 + Gf*Lam*(64*Cphi + (7*Cll2x1x1x2^2 - 3*(-4*CphiBox + CphiD)^2 + Cll2x1x1x2*(-8*CphiBox + 2*CphiD))*Hmass^2*Lam)), 0}, {(24*I)*CphiBox*gc8*Gf*Lam*(4*Sqrt[2]*Gf + (Cll2x1x1x2 + 12*CphiBox - 3*CphiD)*Lam), 0}, {(8*I)*(2*CphiBox + CphiD)*gc8*Gf*Lam*(4*Sqrt[2]*Gf + (Cll2x1x1x2 + 12*CphiBox - 3*CphiD)*Lam), 0}, {(24*I)*CphiBox*gc8*Gf*Lam*(4*Sqrt[2]*Gf + (Cll2x1x1x2 + 12*CphiBox - 3*CphiD)*Lam), 0}, {(24*I)*CphiBox*gc8*Gf*Lam*(4*Sqrt[2]*Gf + (Cll2x1x1x2 + 12*CphiBox - 3*CphiD)*Lam), 0}, {(8*I)*(2*CphiBox + CphiD)*gc8*Gf*Lam*(4*Sqrt[2]*Gf + (Cll2x1x1x2 + 12*CphiBox - 3*CphiD)*Lam), 0}, {(8*I)*(2*CphiBox + CphiD)*gc8*Gf*Lam*(4*Sqrt[2]*Gf + (Cll2x1x1x2 + 12*CphiBox - 3*CphiD)*Lam), 0}},

C[ S[1] , S[1] , S[1] , S[1] ] == {{(3*I)*gc9*(16*Sqrt[2]*Gf^3*Hmass^2 - 8*(Cll2x1x1x2 - 4*CphiBox + CphiD)*Gf^2*Hmass^2*Lam - 16*(3*Cll2x1x1x2*Cphi + 16*Cphi8 + 24*Cphi*CphiBox - 6*Cphi*CphiD)*Lam^2 + Sqrt[2]*Gf*Lam*(-96*Cphi + (-3*Cll2x1x1x2^2 + 2*(-4*CphiBox + CphiD)^2)*Hmass^2*Lam)), 0}, {(24*I)*CphiBox*gc9*Gf*Lam*(2*Gf + Sqrt[2]*(4*CphiBox - CphiD)*Lam), 0}, {(8*I)*(2*CphiBox + CphiD)*gc9*Gf*Lam*(2*Gf + Sqrt[2]*(4*CphiBox - CphiD)*Lam), 0}, {(8*I)*(2*CphiBox + CphiD)*gc9*Gf*Lam*(2*Gf + Sqrt[2]*(4*CphiBox - CphiD)*Lam), 0}, {(8*I)*(2*CphiBox + CphiD)*gc9*Gf*Lam*(2*Gf + Sqrt[2]*(4*CphiBox - CphiD)*Lam), 0}, {(24*I)*CphiBox*gc9*Gf*Lam*(2*Gf + Sqrt[2]*(4*CphiBox - CphiD)*Lam), 0}, {(8*I)*(2*CphiBox + CphiD)*gc9*Gf*Lam*(2*Gf + Sqrt[2]*(4*CphiBox - CphiD)*Lam), 0}, {(-32*I)*(Cphi4n1 + Cphi4n3)*gc9*Gf^2*Lam^2, 0}, {(8*I)*(2*CphiBox + CphiD)*gc9*Gf*Lam*(2*Gf + Sqrt[2]*(4*CphiBox - CphiD)*Lam), 0}, {(-32*I)*(Cphi4n1 + Cphi4n3)*gc9*Gf^2*Lam^2, 0}, {(24*I)*CphiBox*gc9*Gf*Lam*(2*Gf + Sqrt[2]*(4*CphiBox - CphiD)*Lam), 0}, {(8*I)*(2*CphiBox + CphiD)*gc9*Gf*Lam*(2*Gf + Sqrt[2]*(4*CphiBox - CphiD)*Lam), 0}, {(-32*I)*(Cphi4n1 + Cphi4n3)*gc9*Gf^2*Lam^2, 0}, {(24*I)*CphiBox*gc9*Gf*Lam*(2*Gf + Sqrt[2]*(4*CphiBox - CphiD)*Lam), 0}},

C[ S[2] , S[2] , S[2] , S[2] , S[2] , S[2] ] == {{(((45*I)/2)*Lam*(4*Cphi*Gf + 4*Sqrt[2]*Cphi8*Lam - 3*Sqrt[2]*Cphi*CphiD*Lam))/Gf, 0}},

C[ S[2] , S[2] , S[2] , S[2] , S[3] , -S[3] ] == {{((9*I)*Lam*(2*Cphi*Gf + 2*Sqrt[2]*Cphi8*Lam - Sqrt[2]*Cphi*CphiD*Lam))/Gf, 0}},

C[ S[2] , S[2] , S[3] , S[3] , -S[3] , -S[3] ] == {{((3*I)*Lam*(4*Cphi*Gf + 4*Sqrt[2]*Cphi8*Lam - Sqrt[2]*Cphi*CphiD*Lam))/Gf, 0}},

C[ S[3] , S[3] , S[3] , -S[3] , -S[3] , -S[3] ] == {{((36*I)*Lam*(Cphi*Gf + Sqrt[2]*Cphi8*Lam))/Gf, 0}},

C[ S[2] , S[2] , S[2] , S[2] , S[1] ] == {{(((9*I)/2)*Lam*(4*Sqrt[2]*Cphi*Gf + 8*Cphi8*Lam + Cphi*(Cll2x1x1x2 + 4*CphiBox - 5*CphiD)*Lam))/(2^(3/4)*Gf^(3/2)), 0}},

C[ S[2] , S[2] , S[3] , -S[3] , S[1] ] == {{(((3*I)/2)*Lam*(4*Sqrt[2]*Cphi*Gf + 8*Cphi8*Lam + Cphi*(Cll2x1x1x2 + 4*CphiBox - 3*CphiD)*Lam))/(2^(3/4)*Gf^(3/2)), 0}},

C[ S[3] , S[3] , -S[3] , -S[3] , S[1] ] == {{((3*I)*Lam*(4*Sqrt[2]*Cphi*Gf + 8*Cphi8*Lam + Cphi*(Cll2x1x1x2 + 4*CphiBox - CphiD)*Lam))/(2^(3/4)*Gf^(3/2)), 0}},

C[ S[2] , S[2] , S[2] , S[2] , S[1] , S[1] ] == {{(((9*I)/2)*Lam*(4*Cphi*Gf + 12*Sqrt[2]*Cphi8*Lam + Sqrt[2]*Cphi*(4*CphiBox - 3*CphiD)*Lam))/Gf, 0}},

C[ S[2] , S[2] , S[3] , -S[3] , S[1] , S[1] ] == {{((3*I)*Lam*(2*Cphi*Gf + 6*Sqrt[2]*Cphi8*Lam + Sqrt[2]*Cphi*(2*CphiBox - CphiD)*Lam))/Gf, 0}},

C[ S[3] , S[3] , -S[3] , -S[3] , S[1] , S[1] ] == {{((3*I)*Lam*(4*Cphi*Gf + 12*Sqrt[2]*Cphi8*Lam + Sqrt[2]*Cphi*(4*CphiBox - CphiD)*Lam))/Gf, 0}},

C[ S[2] , S[2] , S[1] , S[1] , S[1] ] == {{(((3*I)/2)*Lam*(40*Cphi8*Lam + 3*Cphi*(4*Sqrt[2]*Gf + (Cll2x1x1x2 + 12*CphiBox - 5*CphiD)*Lam)))/(2^(3/4)*Gf^(3/2)), 0}},

C[ S[3] , -S[3] , S[1] , S[1] , S[1] ] == {{(((3*I)/2)*Lam*(40*Cphi8*Lam + 3*Cphi*(4*Sqrt[2]*Gf + (Cll2x1x1x2 + 12*CphiBox - 3*CphiD)*Lam)))/(2^(3/4)*Gf^(3/2)), 0}},

C[ S[2] , S[2] , S[1] , S[1] , S[1] , S[1] ] == {{(((9*I)/2)*Lam*(4*Cphi*Gf + 20*Sqrt[2]*Cphi8*Lam + Sqrt[2]*Cphi*(8*CphiBox - 3*CphiD)*Lam))/Gf, 0}},

C[ S[3] , -S[3] , S[1] , S[1] , S[1] , S[1] ] == {{((9*I)*Lam*(2*Cphi*Gf + 10*Sqrt[2]*Cphi8*Lam + Sqrt[2]*Cphi*(4*CphiBox - CphiD)*Lam))/Gf, 0}},

C[ S[1] , S[1] , S[1] , S[1] , S[1] ] == {{(((15*I)/2)*Lam*(56*Cphi8*Lam + 3*Cphi*(4*Sqrt[2]*Gf + (Cll2x1x1x2 + 20*CphiBox - 5*CphiD)*Lam)))/(2^(3/4)*Gf^(3/2)), 0}},

C[ S[1] , S[1] , S[1] , S[1] , S[1] , S[1] ] == {{(((45*I)/2)*Lam*(4*Cphi*Gf + 28*Sqrt[2]*Cphi8*Lam + 3*Sqrt[2]*Cphi*(4*CphiBox - CphiD)*Lam))/Gf, 0}},

C[ S[2] , S[2] , S[2] , S[2] , S[2] , S[2] , S[2] , S[2] ] == {{(2520*I)*Cphi8*Lam^2, 0}},

C[ S[2] , S[2] , S[2] , S[2] , S[2] , S[2] , S[3] , -S[3] ] == {{(360*I)*Cphi8*Lam^2, 0}},

C[ S[2] , S[2] , S[2] , S[2] , S[3] , S[3] , -S[3] , -S[3] ] == {{(144*I)*Cphi8*Lam^2, 0}},

C[ S[2] , S[2] , S[3] , S[3] , S[3] , -S[3] , -S[3] , -S[3] ] == {{(144*I)*Cphi8*Lam^2, 0}},

C[ S[3] , S[3] , S[3] , S[3] , -S[3] , -S[3] , -S[3] , -S[3] ] == {{(576*I)*Cphi8*Lam^2, 0}},

C[ S[2] , S[2] , S[2] , S[2] , S[2] , S[2] , S[1] ] == {{((180*I)*2^(3/4)*Cphi8*Lam^2)/Sqrt[Gf], 0}},

C[ S[2] , S[2] , S[2] , S[2] , S[3] , -S[3] , S[1] ] == {{((36*I)*2^(3/4)*Cphi8*Lam^2)/Sqrt[Gf], 0}},

C[ S[2] , S[2] , S[3] , S[3] , -S[3] , -S[3] , S[1] ] == {{((24*I)*2^(3/4)*Cphi8*Lam^2)/Sqrt[Gf], 0}},

C[ S[3] , S[3] , S[3] , -S[3] , -S[3] , -S[3] , S[1] ] == {{((72*I)*2^(3/4)*Cphi8*Lam^2)/Sqrt[Gf], 0}},

C[ S[2] , S[2] , S[2] , S[2] , S[2] , S[2] , S[1] , S[1] ] == {{(360*I)*Cphi8*Lam^2, 0}},

C[ S[2] , S[2] , S[2] , S[2] , S[3] , -S[3] , S[1] , S[1] ] == {{(72*I)*Cphi8*Lam^2, 0}},

C[ S[2] , S[2] , S[3] , S[3] , -S[3] , -S[3] , S[1] , S[1] ] == {{(48*I)*Cphi8*Lam^2, 0}},

C[ S[3] , S[3] , S[3] , -S[3] , -S[3] , -S[3] , S[1] , S[1] ] == {{(144*I)*Cphi8*Lam^2, 0}},

C[ S[2] , S[2] , S[2] , S[2] , S[1] , S[1] , S[1] ] == {{((108*I)*2^(3/4)*Cphi8*Lam^2)/Sqrt[Gf], 0}},

C[ S[2] , S[2] , S[3] , -S[3] , S[1] , S[1] , S[1] ] == {{((36*I)*2^(3/4)*Cphi8*Lam^2)/Sqrt[Gf], 0}},

C[ S[3] , S[3] , -S[3] , -S[3] , S[1] , S[1] , S[1] ] == {{((72*I)*2^(3/4)*Cphi8*Lam^2)/Sqrt[Gf], 0}},

C[ S[2] , S[2] , S[2] , S[2] , S[1] , S[1] , S[1] , S[1] ] == {{(216*I)*Cphi8*Lam^2, 0}},

C[ S[2] , S[2] , S[3] , -S[3] , S[1] , S[1] , S[1] , S[1] ] == {{(72*I)*Cphi8*Lam^2, 0}},

C[ S[3] , S[3] , -S[3] , -S[3] , S[1] , S[1] , S[1] , S[1] ] == {{(144*I)*Cphi8*Lam^2, 0}},

C[ S[2] , S[2] , S[1] , S[1] , S[1] , S[1] , S[1] ] == {{((180*I)*2^(3/4)*Cphi8*Lam^2)/Sqrt[Gf], 0}},

C[ S[3] , -S[3] , S[1] , S[1] , S[1] , S[1] , S[1] ] == {{((180*I)*2^(3/4)*Cphi8*Lam^2)/Sqrt[Gf], 0}},

C[ S[2] , S[2] , S[1] , S[1] , S[1] , S[1] , S[1] , S[1] ] == {{(360*I)*Cphi8*Lam^2, 0}},

C[ S[3] , -S[3] , S[1] , S[1] , S[1] , S[1] , S[1] , S[1] ] == {{(360*I)*Cphi8*Lam^2, 0}},

C[ S[1] , S[1] , S[1] , S[1] , S[1] , S[1] , S[1] ] == {{((1260*I)*2^(3/4)*Cphi8*Lam^2)/Sqrt[Gf], 0}},

C[ S[1] , S[1] , S[1] , S[1] , S[1] , S[1] , S[1] , S[1] ] == {{(2520*I)*Cphi8*Lam^2, 0}},

C[ S[3] , -U[31] , U[2] ] == {{((-1/32*I)*Wmass*xiW*(16*CphiWB*Lam*Wmass*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(Wmass^2 - Zmass^2))) - Sqrt[-Wmass^2 + Zmass^2]*(64*Gf^2*(2*Wmass^2 - Zmass^2) + 8*Sqrt[2]*Gf*Lam*(Cll2x1x1x2*(-2*Wmass^2 + Zmass^2) + CphiD*(2*Wmass^2 + Zmass^2)) + Lam^2*(7*Cll2x1x1x2^2*(-2*Wmass^2 + Zmass^2) + 2*Cll2x1x1x2*CphiD*(2*Wmass^2 + Zmass^2) - CphiD^2*(2*Wmass^2 + 3*Zmass^2)))))/(2^(3/4)*Gf^(3/2)*Zmass*Sqrt[-Wmass^2 + Zmass^2]), 0}},

C[ -S[3] , -U[32] , U[2] ] == {{((-1/32*I)*Wmass*xiW*(16*CphiWB*Lam*Wmass*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(Wmass^2 - Zmass^2))) - Sqrt[-Wmass^2 + Zmass^2]*(64*Gf^2*(2*Wmass^2 - Zmass^2) + 8*Sqrt[2]*Gf*Lam*(Cll2x1x1x2*(-2*Wmass^2 + Zmass^2) + CphiD*(2*Wmass^2 + Zmass^2)) + Lam^2*(7*Cll2x1x1x2^2*(-2*Wmass^2 + Zmass^2) + 2*Cll2x1x1x2*CphiD*(2*Wmass^2 + Zmass^2) - CphiD^2*(2*Wmass^2 + 3*Zmass^2)))))/(2^(3/4)*Gf^(3/2)*Zmass*Sqrt[-Wmass^2 + Zmass^2]), 0}},

C[ S[3] , -U[2] , U[32] ] == {{((I/32)*(-64*Gf^2 + 8*Sqrt[2]*(Cll2x1x1x2 - CphiD)*Gf*Lam + (7*Cll2x1x1x2^2 - 2*Cll2x1x1x2*CphiD + CphiD^2)*Lam^2)*Wmass*xiZ*Zmass)/(2^(3/4)*Gf^(3/2)), 0}},

C[ -S[3] , -U[2] , U[31] ] == {{((I/32)*(-64*Gf^2 + 8*Sqrt[2]*(Cll2x1x1x2 - CphiD)*Gf*Lam + (7*Cll2x1x1x2^2 - 2*Cll2x1x1x2*CphiD + CphiD^2)*Lam^2)*Wmass*xiZ*Zmass)/(2^(3/4)*Gf^(3/2)), 0}},

C[ S[2] , -U[32] , U[32] ] == {{((64*Gf^2 - 8*Sqrt[2]*(Cll2x1x1x2 + CphiD)*Gf*Lam + (-7*Cll2x1x1x2^2 - 2*Cll2x1x1x2*CphiD + 3*CphiD^2)*Lam^2)*Wmass^2*xiW)/(32*2^(3/4)*Gf^(3/2)), 0}},

C[ S[2] , -U[31] , U[31] ] == {{((-64*Gf^2 + 8*Sqrt[2]*(Cll2x1x1x2 + CphiD)*Gf*Lam + (7*Cll2x1x1x2^2 + 2*Cll2x1x1x2*CphiD - 3*CphiD^2)*Lam^2)*Wmass^2*xiW)/(32*2^(3/4)*Gf^(3/2)), 0}},

C[ S[1] , -U[32] , U[32] ] == {{((I/32)*(64*Gf^2 - 8*Sqrt[2]*(Cll2x1x1x2 - 4*CphiBox + CphiD)*Gf*Lam + (-7*Cll2x1x1x2^2 + Cll2x1x1x2*(8*CphiBox - 2*CphiD) + 3*(-4*CphiBox + CphiD)^2)*Lam^2)*Wmass^2*xiW)/(2^(3/4)*Gf^(3/2)), 0}},

C[ S[1] , -U[31] , U[31] ] == {{((I/32)*(64*Gf^2 - 8*Sqrt[2]*(Cll2x1x1x2 - 4*CphiBox + CphiD)*Gf*Lam + (-7*Cll2x1x1x2^2 + Cll2x1x1x2*(8*CphiBox - 2*CphiD) + 3*(-4*CphiBox + CphiD)^2)*Lam^2)*Wmass^2*xiW)/(2^(3/4)*Gf^(3/2)), 0}},

C[ S[1] , -U[2] , U[2] ] == {{((I/32)*(64*Gf^2 - 8*Sqrt[2]*(Cll2x1x1x2 - 4*CphiBox + CphiD)*Gf*Lam + (-7*Cll2x1x1x2^2 + Cll2x1x1x2*(8*CphiBox - 2*CphiD) + 3*(-4*CphiBox + CphiD)^2)*Lam^2)*xiZ*Zmass^2)/(2^(3/4)*Gf^(3/2)), 0}},

C[ S[3] , -U[31] , U[1] ] == {{((-1/16*I)*Wmass^2*xiW*(64*Gf^2*(Wmass^2 - Zmass^2)^2 - 8*Sqrt[2]*Gf*Lam*(Wmass^2 - Zmass^2)*(Cll2x1x1x2*(Wmass^2 - Zmass^2) - Wmass*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2])) - Lam^2*(7*Cll2x1x1x2^2*(Wmass^2 - Zmass^2)^2 - 2*Cll2x1x1x2*Wmass*(Wmass^2 - Zmass^2)*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2]) + Wmass*(CphiD^2*Wmass^3 + 8*CphiD*CphiWB*(-Wmass^2 + Zmass^2)^(3/2) + 32*CphiW*CphiWB*(-Wmass^2 + Zmass^2)^(3/2)))))/(2^(3/4)*Gf^(3/2)*(Wmass - Zmass)*Zmass*(Wmass + Zmass)*Sqrt[-Wmass^2 + Zmass^2]), 0}},

C[ -S[3] , -U[32] , U[1] ] == {{((-1/16*I)*Wmass^2*xiW*(64*Gf^2*(Wmass^2 - Zmass^2)^2 - 8*Sqrt[2]*Gf*Lam*(Wmass^2 - Zmass^2)*(Cll2x1x1x2*(Wmass^2 - Zmass^2) - Wmass*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2])) - Lam^2*(7*Cll2x1x1x2^2*(Wmass^2 - Zmass^2)^2 - 2*Cll2x1x1x2*Wmass*(Wmass^2 - Zmass^2)*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2]) + Wmass*(CphiD^2*Wmass^3 + 8*CphiD*CphiWB*(-Wmass^2 + Zmass^2)^(3/2) + 32*CphiW*CphiWB*(-Wmass^2 + Zmass^2)^(3/2)))))/(2^(3/4)*Gf^(3/2)*(Wmass - Zmass)*Zmass*(Wmass + Zmass)*Sqrt[-Wmass^2 + Zmass^2]), 0}},

C[ S[3] , -S[3] , V[1] , V[1] ] == {{((-I)*gc62*Lam*(Wmass^2 - Zmass^2)*(8*Sqrt[2]*CphiW^2*Lam*(Wmass^2 - Zmass^2)^2 + CphiWB*Wmass*(4*Sqrt[2]*CphiWB*Lam*Wmass*(Wmass^2 - Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(-8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*CphiD*Lam*(-2*Wmass^2 + Zmass^2))) + 2*CphiW*(Wmass^2 - Zmass^2)*(4*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*Wmass*(CphiD*Wmass + 2*CphiWB*Sqrt[-Wmass^2 + Zmass^2]))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {((-I)*gc62*Wmass^2*(Wmass^2 - Zmass^2)*(16*Sqrt[2]*Gf^2*(Wmass^2 - Zmass^2)^2 - 8*Gf*Lam*(Wmass^2 - Zmass^2)*(Cll2x1x1x2*(Wmass^2 - Zmass^2) - Wmass*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2])) + Sqrt[2]*Lam^2*(-3*Cll2x1x1x2^2*(Wmass^2 - Zmass^2)^2 - 4*CphiWB*Wmass*(Sqrt[-Wmass^2 + Zmass^2]*(-2*CphiD*Wmass^2 - 4*CphiW*Wmass^2 + CphiD*Zmass^2 + 4*CphiW*Zmass^2) + 2*CphiWB*(Wmass^3 - Wmass*Zmass^2)))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {(I*Sqrt[2]*gc62*Lam*(Wmass^2 - Zmass^2)*(8*CphiW^2*Lam*(Wmass^2 - Zmass^2)^2 + 2*CphiW*(Wmass^2 - Zmass^2)*(2*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*Wmass*(CphiD*Wmass + 2*CphiWB*Sqrt[-Wmass^2 + Zmass^2])) + CphiWB*Wmass*(4*CphiWB*Lam*Wmass*(Wmass^2 - Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(CphiD*Lam*(-2*Wmass^2 + Zmass^2) + 4*Sqrt[2]*Gf*(-Wmass^2 + Zmass^2)))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {0, 0}, {0, 0}, {0, 0}},

C[ S[3] , S[3] , -S[3] , -S[3] , V[1] , V[1] ] == {{(-2*I)*(Cphi4n1 + Cphi4n3)*gc63*Gf*Lam*(Wmass^2 - Zmass^2), 0}, {(-2*I)*(Cphi4n1 + Cphi4n3)*gc63*Gf*Lam*(Wmass^2 - Zmass^2), 0}, {I*(Cphi4n1 + Cphi4n3)*gc63*Gf*Lam*(Wmass - Zmass)*(Wmass + Zmass), 0}, {I*(Cphi4n1 + Cphi4n3)*gc63*Gf*Lam*(Wmass - Zmass)*(Wmass + Zmass), 0}, {I*(Cphi4n1 + Cphi4n3)*gc63*Gf*Lam*(Wmass - Zmass)*(Wmass + Zmass), 0}, {I*(Cphi4n1 + Cphi4n3)*gc63*Gf*Lam*(Wmass - Zmass)*(Wmass + Zmass), 0}, {I*(Cphi4n1 + Cphi4n3)*gc63*Gf*Lam*(Wmass - Zmass)*(Wmass + Zmass), 0}, {I*(Cphi4n1 + Cphi4n3)*gc63*Gf*Lam*(Wmass - Zmass)*(Wmass + Zmass), 0}, {(-2*I)*(Cphi4n1 + Cphi4n3)*gc63*Gf*Lam*(Wmass - Zmass)*(Wmass + Zmass), 0}, {I*(Cphi4n1 + Cphi4n3)*gc63*Gf*Lam*(Wmass - Zmass)*(Wmass + Zmass), 0}, {I*(Cphi4n1 + Cphi4n3)*gc63*Gf*Lam*(Wmass - Zmass)*(Wmass + Zmass), 0}, {(-2*I)*(Cphi4n1 + Cphi4n3)*gc63*Gf*Lam*(Wmass - Zmass)*(Wmass + Zmass), 0}, {(-I)*Sqrt[2]*CphiD*gc63*(2*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Cll2x1x1x2*Lam*(-Wmass^2 + Zmass^2) + Lam*Wmass*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2])), 0}, {(2*I)*(Cphi4n1 + Cphi4n3)*gc63*Gf*Lam*(Wmass - Zmass)*(Wmass + Zmass), 0}, {(2*I)*(Cphi4n1 + Cphi4n3)*gc63*Gf*Lam*(Wmass - Zmass)*(Wmass + Zmass), 0}, {(2*I)*(Cphi4n1 + Cphi4n3)*gc63*Gf*Lam*(Wmass - Zmass)*(Wmass + Zmass), 0}, {(2*I)*(Cphi4n1 + Cphi4n3)*gc63*Gf*Lam*(Wmass - Zmass)*(Wmass + Zmass), 0}, {0, 0}, {0, 0}},

C[ S[3] , S[3] , -S[3] , -S[3] , V[1] , V[1] , V[1] , V[1] ] == {{I*gc64, 0}, {I*gc64, 0}, {I*gc64, 0}},

C[ S[2] , S[3] , -S[3] , V[1] ] == {{gc65, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}},

C[ S[2] , S[3] , -S[3] , S[1] , V[1] ] == {{(CphiD*gc66*(Wmass^2 - Zmass^2)*(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(4*CphiBox*Wmass^2 - CphiD*Wmass^2 - 4*CphiBox*Zmass^2 + 2*CphiD*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2)))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {(CphiD*gc66*(Wmass^2 - Zmass^2)*(4*Sqrt[2]*CphiWB*Lam*Wmass*(Wmass^2 - Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(-8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(-4*CphiBox*Wmass^2 + CphiD*Wmass^2 + 4*CphiBox*Zmass^2 - 2*CphiD*Zmass^2 + Cll2x1x1x2*(Wmass^2 - Zmass^2)))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {-8*Cphi4n1*gc66*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {-8*Cphi4n1*gc66*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {8*Cphi4n1*gc66*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {8*Cphi4n1*gc66*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}},

C[ S[2] , S[2] , S[3] , -S[3] , V[1] , V[1] ] == {{I*Cphi4n1*gc67, 0}, {I*Cphi4n1*gc67, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {(2*I)*Cphi4n3*gc67, 0}, {0, 0}},

C[ -U[32] , U[32] , V[1] ] == {{I*gc68, 0}, {0, 0}},

C[ -U[31] , U[31] , V[1] ] == {{I*gc69, 0}, {0, 0}},

C[ S[3] , -S[3] , V[1] ] == {{(-I)*gc70, 0}, {I*gc70, 0}},

C[ S[3] , S[3] , -S[3] , -S[3] , V[1] ] == {{(I*CphiD*gc71*(Wmass^2 - Zmass^2)*(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(-(Cll2x1x1x2*Wmass^2) + CphiD*Wmass^2 + Cll2x1x1x2*Zmass^2))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {((-I)*CphiD*gc71*(Wmass^2 - Zmass^2)*(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(-(Cll2x1x1x2*Wmass^2) + CphiD*Wmass^2 + Cll2x1x1x2*Zmass^2))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {0, 0}, {(-8*I)*(Cphi4n1 + Cphi4n3)*gc71*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(8*I)*(Cphi4n1 + Cphi4n3)*gc71*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {0, 0}, {(I*Sqrt[2]*CphiD*gc71*(Wmass^2 - Zmass^2)*(4*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(CphiD*Lam*Wmass^2 + 4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Cll2x1x1x2*Lam*(-Wmass^2 + Zmass^2))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {((-I)*Sqrt[2]*CphiD*gc71*(Wmass^2 - Zmass^2)*(4*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(CphiD*Lam*Wmass^2 + 4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Cll2x1x1x2*Lam*(-Wmass^2 + Zmass^2))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {(8*I)*(Cphi4n1 + Cphi4n3)*gc71*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(8*I)*(Cphi4n1 + Cphi4n3)*gc71*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(-8*I)*(Cphi4n1 + Cphi4n3)*gc71*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(8*I)*(Cphi4n1 + Cphi4n3)*gc71*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(-8*I)*(Cphi4n1 + Cphi4n3)*gc71*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(-8*I)*(Cphi4n1 + Cphi4n3)*gc71*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {0, 0}, {0, 0}},

C[ S[3] , S[3] , -S[3] , -S[3] , V[1] , V[1] , V[1] ] == {{(-I)*gc72, 0}, {(-I)*gc72, 0}, {I*gc72, 0}, {I*gc72, 0}, {(-I)*gc72, 0}, {(-I)*gc72, 0}, {I*gc72, 0}, {I*gc72, 0}, {(-I)*gc72, 0}, {(-I)*gc72, 0}, {I*gc72, 0}, {I*gc72, 0}},

C[ S[2] , S[3] , -S[3] ] == {{0, 0}, {0, 0}, {-gc73, 0}, {0, 0}, {0, 0}, {gc73, 0}, {0, 0}},

C[ S[2] , S[3] , -S[3] , S[1] ] == {{0, 0}, {0, 0}, {CphiD*gc74*(-4*Gf + Sqrt[2]*(-2*CphiBox + CphiD)*Lam), 0}, {-(CphiD*gc74*(-4*Gf + Sqrt[2]*(-2*CphiBox + CphiD)*Lam)), 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {-(CphiD*gc74*(-4*Gf + Sqrt[2]*(-2*CphiBox + CphiD)*Lam)), 0}, {-8*Cphi4n1*gc74*Gf*Lam, 0}, {0, 0}, {CphiD*gc74*(-4*Gf + Sqrt[2]*(-2*CphiBox + CphiD)*Lam), 0}, {8*Cphi4n1*gc74*Gf*Lam, 0}, {0, 0}},

C[ S[2] , S[2] , S[3] , -S[3] , V[1] ] == {{0, 0}, {0, 0}, {(-2*I)*Cphi4n3*gc75, 0}, {0, 0}, {(-I)*Cphi4n1*gc75, 0}, {0, 0}, {0, 0}, {0, 0}, {I*Cphi4n1*gc75, 0}, {(-I)*Cphi4n1*gc75, 0}, {0, 0}, {I*Cphi4n1*gc75, 0}, {0, 0}, {0, 0}, {(2*I)*Cphi4n3*gc75, 0}, {0, 0}},

C[ S[3] , -S[3] , S[1] , S[1] , V[1] , V[1] ] == {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {I*Cphi4n1*gc76, 0}, {0, 0}, {0, 0}, {I*Cphi4n1*gc76, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {(2*I)*Cphi4n3*gc76, 0}},

C[ S[3] , -S[3] , S[1] , S[1] , V[1] ] == {{0, 0}, {0, 0}, {0, 0}, {(-I)*Cphi4n1*gc77, 0}, {0, 0}, {(-2*I)*Cphi4n3*gc77, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {(-I)*Cphi4n1*gc77, 0}, {0, 0}, {I*Cphi4n1*gc77, 0}, {I*Cphi4n1*gc77, 0}, {0, 0}, {(2*I)*Cphi4n3*gc77, 0}},

C[ S[2] , S[2] , V[1] , V[1] ] == {{(-I)*gc78, 0}, {0, 0}, {(I*Sqrt[2]*gc78*(8*CphiW^2*Lam*(Wmass^2 - Zmass^2)^2 + CphiWB*Wmass*(4*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(CphiD*Lam*Zmass^2 + 4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2))) + 2*CphiW*(Wmass^2 - Zmass^2)*(2*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(CphiD*Zmass^2 + 6*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2]))))/(8*Sqrt[2]*CphiW^2*Lam*(Wmass^2 - Zmass^2)^2 + CphiWB*Wmass*(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*Wmass^2 - 8*Gf*Zmass^2 + Sqrt[2]*CphiD*Lam*Zmass^2)) + 2*CphiW*(Wmass^2 - Zmass^2)*(4*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Zmass^2 + 6*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2]))), 0}, {0, 0}, {0, 0}, {0, 0}},

C[ S[1] , V[1] , V[1] ] == {{(-I)*gc79, 0}, {I*gc79, 0}, {0, 0}},

C[ S[1] , S[1] , V[1] , V[1] ] == {{(-I)*gc80, 0}, {0, 0}, {(I*Sqrt[2]*gc80*(8*CphiW^2*Lam*(Wmass^2 - Zmass^2)^2 + CphiWB*Wmass*(4*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(CphiD*Lam*Zmass^2 + 4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + 8*CphiBox*Lam*(Wmass^2 - Zmass^2))) + 2*CphiW*(Wmass^2 - Zmass^2)*(2*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(CphiD*Zmass^2 + 4*CphiBox*(Wmass^2 - Zmass^2) + 6*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2]))))/(8*Sqrt[2]*CphiW^2*Lam*(Wmass^2 - Zmass^2)^2 + 2*CphiW*(Wmass^2 - Zmass^2)*(4*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Zmass^2 + 4*CphiBox*(Wmass^2 - Zmass^2) + 6*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2])) + CphiWB*Wmass*(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(8*CphiBox*Wmass^2 - 8*CphiBox*Zmass^2 + CphiD*Zmass^2)))), 0}, {0, 0}, {0, 0}, {0, 0}},

C[ S[2] , -S[3] , V[1] , V[3] ] == {{32*CphiWB*gc81*Lam*(2*Gf + Sqrt[2]*CphiW*Lam)*(-Wmass^2 + Zmass^2)^(3/2), 0}, {-((gc81*Wmass*(-Wmass^2 + Zmass^2)*(64*Sqrt[2]*Gf^2*(Wmass^2 - Zmass^2)^2 - 16*Gf*Lam*(Wmass^2 - Zmass^2)*(-(CphiD*Zmass^2) + 2*Cll2x1x1x2*(Wmass^2 - Zmass^2) - 4*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2]) + Sqrt[2]*Lam^2*(-12*Cll2x1x1x2^2*(Wmass^2 - Zmass^2)^2 - 32*CphiW*CphiWB*Wmass*(-Wmass^2 + Zmass^2)^(3/2) + CphiD^2*(-4*Wmass^2*Zmass^2 + 3*Zmass^4))))/((Wmass - Zmass)*(Wmass + Zmass))), 0}, {-32*CphiWB*gc81*Lam*(2*Gf + Sqrt[2]*CphiW*Lam)*(-Wmass^2 + Zmass^2)^(3/2), 0}, {0, 0}, {0, 0}, {0, 0}},

C[ -S[3] , V[1] , V[3] ] == {{(-8*I)*CphiWB*gc82*Lam*(4*Sqrt[2]*Gf + (Cll2x1x1x2 + CphiD + 4*CphiW)*Lam)*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(8*I)*CphiWB*gc82*Lam*(4*Sqrt[2]*Gf + (Cll2x1x1x2 + CphiD + 4*CphiW)*Lam)*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(I*gc82*Wmass*(-Wmass^2 + Zmass^2)*(64*Gf^2*(Wmass^2 - Zmass^2)^2 - 8*Sqrt[2]*Gf*Lam*(Wmass^2 - Zmass^2)*(Cll2x1x1x2*(Wmass^2 - Zmass^2) - Wmass*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2])) - Lam^2*(7*Cll2x1x1x2^2*(Wmass^2 - Zmass^2)^2 - 2*Cll2x1x1x2*Wmass*(Wmass^2 - Zmass^2)*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2]) + Wmass*(CphiD^2*Wmass^3 + 8*CphiD*CphiWB*(-Wmass^2 + Zmass^2)^(3/2) + 32*CphiW*CphiWB*(-Wmass^2 + Zmass^2)^(3/2)))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}},

C[ -S[3] , S[1] , V[1] , V[3] ] == {{(32*I)*CphiWB*gc83*Lam*(2*Gf + Sqrt[2]*(CphiBox + CphiW)*Lam)*(-Wmass^2 + Zmass^2)^(3/2), 0}, {((-I)*gc83*Wmass*(-Wmass^2 + Zmass^2)*(64*Sqrt[2]*Gf^2*(Wmass^2 - Zmass^2)^2 + 16*Gf*Lam*(Wmass^2 - Zmass^2)*(-2*Cll2x1x1x2*Wmass^2 + 4*CphiBox*Wmass^2 + 2*Cll2x1x1x2*Zmass^2 - 4*CphiBox*Zmass^2 + CphiD*Zmass^2 + 4*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2]) + Sqrt[2]*Lam^2*(-4*CphiD^2*Wmass^2*Zmass^2 + 3*CphiD^2*Zmass^4 - 12*Cll2x1x1x2^2*(Wmass^2 - Zmass^2)^2 + 48*CphiBox^2*(Wmass^2 - Zmass^2)^2 + 32*CphiW*CphiWB*Wmass^3*Sqrt[-Wmass^2 + Zmass^2] - 32*CphiW*CphiWB*Wmass*Zmass^2*Sqrt[-Wmass^2 + Zmass^2] - 8*CphiBox*(Wmass^2 - Zmass^2)*(2*CphiD*Wmass^2 - 3*CphiD*Zmass^2 - 4*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2]))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {(-32*I)*CphiWB*gc83*Lam*(2*Gf + Sqrt[2]*(CphiBox + CphiW)*Lam)*(-Wmass^2 + Zmass^2)^(3/2), 0}, {0, 0}, {0, 0}, {0, 0}},

C[ S[2] , S[3] , V[1] , -V[3] ] == {{32*CphiWB*gc84*Lam*(2*Gf + Sqrt[2]*CphiW*Lam)*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(gc84*Wmass*(-Wmass^2 + Zmass^2)*(-64*Sqrt[2]*Gf^2*(Wmass^2 - Zmass^2)^2 + 16*Gf*Lam*(Wmass^2 - Zmass^2)*(-(CphiD*Zmass^2) + 2*Cll2x1x1x2*(Wmass^2 - Zmass^2) - 4*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2]) + Sqrt[2]*Lam^2*(12*Cll2x1x1x2^2*(Wmass^2 - Zmass^2)^2 + 32*CphiW*CphiWB*Wmass*(-Wmass^2 + Zmass^2)^(3/2) + CphiD^2*(4*Wmass^2*Zmass^2 - 3*Zmass^4))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {-32*CphiWB*gc84*Lam*(2*Gf + Sqrt[2]*CphiW*Lam)*(-Wmass^2 + Zmass^2)^(3/2), 0}, {0, 0}, {0, 0}, {0, 0}},

C[ S[3] , V[1] , -V[3] ] == {{(-8*I)*CphiWB*gc85*Lam*(4*Sqrt[2]*Gf + (Cll2x1x1x2 + CphiD + 4*CphiW)*Lam)*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(8*I)*CphiWB*gc85*Lam*(4*Sqrt[2]*Gf + (Cll2x1x1x2 + CphiD + 4*CphiW)*Lam)*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(I*gc85*Wmass*(-Wmass^2 + Zmass^2)*(64*Gf^2*(Wmass^2 - Zmass^2)^2 - 8*Sqrt[2]*Gf*Lam*(Wmass^2 - Zmass^2)*(Cll2x1x1x2*(Wmass^2 - Zmass^2) - Wmass*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2])) - Lam^2*(7*Cll2x1x1x2^2*(Wmass^2 - Zmass^2)^2 - 2*Cll2x1x1x2*Wmass*(Wmass^2 - Zmass^2)*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2]) + Wmass*(CphiD^2*Wmass^3 + 8*CphiD*CphiWB*(-Wmass^2 + Zmass^2)^(3/2) + 32*CphiW*CphiWB*(-Wmass^2 + Zmass^2)^(3/2)))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}},

C[ S[3] , S[1] , V[1] , -V[3] ] == {{(32*I)*CphiWB*gc86*Lam*(2*Gf + Sqrt[2]*(CphiBox + CphiW)*Lam)*(-Wmass^2 + Zmass^2)^(3/2), 0}, {((-I)*gc86*Wmass*(-Wmass^2 + Zmass^2)*(64*Sqrt[2]*Gf^2*(Wmass^2 - Zmass^2)^2 + 16*Gf*Lam*(Wmass^2 - Zmass^2)*(-2*Cll2x1x1x2*Wmass^2 + 4*CphiBox*Wmass^2 + 2*Cll2x1x1x2*Zmass^2 - 4*CphiBox*Zmass^2 + CphiD*Zmass^2 + 4*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2]) + Sqrt[2]*Lam^2*(-4*CphiD^2*Wmass^2*Zmass^2 + 3*CphiD^2*Zmass^4 - 12*Cll2x1x1x2^2*(Wmass^2 - Zmass^2)^2 + 48*CphiBox^2*(Wmass^2 - Zmass^2)^2 + 32*CphiW*CphiWB*Wmass^3*Sqrt[-Wmass^2 + Zmass^2] - 32*CphiW*CphiWB*Wmass*Zmass^2*Sqrt[-Wmass^2 + Zmass^2] - 8*CphiBox*(Wmass^2 - Zmass^2)*(2*CphiD*Wmass^2 - 3*CphiD*Zmass^2 - 4*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2]))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {(-32*I)*CphiWB*gc86*Lam*(2*Gf + Sqrt[2]*(CphiBox + CphiW)*Lam)*(-Wmass^2 + Zmass^2)^(3/2), 0}, {0, 0}, {0, 0}, {0, 0}},

C[ S[2] , S[2] , V[3] , -V[3] ] == {{(-8*I)*CphiW*gc87*Lam*(4*Gf - Sqrt[2]*(CphiD - 4*CphiW)*Lam), 0}, {(-I)*gc87*(16*Sqrt[2]*Gf^2 - 8*(Cll2x1x1x2 + CphiD)*Gf*Lam + Sqrt[2]*(-3*Cll2x1x1x2^2 + 2*CphiD^2)*Lam^2)*Wmass^2, 0}, {(8*I)*CphiW*gc87*Lam*(4*Gf - Sqrt[2]*(CphiD - 4*CphiW)*Lam), 0}, {(8*I)*Cphi4n1*gc87*Gf*Lam^2*Wmass^2, 0}, {(8*I)*Cphi4n1*gc87*Gf*Lam^2*Wmass^2, 0}, {(16*I)*Cphi4n3*gc87*Gf*Lam^2*Wmass^2, 0}},

C[ S[3] , -S[3] , V[3] , -V[3] ] == {{(-32*I)*CphiW*gc88*Lam*(Gf + Sqrt[2]*CphiW*Lam), 0}, {(-I)*gc88*(16*Sqrt[2]*Gf^2 - 8*(Cll2x1x1x2 - 2*CphiD)*Gf*Lam - 3*Sqrt[2]*Cll2x1x1x2^2*Lam^2)*Wmass^2, 0}, {(32*I)*CphiW*gc88*Lam*(Gf + Sqrt[2]*CphiW*Lam), 0}, {(16*I)*(Cphi4n1 + Cphi4n3)*gc88*Gf*Lam^2*Wmass^2, 0}, {0, 0}, {(16*I)*(Cphi4n1 + Cphi4n3)*gc88*Gf*Lam^2*Wmass^2, 0}},

C[ S[1] , V[3] , -V[3] ] == {{(16*I)*CphiW*gc89*Lam*(4*Sqrt[2]*Gf + (Cll2x1x1x2 + 4*CphiBox - CphiD + 8*CphiW)*Lam), 0}, {(-16*I)*CphiW*gc89*Lam*(4*Sqrt[2]*Gf + (Cll2x1x1x2 + 4*CphiBox - CphiD + 8*CphiW)*Lam), 0}, {I*gc89*(64*Gf^2 - 8*Sqrt[2]*(Cll2x1x1x2 - 4*CphiBox + CphiD)*Gf*Lam + (-7*Cll2x1x1x2^2 + Cll2x1x1x2*(8*CphiBox - 2*CphiD) + 3*(-4*CphiBox + CphiD)^2)*Lam^2)*Wmass^2, 0}},

C[ S[1] , S[1] , V[3] , -V[3] ] == {{(-8*I)*CphiW*gc90*Lam*(4*Gf + Sqrt[2]*(4*CphiBox - CphiD + 4*CphiW)*Lam), 0}, {(-I)*gc90*(16*Sqrt[2]*Gf^2 - 8*(Cll2x1x1x2 - 4*CphiBox + CphiD)*Gf*Lam + Sqrt[2]*(-3*Cll2x1x1x2^2 + 2*(-4*CphiBox + CphiD)^2)*Lam^2)*Wmass^2, 0}, {(8*I)*CphiW*gc90*Lam*(4*Gf + Sqrt[2]*(4*CphiBox - CphiD + 4*CphiW)*Lam), 0}, {(8*I)*Cphi4n1*gc90*Gf*Lam^2*Wmass^2, 0}, {(8*I)*Cphi4n1*gc90*Gf*Lam^2*Wmass^2, 0}, {(16*I)*Cphi4n3*gc90*Gf*Lam^2*Wmass^2, 0}},

C[ S[2] , S[2] , V[1] , V[2] ] == {{(-I)*gc91, 0}, {0, 0}, {(I*Sqrt[2]*gc91*(-4*CphiWB^2*Lam*Wmass*(-Wmass^2 + Zmass^2)^(3/2) - CphiW*Wmass*Sqrt[-Wmass^2 + Zmass^2]*(CphiD*Lam*Zmass^2 + 4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + 8*CphiW*Lam*(Wmass^2 - Zmass^2)) + CphiWB*(Wmass^2 - Zmass^2)*(2*Sqrt[2]*Gf*(2*Wmass^2 - Zmass^2) + Lam*(12*CphiW*Wmass^2 + CphiD*Zmass^2 - 6*CphiW*Zmass^2))))/(-4*Sqrt[2]*CphiWB^2*Lam*Wmass*(-Wmass^2 + Zmass^2)^(3/2) + CphiWB*(Wmass^2 - Zmass^2)*(Gf*(8*Wmass^2 - 4*Zmass^2) + Sqrt[2]*Lam*(12*CphiW*Wmass^2 + CphiD*Zmass^2 - 6*CphiW*Zmass^2)) - CphiW*Wmass*Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Zmass^2 + 8*CphiW*(Wmass^2 - Zmass^2)))), 0}, {0, 0}, {0, 0}, {0, 0}},

C[ S[3] , -S[3] , V[1] , V[2] ] == {{(8*I)*gc92*Lam*(-Wmass^2 + Zmass^2)*(8*Sqrt[2]*CphiW^2*Lam*Wmass*(Wmass^2 - Zmass^2) + 4*Sqrt[2]*CphiWB^2*Lam*Wmass*(Wmass^2 - Zmass^2) - 2*CphiWB*Sqrt[-Wmass^2 + Zmass^2]*(4*Gf*Wmass^2 + Sqrt[2]*CphiD*Lam*Wmass^2 - 2*Gf*Zmass^2) + 8*CphiW*Gf*(Wmass^3 - Wmass*Zmass^2) + Sqrt[2]*CphiW*Lam*(2*Wmass^2 - Zmass^2)*(CphiD*Wmass + 2*CphiWB*Sqrt[-Wmass^2 + Zmass^2])), 0}, {(I*gc92*Wmass*(-Wmass^2 + Zmass^2)*(64*Sqrt[2]*Gf^2*(Wmass^2 - Zmass^2)^2*(2*Wmass^2 - Zmass^2) + Sqrt[2]*Lam^2*(-12*Cll2x1x1x2^2*(Wmass^2 - Zmass^2)^2*(2*Wmass^2 - Zmass^2) + CphiD^2*Zmass^4*(-2*Wmass^2 + Zmass^2) - 16*CphiWB*Wmass*(-Wmass^2 + Zmass^2)^(3/2)*(4*CphiD*Wmass^2 + 8*CphiW*Wmass^2 - CphiD*Zmass^2 - 6*CphiW*Zmass^2) - 64*CphiWB^2*(Wmass^3 - Wmass*Zmass^2)^2) + 16*Gf*Lam*(Wmass^2 - Zmass^2)*(CphiD*(-2*Wmass^2 + Zmass^2)^2 + 4*CphiWB*Wmass*(4*Wmass^2 - 3*Zmass^2)*Sqrt[-Wmass^2 + Zmass^2] - 2*Cll2x1x1x2*(2*Wmass^4 - 3*Wmass^2*Zmass^2 + Zmass^4))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {(-8*I)*Sqrt[2]*gc92*Lam*(-Wmass^2 + Zmass^2)*(4*Sqrt[2]*CphiW*Gf*Wmass*(Wmass^2 - Zmass^2) + 8*CphiW^2*Lam*Wmass*(Wmass^2 - Zmass^2) + 4*CphiWB^2*Lam*Wmass*(Wmass^2 - Zmass^2) + 2*CphiWB*Sqrt[-Wmass^2 + Zmass^2]*(-(CphiD*Lam*Wmass^2) + Sqrt[2]*Gf*(-2*Wmass^2 + Zmass^2)) + CphiW*Lam*(2*Wmass^2 - Zmass^2)*(CphiD*Wmass + 2*CphiWB*Sqrt[-Wmass^2 + Zmass^2])), 0}, {0, 0}, {0, 0}, {0, 0}},

C[ S[1] , V[1] , V[2] ] == {{(-I)*gc93, 0}, {I*gc93, 0}, {0, 0}},

C[ S[1] , S[1] , V[1] , V[2] ] == {{(-I)*gc94, 0}, {0, 0}, {(I*Sqrt[2]*gc94*(-4*CphiWB^2*Lam*Wmass*(-Wmass^2 + Zmass^2)^(3/2) + CphiWB*(Wmass^2 - Zmass^2)*(2*Sqrt[2]*Gf*(2*Wmass^2 - Zmass^2) + Lam*(8*CphiBox*Wmass^2 + 12*CphiW*Wmass^2 - 4*CphiBox*Zmass^2 + CphiD*Zmass^2 - 6*CphiW*Zmass^2)) - CphiW*Wmass*Sqrt[-Wmass^2 + Zmass^2]*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(8*CphiW*Wmass^2 + CphiD*Zmass^2 - 8*CphiW*Zmass^2 + 8*CphiBox*(Wmass^2 - Zmass^2)))))/(-4*Sqrt[2]*CphiWB^2*Lam*Wmass*(-Wmass^2 + Zmass^2)^(3/2) + CphiWB*(Wmass^2 - Zmass^2)*(Gf*(8*Wmass^2 - 4*Zmass^2) + Sqrt[2]*Lam*(8*CphiBox*Wmass^2 + 12*CphiW*Wmass^2 - 4*CphiBox*Zmass^2 + CphiD*Zmass^2 - 6*CphiW*Zmass^2)) - CphiW*Wmass*Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(8*CphiW*Wmass^2 + CphiD*Zmass^2 - 8*CphiW*Zmass^2 + 8*CphiBox*(Wmass^2 - Zmass^2)))), 0}, {0, 0}, {0, 0}, {0, 0}},

C[ -S[3] , V[3] , V[2] ] == {{(-8*I)*CphiWB*gc95*Lam*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(Wmass^2 - Zmass^2))), 0}, {(8*I)*CphiWB*gc95*Lam*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(Wmass^2 - Zmass^2))), 0}, {I*gc95*Wmass*((64*Gf^2 + 8*Sqrt[2]*(-Cll2x1x1x2 + CphiD)*Gf*Lam - (7*Cll2x1x1x2^2 - 2*Cll2x1x1x2*CphiD + CphiD^2)*Lam^2)*(-Wmass^2 + Zmass^2)^(3/2) + 8*CphiWB*Lam*Wmass*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(Wmass^2 - Zmass^2)))), 0}},

C[ S[2] , -S[3] , V[3] , V[2] ] == {{2*CphiWB*gc96*Lam*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Zmass^2 + 4*CphiW*(Wmass^2 - Zmass^2))), 0}, {-(gc96*Wmass*((16*Sqrt[2]*Gf^2 - 8*Cll2x1x1x2*Gf*Lam - 3*Sqrt[2]*Cll2x1x1x2^2*Lam^2)*(-Wmass^2 + Zmass^2)^(3/2) + 2*CphiWB*Lam*Wmass*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Zmass^2 + 4*CphiW*(Wmass^2 - Zmass^2))))), 0}, {-2*CphiWB*gc96*Lam*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Zmass^2 + 4*CphiW*(Wmass^2 - Zmass^2))), 0}, {16*Cphi4n3*gc96*Gf*Lam^2*Wmass*Zmass^2*Sqrt[-Wmass^2 + Zmass^2], 0}, {8*Cphi4n1*gc96*Gf*Lam^2*Wmass*Zmass^2*Sqrt[-Wmass^2 + Zmass^2], 0}, {8*Cphi4n1*gc96*Gf*Lam^2*Wmass*Zmass^2*Sqrt[-Wmass^2 + Zmass^2], 0}},

C[ -S[3] , S[1] , V[3] , V[2] ] == {{(2*I)*CphiWB*gc97*Lam*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(4*CphiW*Wmass^2 + CphiD*Zmass^2 - 4*CphiW*Zmass^2 + 4*CphiBox*(Wmass^2 - Zmass^2))), 0}, {(-I)*gc97*Wmass*(2*CphiWB*Lam*Wmass*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(4*CphiW*Wmass^2 + CphiD*Zmass^2 - 4*CphiW*Zmass^2 + 4*CphiBox*(Wmass^2 - Zmass^2))) + Sqrt[-Wmass^2 + Zmass^2]*(-16*Sqrt[2]*Gf^2*(Wmass^2 - Zmass^2) + 8*Gf*Lam*(-2*CphiBox*Wmass^2 + 2*CphiBox*Zmass^2 + 2*CphiD*Zmass^2 + Cll2x1x1x2*(Wmass^2 - Zmass^2)) + Sqrt[2]*Lam^2*(-4*CphiD^2*Zmass^2 + 3*Cll2x1x1x2^2*(Wmass^2 - Zmass^2) - 12*CphiBox^2*(Wmass^2 - Zmass^2) + 4*CphiBox*CphiD*(Wmass^2 + Zmass^2)))), 0}, {(-2*I)*CphiWB*gc97*Lam*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(4*CphiW*Wmass^2 + CphiD*Zmass^2 - 4*CphiW*Zmass^2 + 4*CphiBox*(Wmass^2 - Zmass^2))), 0}, {(-8*I)*Cphi4n1*gc97*Gf*Lam^2*Wmass*Zmass^2*Sqrt[-Wmass^2 + Zmass^2], 0}, {0, 0}, {(8*I)*Cphi4n1*gc97*Gf*Lam^2*Wmass*Zmass^2*Sqrt[-Wmass^2 + Zmass^2], 0}},

C[ S[3] , -V[3] , V[2] ] == {{(-8*I)*CphiWB*gc98*Lam*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(Wmass^2 - Zmass^2))), 0}, {(8*I)*CphiWB*gc98*Lam*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(Wmass^2 - Zmass^2))), 0}, {I*gc98*Wmass*((64*Gf^2 + 8*Sqrt[2]*(-Cll2x1x1x2 + CphiD)*Gf*Lam - (7*Cll2x1x1x2^2 - 2*Cll2x1x1x2*CphiD + CphiD^2)*Lam^2)*(-Wmass^2 + Zmass^2)^(3/2) + 8*CphiWB*Lam*Wmass*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(Wmass^2 - Zmass^2)))), 0}},

C[ S[2] , S[3] , -V[3] , V[2] ] == {{2*CphiWB*gc99*Lam*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Zmass^2 + 4*CphiW*(Wmass^2 - Zmass^2))), 0}, {gc99*Wmass*((-16*Sqrt[2]*Gf^2 + 8*Cll2x1x1x2*Gf*Lam + 3*Sqrt[2]*Cll2x1x1x2^2*Lam^2)*(-Wmass^2 + Zmass^2)^(3/2) - 2*CphiWB*Lam*Wmass*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Zmass^2 + 4*CphiW*(Wmass^2 - Zmass^2)))), 0}, {-2*CphiWB*gc99*Lam*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Zmass^2 + 4*CphiW*(Wmass^2 - Zmass^2))), 0}, {16*Cphi4n3*gc99*Gf*Lam^2*Wmass*Zmass^2*Sqrt[-Wmass^2 + Zmass^2], 0}, {8*Cphi4n1*gc99*Gf*Lam^2*Wmass*Zmass^2*Sqrt[-Wmass^2 + Zmass^2], 0}, {8*Cphi4n1*gc99*Gf*Lam^2*Wmass*Zmass^2*Sqrt[-Wmass^2 + Zmass^2], 0}},

C[ S[3] , S[1] , -V[3] , V[2] ] == {{(2*I)*CphiWB*gc100*Lam*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(4*CphiW*Wmass^2 + CphiD*Zmass^2 - 4*CphiW*Zmass^2 + 4*CphiBox*(Wmass^2 - Zmass^2))), 0}, {(-I)*gc100*Wmass*(2*CphiWB*Lam*Wmass*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(4*CphiW*Wmass^2 + CphiD*Zmass^2 - 4*CphiW*Zmass^2 + 4*CphiBox*(Wmass^2 - Zmass^2))) + Sqrt[-Wmass^2 + Zmass^2]*(-16*Sqrt[2]*Gf^2*(Wmass^2 - Zmass^2) + 8*Gf*Lam*(-2*CphiBox*Wmass^2 + 2*CphiBox*Zmass^2 + 2*CphiD*Zmass^2 + Cll2x1x1x2*(Wmass^2 - Zmass^2)) + Sqrt[2]*Lam^2*(-4*CphiD^2*Zmass^2 + 3*Cll2x1x1x2^2*(Wmass^2 - Zmass^2) - 12*CphiBox^2*(Wmass^2 - Zmass^2) + 4*CphiBox*CphiD*(Wmass^2 + Zmass^2)))), 0}, {(-2*I)*CphiWB*gc100*Lam*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(4*CphiW*Wmass^2 + CphiD*Zmass^2 - 4*CphiW*Zmass^2 + 4*CphiBox*(Wmass^2 - Zmass^2))), 0}, {(-8*I)*Cphi4n1*gc100*Gf*Lam^2*Wmass*Zmass^2*Sqrt[-Wmass^2 + Zmass^2], 0}, {0, 0}, {(8*I)*Cphi4n1*gc100*Gf*Lam^2*Wmass*Zmass^2*Sqrt[-Wmass^2 + Zmass^2], 0}},

C[ S[2] , S[2] , V[2] , V[2] ] == {{(-4*I)*gc101*Lam*(8*CphiW*(Gf + Sqrt[2]*CphiW*Lam)*Wmass^2*Sqrt[-Wmass^2 + Zmass^2] + 4*Sqrt[2]*CphiWB^2*Lam*(-Wmass^2 + Zmass^2)^(3/2) - CphiWB*Wmass*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Zmass^2 + 12*CphiW*(Wmass^2 - Zmass^2)))), 0}, {(-I)*gc101*(16*Sqrt[2]*Gf^2 - 8*Cll2x1x1x2*Gf*Lam - Sqrt[2]*(3*Cll2x1x1x2^2 + 2*CphiD^2)*Lam^2)*Zmass^4*Sqrt[-Wmass^2 + Zmass^2], 0}, {(-4*I)*gc101*Lam*(-8*CphiW*(Gf + Sqrt[2]*CphiW*Lam)*Wmass^2*Sqrt[-Wmass^2 + Zmass^2] - 4*Sqrt[2]*CphiWB^2*Lam*(-Wmass^2 + Zmass^2)^(3/2) + CphiWB*Wmass*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Zmass^2 + 12*CphiW*(Wmass^2 - Zmass^2)))), 0}, {(16*I)*(Cphi4n1 + Cphi4n3)*gc101*Gf*Lam^2*Zmass^4*Sqrt[-Wmass^2 + Zmass^2], 0}, {(16*I)*(Cphi4n1 + Cphi4n3)*gc101*Gf*Lam^2*Zmass^4*Sqrt[-Wmass^2 + Zmass^2], 0}, {(16*I)*(Cphi4n1 + Cphi4n3)*gc101*Gf*Lam^2*Zmass^4*Sqrt[-Wmass^2 + Zmass^2], 0}},

C[ S[3] , -S[3] , V[2] , V[2] ] == {{(-4*I)*gc102*Lam*(2*CphiW*(4*Gf + Sqrt[2]*(CphiD + 4*CphiW)*Lam)*Wmass^2*Sqrt[-Wmass^2 + Zmass^2] - 4*Sqrt[2]*CphiWB^2*Lam*(-Wmass^2 + Zmass^2)^(3/2) + CphiWB*Wmass*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(2*CphiD*Wmass^2 - 4*CphiW*Wmass^2 - CphiD*Zmass^2 + 4*CphiW*Zmass^2))), 0}, {(-I)*gc102*(32*Sqrt[2]*CphiWB^2*Lam^2*Wmass^2*(-Wmass^2 + Zmass^2)^(3/2) - 8*CphiWB*Lam*Wmass*(2*Wmass^2 - Zmass^2)*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(2*CphiD*Wmass^2 + 4*CphiW*Wmass^2 - CphiD*Zmass^2 - 4*CphiW*Zmass^2)) + Sqrt[-Wmass^2 + Zmass^2]*(16*Sqrt[2]*Gf^2*(-2*Wmass^2 + Zmass^2)^2 - 8*(Cll2x1x1x2 - CphiD)*Gf*Lam*(-2*Wmass^2 + Zmass^2)^2 - Sqrt[2]*Lam^2*(2*CphiD^2*Zmass^4 + 3*Cll2x1x1x2^2*(-2*Wmass^2 + Zmass^2)^2))), 0}, {(4*I)*gc102*Lam*(2*CphiW*(4*Gf + Sqrt[2]*(CphiD + 4*CphiW)*Lam)*Wmass^2*Sqrt[-Wmass^2 + Zmass^2] - 4*Sqrt[2]*CphiWB^2*Lam*(-Wmass^2 + Zmass^2)^(3/2) + CphiWB*Wmass*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(2*CphiD*Wmass^2 - 4*CphiW*Wmass^2 - CphiD*Zmass^2 + 4*CphiW*Zmass^2))), 0}, {(8*I)*Cphi4n1*gc102*Gf*Lam^2*Zmass^4*Sqrt[-Wmass^2 + Zmass^2], 0}, {(8*I)*Cphi4n1*gc102*Gf*Lam^2*Zmass^4*Sqrt[-Wmass^2 + Zmass^2], 0}, {(16*I)*Cphi4n3*gc102*Gf*Lam^2*Zmass^4*Sqrt[-Wmass^2 + Zmass^2], 0}},

C[ S[1] , V[2] , V[2] ] == {{(16*I)*gc103*Lam*(CphiW*(4*Sqrt[2]*Gf + (Cll2x1x1x2 + 4*CphiBox + CphiD + 8*CphiW)*Lam)*Wmass^2*Sqrt[-Wmass^2 + Zmass^2] + 4*CphiWB^2*Lam*(-Wmass^2 + Zmass^2)^(3/2) - CphiWB*Wmass*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(Cll2x1x1x2*Wmass^2 + 4*CphiBox*Wmass^2 + CphiD*Wmass^2 + 12*CphiW*Wmass^2 - Cll2x1x1x2*Zmass^2 - 4*CphiBox*Zmass^2 - 12*CphiW*Zmass^2))), 0}, {(-16*I)*gc103*Lam*(CphiW*(4*Sqrt[2]*Gf + (Cll2x1x1x2 + 4*CphiBox + CphiD + 8*CphiW)*Lam)*Wmass^2*Sqrt[-Wmass^2 + Zmass^2] + 4*CphiWB^2*Lam*(-Wmass^2 + Zmass^2)^(3/2) - CphiWB*Wmass*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(Cll2x1x1x2*Wmass^2 + 4*CphiBox*Wmass^2 + CphiD*Wmass^2 + 12*CphiW*Wmass^2 - Cll2x1x1x2*Zmass^2 - 4*CphiBox*Zmass^2 - 12*CphiW*Zmass^2))), 0}, {I*gc103*(64*Gf^2 + 8*Sqrt[2]*(-Cll2x1x1x2 + 4*CphiBox + CphiD)*Gf*Lam + (-7*Cll2x1x1x2^2 + 48*CphiBox^2 - 8*CphiBox*CphiD - 9*CphiD^2 + 2*Cll2x1x1x2*(4*CphiBox + CphiD))*Lam^2)*Zmass^4*Sqrt[-Wmass^2 + Zmass^2], 0}},

C[ S[1] , S[1] , V[2] , V[2] ] == {{(-4*I)*gc104*Lam*(8*CphiW*(Gf + Sqrt[2]*(CphiBox + CphiW)*Lam)*Wmass^2*Sqrt[-Wmass^2 + Zmass^2] + 4*Sqrt[2]*CphiWB^2*Lam*(-Wmass^2 + Zmass^2)^(3/2) - CphiWB*Wmass*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Zmass^2 + 8*CphiBox*(Wmass^2 - Zmass^2) + 12*CphiW*(Wmass^2 - Zmass^2)))), 0}, {(-I)*gc104*(16*Sqrt[2]*Gf^2 - 8*(Cll2x1x1x2 - 4*(CphiBox + CphiD))*Gf*Lam + Sqrt[2]*(-3*Cll2x1x1x2^2 + 32*CphiBox^2 + 24*CphiBox*CphiD - 18*CphiD^2)*Lam^2)*Zmass^4*Sqrt[-Wmass^2 + Zmass^2], 0}, {(-4*I)*gc104*Lam*(-8*CphiW*(Gf + Sqrt[2]*(CphiBox + CphiW)*Lam)*Wmass^2*Sqrt[-Wmass^2 + Zmass^2] - 4*Sqrt[2]*CphiWB^2*Lam*(-Wmass^2 + Zmass^2)^(3/2) + CphiWB*Wmass*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Zmass^2 + 8*CphiBox*(Wmass^2 - Zmass^2) + 12*CphiW*(Wmass^2 - Zmass^2)))), 0}, {0, 0}, {0, 0}, {(16*I)*(Cphi4n1 + Cphi4n3)*gc104*Gf*Lam^2*Zmass^4*Sqrt[-Wmass^2 + Zmass^2], 0}},

C[ V[4, {e1x2}] , V[4, {e2x2}] , V[4, {e3x2}] ] == {{-(gc105*SUNF[e1x2, e2x2, e3x2]), 0}, {gc105*SUNF[e1x2, e2x2, e3x2], 0}, {gc105*SUNF[e1x2, e2x2, e3x2], 0}, {-(gc105*SUNF[e1x2, e2x2, e3x2]), 0}, {-(gc105*SUNF[e1x2, e2x2, e3x2]), 0}, {gc105*SUNF[e1x2, e2x2, e3x2], 0}},

C[ V[4, {e1x2}] , V[4, {e2x2}] , V[4, {e3x2}] , V[4, {e4x2}] ] == {{(-I)*gc106*(SUNF[e1x2, e2x2, e3x2, e4x2] + SUNF[e1x2, e3x2, e2x2, e4x2]), 0}, {I*gc106*(SUNF[e1x2, e2x2, e3x2, e4x2] - SUNF[e1x2, e4x2, e2x2, e3x2]), 0}, {I*gc106*(SUNF[e1x2, e3x2, e2x2, e4x2] + SUNF[e1x2, e4x2, e2x2, e3x2]), 0}},

C[ -U[4, {e1x1}] , U[4, {e2x1}] , V[4, {e3x2}] ] == {{gc107*SUNF[e3x2, e1x1, e2x1], 0}, {0, 0}},

C[ -F[4, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , S[2] , S[2] , S[2] ] == {{-(gc108*Conjugate[Cdphi[e2x2, e1x2]]*IndexDelta[e1x3, e2x3]), 0}, {0, 0}, {gc108*Cdphi[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}},

C[ -F[4, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , S[2] , S[2] ] == {{I*gc109*Conjugate[Cdphi[e2x2, e1x2]]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {I*gc109*Cdphi[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}},

C[ -F[4, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , S[2] , S[3] , -S[3] ] == {{-(gc110*Conjugate[Cdphi[e2x2, e1x2]]*IndexDelta[e1x3, e2x3]), 0}, {0, 0}, {gc110*Cdphi[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}},

C[ -F[4, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , S[3] , -S[3] ] == {{I*gc111*Conjugate[Cdphi[e2x2, e1x2]]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {I*gc111*Cdphi[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}},

C[ -F[4, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , S[2] , S[2] , S[1] ] == {{I*gc112*Conjugate[Cdphi[e2x2, e1x2]]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {I*gc112*Cdphi[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}},

C[ -F[4, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , S[1] ] == {{I*gc113[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {((-I)*(-4*Lam*(8*Gf + Sqrt[2]*(2*Cll2x1x1x2 + 4*CphiBox - CphiD)*Lam)*Cdphi[e1x2, e2x2] + 2^(1/4)*Sqrt[Gf]*(64*Gf^2 - 8*Sqrt[2]*(Cll2x1x1x2 - 4*CphiBox + CphiD)*Gf*Lam + (-7*Cll2x1x1x2^2 + Cll2x1x1x2*(8*CphiBox - 2*CphiD) + 3*(-4*CphiBox + CphiD)^2)*Lam^2)*fmd[e1x2, e2x2])*gc113[e1x2, e2x2]*IndexDelta[e1x3, e2x3])/(4*Lam*(8*Gf + Sqrt[2]*(2*Cll2x1x1x2 + 4*CphiBox - CphiD)*Lam)*Conjugate[Cdphi[e2x2, e1x2]] - 2^(1/4)*Sqrt[Gf]*(64*Gf^2 - 8*Sqrt[2]*(Cll2x1x1x2 - 4*CphiBox + CphiD)*Gf*Lam + (-7*Cll2x1x1x2^2 + Cll2x1x1x2*(8*CphiBox - 2*CphiD) + 3*(-4*CphiBox + CphiD)^2)*Lam^2)*fmd[e1x2, e2x2]), 0}, {0, 0}},

C[ -F[4, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , S[2] , S[1] ] == {{-(gc114*Conjugate[Cdphi[e2x2, e1x2]]*IndexDelta[e1x3, e2x3]), 0}, {0, 0}, {gc114*Cdphi[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}},

C[ -F[4, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , S[3] , -S[3] , S[1] ] == {{I*gc115*Conjugate[Cdphi[e2x2, e1x2]]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {I*gc115*Cdphi[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}},

C[ -F[4, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , S[2] , S[1] , S[1] ] == {{-(gc116*Conjugate[Cdphi[e2x2, e1x2]]*IndexDelta[e1x3, e2x3]), 0}, {0, 0}, {gc116*Cdphi[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}},

C[ -F[4, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , S[1] , S[1] ] == {{I*gc117*Conjugate[Cdphi[e2x2, e1x2]]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {I*gc117*Cdphi[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}},

C[ -F[4, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , S[1] , S[1] , S[1] ] == {{I*gc118*Conjugate[Cdphi[e2x2, e1x2]]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {I*gc118*Cdphi[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}},

C[ -F[4, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , S[2] , S[2] , -S[3] ] == {{I*gc119[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {0, 0}, {0, 0}},

C[ -F[4, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , S[3] , -S[3] , -S[3] ] == {{I*gc120[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {0, 0}, {0, 0}},

C[ -F[4, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , -S[3] , S[1] ] == {{I*gc121[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {0, 0}, {0, 0}},

C[ -F[4, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , -S[3] , S[1] , S[1] ] == {{I*gc122[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {0, 0}, {0, 0}},

C[ -F[4, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , S[2] ] == {{gc123[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {-(gc123[e1x2, e2x2]*IndexDelta[e1x3, e2x3]), 0}, {0, 0}},

C[ -F[4, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , -S[3] ] == {{I*gc124[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {((-I)*gc124[e1x2, e2x2]*IndexDelta[e1x3, e2x3]*IndexSum[Conjugate[Kq[Generation$1, e1x2]]*fmu[Generation$1, e2x2], {Generation$1, 1, 3}])/IndexSum[Conjugate[Kq[e2x2, Generation$1]]*fmd[e1x2, Generation$1], {Generation$1, 1, 3}], 0}, {0, 0}},

C[ -F[2, {e1x2}] , F[2, {e2x2}] , S[2] ] == {{gc125[e1x2, e2x2], 0}, {0, 0}, {-gc125[e1x2, e2x2], 0}, {0, 0}},

C[ -F[2, {e1x2}] , F[2, {e2x2}] , S[1] ] == {{I*gc126[e1x2, e2x2], 0}, {0, 0}, {I*gc126[e1x2, e2x2], 0}, {0, 0}},

C[ -F[3, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , S[2] ] == {{gc127[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {-(gc127[e1x2, e2x2]*IndexDelta[e1x3, e2x3]), 0}, {0, 0}},

C[ -F[3, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , S[1] ] == {{I*gc128[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {I*gc128[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}},

C[ -F[3, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , S[3] ] == {{I*gc129[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {((-I)*gc129[e1x2, e2x2]*IndexDelta[e1x3, e2x3]*IndexSum[fmd[Generation$1, e2x2]*Kq[e1x2, Generation$1], {Generation$1, 1, 3}])/IndexSum[fmu[e1x2, Generation$1]*Kq[Generation$1, e2x2], {Generation$1, 1, 3}], 0}, {0, 0}},

C[ -F[1, {e1x2}] , F[2, {e2x2}] , S[3] ] == {{0, 0}, {0, 0}, {((-1/32*I)*(64*Sqrt[2]*Gf^2 - 16*Cll2x1x1x2*Gf*Lam - 7*Sqrt[2]*Cll2x1x1x2^2*Lam^2)*IndexSum[Conjugate[Ul[Generation$1, e1x2]]*fml[Generation$1, e2x2], {Generation$1, 1, 3}])/(2^(3/4)*Gf^(3/2)), 0}, {0, 0}},

C[ -F[3, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , S[2] , S[2] , S[3] ] == {{0, 0}, {0, 0}, {I*gc131[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}},

C[ -F[3, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , S[3] , S[3] , -S[3] ] == {{0, 0}, {0, 0}, {I*gc132[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}},

C[ -F[3, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , S[3] , S[1] ] == {{0, 0}, {0, 0}, {I*gc133[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}},

C[ -F[3, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , S[3] , S[1] , S[1] ] == {{0, 0}, {0, 0}, {I*gc134[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}},

C[ -F[2, {e1x2}] , F[1, {e2x2}] , -S[3] ] == {{I*gc135[e1x2, e2x2], 0}, {0, 0}, {0, 0}, {0, 0}},

C[ S[2] , S[3] , -S[3] , -S[3] , V[1] , V[3] ] == {{4*Sqrt[2]*Cphi4n3*gc136*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {4*Sqrt[2]*Cphi4n1*gc136*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {-2*Sqrt[2]*Cphi4n3*gc136*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {0, 0}, {0, 0}, {-2*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc136*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {-2*Sqrt[2]*Cphi4n3*gc136*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {0, 0}, {2*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc136*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {0, 0}, {-2*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc136*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {2*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc136*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {-((CphiD*gc136*(Wmass^2 - Zmass^2)*(4*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(-2*Cll2x1x1x2*Wmass^2 + 2*Cll2x1x1x2*Zmass^2 + CphiD*Zmass^2))))/((Wmass - Zmass)*(Wmass + Zmass))), 0}, {-2*Sqrt[2]*Cphi4n1*gc136*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {-2*Sqrt[2]*Cphi4n1*gc136*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {-2*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc136*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {-2*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc136*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {0, 0}, {0, 0}},

C[ S[3] , -S[3] , -S[3] , V[1] , V[3] ] == {{(-4*I)*(Cphi4n1 + Cphi4n3)*gc137*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(4*I)*(Cphi4n1 + Cphi4n3)*gc137*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(-4*I)*(Cphi4n1 + Cphi4n3)*gc137*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(4*I)*(Cphi4n1 + Cphi4n3)*gc137*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {((-I)*CphiD*gc137*(Wmass^2 - Zmass^2)*(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(-(Cll2x1x1x2*Wmass^2) + CphiD*Wmass^2 + Cll2x1x1x2*Zmass^2))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {(-4*I)*(Cphi4n1 + Cphi4n3)*gc137*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(-4*I)*(Cphi4n1 + Cphi4n3)*gc137*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {0, 0}, {0, 0}, {0, 0}},

C[ S[3] , -S[3] , -S[3] , S[1] , V[1] , V[3] ] == {{0, 0}, {(2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc138*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {0, 0}, {(-2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc138*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc138*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(-2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc138*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(-4*I)*Sqrt[2]*Cphi4n1*gc138*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {0, 0}, {0, 0}, {(-4*I)*Sqrt[2]*Cphi4n3*gc138*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(2*I)*Sqrt[2]*Cphi4n3*gc138*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(2*I)*Sqrt[2]*Cphi4n3*gc138*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(I*CphiD*gc138*(Wmass^2 - Zmass^2)*(4*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(-2*Cll2x1x1x2*Wmass^2 + 4*CphiBox*Wmass^2 + 2*Cll2x1x1x2*Zmass^2 - 4*CphiBox*Zmass^2 + CphiD*Zmass^2))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {(2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc138*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {0, 0}, {0, 0}, {(2*I)*Sqrt[2]*Cphi4n1*gc138*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc138*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(2*I)*Sqrt[2]*Cphi4n1*gc138*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}},

C[ S[3] , -S[3] , -S[3] , V[1] , V[1] , V[1] , V[3] ] == {{I*gc139, 0}, {I*gc139, 0}, {I*gc139, 0}},

C[ S[2] , S[3] , -S[3] , -S[3] , V[1] , V[1] , V[1] , V[3] ] == {{gc140, 0}, {gc140, 0}, {gc140, 0}},

C[ S[3] , -S[3] , -S[3] , S[1] , V[1] , V[1] , V[1] , V[3] ] == {{I*gc141, 0}, {I*gc141, 0}, {I*gc141, 0}},

C[ S[2] , -S[3] , V[3] ] == {{gc142*(64*Gf^2 - 8*Sqrt[2]*(Cll2x1x1x2 - 3*CphiD)*Gf*Lam + (-7*Cll2x1x1x2^2 + 6*Cll2x1x1x2*CphiD - 5*CphiD^2)*Lam^2), 0}, {gc142*(-64*Gf^2 + 8*Sqrt[2]*(Cll2x1x1x2 + CphiD)*Gf*Lam + (7*Cll2x1x1x2^2 + 2*Cll2x1x1x2*CphiD - 3*CphiD^2)*Lam^2), 0}},

C[ S[2] , S[2] , -S[3] , V[3] ] == {{I*CphiD*gc143*(-4*Gf + Sqrt[2]*CphiD*Lam), 0}, {I*CphiD*gc143*(-4*Gf + Sqrt[2]*CphiD*Lam), 0}, {(8*I)*Cphi4n3*gc143*Gf*Lam, 0}, {(4*I)*Cphi4n1*gc143*Gf*Lam, 0}, {(4*I)*Cphi4n1*gc143*Gf*Lam, 0}, {0, 0}},

C[ S[2] , -S[3] , S[1] , V[3] ] == {{2*CphiD*gc144*(4*Gf + Sqrt[2]*(2*CphiBox - CphiD)*Lam), 0}, {0, 0}, {4*Cphi4n1*gc144*Gf*Lam, 0}, {0, 0}, {-4*Cphi4n1*gc144*Gf*Lam, 0}, {CphiD*gc144*(-4*Gf + Sqrt[2]*(-2*CphiBox + CphiD)*Lam), 0}},

C[ S[2] , S[2] , -S[3] , S[1] , V[3] ] == {{I*CphiD*gc145*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 - 4*CphiBox + 3*CphiD)*Lam), 0}, {(-2*I)*CphiD*gc145*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 - 4*CphiBox + 3*CphiD)*Lam), 0}, {(-16*I)*(Cphi4n1 + Cphi4n3)*gc145*Gf*Lam, 0}, {(-8*I)*Cphi4n1*gc145*Gf*Lam, 0}, {0, 0}, {(8*I)*Cphi4n1*gc145*Gf*Lam, 0}, {I*CphiD*gc145*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 - 4*CphiBox + 3*CphiD)*Lam), 0}, {0, 0}, {(8*I)*Cphi4n1*gc145*Gf*Lam, 0}, {0, 0}, {0, 0}, {(8*I)*Cphi4n1*gc145*Gf*Lam, 0}, {(-8*I)*Cphi4n1*gc145*Gf*Lam, 0}, {0, 0}, {(16*I)*Cphi4n3*gc145*Gf*Lam, 0}, {(8*I)*Cphi4n1*gc145*Gf*Lam, 0}},

C[ S[2] , -S[3] , S[1] , S[1] , V[3] ] == {{2*CphiD*gc146*(8*Gf - Sqrt[2]*(Cll2x1x1x2 - 8*CphiBox + 3*CphiD)*Lam), 0}, {CphiD*gc146*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 - 8*CphiBox + 3*CphiD)*Lam), 0}, {8*Cphi4n1*gc146*Gf*Lam, 0}, {0, 0}, {-8*Cphi4n1*gc146*Gf*Lam, 0}, {-16*(Cphi4n1 + Cphi4n3)*gc146*Gf*Lam, 0}, {0, 0}, {CphiD*gc146*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 - 8*CphiBox + 3*CphiD)*Lam), 0}, {0, 0}, {0, 0}, {0, 0}, {-8*Cphi4n1*gc146*Gf*Lam, 0}, {8*Cphi4n1*gc146*Gf*Lam, 0}, {8*Cphi4n1*gc146*Gf*Lam, 0}, {8*Cphi4n1*gc146*Gf*Lam, 0}, {16*Cphi4n3*gc146*Gf*Lam, 0}},

C[ S[2] , S[3] , -S[3] , -S[3] , V[1] , V[1] , V[3] ] == {{-4*Cphi4n3*gc147, 0}, {0, 0}, {2*(Cphi4n1 + Cphi4n3)*gc147, 0}, {2*(Cphi4n1 + Cphi4n3)*gc147, 0}, {-2*Cphi4n1*gc147, 0}, {-2*(Cphi4n1 + Cphi4n3)*gc147, 0}, {(Cphi4n1 + Cphi4n3)*gc147, 0}, {(Cphi4n1 + Cphi4n3)*gc147, 0}, {-2*Cphi4n1*gc147, 0}, {-2*(Cphi4n1 + Cphi4n3)*gc147, 0}, {(Cphi4n1 + Cphi4n3)*gc147, 0}, {(Cphi4n1 + Cphi4n3)*gc147, 0}},

C[ S[2] , S[2] , -S[3] , V[1] , V[3] ] == {{I*Cphi4n1*gc148, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {(2*I)*Cphi4n3*gc148, 0}, {0, 0}, {I*Cphi4n1*gc148, 0}, {0, 0}, {0, 0}},

C[ S[2] , S[2] , S[2] , -S[3] , V[1] , V[3] ] == {{Cphi4n1*gc149, 0}, {Cphi4n1*gc149, 0}, {Cphi4n1*gc149, 0}, {Cphi4n1*gc149, 0}, {Cphi4n1*gc149, 0}, {Cphi4n1*gc149, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {2*Cphi4n3*gc149, 0}, {0, 0}, {2*Cphi4n3*gc149, 0}, {0, 0}, {2*Cphi4n3*gc149, 0}, {0, 0}},

C[ S[2] , S[2] , -S[3] , S[1] , V[1] , V[3] ] == {{I*Cphi4n1*gc150, 0}, {I*Cphi4n1*gc150, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {I*Cphi4n1*gc150, 0}, {I*Cphi4n1*gc150, 0}, {0, 0}, {(-I)*Cphi4n1*gc150, 0}, {(-I)*Cphi4n1*gc150, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {(2*I)*Cphi4n3*gc150, 0}, {0, 0}},

C[ S[2] , S[2] , S[2] , -S[3] , V[3] ] == {{0, 0}, {0, 0}, {2*Cphi4n3*gc151, 0}, {2*Cphi4n3*gc151, 0}, {Cphi4n1*gc151, 0}, {Cphi4n1*gc151, 0}, {0, 0}, {0, 0}, {-2*(Cphi4n1 + Cphi4n3)*gc151, 0}, {Cphi4n1*gc151, 0}, {Cphi4n1*gc151, 0}, {-2*(Cphi4n1 + Cphi4n3)*gc151, 0}, {2*Cphi4n3*gc151, 0}, {Cphi4n1*gc151, 0}, {-2*(Cphi4n1 + Cphi4n3)*gc151, 0}, {Cphi4n1*gc151, 0}},

C[ -U[1] , U[32] , V[3] ] == {{I*gc152, 0}, {0, 0}},

C[ -U[31] , U[2] , V[3] ] == {{I*gc153, 0}, {0, 0}},

C[ -U[31] , U[1] , V[3] ] == {{I*gc154, 0}, {0, 0}},

C[ -U[2] , U[32] , V[3] ] == {{I*gc155, 0}, {0, 0}},

C[ S[3] , -S[3] , -S[3] , V[3] ] == {{(-2*I)*CphiD*gc156, 0}, {I*CphiD*gc156, 0}, {(-2*I)*(Cphi4n1 + Cphi4n3)*gc156*Lam, 0}, {(-2*I)*(Cphi4n1 + Cphi4n3)*gc156*Lam, 0}, {0, 0}, {I*CphiD*gc156, 0}},

C[ S[2] , S[3] , -S[3] , -S[3] , V[3] ] == {{0, 0}, {CphiD*gc157*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 + CphiD)*Lam), 0}, {0, 0}, {0, 0}, {-16*Cphi4n3*gc157*Gf*Lam, 0}, {0, 0}, {-2*CphiD*gc157*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 + CphiD)*Lam), 0}, {CphiD*gc157*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 + CphiD)*Lam), 0}, {-16*Cphi4n1*gc157*Gf*Lam, 0}, {-16*Cphi4n1*gc157*Gf*Lam, 0}, {0, 0}, {-16*Cphi4n3*gc157*Gf*Lam, 0}, {16*(Cphi4n1 + Cphi4n3)*gc157*Gf*Lam, 0}, {16*(Cphi4n1 + Cphi4n3)*gc157*Gf*Lam, 0}, {0, 0}, {0, 0}},

C[ S[3] , -S[3] , -S[3] , S[1] , V[3] ] == {{(-2*I)*CphiD*gc158*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 - 4*CphiBox + CphiD)*Lam), 0}, {0, 0}, {(-16*I)*Cphi4n3*gc158*Gf*Lam, 0}, {(-16*I)*Cphi4n3*gc158*Gf*Lam, 0}, {(-16*I)*Cphi4n1*gc158*Gf*Lam, 0}, {(-16*I)*Cphi4n1*gc158*Gf*Lam, 0}, {I*CphiD*gc158*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 - 4*CphiBox + CphiD)*Lam), 0}, {I*CphiD*gc158*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 - 4*CphiBox + CphiD)*Lam), 0}, {(16*I)*(Cphi4n1 + Cphi4n3)*gc158*Gf*Lam, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {(16*I)*(Cphi4n1 + Cphi4n3)*gc158*Gf*Lam, 0}, {0, 0}},

C[ S[3] , -S[3] , -S[3] , V[1] , V[1] , V[3] ] == {{(2*I)*gc159, 0}, {(2*I)*gc159, 0}, {(-2*I)*gc159, 0}, {I*gc159, 0}, {I*gc159, 0}, {(-2*I)*gc159, 0}, {I*gc159, 0}, {I*gc159, 0}, {0, 0}},

C[ S[3] , -S[3] , -S[3] , S[1] , V[1] , V[1] , V[3] ] == {{0, 0}, {(-2*I)*(Cphi4n1 + Cphi4n3)*gc160, 0}, {(-2*I)*(Cphi4n1 + Cphi4n3)*gc160, 0}, {(4*I)*Cphi4n3*gc160, 0}, {(2*I)*(Cphi4n1 + Cphi4n3)*gc160, 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc160, 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc160, 0}, {(2*I)*Cphi4n1*gc160, 0}, {(2*I)*(Cphi4n1 + Cphi4n3)*gc160, 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc160, 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc160, 0}, {(2*I)*Cphi4n1*gc160, 0}},

C[ -S[3] , S[1] , V[3] ] == {{(-I)*gc161, 0}, {I*gc161, 0}},

C[ -S[3] , S[1] , S[1] , V[1] , V[3] ] == {{0, 0}, {I*Cphi4n1*gc162, 0}, {0, 0}, {I*Cphi4n1*gc162, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {(2*I)*Cphi4n3*gc162, 0}, {0, 0}},

C[ S[2] , -S[3] , S[1] , S[1] , V[1] , V[3] ] == {{0, 0}, {0, 0}, {-(Cphi4n1*gc163), 0}, {0, 0}, {Cphi4n1*gc163, 0}, {0, 0}, {-(Cphi4n1*gc163), 0}, {0, 0}, {Cphi4n1*gc163, 0}, {Cphi4n1*gc163, 0}, {0, 0}, {Cphi4n1*gc163, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {2*Cphi4n3*gc163, 0}},

C[ -S[3] , S[1] , S[1] , S[1] , V[1] , V[3] ] == {{0, 0}, {0, 0}, {0, 0}, {I*Cphi4n1*gc164, 0}, {0, 0}, {I*Cphi4n1*gc164, 0}, {0, 0}, {I*Cphi4n1*gc164, 0}, {I*Cphi4n1*gc164, 0}, {0, 0}, {I*Cphi4n1*gc164, 0}, {I*Cphi4n1*gc164, 0}, {0, 0}, {0, 0}, {0, 0}, {(2*I)*Cphi4n3*gc164, 0}, {(2*I)*Cphi4n3*gc164, 0}, {0, 0}, {(2*I)*Cphi4n3*gc164, 0}},

C[ -S[3] , S[1] , S[1] , V[3] ] == {{0, 0}, {0, 0}, {I*Cphi4n1*gc165, 0}, {I*Cphi4n1*gc165, 0}, {(2*I)*Cphi4n3*gc165, 0}, {0, 0}},

C[ -S[3] , S[1] , S[1] , S[1] , V[3] ] == {{0, 0}, {0, 0}, {(-I)*Cphi4n1*gc166, 0}, {(-I)*Cphi4n1*gc166, 0}, {(-2*I)*Cphi4n3*gc166, 0}, {(-2*I)*Cphi4n3*gc166, 0}, {0, 0}, {0, 0}, {(-I)*Cphi4n1*gc166, 0}, {(-I)*Cphi4n1*gc166, 0}, {(-I)*Cphi4n1*gc166, 0}, {(-2*I)*Cphi4n3*gc166, 0}, {(2*I)*(Cphi4n1 + Cphi4n3)*gc166, 0}, {(2*I)*(Cphi4n1 + Cphi4n3)*gc166, 0}, {(-I)*Cphi4n1*gc166, 0}, {(2*I)*(Cphi4n1 + Cphi4n3)*gc166, 0}},

C[ -S[3] , -S[3] , V[3] , V[3] ] == {{0, 0}, {(2*I)*CphiD*gc167, 0}, {0, 0}, {I*(Cphi4n1 + Cphi4n3)*gc167*Lam, 0}, {I*(Cphi4n1 + Cphi4n3)*gc167*Lam, 0}, {0, 0}},

C[ S[2] , -S[3] , -S[3] , V[3] , V[3] ] == {{2*Cphi4n3*gc168*Gf*Lam, 0}, {-4*(Cphi4n1 + Cphi4n3)*gc168*Gf*Lam, 0}, {2*Cphi4n3*gc168*Gf*Lam, 0}, {-4*(Cphi4n1 + Cphi4n3)*gc168*Gf*Lam, 0}, {CphiD*gc168*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 + CphiD)*Lam), 0}, {4*Cphi4n1*gc168*Gf*Lam, 0}, {4*Cphi4n1*gc168*Gf*Lam, 0}, {2*Cphi4n3*gc168*Gf*Lam, 0}, {0, 0}, {2*Cphi4n3*gc168*Gf*Lam, 0}},

C[ S[2] , S[2] , -S[3] , -S[3] , V[3] , V[3] ] == {{(-2*I)*(Cphi4n1 + Cphi4n3)*gc169*Gf*Lam, 0}, {(-2*I)*(Cphi4n1 + Cphi4n3)*gc169*Gf*Lam, 0}, {I*Cphi4n3*gc169*Gf*Lam, 0}, {I*Cphi4n3*gc169*Gf*Lam, 0}, {I*Cphi4n3*gc169*Gf*Lam, 0}, {I*Cphi4n3*gc169*Gf*Lam, 0}, {I*Cphi4n3*gc169*Gf*Lam, 0}, {I*Cphi4n3*gc169*Gf*Lam, 0}, {(-2*I)*(Cphi4n1 + Cphi4n3)*gc169*Gf*Lam, 0}, {I*Cphi4n3*gc169*Gf*Lam, 0}, {I*Cphi4n3*gc169*Gf*Lam, 0}, {(-2*I)*(Cphi4n1 + Cphi4n3)*gc169*Gf*Lam, 0}, {(-I)*CphiD*gc169*(4*Gf - Sqrt[2]*(Cll2x1x1x2 + CphiD)*Lam), 0}, {(2*I)*Cphi4n1*gc169*Gf*Lam, 0}, {(2*I)*Cphi4n1*gc169*Gf*Lam, 0}, {(2*I)*Cphi4n1*gc169*Gf*Lam, 0}, {(2*I)*Cphi4n1*gc169*Gf*Lam, 0}, {0, 0}, {0, 0}},

C[ -S[3] , -S[3] , S[1] , V[3] , V[3] ] == {{(-4*I)*(Cphi4n1 + Cphi4n3)*gc170*Gf*Lam, 0}, {(2*I)*Cphi4n3*gc170*Gf*Lam, 0}, {(2*I)*Cphi4n3*gc170*Gf*Lam, 0}, {(2*I)*Cphi4n3*gc170*Gf*Lam, 0}, {I*CphiD*gc170*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 - 4*CphiBox + CphiD)*Lam), 0}, {0, 0}, {(4*I)*Cphi4n1*gc170*Gf*Lam, 0}, {(-4*I)*(Cphi4n1 + Cphi4n3)*gc170*Gf*Lam, 0}, {(4*I)*Cphi4n1*gc170*Gf*Lam, 0}, {(2*I)*Cphi4n3*gc170*Gf*Lam, 0}},

C[ S[2] , -S[3] , -S[3] , S[1] , V[3] , V[3] ] == {{Cphi4n3*gc171*Gf*Lam, 0}, {Cphi4n3*gc171*Gf*Lam, 0}, {Cphi4n3*gc171*Gf*Lam, 0}, {-2*(Cphi4n1 + Cphi4n3)*gc171*Gf*Lam, 0}, {Cphi4n3*gc171*Gf*Lam, 0}, {-2*(Cphi4n1 + Cphi4n3)*gc171*Gf*Lam, 0}, {-2*(Cphi4n1 + Cphi4n3)*gc171*Gf*Lam, 0}, {Cphi4n3*gc171*Gf*Lam, 0}, {Cphi4n3*gc171*Gf*Lam, 0}, {-2*(Cphi4n1 + Cphi4n3)*gc171*Gf*Lam, 0}, {Cphi4n3*gc171*Gf*Lam, 0}, {Cphi4n3*gc171*Gf*Lam, 0}, {CphiD*gc171*(-4*Gf + Sqrt[2]*(Cll2x1x1x2 - 2*CphiBox + CphiD)*Lam), 0}, {2*Cphi4n1*gc171*Gf*Lam, 0}, {0, 0}, {0, 0}, {2*Cphi4n1*gc171*Gf*Lam, 0}, {2*Cphi4n1*gc171*Gf*Lam, 0}, {2*Cphi4n1*gc171*Gf*Lam, 0}},

C[ -S[3] , -S[3] , S[1] , S[1] , V[3] , V[3] ] == {{(-2*I)*(Cphi4n1 + Cphi4n3)*gc172*Gf*Lam, 0}, {(-2*I)*(Cphi4n1 + Cphi4n3)*gc172*Gf*Lam, 0}, {I*Cphi4n3*gc172*Gf*Lam, 0}, {I*Cphi4n3*gc172*Gf*Lam, 0}, {I*Cphi4n3*gc172*Gf*Lam, 0}, {I*Cphi4n3*gc172*Gf*Lam, 0}, {I*Cphi4n3*gc172*Gf*Lam, 0}, {I*Cphi4n3*gc172*Gf*Lam, 0}, {(-2*I)*(Cphi4n1 + Cphi4n3)*gc172*Gf*Lam, 0}, {I*Cphi4n3*gc172*Gf*Lam, 0}, {I*Cphi4n3*gc172*Gf*Lam, 0}, {(-2*I)*(Cphi4n1 + Cphi4n3)*gc172*Gf*Lam, 0}, {(-I)*CphiD*gc172*(4*Gf - Sqrt[2]*(Cll2x1x1x2 - 4*CphiBox + CphiD)*Lam), 0}, {(2*I)*Cphi4n1*gc172*Gf*Lam, 0}, {(2*I)*Cphi4n1*gc172*Gf*Lam, 0}, {(2*I)*Cphi4n1*gc172*Gf*Lam, 0}, {(2*I)*Cphi4n1*gc172*Gf*Lam, 0}, {0, 0}, {0, 0}},

C[ S[2] , -S[3] , S[1] , V[1] , V[3] ] == {{0, 0}, {0, 0}, {-gc173, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {gc173, 0}},

C[ -S[3] , V[1] , V[1] , V[3] ] == {{(-I)*gc174, 0}, {(-I)*gc174, 0}, {(I*Sqrt[2]*gc174*(4*CphiWB*Lam*Wmass*(Wmass^2 - Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(CphiD*Lam*(-2*Wmass^2 + Zmass^2) + 4*Sqrt[2]*Gf*(-Wmass^2 + Zmass^2) + 4*CphiW*Lam*(-Wmass^2 + Zmass^2))))/(4*Sqrt[2]*CphiWB*Lam*Wmass*(Wmass^2 - Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(-8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*(-2*Wmass^2 + Zmass^2) + 4*CphiW*(-Wmass^2 + Zmass^2)))), 0}, {(I*Sqrt[2]*gc174*(4*CphiWB*Lam*Wmass*(Wmass^2 - Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(CphiD*Lam*(-2*Wmass^2 + Zmass^2) + 4*Sqrt[2]*Gf*(-Wmass^2 + Zmass^2) + 4*CphiW*Lam*(-Wmass^2 + Zmass^2))))/(4*Sqrt[2]*CphiWB*Lam*Wmass*(Wmass^2 - Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(-8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*(-2*Wmass^2 + Zmass^2) + 4*CphiW*(-Wmass^2 + Zmass^2)))), 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}},

C[ S[2] , -S[3] , V[1] , V[1] , V[3] ] == {{-gc175, 0}, {-gc175, 0}, {-((Sqrt[2]*gc175*(4*CphiWB*Lam*Wmass*(Wmass^2 - Zmass^2) - Sqrt[-Wmass^2 + Zmass^2]*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2)))))/(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2))))), 0}, {-((Sqrt[2]*gc175*(4*CphiWB*Lam*Wmass*(Wmass^2 - Zmass^2) - Sqrt[-Wmass^2 + Zmass^2]*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2)))))/(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2))))), 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}},

C[ -S[3] , S[1] , V[1] , V[1] , V[3] ] == {{(-I)*gc176, 0}, {(-I)*gc176, 0}, {(I*Sqrt[2]*gc176*(4*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(4*CphiBox*Wmass^2 + CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiBox*Zmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2)))))/(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(4*CphiBox*Wmass^2 + CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiBox*Zmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2)))), 0}, {(I*Sqrt[2]*gc176*(4*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(4*CphiBox*Wmass^2 + CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiBox*Zmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2)))))/(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(4*CphiBox*Wmass^2 + CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiBox*Zmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2)))), 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}},

C[ V[1] , V[3] , -V[3] ] == {{((-I)*gc177*(-Wmass^2 + Zmass^2)*(-64*Gf^2*(Wmass^2 - Zmass^2)^2 - 8*Sqrt[2]*Gf*Lam*(Wmass^2 - Zmass^2)*(CphiD*Wmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2)) + Lam^2*(CphiD^2*Wmass^4 + 7*Cll2x1x1x2^2*(Wmass^2 - Zmass^2)^2 + 2*Cll2x1x1x2*CphiD*Wmass^2*(-Wmass^2 + Zmass^2))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {(I*gc177*(-Wmass^2 + Zmass^2)*(-64*Gf^2*(Wmass^2 - Zmass^2)^2 + 8*Sqrt[2]*Gf*Lam*(Wmass^2 - Zmass^2)*(Cll2x1x1x2*(Wmass^2 - Zmass^2) - Wmass*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2])) + Lam^2*(7*Cll2x1x1x2^2*(Wmass^2 - Zmass^2)^2 - 2*Cll2x1x1x2*Wmass*(Wmass^2 - Zmass^2)*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2]) + Wmass*(CphiD^2*Wmass^3 + 8*CphiD*CphiWB*(-Wmass^2 + Zmass^2)^(3/2) + 32*CphiW*CphiWB*(-Wmass^2 + Zmass^2)^(3/2)))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {((-I)*gc177*(-Wmass^2 + Zmass^2)*(64*Gf^2*(Wmass^2 - Zmass^2)^2 + 8*Sqrt[2]*Gf*Lam*(Wmass^2 - Zmass^2)*(CphiD*Wmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2)) - Lam^2*(CphiD^2*Wmass^4 + 7*Cll2x1x1x2^2*(Wmass^2 - Zmass^2)^2 + 2*Cll2x1x1x2*CphiD*Wmass^2*(-Wmass^2 + Zmass^2))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {(I*gc177*(-Wmass^2 + Zmass^2)*(64*Gf^2*(Wmass^2 - Zmass^2)^2 - 8*Sqrt[2]*Gf*Lam*(Wmass^2 - Zmass^2)*(Cll2x1x1x2*(Wmass^2 - Zmass^2) - Wmass*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2])) - Lam^2*(7*Cll2x1x1x2^2*(Wmass^2 - Zmass^2)^2 - 2*Cll2x1x1x2*Wmass*(Wmass^2 - Zmass^2)*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2]) + Wmass*(CphiD^2*Wmass^3 + 8*CphiD*CphiWB*(-Wmass^2 + Zmass^2)^(3/2) + 32*CphiW*CphiWB*(-Wmass^2 + Zmass^2)^(3/2)))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {(I*gc177*(-Wmass^2 + Zmass^2)*(64*Gf^2*(Wmass^2 - Zmass^2)^2 - 8*Sqrt[2]*Gf*Lam*(Wmass^2 - Zmass^2)*(Cll2x1x1x2*(Wmass^2 - Zmass^2) - Wmass*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2])) - Lam^2*(7*Cll2x1x1x2^2*(Wmass^2 - Zmass^2)^2 - 2*Cll2x1x1x2*Wmass*(Wmass^2 - Zmass^2)*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2]) + Wmass*(CphiD^2*Wmass^3 + 8*CphiD*CphiWB*(-Wmass^2 + Zmass^2)^(3/2) + 32*CphiW*CphiWB*(-Wmass^2 + Zmass^2)^(3/2)))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {((-I)*gc177*(-Wmass^2 + Zmass^2)*(64*Gf^2*(Wmass^2 - Zmass^2)^2 - 8*Sqrt[2]*Gf*Lam*(Wmass^2 - Zmass^2)*(Cll2x1x1x2*(Wmass^2 - Zmass^2) - Wmass*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2])) - Lam^2*(7*Cll2x1x1x2^2*(Wmass^2 - Zmass^2)^2 - 2*Cll2x1x1x2*Wmass*(Wmass^2 - Zmass^2)*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2]) + Wmass*(CphiD^2*Wmass^3 + 8*CphiD*CphiWB*(-Wmass^2 + Zmass^2)^(3/2) + 32*CphiW*CphiWB*(-Wmass^2 + Zmass^2)^(3/2)))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}},

C[ S[2] , S[2] , V[1] , V[3] , -V[3] ] == {{(I*gc178*(Wmass^2 - Zmass^2)*(CphiWB*(8*Gf - Sqrt[2]*(Cll2x1x1x2 + CphiD - 12*CphiW)*Lam)*Wmass*(Wmass^2 - Zmass^2) - 2*CphiW*Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(-(CphiD*Wmass^2) + 8*CphiW*Wmass^2 + 2*CphiD*Zmass^2 - 8*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2)))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {((2*I)*CphiW*gc178*(Wmass^2 - Zmass^2)*(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(-(CphiD*Wmass^2) + 8*CphiW*Wmass^2 + 2*CphiD*Zmass^2 - 8*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2)))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {(I*Sqrt[2]*gc178*(Wmass^2 - Zmass^2)*(-(CphiWB*(4*Sqrt[2]*Gf - (Cll2x1x1x2 + CphiD - 12*CphiW)*Lam)*Wmass*(Wmass^2 - Zmass^2)) + 2*CphiW*Sqrt[-Wmass^2 + Zmass^2]*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(-(CphiD*Wmass^2) + 8*CphiW*Wmass^2 + 2*CphiD*Zmass^2 - 8*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2)))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {((-2*I)*CphiW*gc178*(Wmass^2 - Zmass^2)*(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(-(CphiD*Wmass^2) + 8*CphiW*Wmass^2 + 2*CphiD*Zmass^2 - 8*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2)))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {((-2*I)*CphiW*gc178*(Wmass^2 - Zmass^2)*(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(-(CphiD*Wmass^2) + 8*CphiW*Wmass^2 + 2*CphiD*Zmass^2 - 8*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2)))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {((2*I)*CphiW*gc178*(Wmass^2 - Zmass^2)*(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(-(CphiD*Wmass^2) + 8*CphiW*Wmass^2 + 2*CphiD*Zmass^2 - 8*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2)))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}},

C[ S[3] , -S[3] , V[1] , V[3] , -V[3] ] == {{(I*gc179*(Wmass^2 - Zmass^2)*(-(CphiWB*(8*Gf + Sqrt[2]*(-Cll2x1x1x2 + CphiD - 4*CphiW)*Lam)*Wmass*(Wmass^2 - Zmass^2)) - 2*CphiW*Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Wmass^2 + 8*CphiW*Wmass^2 - 8*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2)))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {((2*I)*CphiW*gc179*(Wmass^2 - Zmass^2)*(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Wmass^2 + 8*CphiW*Wmass^2 - 8*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2)))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {(I*Sqrt[2]*gc179*(Wmass^2 - Zmass^2)*(CphiWB*(4*Sqrt[2]*Gf + (-Cll2x1x1x2 + CphiD - 4*CphiW)*Lam)*Wmass*(Wmass^2 - Zmass^2) + 2*CphiW*Sqrt[-Wmass^2 + Zmass^2]*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(CphiD*Wmass^2 + 8*CphiW*Wmass^2 - 8*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2)))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {((-2*I)*CphiW*gc179*(Wmass^2 - Zmass^2)*(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Wmass^2 + 8*CphiW*Wmass^2 - 8*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2)))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {((-2*I)*CphiW*gc179*(Wmass^2 - Zmass^2)*(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Wmass^2 + 8*CphiW*Wmass^2 - 8*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2)))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {((2*I)*CphiW*gc179*(Wmass^2 - Zmass^2)*(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Wmass^2 + 8*CphiW*Wmass^2 - 8*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2)))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {(8*I)*(Cphi4n1 + Cphi4n3)*gc179*Gf*Lam*Wmass^2*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(-8*I)*(Cphi4n1 + Cphi4n3)*gc179*Gf*Lam*Wmass^2*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(8*I)*(Cphi4n1 + Cphi4n3)*gc179*Gf*Lam*Wmass^2*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(-8*I)*(Cphi4n1 + Cphi4n3)*gc179*Gf*Lam*Wmass^2*(-Wmass^2 + Zmass^2)^(3/2), 0}, {0, 0}, {0, 0}},

C[ S[1] , V[1] , V[3] , -V[3] ] == {{(I*gc180*(Wmass^2 - Zmass^2)*(2*CphiWB*(2*Gf + Sqrt[2]*(CphiBox + 3*CphiW)*Lam)*Wmass*(Wmass^2 - Zmass^2) - CphiW*Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(8*CphiW*Wmass^2 + CphiD*Zmass^2 - 8*CphiW*Zmass^2 + 4*CphiBox*(Wmass^2 - Zmass^2)))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {(I*CphiW*gc180*(Wmass^2 - Zmass^2)*(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(8*CphiW*Wmass^2 + CphiD*Zmass^2 - 8*CphiW*Zmass^2 + 4*CphiBox*(Wmass^2 - Zmass^2)))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {((-I)*gc180*(Wmass^2 - Zmass^2)*(2*CphiWB*(2*Gf + Sqrt[2]*(CphiBox + 3*CphiW)*Lam)*Wmass*(Wmass^2 - Zmass^2) - CphiW*Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(8*CphiW*Wmass^2 + CphiD*Zmass^2 - 8*CphiW*Zmass^2 + 4*CphiBox*(Wmass^2 - Zmass^2)))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {((-I)*CphiW*gc180*(Wmass^2 - Zmass^2)*(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(8*CphiW*Wmass^2 + CphiD*Zmass^2 - 8*CphiW*Zmass^2 + 4*CphiBox*(Wmass^2 - Zmass^2)))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {((-I)*CphiW*gc180*(Wmass^2 - Zmass^2)*(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(8*CphiW*Wmass^2 + CphiD*Zmass^2 - 8*CphiW*Zmass^2 + 4*CphiBox*(Wmass^2 - Zmass^2)))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {(I*CphiW*gc180*(Wmass^2 - Zmass^2)*(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(8*CphiW*Wmass^2 + CphiD*Zmass^2 - 8*CphiW*Zmass^2 + 4*CphiBox*(Wmass^2 - Zmass^2)))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {0, 0}, {0, 0}, {0, 0}},

C[ S[1] , S[1] , V[1] , V[3] , -V[3] ] == {{(I*gc181*(Wmass^2 - Zmass^2)*(CphiWB*(8*Gf - Sqrt[2]*(Cll2x1x1x2 - 8*CphiBox + CphiD - 12*CphiW)*Lam)*Wmass*(Wmass^2 - Zmass^2) - 2*CphiW*Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(8*CphiBox*Wmass^2 - CphiD*Wmass^2 + 8*CphiW*Wmass^2 - 8*CphiBox*Zmass^2 + 2*CphiD*Zmass^2 - 8*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2)))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {((2*I)*CphiW*gc181*(Wmass^2 - Zmass^2)*(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(8*CphiBox*Wmass^2 - CphiD*Wmass^2 + 8*CphiW*Wmass^2 - 8*CphiBox*Zmass^2 + 2*CphiD*Zmass^2 - 8*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2)))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {(I*Sqrt[2]*gc181*(Wmass^2 - Zmass^2)*(-(CphiWB*(4*Sqrt[2]*Gf - (Cll2x1x1x2 - 8*CphiBox + CphiD - 12*CphiW)*Lam)*Wmass*(Wmass^2 - Zmass^2)) + 2*CphiW*Sqrt[-Wmass^2 + Zmass^2]*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(8*CphiBox*Wmass^2 - CphiD*Wmass^2 + 8*CphiW*Wmass^2 - 8*CphiBox*Zmass^2 + 2*CphiD*Zmass^2 - 8*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2)))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {((-2*I)*CphiW*gc181*(Wmass^2 - Zmass^2)*(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(8*CphiBox*Wmass^2 - CphiD*Wmass^2 + 8*CphiW*Wmass^2 - 8*CphiBox*Zmass^2 + 2*CphiD*Zmass^2 - 8*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2)))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {((-2*I)*CphiW*gc181*(Wmass^2 - Zmass^2)*(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(8*CphiBox*Wmass^2 - CphiD*Wmass^2 + 8*CphiW*Wmass^2 - 8*CphiBox*Zmass^2 + 2*CphiD*Zmass^2 - 8*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2)))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {((2*I)*CphiW*gc181*(Wmass^2 - Zmass^2)*(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(8*CphiBox*Wmass^2 - CphiD*Wmass^2 + 8*CphiW*Wmass^2 - 8*CphiBox*Zmass^2 + 2*CphiD*Zmass^2 - 8*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2)))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}},

C[ -S[3] , V[1] , V[3] , V[2] ] == {{I*gc182*Wmass*(4*Gf*Wmass + Sqrt[2]*Lam*(CphiD*Wmass + 2*CphiW*Wmass + 2*CphiWB*Sqrt[-Wmass^2 + Zmass^2])), 0}, {0, 0}, {(-I)*gc182*Wmass*(4*Gf*Wmass + Sqrt[2]*Lam*(CphiD*Wmass + 2*CphiW*Wmass + 2*CphiWB*Sqrt[-Wmass^2 + Zmass^2])), 0}, {0, 0}, {(-I)*gc182*(4*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Wmass^2 + 2*CphiW*Wmass^2 - 2*CphiW*Zmass^2 + 2*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2])), 0}, {I*gc182*(4*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Wmass^2 + 2*CphiW*Wmass^2 - 2*CphiW*Zmass^2 + 2*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2])), 0}, {0, 0}, {0, 0}, {0, 0}},

C[ S[2] , -S[3] , V[1] , V[3] , V[2] ] == {{CphiWB*gc183*Wmass*(8*Gf*Wmass + Sqrt[2]*Lam*(-(Cll2x1x1x2*Wmass) + CphiD*Wmass + 4*CphiW*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2])), 0}, {0, 0}, {-(CphiWB*gc183*Wmass*(8*Gf*Wmass + Sqrt[2]*Lam*(-(Cll2x1x1x2*Wmass) + CphiD*Wmass + 4*CphiW*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2]))), 0}, {0, 0}, {-(CphiWB*gc183*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 + CphiD*Zmass^2 - 4*CphiW*Zmass^2 + 4*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2] + Cll2x1x1x2*(-Wmass^2 + Zmass^2)))), 0}, {CphiWB*gc183*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 + CphiD*Zmass^2 - 4*CphiW*Zmass^2 + 4*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2] + Cll2x1x1x2*(-Wmass^2 + Zmass^2))), 0}, {8*Cphi4n3*gc183*Gf*Lam*Wmass*Zmass^2*Sqrt[-Wmass^2 + Zmass^2], 0}, {0, 0}, {4*Cphi4n1*gc183*Gf*Lam*Wmass*Zmass^2*Sqrt[-Wmass^2 + Zmass^2], 0}, {0, 0}, {4*Cphi4n1*gc183*Gf*Lam*Wmass*Zmass^2*Sqrt[-Wmass^2 + Zmass^2], 0}, {0, 0}},

C[ -S[3] , S[1] , V[1] , V[3] , V[2] ] == {{I*CphiWB*gc184*Wmass*(8*Gf*Wmass + Sqrt[2]*Lam*(-(Cll2x1x1x2*Wmass) + 4*CphiBox*Wmass + CphiD*Wmass + 4*CphiW*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2])), 0}, {0, 0}, {(-I)*CphiWB*gc184*Wmass*(8*Gf*Wmass + Sqrt[2]*Lam*(-(Cll2x1x1x2*Wmass) + 4*CphiBox*Wmass + CphiD*Wmass + 4*CphiW*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2])), 0}, {0, 0}, {(-I)*CphiWB*gc184*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(4*CphiBox*Wmass^2 + CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiBox*Zmass^2 + CphiD*Zmass^2 - 4*CphiW*Zmass^2 + 4*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2] + Cll2x1x1x2*(-Wmass^2 + Zmass^2))), 0}, {I*CphiWB*gc184*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(4*CphiBox*Wmass^2 + CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiBox*Zmass^2 + CphiD*Zmass^2 - 4*CphiW*Zmass^2 + 4*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2] + Cll2x1x1x2*(-Wmass^2 + Zmass^2))), 0}, {0, 0}, {(-4*I)*Cphi4n1*gc184*Gf*Lam*Wmass*Zmass^2*Sqrt[-Wmass^2 + Zmass^2], 0}, {0, 0}, {(4*I)*Cphi4n1*gc184*Gf*Lam*Wmass*Zmass^2*Sqrt[-Wmass^2 + Zmass^2], 0}, {0, 0}, {0, 0}},

C[ -S[3] , -S[3] , V[1] , V[1] , V[3] , V[3] ] == {{I*gc185, 0}, {I*gc185, 0}, {0, 0}},

C[ S[2] , -S[3] , -S[3] , V[1] , V[1] , V[3] , V[3] ] == {{gc186, 0}, {gc186, 0}, {0, 0}},

C[ S[2] , S[2] , -S[3] , -S[3] , V[1] , V[1] , V[3] , V[3] ] == {{I*gc187, 0}, {I*gc187, 0}, {0, 0}},

C[ -S[3] , -S[3] , S[1] , V[1] , V[1] , V[3] , V[3] ] == {{I*gc188, 0}, {I*gc188, 0}, {0, 0}},

C[ S[2] , -S[3] , -S[3] , S[1] , V[1] , V[1] , V[3] , V[3] ] == {{gc189, 0}, {gc189, 0}, {0, 0}},

C[ -S[3] , -S[3] , S[1] , S[1] , V[1] , V[1] , V[3] , V[3] ] == {{I*gc190, 0}, {I*gc190, 0}, {0, 0}},

C[ S[2] , -S[3] , -S[3] , V[1] , V[3] , V[3] ] == {{-((Cphi4n1 + Cphi4n3)*gc191), 0}, {-((Cphi4n1 + Cphi4n3)*gc191), 0}, {Cphi4n3*gc191, 0}, {-((Cphi4n1 + Cphi4n3)*gc191), 0}, {-((Cphi4n1 + Cphi4n3)*gc191), 0}, {2*Cphi4n1*gc191, 0}, {0, 0}, {0, 0}, {Cphi4n3*gc191, 0}},

C[ S[2] , S[2] , -S[3] , -S[3] , V[1] , V[3] , V[3] ] == {{I*Cphi4n3*gc192, 0}, {I*Cphi4n3*gc192, 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc192, 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc192, 0}, {I*Cphi4n3*gc192, 0}, {I*Cphi4n3*gc192, 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc192, 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc192, 0}, {(2*I)*Cphi4n1*gc192, 0}, {(2*I)*Cphi4n1*gc192, 0}, {0, 0}, {0, 0}},

C[ S[2] , -S[3] , -S[3] , S[1] , V[1] , V[3] , V[3] ] == {{Cphi4n3*gc193, 0}, {-((Cphi4n1 + Cphi4n3)*gc193), 0}, {-((Cphi4n1 + Cphi4n3)*gc193), 0}, {Cphi4n3*gc193, 0}, {Cphi4n3*gc193, 0}, {-((Cphi4n1 + Cphi4n3)*gc193), 0}, {-((Cphi4n1 + Cphi4n3)*gc193), 0}, {Cphi4n3*gc193, 0}, {2*Cphi4n1*gc193, 0}, {0, 0}, {0, 0}, {2*Cphi4n1*gc193, 0}},

C[ -S[3] , -S[3] , V[1] , V[3] , V[3] ] == {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {I*gc194, 0}, {I*gc194, 0}, {0, 0}, {0, 0}, {I*gc194, 0}, {I*gc194, 0}},

C[ -S[3] , -S[3] , S[1] , V[1] , V[3] , V[3] ] == {{I*(Cphi4n1 + Cphi4n3)*gc195, 0}, {(-I)*Cphi4n3*gc195, 0}, {I*(Cphi4n1 + Cphi4n3)*gc195, 0}, {I*(Cphi4n1 + Cphi4n3)*gc195, 0}, {(-I)*Cphi4n3*gc195, 0}, {0, 0}, {0, 0}, {(-2*I)*Cphi4n1*gc195, 0}, {I*(Cphi4n1 + Cphi4n3)*gc195, 0}},

C[ -S[3] , -S[3] , S[1] , S[1] , V[1] , V[3] , V[3] ] == {{(-I)*(Cphi4n1 + Cphi4n3)*gc196, 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc196, 0}, {I*Cphi4n3*gc196, 0}, {I*Cphi4n3*gc196, 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc196, 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc196, 0}, {I*Cphi4n3*gc196, 0}, {I*Cphi4n3*gc196, 0}, {0, 0}, {0, 0}, {(2*I)*Cphi4n1*gc196, 0}, {(2*I)*Cphi4n1*gc196, 0}},

C[ S[2] , S[3] , S[3] , -S[3] , V[1] , -V[3] ] == {{-2*Sqrt[2]*Cphi4n3*gc197*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {0, 0}, {-2*Sqrt[2]*Cphi4n3*gc197*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {2*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc197*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {0, 0}, {2*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc197*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {4*Sqrt[2]*Cphi4n3*gc197*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {-2*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc197*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {-2*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc197*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {4*Sqrt[2]*Cphi4n1*gc197*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {0, 0}, {0, 0}, {-((CphiD*gc197*(Wmass^2 - Zmass^2)*(4*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(-2*Cll2x1x1x2*Wmass^2 + 2*Cll2x1x1x2*Zmass^2 + CphiD*Zmass^2))))/((Wmass - Zmass)*(Wmass + Zmass))), 0}, {-2*Sqrt[2]*Cphi4n1*gc197*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {0, 0}, {0, 0}, {-2*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc197*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {-2*Sqrt[2]*Cphi4n1*gc197*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {-2*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc197*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}},

C[ S[3] , S[3] , -S[3] , V[1] , -V[3] ] == {{(4*I)*(Cphi4n1 + Cphi4n3)*gc198*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(-4*I)*(Cphi4n1 + Cphi4n3)*gc198*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {0, 0}, {0, 0}, {((-I)*CphiD*gc198*(Wmass^2 - Zmass^2)*(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(-(Cll2x1x1x2*Wmass^2) + CphiD*Wmass^2 + Cll2x1x1x2*Zmass^2))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {0, 0}, {(-4*I)*(Cphi4n1 + Cphi4n3)*gc198*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(4*I)*(Cphi4n1 + Cphi4n3)*gc198*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(-4*I)*(Cphi4n1 + Cphi4n3)*gc198*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(-4*I)*(Cphi4n1 + Cphi4n3)*gc198*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}},

C[ S[3] , S[3] , -S[3] , S[1] , V[1] , -V[3] ] == {{(-2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc199*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(-2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc199*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc199*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc199*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {(-4*I)*Sqrt[2]*Cphi4n1*gc199*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(2*I)*Sqrt[2]*Cphi4n3*gc199*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(2*I)*Sqrt[2]*Cphi4n3*gc199*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(-4*I)*Sqrt[2]*Cphi4n3*gc199*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(I*CphiD*gc199*(Wmass^2 - Zmass^2)*(4*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(-2*Cll2x1x1x2*Wmass^2 + 4*CphiBox*Wmass^2 + 2*Cll2x1x1x2*Zmass^2 - 4*CphiBox*Zmass^2 + CphiD*Zmass^2))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {(2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc199*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(2*I)*Sqrt[2]*Cphi4n1*gc199*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc199*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(2*I)*Sqrt[2]*Cphi4n1*gc199*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {0, 0}, {0, 0}},

C[ S[3] , S[3] , -S[3] , V[1] , V[1] , V[1] , -V[3] ] == {{I*gc200, 0}, {I*gc200, 0}, {I*gc200, 0}},

C[ S[2] , S[3] , S[3] , -S[3] , V[1] , V[1] , V[1] , -V[3] ] == {{gc201, 0}, {gc201, 0}, {gc201, 0}},

C[ S[3] , S[3] , -S[3] , S[1] , V[1] , V[1] , V[1] , -V[3] ] == {{I*gc202, 0}, {I*gc202, 0}, {I*gc202, 0}},

C[ S[2] , S[3] , -V[3] ] == {{gc203*(64*Gf^2 - 8*Sqrt[2]*(Cll2x1x1x2 - 3*CphiD)*Gf*Lam + (-7*Cll2x1x1x2^2 + 6*Cll2x1x1x2*CphiD - 5*CphiD^2)*Lam^2), 0}, {gc203*(-64*Gf^2 + 8*Sqrt[2]*(Cll2x1x1x2 + CphiD)*Gf*Lam + (7*Cll2x1x1x2^2 + 2*Cll2x1x1x2*CphiD - 3*CphiD^2)*Lam^2), 0}},

C[ S[2] , S[2] , S[3] , -V[3] ] == {{I*CphiD*gc204*(-4*Gf + Sqrt[2]*CphiD*Lam), 0}, {I*CphiD*gc204*(-4*Gf + Sqrt[2]*CphiD*Lam), 0}, {(8*I)*Cphi4n3*gc204*Gf*Lam, 0}, {(4*I)*Cphi4n1*gc204*Gf*Lam, 0}, {(4*I)*Cphi4n1*gc204*Gf*Lam, 0}, {0, 0}},

C[ S[2] , S[3] , S[1] , -V[3] ] == {{2*CphiD*gc205*(4*Gf + Sqrt[2]*(2*CphiBox - CphiD)*Lam), 0}, {0, 0}, {4*Cphi4n1*gc205*Gf*Lam, 0}, {0, 0}, {-4*Cphi4n1*gc205*Gf*Lam, 0}, {CphiD*gc205*(-4*Gf + Sqrt[2]*(-2*CphiBox + CphiD)*Lam), 0}},

C[ S[2] , S[2] , S[3] , S[1] , -V[3] ] == {{I*CphiD*gc206*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 - 4*CphiBox + 3*CphiD)*Lam), 0}, {(-2*I)*CphiD*gc206*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 - 4*CphiBox + 3*CphiD)*Lam), 0}, {(-16*I)*(Cphi4n1 + Cphi4n3)*gc206*Gf*Lam, 0}, {(-8*I)*Cphi4n1*gc206*Gf*Lam, 0}, {0, 0}, {(8*I)*Cphi4n1*gc206*Gf*Lam, 0}, {I*CphiD*gc206*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 - 4*CphiBox + 3*CphiD)*Lam), 0}, {0, 0}, {(8*I)*Cphi4n1*gc206*Gf*Lam, 0}, {0, 0}, {0, 0}, {(8*I)*Cphi4n1*gc206*Gf*Lam, 0}, {(-8*I)*Cphi4n1*gc206*Gf*Lam, 0}, {0, 0}, {(16*I)*Cphi4n3*gc206*Gf*Lam, 0}, {(8*I)*Cphi4n1*gc206*Gf*Lam, 0}},

C[ S[2] , S[3] , S[1] , S[1] , -V[3] ] == {{2*CphiD*gc207*(8*Gf - Sqrt[2]*(Cll2x1x1x2 - 8*CphiBox + 3*CphiD)*Lam), 0}, {CphiD*gc207*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 - 8*CphiBox + 3*CphiD)*Lam), 0}, {8*Cphi4n1*gc207*Gf*Lam, 0}, {0, 0}, {-8*Cphi4n1*gc207*Gf*Lam, 0}, {-16*(Cphi4n1 + Cphi4n3)*gc207*Gf*Lam, 0}, {0, 0}, {CphiD*gc207*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 - 8*CphiBox + 3*CphiD)*Lam), 0}, {0, 0}, {0, 0}, {0, 0}, {-8*Cphi4n1*gc207*Gf*Lam, 0}, {8*Cphi4n1*gc207*Gf*Lam, 0}, {8*Cphi4n1*gc207*Gf*Lam, 0}, {8*Cphi4n1*gc207*Gf*Lam, 0}, {16*Cphi4n3*gc207*Gf*Lam, 0}},

C[ S[2] , S[3] , S[3] , -S[3] , V[1] , V[1] , -V[3] ] == {{4*Cphi4n3*gc208, 0}, {-2*(Cphi4n1 + Cphi4n3)*gc208, 0}, {-2*(Cphi4n1 + Cphi4n3)*gc208, 0}, {0, 0}, {2*Cphi4n1*gc208, 0}, {-((Cphi4n1 + Cphi4n3)*gc208), 0}, {-((Cphi4n1 + Cphi4n3)*gc208), 0}, {2*(Cphi4n1 + Cphi4n3)*gc208, 0}, {2*Cphi4n1*gc208, 0}, {-((Cphi4n1 + Cphi4n3)*gc208), 0}, {-((Cphi4n1 + Cphi4n3)*gc208), 0}, {2*(Cphi4n1 + Cphi4n3)*gc208, 0}},

C[ S[2] , S[2] , S[3] , V[1] , -V[3] ] == {{I*Cphi4n1*gc209, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {(2*I)*Cphi4n3*gc209, 0}, {0, 0}, {I*Cphi4n1*gc209, 0}, {0, 0}, {0, 0}},

C[ S[2] , S[2] , S[2] , S[3] , V[1] , -V[3] ] == {{Cphi4n1*gc210, 0}, {Cphi4n1*gc210, 0}, {Cphi4n1*gc210, 0}, {Cphi4n1*gc210, 0}, {Cphi4n1*gc210, 0}, {Cphi4n1*gc210, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {2*Cphi4n3*gc210, 0}, {0, 0}, {2*Cphi4n3*gc210, 0}, {0, 0}, {2*Cphi4n3*gc210, 0}, {0, 0}},

C[ S[2] , S[2] , S[3] , S[1] , V[1] , -V[3] ] == {{I*Cphi4n1*gc211, 0}, {I*Cphi4n1*gc211, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {I*Cphi4n1*gc211, 0}, {I*Cphi4n1*gc211, 0}, {0, 0}, {(-I)*Cphi4n1*gc211, 0}, {(-I)*Cphi4n1*gc211, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {(2*I)*Cphi4n3*gc211, 0}, {0, 0}},

C[ S[2] , S[2] , S[2] , S[3] , -V[3] ] == {{0, 0}, {0, 0}, {2*Cphi4n3*gc212, 0}, {2*Cphi4n3*gc212, 0}, {Cphi4n1*gc212, 0}, {Cphi4n1*gc212, 0}, {0, 0}, {0, 0}, {-2*(Cphi4n1 + Cphi4n3)*gc212, 0}, {Cphi4n1*gc212, 0}, {Cphi4n1*gc212, 0}, {-2*(Cphi4n1 + Cphi4n3)*gc212, 0}, {2*Cphi4n3*gc212, 0}, {Cphi4n1*gc212, 0}, {-2*(Cphi4n1 + Cphi4n3)*gc212, 0}, {Cphi4n1*gc212, 0}},

C[ -U[1] , U[31] , -V[3] ] == {{I*gc213, 0}, {0, 0}},

C[ -U[32] , U[2] , -V[3] ] == {{I*gc214, 0}, {0, 0}},

C[ -U[32] , U[1] , -V[3] ] == {{I*gc215, 0}, {0, 0}},

C[ -U[2] , U[31] , -V[3] ] == {{I*gc216, 0}, {0, 0}},

C[ S[3] , S[1] , -V[3] ] == {{(-I)*gc217, 0}, {I*gc217, 0}},

C[ S[3] , S[3] , -S[3] , -V[3] ] == {{(-I)*CphiD*gc218, 0}, {(-I)*CphiD*gc218, 0}, {0, 0}, {(2*I)*(Cphi4n1 + Cphi4n3)*gc218*Lam, 0}, {(2*I)*(Cphi4n1 + Cphi4n3)*gc218*Lam, 0}, {(2*I)*CphiD*gc218, 0}},

C[ S[2] , S[3] , S[3] , -S[3] , -V[3] ] == {{0, 0}, {-2*CphiD*gc219*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 + CphiD)*Lam), 0}, {-16*Cphi4n1*gc219*Gf*Lam, 0}, {-16*Cphi4n1*gc219*Gf*Lam, 0}, {-16*Cphi4n3*gc219*Gf*Lam, 0}, {-16*Cphi4n3*gc219*Gf*Lam, 0}, {CphiD*gc219*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 + CphiD)*Lam), 0}, {CphiD*gc219*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 + CphiD)*Lam), 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {16*(Cphi4n1 + Cphi4n3)*gc219*Gf*Lam, 0}, {0, 0}, {16*(Cphi4n1 + Cphi4n3)*gc219*Gf*Lam, 0}},

C[ S[3] , S[3] , -S[3] , S[1] , -V[3] ] == {{(-I)*CphiD*gc220*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 - 4*CphiBox + CphiD)*Lam), 0}, {0, 0}, {0, 0}, {(16*I)*Cphi4n3*gc220*Gf*Lam, 0}, {0, 0}, {0, 0}, {(-I)*CphiD*gc220*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 - 4*CphiBox + CphiD)*Lam), 0}, {(2*I)*CphiD*gc220*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 - 4*CphiBox + CphiD)*Lam), 0}, {(-16*I)*(Cphi4n1 + Cphi4n3)*gc220*Gf*Lam, 0}, {0, 0}, {(16*I)*Cphi4n1*gc220*Gf*Lam, 0}, {(-16*I)*(Cphi4n1 + Cphi4n3)*gc220*Gf*Lam, 0}, {(16*I)*Cphi4n3*gc220*Gf*Lam, 0}, {(16*I)*Cphi4n1*gc220*Gf*Lam, 0}, {0, 0}, {0, 0}},

C[ S[3] , S[3] , -S[3] , V[1] , V[1] , -V[3] ] == {{(2*I)*gc221, 0}, {0, 0}, {I*gc221, 0}, {I*gc221, 0}, {(-2*I)*gc221, 0}, {I*gc221, 0}, {I*gc221, 0}, {(-2*I)*gc221, 0}, {(2*I)*gc221, 0}},

C[ S[3] , S[3] , -S[3] , S[1] , V[1] , V[1] , -V[3] ] == {{(-2*I)*(Cphi4n1 + Cphi4n3)*gc222, 0}, {(-2*I)*(Cphi4n1 + Cphi4n3)*gc222, 0}, {0, 0}, {(4*I)*Cphi4n3*gc222, 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc222, 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc222, 0}, {(2*I)*(Cphi4n1 + Cphi4n3)*gc222, 0}, {(2*I)*Cphi4n1*gc222, 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc222, 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc222, 0}, {(2*I)*(Cphi4n1 + Cphi4n3)*gc222, 0}, {(2*I)*Cphi4n1*gc222, 0}},

C[ S[3] , S[1] , S[1] , V[1] , -V[3] ] == {{0, 0}, {I*Cphi4n1*gc223, 0}, {0, 0}, {I*Cphi4n1*gc223, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {(2*I)*Cphi4n3*gc223, 0}, {0, 0}},

C[ S[2] , S[3] , S[1] , S[1] , V[1] , -V[3] ] == {{0, 0}, {0, 0}, {-(Cphi4n1*gc224), 0}, {0, 0}, {Cphi4n1*gc224, 0}, {0, 0}, {-(Cphi4n1*gc224), 0}, {0, 0}, {Cphi4n1*gc224, 0}, {Cphi4n1*gc224, 0}, {0, 0}, {Cphi4n1*gc224, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {2*Cphi4n3*gc224, 0}},

C[ S[3] , S[1] , S[1] , S[1] , V[1] , -V[3] ] == {{0, 0}, {0, 0}, {0, 0}, {I*Cphi4n1*gc225, 0}, {0, 0}, {I*Cphi4n1*gc225, 0}, {0, 0}, {I*Cphi4n1*gc225, 0}, {I*Cphi4n1*gc225, 0}, {0, 0}, {I*Cphi4n1*gc225, 0}, {I*Cphi4n1*gc225, 0}, {0, 0}, {0, 0}, {0, 0}, {(2*I)*Cphi4n3*gc225, 0}, {(2*I)*Cphi4n3*gc225, 0}, {0, 0}, {(2*I)*Cphi4n3*gc225, 0}},

C[ S[3] , S[1] , S[1] , -V[3] ] == {{0, 0}, {0, 0}, {I*Cphi4n1*gc226, 0}, {I*Cphi4n1*gc226, 0}, {(2*I)*Cphi4n3*gc226, 0}, {0, 0}},

C[ S[3] , S[1] , S[1] , S[1] , -V[3] ] == {{0, 0}, {0, 0}, {(-I)*Cphi4n1*gc227, 0}, {(-I)*Cphi4n1*gc227, 0}, {(-2*I)*Cphi4n3*gc227, 0}, {(-2*I)*Cphi4n3*gc227, 0}, {0, 0}, {0, 0}, {(-I)*Cphi4n1*gc227, 0}, {(-I)*Cphi4n1*gc227, 0}, {(-I)*Cphi4n1*gc227, 0}, {(-2*I)*Cphi4n3*gc227, 0}, {(2*I)*(Cphi4n1 + Cphi4n3)*gc227, 0}, {(2*I)*(Cphi4n1 + Cphi4n3)*gc227, 0}, {(-I)*Cphi4n1*gc227, 0}, {(2*I)*(Cphi4n1 + Cphi4n3)*gc227, 0}},

C[ S[2] , S[2] , S[3] , -S[3] , V[3] , -V[3] ] == {{I*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc228*Gf*Lam, 0}, {I*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc228*Gf*Lam, 0}, {(-I)*Sqrt[2]*Cphi4n1*gc228*Gf*Lam, 0}, {(-I)*Sqrt[2]*Cphi4n1*gc228*Gf*Lam, 0}, {(-I)*Sqrt[2]*Cphi4n3*gc228*Gf*Lam, 0}, {(-I)*Sqrt[2]*Cphi4n3*gc228*Gf*Lam, 0}, {(-I)*Sqrt[2]*Cphi4n3*gc228*Gf*Lam, 0}, {(-I)*Sqrt[2]*Cphi4n3*gc228*Gf*Lam, 0}, {(2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc228*Gf*Lam, 0}, {(-I)*Sqrt[2]*Cphi4n1*gc228*Gf*Lam, 0}, {(-I)*Sqrt[2]*Cphi4n1*gc228*Gf*Lam, 0}, {0, 0}, {I*CphiD*gc228*(-2*Sqrt[2]*Gf + (Cll2x1x1x2 + CphiD)*Lam), 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {(2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc228*Gf*Lam, 0}, {(2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc228*Gf*Lam, 0}},

C[ S[3] , -S[3] , S[1] , V[3] , -V[3] ] == {{0, 0}, {(4*I)*Cphi4n1*gc229*Gf*Lam, 0}, {(4*I)*Cphi4n1*gc229*Gf*Lam, 0}, {(4*I)*Cphi4n3*gc229*Gf*Lam, 0}, {(-I)*CphiD*gc229*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 - 4*CphiBox + CphiD)*Lam), 0}, {(-8*I)*(Cphi4n1 + Cphi4n3)*gc229*Gf*Lam, 0}, {0, 0}, {(-8*I)*(Cphi4n1 + Cphi4n3)*gc229*Gf*Lam, 0}, {0, 0}, {(4*I)*Cphi4n3*gc229*Gf*Lam, 0}},

C[ S[3] , -S[3] , S[1] , S[1] , V[3] , -V[3] ] == {{(2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc230*Gf*Lam, 0}, {0, 0}, {(-I)*Sqrt[2]*Cphi4n3*gc230*Gf*Lam, 0}, {(-I)*Sqrt[2]*Cphi4n1*gc230*Gf*Lam, 0}, {(-I)*Sqrt[2]*Cphi4n1*gc230*Gf*Lam, 0}, {(-I)*Sqrt[2]*Cphi4n3*gc230*Gf*Lam, 0}, {(-I)*Sqrt[2]*Cphi4n3*gc230*Gf*Lam, 0}, {(-I)*Sqrt[2]*Cphi4n1*gc230*Gf*Lam, 0}, {I*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc230*Gf*Lam, 0}, {(-I)*Sqrt[2]*Cphi4n1*gc230*Gf*Lam, 0}, {(-I)*Sqrt[2]*Cphi4n3*gc230*Gf*Lam, 0}, {I*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc230*Gf*Lam, 0}, {I*CphiD*gc230*(-2*Sqrt[2]*Gf + (Cll2x1x1x2 - 4*CphiBox + CphiD)*Lam), 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {(2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc230*Gf*Lam, 0}, {(2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc230*Gf*Lam, 0}},

C[ V[1] , V[1] , V[3] , -V[3] ] == {{(-I)*gc231, 0}, {(-I)*gc231, 0}, {((2*I)*Sqrt[2]*gc231*(16*Gf^2*(Wmass^2 - Zmass^2)^2 - 4*Sqrt[2]*Gf*Lam*(Wmass^2 - Zmass^2)*(Cll2x1x1x2*(Wmass^2 - Zmass^2) - Wmass*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2])) + Lam^2*(-3*Cll2x1x1x2^2*(Wmass^2 - Zmass^2)^2 - 4*CphiWB*Wmass*(Sqrt[-Wmass^2 + Zmass^2]*(-2*CphiD*Wmass^2 - 4*CphiW*Wmass^2 + CphiD*Zmass^2 + 4*CphiW*Zmass^2) + 2*CphiWB*(Wmass^3 - Wmass*Zmass^2)))))/(16*Sqrt[2]*Gf^2*(Wmass^2 - Zmass^2)^2 - 8*Gf*Lam*(Wmass^2 - Zmass^2)*(Cll2x1x1x2*(Wmass^2 - Zmass^2) - Wmass*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2])) + Sqrt[2]*Lam^2*(-3*Cll2x1x1x2^2*(Wmass^2 - Zmass^2)^2 - 4*CphiWB*Wmass*(Sqrt[-Wmass^2 + Zmass^2]*(-2*CphiD*Wmass^2 - 4*CphiW*Wmass^2 + CphiD*Zmass^2 + 4*CphiW*Zmass^2) + 2*CphiWB*(Wmass^3 - Wmass*Zmass^2)))), 0}},

C[ S[2] , S[2] , V[1] , V[1] , V[3] , -V[3] ] == {{(-I)*gc232, 0}, {(-I)*gc232, 0}, {(2*I)*gc232, 0}},

C[ S[3] , -S[3] , V[1] , V[1] , V[3] , -V[3] ] == {{(-I)*gc233*(2*Sqrt[2]*CphiW*Gf*(Wmass^2 - Zmass^2) + 4*CphiW^2*Lam*(Wmass^2 - Zmass^2) - Sqrt[2]*(Cphi4n1 + Cphi4n3)*Gf*Lam*Wmass^2*(Wmass^2 - Zmass^2) + CphiW*Lam*(Cll2x1x1x2*(-Wmass^2 + Zmass^2) + Wmass*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2]))), 0}, {(-I)*gc233*(2*Sqrt[2]*CphiW*Gf*(Wmass^2 - Zmass^2) + 4*CphiW^2*Lam*(Wmass^2 - Zmass^2) - Sqrt[2]*(Cphi4n1 + Cphi4n3)*Gf*Lam*Wmass^2*(Wmass^2 - Zmass^2) + CphiW*Lam*(Cll2x1x1x2*(-Wmass^2 + Zmass^2) + Wmass*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2]))), 0}, {(2*I)*gc233*(2*Sqrt[2]*CphiW*Gf*(Wmass^2 - Zmass^2) + 4*CphiW^2*Lam*(Wmass^2 - Zmass^2) + Sqrt[2]*(Cphi4n1 + Cphi4n3)*Gf*Lam*Wmass^2*(Wmass^2 - Zmass^2) + CphiW*Lam*(Cll2x1x1x2*(-Wmass^2 + Zmass^2) + Wmass*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2]))), 0}},

C[ S[1] , V[1] , V[1] , V[3] , -V[3] ] == {{(-I)*gc234, 0}, {(-I)*gc234, 0}, {(2*I)*gc234, 0}},

C[ S[1] , S[1] , V[1] , V[1] , V[3] , -V[3] ] == {{(-I)*gc235, 0}, {(-I)*gc235, 0}, {(2*I)*gc235, 0}},

C[ S[2] , S[2] , S[3] , -S[3] , V[1] , V[1] , V[3] , -V[3] ] == {{I*gc236, 0}, {I*gc236, 0}, {(2*I)*gc236, 0}},

C[ S[3] , S[3] , -S[3] , -S[3] , V[1] , V[1] , V[3] , -V[3] ] == {{I*Cphi4n1*gc237, 0}, {I*Cphi4n1*gc237, 0}, {(2*I)*Cphi4n3*gc237, 0}},

C[ S[3] , -S[3] , S[1] , V[1] , V[1] , V[3] , -V[3] ] == {{I*gc238, 0}, {I*gc238, 0}, {(2*I)*gc238, 0}},

C[ S[3] , -S[3] , S[1] , S[1] , V[1] , V[1] , V[3] , -V[3] ] == {{I*gc239, 0}, {I*gc239, 0}, {(2*I)*gc239, 0}},

C[ S[2] , S[3] , -S[3] , V[1] , V[3] , -V[3] ] == {{0, 0}, {0, 0}, {gc240, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {gc240, 0}},

C[ S[2] , S[2] , S[3] , -S[3] , V[1] , V[3] , -V[3] ] == {{(-I)*(Cphi4n1 - Cphi4n3)*gc241, 0}, {(-I)*(Cphi4n1 - Cphi4n3)*gc241, 0}, {(-2*I)*(Cphi4n1 + Cphi4n3)*gc241, 0}, {0, 0}, {I*(Cphi4n1 - Cphi4n3)*gc241, 0}, {I*(Cphi4n1 - Cphi4n3)*gc241, 0}, {0, 0}, {(2*I)*(Cphi4n1 + Cphi4n3)*gc241, 0}, {0, 0}, {0, 0}, {(-2*I)*(Cphi4n1 + Cphi4n3)*gc241, 0}, {(2*I)*(Cphi4n1 + Cphi4n3)*gc241, 0}},

C[ S[2] , S[3] , -S[3] , S[1] , V[1] , V[3] , -V[3] ] == {{-gc242, 0}, {0, 0}, {0, 0}, {gc242, 0}, {-gc242, 0}, {0, 0}, {0, 0}, {gc242, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}},

C[ S[2] , S[2] , S[2] , S[2] , V[3] , -V[3] ] == {{I*Cphi4n1*gc243, 0}, {I*Cphi4n1*gc243, 0}, {I*Cphi4n1*gc243, 0}, {I*Cphi4n1*gc243, 0}, {I*Cphi4n1*gc243, 0}, {I*Cphi4n1*gc243, 0}, {I*Cphi4n1*gc243, 0}, {I*Cphi4n1*gc243, 0}, {I*Cphi4n1*gc243, 0}, {I*Cphi4n1*gc243, 0}, {I*Cphi4n1*gc243, 0}, {I*Cphi4n1*gc243, 0}, {0, 0}, {(2*I)*Cphi4n3*gc243, 0}, {(2*I)*Cphi4n3*gc243, 0}, {(2*I)*Cphi4n3*gc243, 0}, {(2*I)*Cphi4n3*gc243, 0}, {(2*I)*Cphi4n3*gc243, 0}, {(2*I)*Cphi4n3*gc243, 0}},

C[ S[2] , S[2] , S[1] , V[3] , -V[3] ] == {{I*Cphi4n1*gc244, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {(2*I)*Cphi4n3*gc244, 0}, {0, 0}, {I*Cphi4n1*gc244, 0}, {0, 0}, {0, 0}},

C[ S[2] , S[2] , S[1] , S[1] , V[3] , -V[3] ] == {{I*Cphi4n1*gc245, 0}, {I*Cphi4n1*gc245, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {I*Cphi4n1*gc245, 0}, {0, 0}, {0, 0}, {I*Cphi4n1*gc245, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {(2*I)*Cphi4n3*gc245, 0}, {(2*I)*Cphi4n3*gc245, 0}},

C[ S[3] , S[3] , -S[3] , -S[3] , V[1] , V[3] , -V[3] ] == {{0, 0}, {0, 0}, {I*Cphi4n1*gc246, 0}, {I*Cphi4n1*gc246, 0}, {(-I)*Cphi4n1*gc246, 0}, {(-I)*Cphi4n1*gc246, 0}, {0, 0}, {0, 0}, {(-I)*Cphi4n3*gc246, 0}, {(-I)*Cphi4n3*gc246, 0}, {I*Cphi4n3*gc246, 0}, {I*Cphi4n3*gc246, 0}},

C[ S[2] , S[3] , -S[3] , V[3] , -V[3] ] == {{-(Cphi4n3*gc247), 0}, {0, 0}, {Cphi4n1*gc247, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {-(Cphi4n1*gc247), 0}, {0, 0}, {Cphi4n3*gc247, 0}},

C[ S[2] , S[3] , -S[3] , S[1] , V[3] , -V[3] ] == {{Cphi4n1*gc248, 0}, {Cphi4n3*gc248, 0}, {-(Cphi4n3*gc248), 0}, {0, 0}, {-(Cphi4n1*gc248), 0}, {0, 0}, {(Cphi4n1 + Cphi4n3)*gc248, 0}, {-(Cphi4n3*gc248), 0}, {Cphi4n1*gc248, 0}, {-((Cphi4n1 + Cphi4n3)*gc248), 0}, {-(Cphi4n1*gc248), 0}, {Cphi4n3*gc248, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}},

C[ S[3] , -S[3] , S[1] , V[1] , V[3] , -V[3] ] == {{0, 0}, {I*(Cphi4n1 - Cphi4n3)*gc249, 0}, {0, 0}, {(-2*I)*(Cphi4n1 + Cphi4n3)*gc249, 0}, {(-I)*(Cphi4n1 - Cphi4n3)*gc249, 0}, {(2*I)*(Cphi4n1 + Cphi4n3)*gc249, 0}, {(-2*I)*(Cphi4n1 + Cphi4n3)*gc249, 0}, {0, 0}, {(2*I)*(Cphi4n1 + Cphi4n3)*gc249, 0}},

C[ S[3] , -S[3] , S[1] , S[1] , V[1] , V[3] , -V[3] ] == {{(-2*I)*(Cphi4n1 + Cphi4n3)*gc250, 0}, {0, 0}, {(-I)*(Cphi4n1 - Cphi4n3)*gc250, 0}, {(-I)*(Cphi4n1 - Cphi4n3)*gc250, 0}, {0, 0}, {(2*I)*(Cphi4n1 + Cphi4n3)*gc250, 0}, {I*(Cphi4n1 - Cphi4n3)*gc250, 0}, {I*(Cphi4n1 - Cphi4n3)*gc250, 0}, {(-2*I)*(Cphi4n1 + Cphi4n3)*gc250, 0}, {(2*I)*(Cphi4n1 + Cphi4n3)*gc250, 0}, {0, 0}, {0, 0}},

C[ S[2] , S[1] , V[3] , -V[3] ] == {{0, 0}, {0, 0}, {0, 0}, {-gc251, 0}, {gc251, 0}, {0, 0}},

C[ S[2] , S[2] , S[2] , S[1] , V[3] , -V[3] ] == {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {-gc252, 0}, {-gc252, 0}, {-gc252, 0}, {gc252, 0}, {gc252, 0}, {gc252, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}},

C[ S[2] , S[1] , S[1] , V[3] , -V[3] ] == {{-gc253, 0}, {0, 0}, {-gc253, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {gc253, 0}, {0, 0}, {gc253, 0}},

C[ S[2] , S[1] , S[1] , S[1] , V[3] , -V[3] ] == {{-gc254, 0}, {gc254, 0}, {-gc254, 0}, {0, 0}, {gc254, 0}, {0, 0}, {-gc254, 0}, {0, 0}, {0, 0}, {gc254, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}},

C[ S[1] , S[1] , S[1] , V[3] , -V[3] ] == {{I*Cphi4n1*gc255, 0}, {I*Cphi4n1*gc255, 0}, {I*Cphi4n1*gc255, 0}, {I*Cphi4n1*gc255, 0}, {0, 0}, {(2*I)*Cphi4n3*gc255, 0}, {(2*I)*Cphi4n3*gc255, 0}, {I*Cphi4n1*gc255, 0}, {(2*I)*Cphi4n3*gc255, 0}, {I*Cphi4n1*gc255, 0}},

C[ S[1] , S[1] , S[1] , S[1] , V[3] , -V[3] ] == {{I*Cphi4n1*gc256, 0}, {I*Cphi4n1*gc256, 0}, {I*Cphi4n1*gc256, 0}, {I*Cphi4n1*gc256, 0}, {I*Cphi4n1*gc256, 0}, {I*Cphi4n1*gc256, 0}, {I*Cphi4n1*gc256, 0}, {I*Cphi4n1*gc256, 0}, {I*Cphi4n1*gc256, 0}, {I*Cphi4n1*gc256, 0}, {I*Cphi4n1*gc256, 0}, {I*Cphi4n1*gc256, 0}, {0, 0}, {(2*I)*Cphi4n3*gc256, 0}, {(2*I)*Cphi4n3*gc256, 0}, {(2*I)*Cphi4n3*gc256, 0}, {(2*I)*Cphi4n3*gc256, 0}, {(2*I)*Cphi4n3*gc256, 0}, {(2*I)*Cphi4n3*gc256, 0}},

C[ V[3] , -V[3] , V[2] ] == {{(-I)*gc257*((-64*Gf^2 + 8*Sqrt[2]*(Cll2x1x1x2 - CphiD)*Gf*Lam + (7*Cll2x1x1x2^2 - 2*Cll2x1x1x2*CphiD + CphiD^2)*Lam^2)*Wmass*Sqrt[-Wmass^2 + Zmass^2] + 8*CphiWB*Lam*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(Cll2x1x1x2*Wmass^2 + CphiD*Wmass^2 + 4*CphiW*Wmass^2 - Cll2x1x1x2*Zmass^2 - 4*CphiW*Zmass^2))), 0}, {I*gc257*((-64*Gf^2 + 8*Sqrt[2]*(Cll2x1x1x2 - CphiD)*Gf*Lam + (7*Cll2x1x1x2^2 - 2*Cll2x1x1x2*CphiD + CphiD^2)*Lam^2)*Wmass*Sqrt[-Wmass^2 + Zmass^2] + 8*CphiWB*Lam*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(Cll2x1x1x2*Wmass^2 + CphiD*Wmass^2 + 4*CphiW*Wmass^2 - Cll2x1x1x2*Zmass^2 - 4*CphiW*Zmass^2))), 0}, {I*gc257*((-64*Gf^2 + 8*Sqrt[2]*(Cll2x1x1x2 - CphiD)*Gf*Lam + (7*Cll2x1x1x2^2 - 2*Cll2x1x1x2*CphiD + CphiD^2)*Lam^2)*Wmass*Sqrt[-Wmass^2 + Zmass^2] + 8*CphiWB*Lam*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(Cll2x1x1x2*Wmass^2 + CphiD*Wmass^2 + 4*CphiW*Wmass^2 - Cll2x1x1x2*Zmass^2 - 4*CphiW*Zmass^2))), 0}, {I*gc257*(64*Gf^2 + 8*Sqrt[2]*(-Cll2x1x1x2 + CphiD)*Gf*Lam - (7*Cll2x1x1x2^2 - 2*Cll2x1x1x2*CphiD + CphiD^2)*Lam^2)*Wmass*Sqrt[-Wmass^2 + Zmass^2], 0}, {(-I)*gc257*((-64*Gf^2 + 8*Sqrt[2]*(Cll2x1x1x2 - CphiD)*Gf*Lam + (7*Cll2x1x1x2^2 - 2*Cll2x1x1x2*CphiD + CphiD^2)*Lam^2)*Wmass*Sqrt[-Wmass^2 + Zmass^2] + 8*CphiWB*Lam*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(Cll2x1x1x2*Wmass^2 + CphiD*Wmass^2 + 4*CphiW*Wmass^2 - Cll2x1x1x2*Zmass^2 - 4*CphiW*Zmass^2))), 0}, {I*gc257*(-64*Gf^2 + 8*Sqrt[2]*(Cll2x1x1x2 - CphiD)*Gf*Lam + (7*Cll2x1x1x2^2 - 2*Cll2x1x1x2*CphiD + CphiD^2)*Lam^2)*Wmass*Sqrt[-Wmass^2 + Zmass^2], 0}},

C[ S[2] , S[2] , V[3] , -V[3] , V[2] ] == {{(-2*I)*CphiW*gc258*Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*Wmass - Sqrt[2]*Lam*(Cll2x1x1x2*Wmass + CphiD*Wmass - 8*CphiW*Wmass - 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2])), 0}, {(2*I)*CphiW*gc258*Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*Wmass - Sqrt[2]*Lam*(Cll2x1x1x2*Wmass + CphiD*Wmass - 8*CphiW*Wmass - 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2])), 0}, {(2*I)*CphiW*gc258*((8*Gf - Sqrt[2]*(Cll2x1x1x2 + CphiD - 8*CphiW)*Lam)*Wmass*Sqrt[-Wmass^2 + Zmass^2] + 4*Sqrt[2]*CphiWB*Lam*(-Wmass^2 + Zmass^2)), 0}, {(-2*I)*CphiW*gc258*((8*Gf - Sqrt[2]*(Cll2x1x1x2 + CphiD - 8*CphiW)*Lam)*Wmass*Sqrt[-Wmass^2 + Zmass^2] + 4*Sqrt[2]*CphiWB*Lam*(-Wmass^2 + Zmass^2)), 0}, {(-I)*gc258*(2*CphiW*(8*Gf - Sqrt[2]*(Cll2x1x1x2 + CphiD - 8*CphiW)*Lam)*Wmass*Sqrt[-Wmass^2 + Zmass^2] + CphiWB*(-8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*(Wmass^2 - 2*Zmass^2) + Cll2x1x1x2*(Wmass^2 - Zmass^2) + 12*CphiW*(-Wmass^2 + Zmass^2)))), 0}, {I*gc258*(2*CphiW*(8*Gf - Sqrt[2]*(Cll2x1x1x2 + CphiD - 8*CphiW)*Lam)*Wmass*Sqrt[-Wmass^2 + Zmass^2] + CphiWB*(-8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*(Wmass^2 - 2*Zmass^2) + Cll2x1x1x2*(Wmass^2 - Zmass^2) + 12*CphiW*(-Wmass^2 + Zmass^2)))), 0}, {0, 0}, {(2*I)*Cphi4n1*gc258*Gf*Lam*Wmass*Zmass^2*Sqrt[-Wmass^2 + Zmass^2], 0}, {(-2*I)*Cphi4n1*gc258*Gf*Lam*Wmass*Zmass^2*Sqrt[-Wmass^2 + Zmass^2], 0}, {(-2*I)*Cphi4n1*gc258*Gf*Lam*Wmass*Zmass^2*Sqrt[-Wmass^2 + Zmass^2], 0}, {(2*I)*Cphi4n1*gc258*Gf*Lam*Wmass*Zmass^2*Sqrt[-Wmass^2 + Zmass^2], 0}, {0, 0}},

C[ S[3] , -S[3] , V[3] , -V[3] , V[2] ] == {{(-2*I)*CphiW*gc259*Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*Wmass + Sqrt[2]*Lam*(-(Cll2x1x1x2*Wmass) + CphiD*Wmass + 8*CphiW*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2])), 0}, {(2*I)*CphiW*gc259*Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*Wmass + Sqrt[2]*Lam*(-(Cll2x1x1x2*Wmass) + CphiD*Wmass + 8*CphiW*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2])), 0}, {(2*I)*CphiW*gc259*((8*Gf + Sqrt[2]*(-Cll2x1x1x2 + CphiD + 8*CphiW)*Lam)*Wmass*Sqrt[-Wmass^2 + Zmass^2] + 4*Sqrt[2]*CphiWB*Lam*(-Wmass^2 + Zmass^2)), 0}, {(-2*I)*CphiW*gc259*((8*Gf + Sqrt[2]*(-Cll2x1x1x2 + CphiD + 8*CphiW)*Lam)*Wmass*Sqrt[-Wmass^2 + Zmass^2] + 4*Sqrt[2]*CphiWB*Lam*(-Wmass^2 + Zmass^2)), 0}, {(-I)*gc259*(2*CphiW*(8*Gf + Sqrt[2]*(-Cll2x1x1x2 + CphiD + 8*CphiW)*Lam)*Wmass*Sqrt[-Wmass^2 + Zmass^2] + CphiWB*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(-(Cll2x1x1x2*Wmass^2) + CphiD*Wmass^2 - 4*CphiW*Wmass^2 + Cll2x1x1x2*Zmass^2 + 4*CphiW*Zmass^2))), 0}, {I*gc259*(2*CphiW*(8*Gf + Sqrt[2]*(-Cll2x1x1x2 + CphiD + 8*CphiW)*Lam)*Wmass*Sqrt[-Wmass^2 + Zmass^2] + CphiWB*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(-(Cll2x1x1x2*Wmass^2) + CphiD*Wmass^2 - 4*CphiW*Wmass^2 + Cll2x1x1x2*Zmass^2 + 4*CphiW*Zmass^2))), 0}, {(-4*I)*(Cphi4n1 + Cphi4n3)*gc259*Gf*Lam*Wmass*(2*Wmass^2 - Zmass^2)*Sqrt[-Wmass^2 + Zmass^2], 0}, {(-4*I)*Cphi4n1*gc259*Gf*Lam*Wmass*Zmass^2*Sqrt[-Wmass^2 + Zmass^2], 0}, {(4*I)*Cphi4n1*gc259*Gf*Lam*Wmass*Zmass^2*Sqrt[-Wmass^2 + Zmass^2], 0}, {(4*I)*gc259*Gf*Lam*Wmass*Sqrt[-Wmass^2 + Zmass^2]*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-4*I)*gc259*Gf*Lam*Wmass*Sqrt[-Wmass^2 + Zmass^2]*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(4*I)*(Cphi4n1 + Cphi4n3)*gc259*Gf*Lam*Wmass*(2*Wmass^2 - Zmass^2)*Sqrt[-Wmass^2 + Zmass^2], 0}},

C[ S[1] , V[3] , -V[3] , V[2] ] == {{(8*I)*CphiW*gc260*(2*Gf*Wmass + Sqrt[2]*Lam*(CphiBox*Wmass + 2*CphiW*Wmass + CphiWB*Sqrt[-Wmass^2 + Zmass^2])), 0}, {(-8*I)*CphiW*gc260*(2*Gf*Wmass + Sqrt[2]*Lam*(CphiBox*Wmass + 2*CphiW*Wmass + CphiWB*Sqrt[-Wmass^2 + Zmass^2])), 0}, {(-8*I)*CphiW*gc260*(2*Gf*Wmass + Sqrt[2]*Lam*(CphiBox*Wmass + 2*CphiW*Wmass + CphiWB*Sqrt[-Wmass^2 + Zmass^2])), 0}, {(8*I)*CphiW*gc260*(2*Gf*Wmass + Sqrt[2]*Lam*(CphiBox*Wmass + 2*CphiW*Wmass + CphiWB*Sqrt[-Wmass^2 + Zmass^2])), 0}, {I*gc260*(8*CphiW*(2*Gf + Sqrt[2]*(CphiBox + 2*CphiW)*Lam)*Wmass - (CphiWB*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Zmass^2 + 4*CphiBox*(Wmass^2 - Zmass^2) + 12*CphiW*(Wmass^2 - Zmass^2))))/Sqrt[-Wmass^2 + Zmass^2]), 0}, {(-8*I)*CphiW*gc260*(2*Gf + Sqrt[2]*(CphiBox + 2*CphiW)*Lam)*Wmass + (I*CphiWB*gc260*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Zmass^2 + 4*CphiBox*(Wmass^2 - Zmass^2) + 12*CphiW*(Wmass^2 - Zmass^2))))/Sqrt[-Wmass^2 + Zmass^2], 0}, {(-2*I)*Cphi4n1*gc260*Gf*Lam*Wmass*Zmass^2, 0}, {(2*I)*Cphi4n1*gc260*Gf*Lam*Wmass*Zmass^2, 0}, {0, 0}},

C[ S[1] , S[1] , V[3] , -V[3] , V[2] ] == {{(-2*I)*CphiW*gc261*Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*Wmass + Sqrt[2]*Lam*(-(Cll2x1x1x2*Wmass) + 8*CphiBox*Wmass - CphiD*Wmass + 8*CphiW*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2])), 0}, {(2*I)*CphiW*gc261*Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*Wmass + Sqrt[2]*Lam*(-(Cll2x1x1x2*Wmass) + 8*CphiBox*Wmass - CphiD*Wmass + 8*CphiW*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2])), 0}, {(2*I)*CphiW*gc261*((8*Gf - Sqrt[2]*(Cll2x1x1x2 - 8*CphiBox + CphiD - 8*CphiW)*Lam)*Wmass*Sqrt[-Wmass^2 + Zmass^2] + 4*Sqrt[2]*CphiWB*Lam*(-Wmass^2 + Zmass^2)), 0}, {(-2*I)*CphiW*gc261*((8*Gf - Sqrt[2]*(Cll2x1x1x2 - 8*CphiBox + CphiD - 8*CphiW)*Lam)*Wmass*Sqrt[-Wmass^2 + Zmass^2] + 4*Sqrt[2]*CphiWB*Lam*(-Wmass^2 + Zmass^2)), 0}, {(-I)*gc261*(2*CphiW*(8*Gf - Sqrt[2]*(Cll2x1x1x2 - 8*CphiBox + CphiD - 8*CphiW)*Lam)*Wmass*Sqrt[-Wmass^2 + Zmass^2] + CphiWB*(-8*Gf*Wmass^2 + 8*Gf*Zmass^2 + Sqrt[2]*Lam*(-8*CphiBox*Wmass^2 + CphiD*Wmass^2 - 12*CphiW*Wmass^2 + 8*CphiBox*Zmass^2 - 2*CphiD*Zmass^2 + 12*CphiW*Zmass^2 + Cll2x1x1x2*(Wmass^2 - Zmass^2)))), 0}, {I*gc261*(2*CphiW*(8*Gf - Sqrt[2]*(Cll2x1x1x2 - 8*CphiBox + CphiD - 8*CphiW)*Lam)*Wmass*Sqrt[-Wmass^2 + Zmass^2] + CphiWB*(-8*Gf*Wmass^2 + 8*Gf*Zmass^2 + Sqrt[2]*Lam*(-8*CphiBox*Wmass^2 + CphiD*Wmass^2 - 12*CphiW*Wmass^2 + 8*CphiBox*Zmass^2 - 2*CphiD*Zmass^2 + 12*CphiW*Zmass^2 + Cll2x1x1x2*(Wmass^2 - Zmass^2)))), 0}, {0, 0}, {(6*I)*Cphi4n1*gc261*Gf*Lam*Wmass*Zmass^2*Sqrt[-Wmass^2 + Zmass^2], 0}, {(-6*I)*Cphi4n1*gc261*Gf*Lam*Wmass*Zmass^2*Sqrt[-Wmass^2 + Zmass^2], 0}, {(-6*I)*Cphi4n1*gc261*Gf*Lam*Wmass*Zmass^2*Sqrt[-Wmass^2 + Zmass^2], 0}, {(6*I)*Cphi4n1*gc261*Gf*Lam*Wmass*Zmass^2*Sqrt[-Wmass^2 + Zmass^2], 0}, {0, 0}},

C[ S[3] , -S[3] , -S[3] , V[1] , V[3] , V[3] , -V[3] ] == {{(2*I)*Cphi4n1*gc262, 0}, {I*Cphi4n3*gc262, 0}, {I*Cphi4n3*gc262, 0}},

C[ S[2] , S[3] , -S[3] , -S[3] , V[1] , V[3] , V[3] , -V[3] ] == {{2*Cphi4n1*gc263, 0}, {Cphi4n3*gc263, 0}, {Cphi4n3*gc263, 0}},

C[ S[3] , -S[3] , -S[3] , S[1] , V[1] , V[3] , V[3] , -V[3] ] == {{(2*I)*Cphi4n1*gc264, 0}, {I*Cphi4n3*gc264, 0}, {I*Cphi4n3*gc264, 0}},

C[ S[2] , -S[3] , V[3] , V[3] , -V[3] ] == {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {2*Cphi4n1*gc265, 0}, {-((Cphi4n1 + Cphi4n3)*gc265), 0}, {Cphi4n3*gc265, 0}, {-((Cphi4n1 + Cphi4n3)*gc265), 0}, {Cphi4n3*gc265, 0}, {0, 0}},

C[ S[2] , S[2] , S[2] , -S[3] , V[3] , V[3] , -V[3] ] == {{-2*Cphi4n1*gc266, 0}, {-2*Cphi4n1*gc266, 0}, {-2*Cphi4n1*gc266, 0}, {0, 0}, {-(Cphi4n3*gc266), 0}, {-(Cphi4n3*gc266), 0}, {-(Cphi4n3*gc266), 0}, {3*(Cphi4n1 + Cphi4n3)*gc266, 0}, {-(Cphi4n3*gc266), 0}, {-(Cphi4n3*gc266), 0}, {-(Cphi4n3*gc266), 0}, {3*(Cphi4n1 + Cphi4n3)*gc266, 0}},

C[ S[2] , -S[3] , S[1] , V[3] , V[3] , -V[3] ] == {{0, 0}, {0, 0}, {Cphi4n3*gc267, 0}, {-((Cphi4n1 + Cphi4n3)*gc267), 0}, {0, 0}, {Cphi4n3*gc267, 0}, {-((Cphi4n1 + Cphi4n3)*gc267), 0}, {0, 0}, {2*Cphi4n1*gc267, 0}},

C[ S[2] , -S[3] , S[1] , S[1] , V[3] , V[3] , -V[3] ] == {{-2*Cphi4n1*gc268, 0}, {0, 0}, {0, 0}, {0, 0}, {-(Cphi4n3*gc268), 0}, {(Cphi4n1 + Cphi4n3)*gc268, 0}, {0, 0}, {0, 0}, {-(Cphi4n3*gc268), 0}, {(Cphi4n1 + Cphi4n3)*gc268, 0}, {0, 0}, {0, 0}},

C[ S[3] , -S[3] , -S[3] , V[3] , V[3] , -V[3] ] == {{(2*I)*Cphi4n1*gc269, 0}, {(2*I)*Cphi4n1*gc269, 0}, {0, 0}, {I*Cphi4n3*gc269, 0}, {I*Cphi4n3*gc269, 0}, {0, 0}, {I*Cphi4n3*gc269, 0}, {I*Cphi4n3*gc269, 0}, {0, 0}},

C[ S[2] , S[3] , -S[3] , -S[3] , V[3] , V[3] , -V[3] ] == {{0, 0}, {0, 0}, {2*Cphi4n1*gc270, 0}, {2*Cphi4n1*gc270, 0}, {-2*(Cphi4n1 + Cphi4n3)*gc270, 0}, {0, 0}, {Cphi4n3*gc270, 0}, {Cphi4n3*gc270, 0}, {-2*(Cphi4n1 + Cphi4n3)*gc270, 0}, {0, 0}, {Cphi4n3*gc270, 0}, {Cphi4n3*gc270, 0}},

C[ S[3] , -S[3] , -S[3] , S[1] , V[3] , V[3] , -V[3] ] == {{0, 0}, {(-2*I)*Cphi4n1*gc271, 0}, {(-2*I)*Cphi4n1*gc271, 0}, {0, 0}, {0, 0}, {(-I)*Cphi4n3*gc271, 0}, {(-I)*Cphi4n3*gc271, 0}, {(2*I)*(Cphi4n1 + Cphi4n3)*gc271, 0}, {0, 0}, {(-I)*Cphi4n3*gc271, 0}, {(-I)*Cphi4n3*gc271, 0}, {(2*I)*(Cphi4n1 + Cphi4n3)*gc271, 0}},

C[ -S[3] , S[1] , V[3] , V[3] , -V[3] ] == {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {I*Cphi4n3*gc272, 0}, {(-3*I)*(Cphi4n1 + Cphi4n3)*gc272, 0}, {I*Cphi4n3*gc272, 0}, {(-3*I)*(Cphi4n1 + Cphi4n3)*gc272, 0}, {(2*I)*Cphi4n1*gc272, 0}},

C[ S[2] , S[2] , -S[3] , S[1] , V[3] , V[3] , -V[3] ] == {{0, 0}, {0, 0}, {0, 0}, {(2*I)*Cphi4n1*gc273, 0}, {0, 0}, {0, 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc273, 0}, {I*Cphi4n3*gc273, 0}, {0, 0}, {0, 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc273, 0}, {I*Cphi4n3*gc273, 0}},

C[ -S[3] , S[1] , S[1] , V[3] , V[3] , -V[3] ] == {{(2*I)*Cphi4n1*gc274, 0}, {(2*I)*Cphi4n1*gc274, 0}, {(-3*I)*(Cphi4n1 + Cphi4n3)*gc274, 0}, {I*Cphi4n3*gc274, 0}, {I*Cphi4n3*gc274, 0}, {(-3*I)*(Cphi4n1 + Cphi4n3)*gc274, 0}, {I*Cphi4n3*gc274, 0}, {I*Cphi4n3*gc274, 0}, {0, 0}},

C[ -S[3] , S[1] , S[1] , S[1] , V[3] , V[3] , -V[3] ] == {{0, 0}, {(2*I)*Cphi4n1*gc275, 0}, {(2*I)*Cphi4n1*gc275, 0}, {(2*I)*Cphi4n1*gc275, 0}, {(-3*I)*(Cphi4n1 + Cphi4n3)*gc275, 0}, {I*Cphi4n3*gc275, 0}, {I*Cphi4n3*gc275, 0}, {I*Cphi4n3*gc275, 0}, {(-3*I)*(Cphi4n1 + Cphi4n3)*gc275, 0}, {I*Cphi4n3*gc275, 0}, {I*Cphi4n3*gc275, 0}, {I*Cphi4n3*gc275, 0}},

C[ S[3] , S[3] , -V[3] , -V[3] ] == {{0, 0}, {(2*I)*CphiD*gc276, 0}, {0, 0}, {I*(Cphi4n1 + Cphi4n3)*gc276*Lam, 0}, {I*(Cphi4n1 + Cphi4n3)*gc276*Lam, 0}, {0, 0}},

C[ S[2] , S[3] , S[3] , -V[3] , -V[3] ] == {{2*Cphi4n3*gc277*Gf*Lam, 0}, {-4*(Cphi4n1 + Cphi4n3)*gc277*Gf*Lam, 0}, {2*Cphi4n3*gc277*Gf*Lam, 0}, {-4*(Cphi4n1 + Cphi4n3)*gc277*Gf*Lam, 0}, {CphiD*gc277*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 + CphiD)*Lam), 0}, {4*Cphi4n1*gc277*Gf*Lam, 0}, {4*Cphi4n1*gc277*Gf*Lam, 0}, {2*Cphi4n3*gc277*Gf*Lam, 0}, {0, 0}, {2*Cphi4n3*gc277*Gf*Lam, 0}},

C[ S[2] , S[2] , S[3] , S[3] , -V[3] , -V[3] ] == {{(-2*I)*(Cphi4n1 + Cphi4n3)*gc278*Gf*Lam, 0}, {(-2*I)*(Cphi4n1 + Cphi4n3)*gc278*Gf*Lam, 0}, {I*Cphi4n3*gc278*Gf*Lam, 0}, {I*Cphi4n3*gc278*Gf*Lam, 0}, {I*Cphi4n3*gc278*Gf*Lam, 0}, {I*Cphi4n3*gc278*Gf*Lam, 0}, {I*Cphi4n3*gc278*Gf*Lam, 0}, {I*Cphi4n3*gc278*Gf*Lam, 0}, {(-2*I)*(Cphi4n1 + Cphi4n3)*gc278*Gf*Lam, 0}, {I*Cphi4n3*gc278*Gf*Lam, 0}, {I*Cphi4n3*gc278*Gf*Lam, 0}, {(-2*I)*(Cphi4n1 + Cphi4n3)*gc278*Gf*Lam, 0}, {(-I)*CphiD*gc278*(4*Gf - Sqrt[2]*(Cll2x1x1x2 + CphiD)*Lam), 0}, {(2*I)*Cphi4n1*gc278*Gf*Lam, 0}, {(2*I)*Cphi4n1*gc278*Gf*Lam, 0}, {(2*I)*Cphi4n1*gc278*Gf*Lam, 0}, {(2*I)*Cphi4n1*gc278*Gf*Lam, 0}, {0, 0}, {0, 0}},

C[ S[3] , S[3] , S[1] , -V[3] , -V[3] ] == {{(-4*I)*(Cphi4n1 + Cphi4n3)*gc279*Gf*Lam, 0}, {(2*I)*Cphi4n3*gc279*Gf*Lam, 0}, {(2*I)*Cphi4n3*gc279*Gf*Lam, 0}, {(2*I)*Cphi4n3*gc279*Gf*Lam, 0}, {I*CphiD*gc279*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 - 4*CphiBox + CphiD)*Lam), 0}, {0, 0}, {(4*I)*Cphi4n1*gc279*Gf*Lam, 0}, {(-4*I)*(Cphi4n1 + Cphi4n3)*gc279*Gf*Lam, 0}, {(4*I)*Cphi4n1*gc279*Gf*Lam, 0}, {(2*I)*Cphi4n3*gc279*Gf*Lam, 0}},

C[ S[2] , S[3] , S[3] , S[1] , -V[3] , -V[3] ] == {{Cphi4n3*gc280*Gf*Lam, 0}, {Cphi4n3*gc280*Gf*Lam, 0}, {Cphi4n3*gc280*Gf*Lam, 0}, {-2*(Cphi4n1 + Cphi4n3)*gc280*Gf*Lam, 0}, {Cphi4n3*gc280*Gf*Lam, 0}, {-2*(Cphi4n1 + Cphi4n3)*gc280*Gf*Lam, 0}, {-2*(Cphi4n1 + Cphi4n3)*gc280*Gf*Lam, 0}, {Cphi4n3*gc280*Gf*Lam, 0}, {Cphi4n3*gc280*Gf*Lam, 0}, {-2*(Cphi4n1 + Cphi4n3)*gc280*Gf*Lam, 0}, {Cphi4n3*gc280*Gf*Lam, 0}, {Cphi4n3*gc280*Gf*Lam, 0}, {CphiD*gc280*(-4*Gf + Sqrt[2]*(Cll2x1x1x2 - 2*CphiBox + CphiD)*Lam), 0}, {2*Cphi4n1*gc280*Gf*Lam, 0}, {0, 0}, {0, 0}, {2*Cphi4n1*gc280*Gf*Lam, 0}, {2*Cphi4n1*gc280*Gf*Lam, 0}, {2*Cphi4n1*gc280*Gf*Lam, 0}},

C[ S[3] , S[3] , S[1] , S[1] , -V[3] , -V[3] ] == {{(-2*I)*(Cphi4n1 + Cphi4n3)*gc281*Gf*Lam, 0}, {(-2*I)*(Cphi4n1 + Cphi4n3)*gc281*Gf*Lam, 0}, {I*Cphi4n3*gc281*Gf*Lam, 0}, {I*Cphi4n3*gc281*Gf*Lam, 0}, {I*Cphi4n3*gc281*Gf*Lam, 0}, {I*Cphi4n3*gc281*Gf*Lam, 0}, {I*Cphi4n3*gc281*Gf*Lam, 0}, {I*Cphi4n3*gc281*Gf*Lam, 0}, {(-2*I)*(Cphi4n1 + Cphi4n3)*gc281*Gf*Lam, 0}, {I*Cphi4n3*gc281*Gf*Lam, 0}, {I*Cphi4n3*gc281*Gf*Lam, 0}, {(-2*I)*(Cphi4n1 + Cphi4n3)*gc281*Gf*Lam, 0}, {(-I)*CphiD*gc281*(4*Gf - Sqrt[2]*(Cll2x1x1x2 - 4*CphiBox + CphiD)*Lam), 0}, {(2*I)*Cphi4n1*gc281*Gf*Lam, 0}, {(2*I)*Cphi4n1*gc281*Gf*Lam, 0}, {(2*I)*Cphi4n1*gc281*Gf*Lam, 0}, {(2*I)*Cphi4n1*gc281*Gf*Lam, 0}, {0, 0}, {0, 0}},

C[ S[2] , S[3] , S[1] , V[1] , -V[3] ] == {{0, 0}, {0, 0}, {-gc282, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {gc282, 0}},

C[ S[3] , V[1] , V[1] , -V[3] ] == {{(-I)*gc283, 0}, {(-I)*gc283, 0}, {(I*Sqrt[2]*gc283*(4*CphiWB*Lam*Wmass*(Wmass^2 - Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(CphiD*Lam*(-2*Wmass^2 + Zmass^2) + 4*Sqrt[2]*Gf*(-Wmass^2 + Zmass^2) + 4*CphiW*Lam*(-Wmass^2 + Zmass^2))))/(4*Sqrt[2]*CphiWB*Lam*Wmass*(Wmass^2 - Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(-8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*(-2*Wmass^2 + Zmass^2) + 4*CphiW*(-Wmass^2 + Zmass^2)))), 0}, {(I*Sqrt[2]*gc283*(4*CphiWB*Lam*Wmass*(Wmass^2 - Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(CphiD*Lam*(-2*Wmass^2 + Zmass^2) + 4*Sqrt[2]*Gf*(-Wmass^2 + Zmass^2) + 4*CphiW*Lam*(-Wmass^2 + Zmass^2))))/(4*Sqrt[2]*CphiWB*Lam*Wmass*(Wmass^2 - Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(-8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*(-2*Wmass^2 + Zmass^2) + 4*CphiW*(-Wmass^2 + Zmass^2)))), 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}},

C[ S[2] , S[3] , V[1] , V[1] , -V[3] ] == {{-gc284, 0}, {-gc284, 0}, {-((Sqrt[2]*gc284*(4*CphiWB*Lam*Wmass*(Wmass^2 - Zmass^2) - Sqrt[-Wmass^2 + Zmass^2]*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2)))))/(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2))))), 0}, {-((Sqrt[2]*gc284*(4*CphiWB*Lam*Wmass*(Wmass^2 - Zmass^2) - Sqrt[-Wmass^2 + Zmass^2]*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2)))))/(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2))))), 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}},

C[ S[3] , S[1] , V[1] , V[1] , -V[3] ] == {{(-I)*gc285, 0}, {(-I)*gc285, 0}, {(I*Sqrt[2]*gc285*(4*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(4*CphiBox*Wmass^2 + CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiBox*Zmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2)))))/(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(4*CphiBox*Wmass^2 + CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiBox*Zmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2)))), 0}, {(I*Sqrt[2]*gc285*(4*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(4*CphiBox*Wmass^2 + CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiBox*Zmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2)))))/(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(4*CphiBox*Wmass^2 + CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiBox*Zmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2)))), 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}},

C[ S[3] , V[1] , -V[3] , V[2] ] == {{I*gc286*Wmass*(4*Gf*Wmass + Sqrt[2]*Lam*(CphiD*Wmass + 2*CphiW*Wmass + 2*CphiWB*Sqrt[-Wmass^2 + Zmass^2])), 0}, {0, 0}, {(-I)*gc286*Wmass*(4*Gf*Wmass + Sqrt[2]*Lam*(CphiD*Wmass + 2*CphiW*Wmass + 2*CphiWB*Sqrt[-Wmass^2 + Zmass^2])), 0}, {0, 0}, {(-I)*gc286*(4*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Wmass^2 + 2*CphiW*Wmass^2 - 2*CphiW*Zmass^2 + 2*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2])), 0}, {I*gc286*(4*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Wmass^2 + 2*CphiW*Wmass^2 - 2*CphiW*Zmass^2 + 2*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2])), 0}, {0, 0}, {0, 0}, {0, 0}},

C[ S[2] , S[3] , V[1] , -V[3] , V[2] ] == {{CphiWB*gc287*Wmass*(8*Gf*Wmass + Sqrt[2]*Lam*(-(Cll2x1x1x2*Wmass) + CphiD*Wmass + 4*CphiW*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2])), 0}, {0, 0}, {-(CphiWB*gc287*Wmass*(8*Gf*Wmass + Sqrt[2]*Lam*(-(Cll2x1x1x2*Wmass) + CphiD*Wmass + 4*CphiW*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2]))), 0}, {0, 0}, {-(CphiWB*gc287*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 + CphiD*Zmass^2 - 4*CphiW*Zmass^2 + 4*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2] + Cll2x1x1x2*(-Wmass^2 + Zmass^2)))), 0}, {CphiWB*gc287*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 + CphiD*Zmass^2 - 4*CphiW*Zmass^2 + 4*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2] + Cll2x1x1x2*(-Wmass^2 + Zmass^2))), 0}, {8*Cphi4n3*gc287*Gf*Lam*Wmass*Zmass^2*Sqrt[-Wmass^2 + Zmass^2], 0}, {0, 0}, {4*Cphi4n1*gc287*Gf*Lam*Wmass*Zmass^2*Sqrt[-Wmass^2 + Zmass^2], 0}, {0, 0}, {4*Cphi4n1*gc287*Gf*Lam*Wmass*Zmass^2*Sqrt[-Wmass^2 + Zmass^2], 0}, {0, 0}},

C[ S[3] , S[1] , V[1] , -V[3] , V[2] ] == {{I*CphiWB*gc288*Wmass*(8*Gf*Wmass + Sqrt[2]*Lam*(-(Cll2x1x1x2*Wmass) + 4*CphiBox*Wmass + CphiD*Wmass + 4*CphiW*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2])), 0}, {0, 0}, {(-I)*CphiWB*gc288*Wmass*(8*Gf*Wmass + Sqrt[2]*Lam*(-(Cll2x1x1x2*Wmass) + 4*CphiBox*Wmass + CphiD*Wmass + 4*CphiW*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2])), 0}, {0, 0}, {(-I)*CphiWB*gc288*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(4*CphiBox*Wmass^2 + CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiBox*Zmass^2 + CphiD*Zmass^2 - 4*CphiW*Zmass^2 + 4*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2] + Cll2x1x1x2*(-Wmass^2 + Zmass^2))), 0}, {I*CphiWB*gc288*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(4*CphiBox*Wmass^2 + CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiBox*Zmass^2 + CphiD*Zmass^2 - 4*CphiW*Zmass^2 + 4*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2] + Cll2x1x1x2*(-Wmass^2 + Zmass^2))), 0}, {0, 0}, {(-4*I)*Cphi4n1*gc288*Gf*Lam*Wmass*Zmass^2*Sqrt[-Wmass^2 + Zmass^2], 0}, {0, 0}, {(4*I)*Cphi4n1*gc288*Gf*Lam*Wmass*Zmass^2*Sqrt[-Wmass^2 + Zmass^2], 0}, {0, 0}, {0, 0}},

C[ S[3] , S[3] , -S[3] , -S[3] , V[3] , -V[3] ] == {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {I*Cphi4n1*gc289, 0}, {I*Cphi4n1*gc289, 0}, {0, 0}, {0, 0}, {0, 0}, {I*Cphi4n1*gc289, 0}, {I*Cphi4n1*gc289, 0}, {0, 0}, {0, 0}, {I*Cphi4n3*gc289, 0}, {I*Cphi4n3*gc289, 0}, {I*Cphi4n3*gc289, 0}, {I*Cphi4n3*gc289, 0}, {0, 0}, {0, 0}},

C[ -S[3] , V[1] , V[3] , V[3] , -V[3] ] == {{0, 0}, {I*gc290, 0}, {I*gc290, 0}},

C[ S[2] , -S[3] , V[1] , V[3] , V[3] , -V[3] ] == {{0, 0}, {gc291, 0}, {gc291, 0}},

C[ S[2] , S[2] , -S[3] , V[1] , V[3] , V[3] , -V[3] ] == {{0, 0}, {I*gc292, 0}, {I*gc292, 0}},

C[ S[2] , S[2] , S[2] , -S[3] , V[1] , V[3] , V[3] , -V[3] ] == {{0, 0}, {gc293, 0}, {gc293, 0}},

C[ -S[3] , S[1] , V[1] , V[3] , V[3] , -V[3] ] == {{0, 0}, {I*gc294, 0}, {I*gc294, 0}},

C[ S[2] , -S[3] , S[1] , V[1] , V[3] , V[3] , -V[3] ] == {{0, 0}, {gc295, 0}, {gc295, 0}},

C[ S[2] , S[2] , -S[3] , S[1] , V[1] , V[3] , V[3] , -V[3] ] == {{0, 0}, {I*gc296, 0}, {I*gc296, 0}},

C[ -S[3] , S[1] , S[1] , V[1] , V[3] , V[3] , -V[3] ] == {{0, 0}, {I*gc297, 0}, {I*gc297, 0}},

C[ S[2] , -S[3] , S[1] , S[1] , V[1] , V[3] , V[3] , -V[3] ] == {{0, 0}, {gc298, 0}, {gc298, 0}},

C[ -S[3] , S[1] , S[1] , S[1] , V[1] , V[3] , V[3] , -V[3] ] == {{0, 0}, {I*gc299, 0}, {I*gc299, 0}},

C[ -S[3] , V[3] , V[3] , -V[3] ] == {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {I*gc300, 0}, {I*gc300, 0}, {0, 0}},

C[ S[2] , S[2] , -S[3] , V[3] , V[3] , -V[3] ] == {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {I*gc301, 0}, {0, 0}, {0, 0}, {I*gc301, 0}, {0, 0}},

C[ S[3] , S[3] , V[1] , V[1] , -V[3] , -V[3] ] == {{I*gc302, 0}, {I*gc302, 0}, {0, 0}},

C[ S[2] , S[3] , S[3] , V[1] , V[1] , -V[3] , -V[3] ] == {{gc303, 0}, {gc303, 0}, {0, 0}},

C[ S[2] , S[2] , S[3] , S[3] , V[1] , V[1] , -V[3] , -V[3] ] == {{I*gc304, 0}, {I*gc304, 0}, {0, 0}},

C[ S[3] , S[3] , S[1] , V[1] , V[1] , -V[3] , -V[3] ] == {{I*gc305, 0}, {I*gc305, 0}, {0, 0}},

C[ S[2] , S[3] , S[3] , S[1] , V[1] , V[1] , -V[3] , -V[3] ] == {{gc306, 0}, {gc306, 0}, {0, 0}},

C[ S[3] , S[3] , S[1] , S[1] , V[1] , V[1] , -V[3] , -V[3] ] == {{I*gc307, 0}, {I*gc307, 0}, {0, 0}},

C[ S[2] , S[3] , S[3] , V[1] , -V[3] , -V[3] ] == {{-((Cphi4n1 + Cphi4n3)*gc308), 0}, {-((Cphi4n1 + Cphi4n3)*gc308), 0}, {Cphi4n3*gc308, 0}, {-((Cphi4n1 + Cphi4n3)*gc308), 0}, {-((Cphi4n1 + Cphi4n3)*gc308), 0}, {2*Cphi4n1*gc308, 0}, {0, 0}, {0, 0}, {Cphi4n3*gc308, 0}},

C[ S[2] , S[2] , S[3] , S[3] , V[1] , -V[3] , -V[3] ] == {{I*Cphi4n3*gc309, 0}, {I*Cphi4n3*gc309, 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc309, 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc309, 0}, {I*Cphi4n3*gc309, 0}, {I*Cphi4n3*gc309, 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc309, 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc309, 0}, {(2*I)*Cphi4n1*gc309, 0}, {(2*I)*Cphi4n1*gc309, 0}, {0, 0}, {0, 0}},

C[ S[2] , S[3] , S[3] , S[1] , V[1] , -V[3] , -V[3] ] == {{Cphi4n3*gc310, 0}, {-((Cphi4n1 + Cphi4n3)*gc310), 0}, {-((Cphi4n1 + Cphi4n3)*gc310), 0}, {Cphi4n3*gc310, 0}, {Cphi4n3*gc310, 0}, {-((Cphi4n1 + Cphi4n3)*gc310), 0}, {-((Cphi4n1 + Cphi4n3)*gc310), 0}, {Cphi4n3*gc310, 0}, {2*Cphi4n1*gc310, 0}, {0, 0}, {0, 0}, {2*Cphi4n1*gc310, 0}},

C[ S[3] , S[3] , V[1] , -V[3] , -V[3] ] == {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {I*gc311, 0}, {I*gc311, 0}, {0, 0}, {0, 0}, {I*gc311, 0}, {I*gc311, 0}},

C[ S[3] , S[3] , S[1] , V[1] , -V[3] , -V[3] ] == {{I*(Cphi4n1 + Cphi4n3)*gc312, 0}, {(-I)*Cphi4n3*gc312, 0}, {I*(Cphi4n1 + Cphi4n3)*gc312, 0}, {I*(Cphi4n1 + Cphi4n3)*gc312, 0}, {(-I)*Cphi4n3*gc312, 0}, {0, 0}, {0, 0}, {(-2*I)*Cphi4n1*gc312, 0}, {I*(Cphi4n1 + Cphi4n3)*gc312, 0}},

C[ S[3] , S[3] , S[1] , S[1] , V[1] , -V[3] , -V[3] ] == {{(-I)*(Cphi4n1 + Cphi4n3)*gc313, 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc313, 0}, {I*Cphi4n3*gc313, 0}, {I*Cphi4n3*gc313, 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc313, 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc313, 0}, {I*Cphi4n3*gc313, 0}, {I*Cphi4n3*gc313, 0}, {0, 0}, {0, 0}, {(2*I)*Cphi4n1*gc313, 0}, {(2*I)*Cphi4n1*gc313, 0}},

C[ S[3] , V[1] , V[3] , -V[3] , -V[3] ] == {{I*gc314, 0}, {I*gc314, 0}, {0, 0}},

C[ S[2] , S[3] , V[1] , V[3] , -V[3] , -V[3] ] == {{gc315, 0}, {gc315, 0}, {0, 0}},

C[ S[2] , S[2] , S[3] , V[1] , V[3] , -V[3] , -V[3] ] == {{I*gc316, 0}, {I*gc316, 0}, {0, 0}},

C[ S[2] , S[2] , S[2] , S[3] , V[1] , V[3] , -V[3] , -V[3] ] == {{gc317, 0}, {gc317, 0}, {0, 0}},

C[ S[3] , S[3] , -S[3] , V[1] , V[3] , -V[3] , -V[3] ] == {{I*Cphi4n3*gc318, 0}, {I*Cphi4n3*gc318, 0}, {(2*I)*Cphi4n1*gc318, 0}},

C[ S[2] , S[3] , S[3] , -S[3] , V[1] , V[3] , -V[3] , -V[3] ] == {{Cphi4n3*gc319, 0}, {Cphi4n3*gc319, 0}, {2*Cphi4n1*gc319, 0}},

C[ S[3] , S[1] , V[1] , V[3] , -V[3] , -V[3] ] == {{I*gc320, 0}, {I*gc320, 0}, {0, 0}},

C[ S[2] , S[3] , S[1] , V[1] , V[3] , -V[3] , -V[3] ] == {{gc321, 0}, {gc321, 0}, {0, 0}},

C[ S[2] , S[2] , S[3] , S[1] , V[1] , V[3] , -V[3] , -V[3] ] == {{I*gc322, 0}, {I*gc322, 0}, {0, 0}},

C[ S[3] , S[3] , -S[3] , S[1] , V[1] , V[3] , -V[3] , -V[3] ] == {{I*Cphi4n3*gc323, 0}, {I*Cphi4n3*gc323, 0}, {(2*I)*Cphi4n1*gc323, 0}},

C[ S[3] , S[1] , S[1] , V[1] , V[3] , -V[3] , -V[3] ] == {{I*gc324, 0}, {I*gc324, 0}, {0, 0}},

C[ S[2] , S[3] , S[1] , S[1] , V[1] , V[3] , -V[3] , -V[3] ] == {{gc325, 0}, {gc325, 0}, {0, 0}},

C[ S[3] , S[1] , S[1] , S[1] , V[1] , V[3] , -V[3] , -V[3] ] == {{I*gc326, 0}, {I*gc326, 0}, {0, 0}},

C[ S[2] , S[3] , V[3] , -V[3] , -V[3] ] == {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {-(Cphi4n3*gc327), 0}, {(Cphi4n1 + Cphi4n3)*gc327, 0}, {-2*Cphi4n1*gc327, 0}, {0, 0}, {-(Cphi4n3*gc327), 0}, {(Cphi4n1 + Cphi4n3)*gc327, 0}},

C[ S[2] , S[2] , S[2] , S[3] , V[3] , -V[3] , -V[3] ] == {{Cphi4n3*gc328, 0}, {Cphi4n3*gc328, 0}, {Cphi4n3*gc328, 0}, {-3*(Cphi4n1 + Cphi4n3)*gc328, 0}, {Cphi4n3*gc328, 0}, {Cphi4n3*gc328, 0}, {Cphi4n3*gc328, 0}, {-3*(Cphi4n1 + Cphi4n3)*gc328, 0}, {2*Cphi4n1*gc328, 0}, {2*Cphi4n1*gc328, 0}, {2*Cphi4n1*gc328, 0}, {0, 0}},

C[ S[2] , S[3] , S[3] , -S[3] , V[3] , -V[3] , -V[3] ] == {{-2*(Cphi4n1 + Cphi4n3)*gc329, 0}, {Cphi4n3*gc329, 0}, {Cphi4n3*gc329, 0}, {0, 0}, {-2*(Cphi4n1 + Cphi4n3)*gc329, 0}, {Cphi4n3*gc329, 0}, {Cphi4n3*gc329, 0}, {0, 0}, {0, 0}, {2*Cphi4n1*gc329, 0}, {2*Cphi4n1*gc329, 0}, {0, 0}},

C[ S[2] , S[3] , S[1] , V[3] , -V[3] , -V[3] ] == {{-((Cphi4n1 + Cphi4n3)*gc330), 0}, {0, 0}, {Cphi4n3*gc330, 0}, {-((Cphi4n1 + Cphi4n3)*gc330), 0}, {0, 0}, {2*Cphi4n1*gc330, 0}, {0, 0}, {0, 0}, {Cphi4n3*gc330, 0}},

C[ S[2] , S[3] , S[1] , S[1] , V[3] , -V[3] , -V[3] ] == {{Cphi4n3*gc331, 0}, {-((Cphi4n1 + Cphi4n3)*gc331), 0}, {0, 0}, {0, 0}, {Cphi4n3*gc331, 0}, {-((Cphi4n1 + Cphi4n3)*gc331), 0}, {0, 0}, {0, 0}, {2*Cphi4n1*gc331, 0}, {0, 0}, {0, 0}, {0, 0}},

C[ S[3] , V[3] , -V[3] , -V[3] ] == {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {I*gc332, 0}, {0, 0}, {I*gc332, 0}},

C[ S[2] , S[2] , S[3] , V[3] , -V[3] , -V[3] ] == {{0, 0}, {I*gc333, 0}, {0, 0}, {0, 0}, {I*gc333, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}},

C[ S[3] , S[3] , -S[3] , V[3] , -V[3] , -V[3] ] == {{I*Cphi4n3*gc334, 0}, {0, 0}, {I*Cphi4n3*gc334, 0}, {I*Cphi4n3*gc334, 0}, {0, 0}, {(2*I)*Cphi4n1*gc334, 0}, {(2*I)*Cphi4n1*gc334, 0}, {0, 0}, {I*Cphi4n3*gc334, 0}},

C[ S[3] , S[1] , V[3] , -V[3] , -V[3] ] == {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {(-3*I)*(Cphi4n1 + Cphi4n3)*gc335, 0}, {I*Cphi4n3*gc335, 0}, {0, 0}, {(2*I)*Cphi4n1*gc335, 0}, {(-3*I)*(Cphi4n1 + Cphi4n3)*gc335, 0}, {I*Cphi4n3*gc335, 0}},

C[ S[2] , S[2] , S[3] , S[1] , V[3] , -V[3] , -V[3] ] == {{0, 0}, {0, 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc336, 0}, {I*Cphi4n3*gc336, 0}, {0, 0}, {0, 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc336, 0}, {I*Cphi4n3*gc336, 0}, {0, 0}, {0, 0}, {0, 0}, {(2*I)*Cphi4n1*gc336, 0}},

C[ S[3] , S[3] , -S[3] , S[1] , V[3] , -V[3] , -V[3] ] == {{I*Cphi4n3*gc337, 0}, {I*Cphi4n3*gc337, 0}, {0, 0}, {(-2*I)*(Cphi4n1 + Cphi4n3)*gc337, 0}, {I*Cphi4n3*gc337, 0}, {I*Cphi4n3*gc337, 0}, {0, 0}, {(-2*I)*(Cphi4n1 + Cphi4n3)*gc337, 0}, {(2*I)*Cphi4n1*gc337, 0}, {(2*I)*Cphi4n1*gc337, 0}, {0, 0}, {0, 0}},

C[ S[3] , S[1] , S[1] , V[3] , -V[3] , -V[3] ] == {{(-I)*Cphi4n3*gc338, 0}, {(-I)*Cphi4n3*gc338, 0}, {(3*I)*(Cphi4n1 + Cphi4n3)*gc338, 0}, {(-I)*Cphi4n3*gc338, 0}, {(-I)*Cphi4n3*gc338, 0}, {0, 0}, {(-2*I)*Cphi4n1*gc338, 0}, {(-2*I)*Cphi4n1*gc338, 0}, {(3*I)*(Cphi4n1 + Cphi4n3)*gc338, 0}},

C[ S[3] , S[1] , S[1] , S[1] , V[3] , -V[3] , -V[3] ] == {{(-3*I)*(Cphi4n1 + Cphi4n3)*gc339, 0}, {I*Cphi4n3*gc339, 0}, {I*Cphi4n3*gc339, 0}, {I*Cphi4n3*gc339, 0}, {(-3*I)*(Cphi4n1 + Cphi4n3)*gc339, 0}, {I*Cphi4n3*gc339, 0}, {I*Cphi4n3*gc339, 0}, {I*Cphi4n3*gc339, 0}, {0, 0}, {(2*I)*Cphi4n1*gc339, 0}, {(2*I)*Cphi4n1*gc339, 0}, {(2*I)*Cphi4n1*gc339, 0}},

C[ V[3] , V[3] , -V[3] , -V[3] ] == {{I*gc340*(-16*Sqrt[2]*Gf^2 + 3*Sqrt[2]*Cll2x1x1x2^2*Lam^2 + 8*Gf*Lam*(Cll2x1x1x2 + (Cphi4n1 + Cphi4n3)*Lam*Wmass^2)), 0}, {I*gc340*(-16*Sqrt[2]*Gf^2 + 3*Sqrt[2]*Cll2x1x1x2^2*Lam^2 + 8*Gf*Lam*(Cll2x1x1x2 + (Cphi4n1 + Cphi4n3)*Lam*Wmass^2)), 0}, {(2*I)*gc340*(16*Sqrt[2]*Gf^2 - 8*Cll2x1x1x2*Gf*Lam - 3*Sqrt[2]*Cll2x1x1x2^2*Lam^2), 0}},

C[ S[2] , S[2] , V[3] , V[3] , -V[3] , -V[3] ] == {{(-I)*gc341*(2*Sqrt[2]*CphiW*Gf - (Cll2x1x1x2 + CphiD)*CphiW*Lam + 4*CphiW^2*Lam + Sqrt[2]*(Cphi4n1 + Cphi4n3)*Gf*Lam*Wmass^2), 0}, {(-I)*gc341*(2*Sqrt[2]*CphiW*Gf - (Cll2x1x1x2 + CphiD)*CphiW*Lam + 4*CphiW^2*Lam + Sqrt[2]*(Cphi4n1 + Cphi4n3)*Gf*Lam*Wmass^2), 0}, {(2*I)*CphiW*gc341*(2*Sqrt[2]*Gf - (Cll2x1x1x2 + CphiD - 4*CphiW)*Lam), 0}},

C[ S[3] , -S[3] , V[3] , V[3] , -V[3] , -V[3] ] == {{I*gc342*(2*Sqrt[2]*CphiW*Gf - Cll2x1x1x2*CphiW*Lam + 4*CphiW^2*Lam + Sqrt[2]*Cphi4n3*Gf*Lam*Wmass^2), 0}, {I*gc342*(2*Sqrt[2]*CphiW*Gf - Cll2x1x1x2*CphiW*Lam + 4*CphiW^2*Lam + Sqrt[2]*Cphi4n3*Gf*Lam*Wmass^2), 0}, {(2*I)*gc342*(-2*Sqrt[2]*CphiW*Gf + Cll2x1x1x2*CphiW*Lam - 4*CphiW^2*Lam + Sqrt[2]*Cphi4n1*Gf*Lam*Wmass^2), 0}},

C[ S[1] , V[3] , V[3] , -V[3] , -V[3] ] == {{(-I)*gc343*(8*CphiW*Gf - Sqrt[2]*(Cll2x1x1x2 - 4*CphiBox + CphiD)*CphiW*Lam + 8*Sqrt[2]*CphiW^2*Lam + 4*(Cphi4n1 + Cphi4n3)*Gf*Lam*Wmass^2), 0}, {(-I)*gc343*(8*CphiW*Gf - Sqrt[2]*(Cll2x1x1x2 - 4*CphiBox + CphiD)*CphiW*Lam + 8*Sqrt[2]*CphiW^2*Lam + 4*(Cphi4n1 + Cphi4n3)*Gf*Lam*Wmass^2), 0}, {(2*I)*CphiW*gc343*(8*Gf - Sqrt[2]*(Cll2x1x1x2 - 4*CphiBox + CphiD - 8*CphiW)*Lam), 0}},

C[ S[1] , S[1] , V[3] , V[3] , -V[3] , -V[3] ] == {{(-I)*gc344*(2*Sqrt[2]*CphiW*Gf - (Cll2x1x1x2 - 4*CphiBox + CphiD)*CphiW*Lam + 4*CphiW^2*Lam + 3*Sqrt[2]*(Cphi4n1 + Cphi4n3)*Gf*Lam*Wmass^2), 0}, {(-I)*gc344*(2*Sqrt[2]*CphiW*Gf - (Cll2x1x1x2 - 4*CphiBox + CphiD)*CphiW*Lam + 4*CphiW^2*Lam + 3*Sqrt[2]*(Cphi4n1 + Cphi4n3)*Gf*Lam*Wmass^2), 0}, {(2*I)*CphiW*gc344*(2*Sqrt[2]*Gf - (Cll2x1x1x2 - 4*CphiBox + CphiD - 4*CphiW)*Lam), 0}},

C[ S[2] , S[2] , S[2] , S[2] , V[3] , V[3] , -V[3] , -V[3] ] == {{I*gc345, 0}, {I*gc345, 0}, {0, 0}},

C[ S[2] , S[2] , S[3] , -S[3] , V[3] , V[3] , -V[3] , -V[3] ] == {{I*Cphi4n3*gc346, 0}, {I*Cphi4n3*gc346, 0}, {(2*I)*Cphi4n1*gc346, 0}},

C[ S[3] , S[3] , -S[3] , -S[3] , V[3] , V[3] , -V[3] , -V[3] ] == {{I*gc347, 0}, {I*gc347, 0}, {0, 0}},

C[ S[2] , S[2] , S[1] , V[3] , V[3] , -V[3] , -V[3] ] == {{I*gc348, 0}, {I*gc348, 0}, {0, 0}},

C[ S[3] , -S[3] , S[1] , V[3] , V[3] , -V[3] , -V[3] ] == {{I*Cphi4n3*gc349, 0}, {I*Cphi4n3*gc349, 0}, {(2*I)*Cphi4n1*gc349, 0}},

C[ S[2] , S[2] , S[1] , S[1] , V[3] , V[3] , -V[3] , -V[3] ] == {{I*gc350, 0}, {I*gc350, 0}, {0, 0}},

C[ S[3] , -S[3] , S[1] , S[1] , V[3] , V[3] , -V[3] , -V[3] ] == {{I*Cphi4n3*gc351, 0}, {I*Cphi4n3*gc351, 0}, {(2*I)*Cphi4n1*gc351, 0}},

C[ S[1] , S[1] , S[1] , V[3] , V[3] , -V[3] , -V[3] ] == {{I*gc352, 0}, {I*gc352, 0}, {0, 0}},

C[ S[1] , S[1] , S[1] , S[1] , V[3] , V[3] , -V[3] , -V[3] ] == {{I*gc353, 0}, {I*gc353, 0}, {0, 0}},

C[ S[2] , S[2] , S[3] , -S[3] , V[1] , V[2] ] == {{(4*I)*Sqrt[2]*Cphi4n1*gc354*Gf*Lam*(-2*Wmass^2 + Zmass^2)*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(4*I)*Sqrt[2]*Cphi4n1*gc354*Gf*Lam*(-2*Wmass^2 + Zmass^2)*(-Wmass^2 + Zmass^2)^(3/2), 0}, {0, 0}, {0, 0}, {(-2*I)*Sqrt[2]*Cphi4n1*gc354*Gf*Lam*Zmass^2*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(-2*I)*Sqrt[2]*Cphi4n1*gc354*Gf*Lam*Zmass^2*(-Wmass^2 + Zmass^2)^(3/2), 0}, {0, 0}, {0, 0}, {0, 0}, {(-2*I)*Sqrt[2]*Cphi4n1*gc354*Gf*Lam*Zmass^2*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(-2*I)*Sqrt[2]*Cphi4n1*gc354*Gf*Lam*Zmass^2*(-Wmass^2 + Zmass^2)^(3/2), 0}, {0, 0}, {(I*CphiD*gc354*(-(Wmass^2*Zmass^2) + Zmass^4)*(4*CphiWB*Lam*Wmass*(Wmass^2 - Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(4*Sqrt[2]*Gf*(-Wmass^2 + Zmass^2) + Lam*(2*Cll2x1x1x2*Wmass^2 + 2*CphiD*Wmass^2 - 2*Cll2x1x1x2*Zmass^2 - 3*CphiD*Zmass^2))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {(2*I)*Sqrt[2]*Cphi4n1*gc354*Gf*Lam*Sqrt[-Wmass^2 + Zmass^2]*(-(Wmass^2*Zmass^2) + Zmass^4), 0}, {(2*I)*Sqrt[2]*Cphi4n1*gc354*Gf*Lam*Sqrt[-Wmass^2 + Zmass^2]*(-(Wmass^2*Zmass^2) + Zmass^4), 0}, {(2*I)*Sqrt[2]*Cphi4n1*gc354*Gf*Lam*Sqrt[-Wmass^2 + Zmass^2]*(-(Wmass^2*Zmass^2) + Zmass^4), 0}, {(2*I)*Sqrt[2]*Cphi4n1*gc354*Gf*Lam*Sqrt[-Wmass^2 + Zmass^2]*(-(Wmass^2*Zmass^2) + Zmass^4), 0}, {(8*I)*Sqrt[2]*Cphi4n3*gc354*Gf*Lam*(-2*Wmass^2 + Zmass^2)*(-Wmass^2 + Zmass^2)^(3/2), 0}, {0, 0}},

C[ S[3] , S[3] , -S[3] , -S[3] , V[1] , V[2] ] == {{(-2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc355*Gf*Lam*(-2*Wmass^2 + Zmass^2)*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(-2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc355*Gf*Lam*(-2*Wmass^2 + Zmass^2)*(-Wmass^2 + Zmass^2)^(3/2), 0}, {I*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc355*Gf*Lam*(-2*Wmass^2 + Zmass^2)*(-Wmass^2 + Zmass^2)^(3/2), 0}, {I*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc355*Gf*Lam*(-2*Wmass^2 + Zmass^2)*(-Wmass^2 + Zmass^2)^(3/2), 0}, {I*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc355*Gf*Lam*(-2*Wmass^2 + Zmass^2)*(-Wmass^2 + Zmass^2)^(3/2), 0}, {I*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc355*Gf*Lam*(-2*Wmass^2 + Zmass^2)*(-Wmass^2 + Zmass^2)^(3/2), 0}, {I*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc355*Gf*Lam*(-2*Wmass^2 + Zmass^2)*(-Wmass^2 + Zmass^2)^(3/2), 0}, {I*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc355*Gf*Lam*(-2*Wmass^2 + Zmass^2)*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(-2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc355*Gf*Lam*(-2*Wmass^2 + Zmass^2)*(-Wmass^2 + Zmass^2)^(3/2), 0}, {I*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc355*Gf*Lam*(-2*Wmass^2 + Zmass^2)*(-Wmass^2 + Zmass^2)^(3/2), 0}, {I*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc355*Gf*Lam*(-2*Wmass^2 + Zmass^2)*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(-2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc355*Gf*Lam*(-2*Wmass^2 + Zmass^2)*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(I*CphiD*gc355*(-(Wmass^2*Zmass^2) + Zmass^4)*(-4*CphiWB*Lam*Wmass*(4*Wmass^4 - 7*Wmass^2*Zmass^2 + 3*Zmass^4) + Sqrt[-Wmass^2 + Zmass^2]*(4*Sqrt[2]*Gf*(2*Wmass^4 - 3*Wmass^2*Zmass^2 + Zmass^4) - Lam*(2*Cll2x1x1x2*(2*Wmass^4 - 3*Wmass^2*Zmass^2 + Zmass^4) + CphiD*(-4*Wmass^4 + 2*Wmass^2*Zmass^2 + Zmass^4)))))/((Wmass - Zmass)*Zmass^2*(Wmass + Zmass)), 0}, {(2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc355*Gf*Lam*(-2*Wmass^2 + Zmass^2)*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc355*Gf*Lam*(-2*Wmass^2 + Zmass^2)*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc355*Gf*Lam*(-2*Wmass^2 + Zmass^2)*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc355*Gf*Lam*(-2*Wmass^2 + Zmass^2)*(-Wmass^2 + Zmass^2)^(3/2), 0}, {0, 0}, {0, 0}},

C[ S[3] , -S[3] , S[1] , V[1] , V[2] ] == {{0, 0}, {(4*I)*Cphi4n1*gc356*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {0, 0}, {0, 0}, {(I*Sqrt[2]*CphiD*gc356*(Wmass^2 - Zmass^2)*(4*CphiWB*Lam*Wmass*(Wmass^2 - Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(4*Sqrt[2]*Gf*(-Wmass^2 + Zmass^2) + Lam*(-4*CphiBox*Wmass^2 + CphiD*Wmass^2 + 4*CphiBox*Zmass^2 - 2*CphiD*Zmass^2 + Cll2x1x1x2*(Wmass^2 - Zmass^2)))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {0, 0}, {(-4*I)*Cphi4n1*gc356*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {0, 0}, {(-4*I)*Cphi4n1*gc356*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(4*I)*Cphi4n1*gc356*Gf*Lam*(-Wmass^2 + Zmass^2)^(3/2), 0}},

C[ S[3] , -S[3] , S[1] , S[1] , V[1] , V[2] ] == {{0, 0}, {0, 0}, {(-2*I)*Sqrt[2]*Cphi4n1*gc357*Gf*Lam*Zmass^2*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(-2*I)*Sqrt[2]*Cphi4n1*gc357*Gf*Lam*Zmass^2*(-Wmass^2 + Zmass^2)^(3/2), 0}, {0, 0}, {0, 0}, {(-2*I)*Sqrt[2]*Cphi4n1*gc357*Gf*Lam*Zmass^2*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(-2*I)*Sqrt[2]*Cphi4n1*gc357*Gf*Lam*Zmass^2*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(4*I)*Sqrt[2]*Cphi4n1*gc357*Gf*Lam*(-2*Wmass^2 + Zmass^2)*(-Wmass^2 + Zmass^2)^(3/2), 0}, {0, 0}, {0, 0}, {(4*I)*Sqrt[2]*Cphi4n1*gc357*Gf*Lam*(-2*Wmass^2 + Zmass^2)*(-Wmass^2 + Zmass^2)^(3/2), 0}, {(I*CphiD*gc357*(-(Wmass^2*Zmass^2) + Zmass^4)*(4*CphiWB*Lam*Wmass*(Wmass^2 - Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(4*Sqrt[2]*Gf*(-Wmass^2 + Zmass^2) + Lam*(-8*CphiBox*Wmass^2 + 2*CphiD*Wmass^2 + 8*CphiBox*Zmass^2 - 3*CphiD*Zmass^2 + 2*Cll2x1x1x2*(Wmass^2 - Zmass^2)))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {(2*I)*Sqrt[2]*Cphi4n1*gc357*Gf*Lam*Sqrt[-Wmass^2 + Zmass^2]*(-(Wmass^2*Zmass^2) + Zmass^4), 0}, {(2*I)*Sqrt[2]*Cphi4n1*gc357*Gf*Lam*Sqrt[-Wmass^2 + Zmass^2]*(-(Wmass^2*Zmass^2) + Zmass^4), 0}, {(2*I)*Sqrt[2]*Cphi4n1*gc357*Gf*Lam*Sqrt[-Wmass^2 + Zmass^2]*(-(Wmass^2*Zmass^2) + Zmass^4), 0}, {(2*I)*Sqrt[2]*Cphi4n1*gc357*Gf*Lam*Sqrt[-Wmass^2 + Zmass^2]*(-(Wmass^2*Zmass^2) + Zmass^4), 0}, {0, 0}, {(8*I)*Sqrt[2]*Cphi4n3*gc357*Gf*Lam*(-2*Wmass^2 + Zmass^2)*(-Wmass^2 + Zmass^2)^(3/2), 0}},

C[ S[3] , S[3] , -S[3] , -S[3] , V[1] , V[1] , V[1] , V[2] ] == {{I*gc358, 0}, {I*gc358, 0}, {I*gc358, 0}},

C[ S[2] , S[3] , -S[3] , V[2] ] == {{CphiD*gc359*(Gf*(8*Wmass^2 - 4*Zmass^2) + Sqrt[2]*Lam*(CphiD*Zmass^2 + 4*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2])), 0}, {0, 0}, {4*Cphi4n1*gc359*Gf*Lam*Zmass^2, 0}, {4*Cphi4n1*gc359*Gf*Lam*Zmass^2, 0}, {8*Cphi4n3*gc359*Gf*Lam*Zmass^2, 0}, {0, 0}},

C[ S[2] , S[3] , -S[3] , S[1] , V[2] ] == {{-(CphiD*gc360*(8*Gf*(2*Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(8*CphiBox*Wmass^2 - 2*CphiD*Wmass^2 - 4*CphiBox*Zmass^2 + 3*CphiD*Zmass^2 + Cll2x1x1x2*(-2*Wmass^2 + Zmass^2) + 8*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2]))), 0}, {-(CphiD*gc360*(8*Gf*(-2*Wmass^2 + Zmass^2) + Sqrt[2]*Lam*(2*Cll2x1x1x2*Wmass^2 - 8*CphiBox*Wmass^2 + 2*CphiD*Wmass^2 - Cll2x1x1x2*Zmass^2 + 4*CphiBox*Zmass^2 - 3*CphiD*Zmass^2 - 8*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2]))), 0}, {8*Cphi4n1*gc360*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}, {8*Cphi4n1*gc360*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}, {-8*Cphi4n1*gc360*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}, {-8*Cphi4n1*gc360*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}, {0, 0}, {0, 0}, {-8*Cphi4n1*gc360*Gf*Lam*Zmass^2, 0}, {0, 0}, {0, 0}, {-16*Cphi4n3*gc360*Gf*Lam*Zmass^2, 0}, {16*Cphi4n3*gc360*Gf*Lam*Zmass^2, 0}, {8*Cphi4n1*gc360*Gf*Lam*Zmass^2, 0}, {-8*Cphi4n1*gc360*Gf*Lam*Zmass^2, 0}, {8*Cphi4n1*gc360*Gf*Lam*Zmass^2, 0}},

C[ S[2] , S[1] , V[2] ] == {{-(gc361*(64*Gf^2 - 8*Sqrt[2]*(Cll2x1x1x2 - 4*CphiBox - 3*CphiD)*Gf*Lam + (-7*Cll2x1x1x2^2 + 8*Cll2x1x1x2*CphiBox + 48*CphiBox^2 + 6*Cll2x1x1x2*CphiD + 8*CphiBox*CphiD - 21*CphiD^2)*Lam^2)), 0}, {gc361*(64*Gf^2 - 8*Sqrt[2]*(Cll2x1x1x2 - 4*CphiBox + CphiD)*Gf*Lam + (-7*Cll2x1x1x2^2 + Cll2x1x1x2*(8*CphiBox - 2*CphiD) + 3*(-4*CphiBox + CphiD)^2)*Lam^2), 0}},

C[ S[2] , S[2] , S[2] , V[2] ] == {{CphiD*gc362*(-2*Gf + Sqrt[2]*CphiD*Lam), 0}, {CphiD*gc362*(-2*Gf + Sqrt[2]*CphiD*Lam), 0}, {4*(Cphi4n1 + Cphi4n3)*gc362*Gf*Lam, 0}, {4*(Cphi4n1 + Cphi4n3)*gc362*Gf*Lam, 0}, {4*(Cphi4n1 + Cphi4n3)*gc362*Gf*Lam, 0}, {CphiD*gc362*(-2*Gf + Sqrt[2]*CphiD*Lam), 0}},

C[ S[2] , S[2] , S[2] , S[1] , V[2] ] == {{CphiD*gc363*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 - 4*CphiBox + 5*CphiD)*Lam), 0}, {-3*CphiD*gc363*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 - 4*CphiBox + 5*CphiD)*Lam), 0}, {-16*(Cphi4n1 + Cphi4n3)*gc363*Gf*Lam, 0}, {-16*(Cphi4n1 + Cphi4n3)*gc363*Gf*Lam, 0}, {0, 0}, {0, 0}, {CphiD*gc363*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 - 4*CphiBox + 5*CphiD)*Lam), 0}, {CphiD*gc363*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 - 4*CphiBox + 5*CphiD)*Lam), 0}, {16*(Cphi4n1 + Cphi4n3)*gc363*Gf*Lam, 0}, {0, 0}, {0, 0}, {16*(Cphi4n1 + Cphi4n3)*gc363*Gf*Lam, 0}, {-16*(Cphi4n1 + Cphi4n3)*gc363*Gf*Lam, 0}, {0, 0}, {16*(Cphi4n1 + Cphi4n3)*gc363*Gf*Lam, 0}, {0, 0}},

C[ S[2] , S[1] , S[1] , V[2] ] == {{-3*CphiD*gc364*(-2*Gf + Sqrt[2]*(-2*CphiBox + CphiD)*Lam), 0}, {CphiD*gc364*(-2*Gf + Sqrt[2]*(-2*CphiBox + CphiD)*Lam), 0}, {0, 0}, {0, 0}, {-4*(Cphi4n1 + Cphi4n3)*gc364*Gf*Lam, 0}, {CphiD*gc364*(-2*Gf + Sqrt[2]*(-2*CphiBox + CphiD)*Lam), 0}},

C[ S[2] , S[1] , S[1] , S[1] , V[2] ] == {{-3*CphiD*gc365*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 - 12*CphiBox + 5*CphiD)*Lam), 0}, {CphiD*gc365*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 - 12*CphiBox + 5*CphiD)*Lam), 0}, {0, 0}, {0, 0}, {-16*(Cphi4n1 + Cphi4n3)*gc365*Gf*Lam, 0}, {-16*(Cphi4n1 + Cphi4n3)*gc365*Gf*Lam, 0}, {CphiD*gc365*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 - 12*CphiBox + 5*CphiD)*Lam), 0}, {CphiD*gc365*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 - 12*CphiBox + 5*CphiD)*Lam), 0}, {0, 0}, {0, 0}, {0, 0}, {-16*(Cphi4n1 + Cphi4n3)*gc365*Gf*Lam, 0}, {16*(Cphi4n1 + Cphi4n3)*gc365*Gf*Lam, 0}, {16*(Cphi4n1 + Cphi4n3)*gc365*Gf*Lam, 0}, {0, 0}, {16*(Cphi4n1 + Cphi4n3)*gc365*Gf*Lam, 0}},

C[ S[2] , S[3] , -S[3] , V[1] , V[1] , V[2] ] == {{0, 0}, {0, 0}, {Cphi4n1*gc366, 0}, {0, 0}, {0, 0}, {Cphi4n1*gc366, 0}, {0, 0}, {0, 0}, {2*Cphi4n3*gc366, 0}},

C[ S[2] , S[3] , -S[3] , S[1] , V[1] , V[1] , V[2] ] == {{-2*Cphi4n3*gc367, 0}, {0, 0}, {0, 0}, {2*Cphi4n3*gc367, 0}, {-(Cphi4n1*gc367), 0}, {0, 0}, {0, 0}, {Cphi4n1*gc367, 0}, {-(Cphi4n1*gc367), 0}, {0, 0}, {0, 0}, {Cphi4n1*gc367, 0}},

C[ -U[32] , U[32] , V[2] ] == {{I*gc368, 0}, {0, 0}},

C[ -U[31] , U[31] , V[2] ] == {{I*gc369, 0}, {0, 0}},

C[ S[3] , -S[3] , V[2] ] == {{(-I)*gc370, 0}, {I*gc370, 0}},

C[ S[3] , S[3] , -S[3] , -S[3] , V[2] ] == {{(-I)*CphiD*gc371*(8*Gf*(2*Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(2*CphiD*Wmass^2 + CphiD*Zmass^2 + Cll2x1x1x2*(-2*Wmass^2 + Zmass^2) + 8*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2])), 0}, {I*CphiD*gc371*(8*Gf*(2*Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(2*CphiD*Wmass^2 + CphiD*Zmass^2 + Cll2x1x1x2*(-2*Wmass^2 + Zmass^2) + 8*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2])), 0}, {0, 0}, {(8*I)*(Cphi4n1 + Cphi4n3)*gc371*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}, {(-8*I)*(Cphi4n1 + Cphi4n3)*gc371*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}, {0, 0}, {(-I)*CphiD*gc371*(8*Gf*(2*Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(2*CphiD*Wmass^2 + CphiD*Zmass^2 + Cll2x1x1x2*(-2*Wmass^2 + Zmass^2) + 8*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2])), 0}, {I*CphiD*gc371*(8*Gf*(2*Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(2*CphiD*Wmass^2 + CphiD*Zmass^2 + Cll2x1x1x2*(-2*Wmass^2 + Zmass^2) + 8*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2])), 0}, {(-8*I)*(Cphi4n1 + Cphi4n3)*gc371*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}, {(-8*I)*(Cphi4n1 + Cphi4n3)*gc371*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}, {(8*I)*(Cphi4n1 + Cphi4n3)*gc371*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}, {(-8*I)*(Cphi4n1 + Cphi4n3)*gc371*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}, {(8*I)*(Cphi4n1 + Cphi4n3)*gc371*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}, {(8*I)*(Cphi4n1 + Cphi4n3)*gc371*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}, {0, 0}, {0, 0}},

C[ S[2] , S[2] , S[3] , -S[3] , V[2] ] == {{0, 0}, {I*CphiD*gc372*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 + 3*CphiD)*Lam)*Zmass^2, 0}, {(16*I)*Cphi4n3*gc372*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}, {(8*I)*Cphi4n1*gc372*Gf*Lam*Zmass^2, 0}, {(8*I)*Cphi4n1*gc372*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}, {0, 0}, {0, 0}, {(-I)*CphiD*gc372*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 + 3*CphiD)*Lam)*Zmass^2, 0}, {(-8*I)*Cphi4n1*gc372*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}, {(8*I)*Cphi4n1*gc372*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}, {(-8*I)*Cphi4n1*gc372*Gf*Lam*Zmass^2, 0}, {(-8*I)*Cphi4n1*gc372*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}, {(8*I)*Cphi4n1*gc372*Gf*Lam*Zmass^2, 0}, {(-8*I)*Cphi4n1*gc372*Gf*Lam*Zmass^2, 0}, {(-16*I)*Cphi4n3*gc372*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}, {0, 0}},

C[ S[3] , -S[3] , S[1] , V[2] ] == {{(-I)*CphiD*gc373*(4*Gf + Sqrt[2]*(2*CphiBox - CphiD)*Lam), 0}, {(-I)*CphiD*gc373*(-4*Gf + Sqrt[2]*(-2*CphiBox + CphiD)*Lam), 0}, {0, 0}, {(-4*I)*Cphi4n1*gc373*Gf*Lam, 0}, {(4*I)*Cphi4n1*gc373*Gf*Lam, 0}, {0, 0}},

C[ S[3] , -S[3] , S[1] , S[1] , V[2] ] == {{I*CphiD*gc374*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 - 8*CphiBox + 3*CphiD)*Lam)*Zmass^2, 0}, {0, 0}, {0, 0}, {(8*I)*Cphi4n1*gc374*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}, {(8*I)*Cphi4n1*gc374*Gf*Lam*Zmass^2, 0}, {(16*I)*Cphi4n3*gc374*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}, {(-I)*CphiD*gc374*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 - 8*CphiBox + 3*CphiD)*Lam)*Zmass^2, 0}, {0, 0}, {(-8*I)*Cphi4n1*gc374*Gf*Lam*Zmass^2, 0}, {(-8*I)*Cphi4n1*gc374*Gf*Lam*Zmass^2, 0}, {(8*I)*Cphi4n1*gc374*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}, {(8*I)*Cphi4n1*gc374*Gf*Lam*Zmass^2, 0}, {(-8*I)*Cphi4n1*gc374*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}, {(-8*I)*Cphi4n1*gc374*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}, {0, 0}, {(-16*I)*Cphi4n3*gc374*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}},

C[ S[3] , S[3] , -S[3] , -S[3] , V[1] , V[1] , V[2] ] == {{(-I)*gc375, 0}, {(-I)*gc375, 0}, {I*gc375, 0}, {I*gc375, 0}, {(-I)*gc375, 0}, {(-I)*gc375, 0}, {I*gc375, 0}, {I*gc375, 0}, {(-I)*gc375, 0}, {(-I)*gc375, 0}, {I*gc375, 0}, {I*gc375, 0}},

C[ S[2] , S[3] , -S[3] , V[1] , V[2] ] == {{-(Cphi4n1*gc376), 0}, {0, 0}, {Cphi4n1*gc376, 0}, {0, 0}, {0, 0}, {-(Cphi4n1*gc376), 0}, {Cphi4n1*gc376, 0}, {-2*Cphi4n3*gc376, 0}, {0, 0}, {2*Cphi4n3*gc376, 0}},

C[ S[2] , S[3] , -S[3] , S[1] , V[1] , V[2] ] == {{2*Cphi4n3*gc377, 0}, {Cphi4n1*gc377, 0}, {-2*Cphi4n3*gc377, 0}, {0, 0}, {-(Cphi4n1*gc377), 0}, {0, 0}, {0, 0}, {-(Cphi4n1*gc377), 0}, {Cphi4n1*gc377, 0}, {0, 0}, {-2*Cphi4n3*gc377, 0}, {2*Cphi4n3*gc377, 0}, {0, 0}, {-(Cphi4n1*gc377), 0}, {0, 0}, {0, 0}, {-(Cphi4n1*gc377), 0}, {Cphi4n1*gc377, 0}, {Cphi4n1*gc377, 0}},

C[ S[3] , -S[3] , -S[3] , V[3] , V[2] ] == {{(-4*I)*Cphi4n1*gc378*Gf*Lam*Zmass^2, 0}, {(-4*I)*(Cphi4n1 + Cphi4n3)*gc378*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {(-4*I)*Cphi4n1*gc378*Gf*Lam*Zmass^2, 0}, {(-4*I)*(Cphi4n1 + Cphi4n3)*gc378*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {(-I)*CphiD*gc378*(8*Gf*(2*Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(2*CphiD*Wmass^2 + CphiD*Zmass^2 + Cll2x1x1x2*(-2*Wmass^2 + Zmass^2) + 8*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2])), 0}, {(4*I)*gc378*Gf*Lam*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(4*I)*gc378*Gf*Lam*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(4*I)*(Cphi4n1 + Cphi4n3)*gc378*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {0, 0}, {(4*I)*(Cphi4n1 + Cphi4n3)*gc378*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}},

C[ S[2] , S[3] , -S[3] , -S[3] , V[3] , V[2] ] == {{2*Sqrt[2]*Cphi4n1*gc379*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}, {2*Sqrt[2]*Cphi4n3*gc379*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}, {0, 0}, {Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc379*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {Sqrt[2]*Cphi4n3*gc379*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {-(Sqrt[2]*Cphi4n1*gc379*Gf*Lam*Zmass^2), 0}, {0, 0}, {Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc379*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {-(Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc379*Gf*Lam*(2*Wmass^2 - Zmass^2)), 0}, {Sqrt[2]*Cphi4n3*gc379*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {-(Sqrt[2]*Cphi4n1*gc379*Gf*Lam*Zmass^2), 0}, {-(Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc379*Gf*Lam*(2*Wmass^2 - Zmass^2)), 0}, {-(CphiD*gc379*(2*Sqrt[2]*Gf*(2*Wmass^2 - Zmass^2) + Lam*(CphiD*Zmass^2 + Cll2x1x1x2*(-2*Wmass^2 + Zmass^2) + 4*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2]))), 0}, {Sqrt[2]*Cphi4n1*gc379*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {Sqrt[2]*Cphi4n1*gc379*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {Sqrt[2]*gc379*Gf*Lam*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {Sqrt[2]*gc379*Gf*Lam*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {0, 0}, {0, 0}},

C[ S[3] , -S[3] , -S[3] , S[1] , V[3] , V[2] ] == {{I*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc380*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {(-I)*Sqrt[2]*Cphi4n1*gc380*Gf*Lam*Zmass^2, 0}, {I*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc380*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {(-I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc380*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {(-I)*Sqrt[2]*Cphi4n1*gc380*Gf*Lam*Zmass^2, 0}, {(-I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc380*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {(-2*I)*Sqrt[2]*Cphi4n3*gc380*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {I*Sqrt[2]*Cphi4n3*gc380*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {I*Sqrt[2]*Cphi4n3*gc380*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {(-2*I)*Sqrt[2]*Cphi4n1*gc380*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {0, 0}, {0, 0}, {(-I)*CphiD*gc380*(2*Sqrt[2]*Gf*(2*Wmass^2 - Zmass^2) + Lam*(4*CphiBox*Wmass^2 - 2*CphiBox*Zmass^2 + CphiD*Zmass^2 + Cll2x1x1x2*(-2*Wmass^2 + Zmass^2) + 4*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2])), 0}, {I*Sqrt[2]*gc380*Gf*Lam*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {0, 0}, {0, 0}, {I*Sqrt[2]*Cphi4n1*gc380*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {I*Sqrt[2]*gc380*Gf*Lam*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {I*Sqrt[2]*Cphi4n1*gc380*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}},

C[ S[2] , S[2] , -S[3] , V[3] , V[2] ] == {{(4*I)*gc381*Gf*Lam*(2*Cphi4n1*Wmass^2 - 3*Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(8*I)*Cphi4n3*gc381*Gf*Lam*Zmass^2, 0}, {(8*I)*Cphi4n1*gc381*Gf*Lam*Zmass^2, 0}, {(8*I)*Cphi4n1*gc381*Gf*Lam*Zmass^2, 0}, {(-I)*CphiD*gc381*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 + 3*CphiD)*Lam)*Zmass^2, 0}, {(-8*I)*gc381*Gf*Lam*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {0, 0}, {(4*I)*gc381*Gf*Lam*(2*Cphi4n1*Wmass^2 - 3*Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {0, 0}, {(8*I)*Cphi4n3*gc381*Gf*Lam*Zmass^2, 0}},

C[ S[2] , S[2] , S[2] , -S[3] , V[3] , V[2] ] == {{-(Sqrt[2]*Cphi4n1*gc382*Gf*Lam*(2*Wmass^2 - Zmass^2)), 0}, {-(Sqrt[2]*Cphi4n1*gc382*Gf*Lam*(2*Wmass^2 - Zmass^2)), 0}, {-(Sqrt[2]*Cphi4n1*gc382*Gf*Lam*(2*Wmass^2 - Zmass^2)), 0}, {-(Sqrt[2]*Cphi4n1*gc382*Gf*Lam*(2*Wmass^2 - Zmass^2)), 0}, {-(Sqrt[2]*Cphi4n1*gc382*Gf*Lam*(2*Wmass^2 - Zmass^2)), 0}, {-(Sqrt[2]*Cphi4n1*gc382*Gf*Lam*(2*Wmass^2 - Zmass^2)), 0}, {0, 0}, {0, 0}, {0, 0}, {-2*Sqrt[2]*Cphi4n1*gc382*Gf*Lam*Zmass^2, 0}, {-2*Sqrt[2]*Cphi4n1*gc382*Gf*Lam*Zmass^2, 0}, {-2*Sqrt[2]*Cphi4n1*gc382*Gf*Lam*Zmass^2, 0}, {3*CphiD*gc382*(-2*Sqrt[2]*Gf + (Cll2x1x1x2 + 2*CphiD)*Lam)*Zmass^2, 0}, {2*Sqrt[2]*gc382*Gf*Lam*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {2*Sqrt[2]*Cphi4n1*gc382*Gf*Lam*Zmass^2, 0}, {2*Sqrt[2]*gc382*Gf*Lam*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {2*Sqrt[2]*Cphi4n1*gc382*Gf*Lam*Zmass^2, 0}, {2*Sqrt[2]*gc382*Gf*Lam*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {2*Sqrt[2]*Cphi4n1*gc382*Gf*Lam*Zmass^2, 0}},

C[ S[2] , -S[3] , S[1] , V[3] , V[2] ] == {{-8*Cphi4n1*gc383*Gf*Lam*Zmass^2, 0}, {8*Cphi4n1*gc383*Gf*Lam*Zmass^2, 0}, {-4*Cphi4n1*gc383*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {8*Cphi4n3*gc383*Gf*Lam*Zmass^2, 0}, {-(CphiD*gc383*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 - 4*CphiBox + 3*CphiD)*Lam)*Zmass^2), 0}, {-8*Cphi4n1*gc383*Gf*Lam*Zmass^2, 0}, {0, 0}, {-16*Cphi4n3*gc383*Gf*Lam*Zmass^2, 0}, {0, 0}, {4*gc383*Gf*Lam*(2*Cphi4n3*Zmass^2 + Cphi4n1*(2*Wmass^2 + Zmass^2)), 0}},

C[ S[2] , S[2] , -S[3] , S[1] , V[3] , V[2] ] == {{(-I)*Sqrt[2]*gc384*Gf*Lam*(2*Cphi4n1*Wmass^2 - 3*Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*Sqrt[2]*gc384*Gf*Lam*(2*Cphi4n1*Wmass^2 - 3*Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-2*I)*Sqrt[2]*Cphi4n3*gc384*Gf*Lam*Zmass^2, 0}, {(-2*I)*Sqrt[2]*Cphi4n3*gc384*Gf*Lam*Zmass^2, 0}, {(-2*I)*Sqrt[2]*Cphi4n1*gc384*Gf*Lam*Zmass^2, 0}, {(-2*I)*Sqrt[2]*Cphi4n1*gc384*Gf*Lam*Zmass^2, 0}, {I*Sqrt[2]*Cphi4n1*gc384*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {I*Sqrt[2]*Cphi4n1*gc384*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {(2*I)*Sqrt[2]*Cphi4n1*gc384*Gf*Lam*Zmass^2, 0}, {(-I)*Sqrt[2]*gc384*Gf*Lam*(2*Cphi4n3*Zmass^2 + Cphi4n1*(2*Wmass^2 + Zmass^2)), 0}, {(-I)*Sqrt[2]*gc384*Gf*Lam*(2*Cphi4n3*Zmass^2 + Cphi4n1*(2*Wmass^2 + Zmass^2)), 0}, {(4*I)*Sqrt[2]*Cphi4n3*gc384*Gf*Lam*Zmass^2, 0}, {I*CphiD*gc384*(-2*Sqrt[2]*Gf + (Cll2x1x1x2 - 2*CphiBox + 2*CphiD)*Lam)*Zmass^2, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {(2*I)*Sqrt[2]*gc384*Gf*Lam*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {(2*I)*Sqrt[2]*Cphi4n1*gc384*Gf*Lam*Zmass^2, 0}},

C[ -S[3] , S[1] , S[1] , V[3] , V[2] ] == {{0, 0}, {(4*I)*Cphi4n1*gc385*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {0, 0}, {(4*I)*Cphi4n1*gc385*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {(-3*I)*CphiD*gc385*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 - 8*CphiBox + 3*CphiD)*Lam)*Zmass^2, 0}, {(-8*I)*Cphi4n1*gc385*Gf*Lam*Zmass^2, 0}, {(-8*I)*Cphi4n1*gc385*Gf*Lam*Zmass^2, 0}, {(8*I)*Cphi4n1*gc385*Gf*Lam*Zmass^2, 0}, {(-8*I)*gc385*Gf*Lam*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {(8*I)*Cphi4n1*gc385*Gf*Lam*Zmass^2, 0}},

C[ S[2] , -S[3] , S[1] , S[1] , V[3] , V[2] ] == {{-4*Sqrt[2]*Cphi4n3*gc386*Gf*Lam*Zmass^2, 0}, {-2*Sqrt[2]*Cphi4n1*gc386*Gf*Lam*Zmass^2, 0}, {Sqrt[2]*gc386*Gf*Lam*(2*Cphi4n3*Zmass^2 + Cphi4n1*(2*Wmass^2 + Zmass^2)), 0}, {2*Sqrt[2]*Cphi4n1*gc386*Gf*Lam*Zmass^2, 0}, {-(Sqrt[2]*Cphi4n1*gc386*Gf*Lam*(2*Wmass^2 - Zmass^2)), 0}, {2*Sqrt[2]*Cphi4n3*gc386*Gf*Lam*Zmass^2, 0}, {Sqrt[2]*gc386*Gf*Lam*(2*Cphi4n3*Zmass^2 + Cphi4n1*(2*Wmass^2 + Zmass^2)), 0}, {2*Sqrt[2]*Cphi4n1*gc386*Gf*Lam*Zmass^2, 0}, {Sqrt[2]*gc386*Gf*Lam*(2*Cphi4n1*Wmass^2 - 3*Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {-(Sqrt[2]*Cphi4n1*gc386*Gf*Lam*(2*Wmass^2 - Zmass^2)), 0}, {2*Sqrt[2]*Cphi4n3*gc386*Gf*Lam*Zmass^2, 0}, {Sqrt[2]*gc386*Gf*Lam*(2*Cphi4n1*Wmass^2 - 3*Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {CphiD*gc386*(2*Sqrt[2]*Gf - (Cll2x1x1x2 - 4*CphiBox + 2*CphiD)*Lam)*Zmass^2, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {-2*Sqrt[2]*Cphi4n1*gc386*Gf*Lam*Zmass^2, 0}, {-2*Sqrt[2]*gc386*Gf*Lam*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}},

C[ -S[3] , S[1] , S[1] , S[1] , V[3] , V[2] ] == {{(2*I)*Sqrt[2]*Cphi4n1*gc387*Gf*Lam*Zmass^2, 0}, {0, 0}, {(2*I)*Sqrt[2]*Cphi4n1*gc387*Gf*Lam*Zmass^2, 0}, {I*Sqrt[2]*Cphi4n1*gc387*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {0, 0}, {I*Sqrt[2]*Cphi4n1*gc387*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {(2*I)*Sqrt[2]*Cphi4n1*gc387*Gf*Lam*Zmass^2, 0}, {I*Sqrt[2]*Cphi4n1*gc387*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {I*Sqrt[2]*Cphi4n1*gc387*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {0, 0}, {I*Sqrt[2]*Cphi4n1*gc387*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {I*Sqrt[2]*Cphi4n1*gc387*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {(-3*I)*CphiD*gc387*(-2*Sqrt[2]*Gf + (Cll2x1x1x2 - 6*CphiBox + 2*CphiD)*Lam)*Zmass^2, 0}, {(-2*I)*Sqrt[2]*Cphi4n1*gc387*Gf*Lam*Zmass^2, 0}, {(-2*I)*Sqrt[2]*Cphi4n1*gc387*Gf*Lam*Zmass^2, 0}, {(-2*I)*Sqrt[2]*gc387*Gf*Lam*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {(-2*I)*Sqrt[2]*gc387*Gf*Lam*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {(-2*I)*Sqrt[2]*Cphi4n1*gc387*Gf*Lam*Zmass^2, 0}, {(-2*I)*Sqrt[2]*gc387*Gf*Lam*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}},

C[ S[3] , -S[3] , -S[3] , V[1] , V[1] , V[3] , V[2] ] == {{I*gc388*(4*Cphi4n1*Wmass^2 + 4*Cphi4n3*Wmass^2 - 3*Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {I*gc388*(4*Cphi4n1*Wmass^2 + 4*Cphi4n3*Wmass^2 - 3*Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(2*I)*gc388*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}},

C[ S[2] , S[3] , -S[3] , -S[3] , V[1] , V[1] , V[3] , V[2] ] == {{gc389*(4*Cphi4n1*Wmass^2 + 4*Cphi4n3*Wmass^2 - 3*Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {gc389*(4*Cphi4n1*Wmass^2 + 4*Cphi4n3*Wmass^2 - 3*Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {2*gc389*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}},

C[ S[3] , -S[3] , -S[3] , S[1] , V[1] , V[1] , V[3] , V[2] ] == {{I*gc390*(4*Cphi4n1*Wmass^2 + 4*Cphi4n3*Wmass^2 - 3*Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {I*gc390*(4*Cphi4n1*Wmass^2 + 4*Cphi4n3*Wmass^2 - 3*Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(2*I)*gc390*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}},

C[ S[2] , S[2] , -S[3] , V[1] , V[3] , V[2] ] == {{I*Cphi4n3*gc391, 0}, {0, 0}, {I*Cphi4n1*gc391, 0}, {I*Cphi4n1*gc391, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {I*Cphi4n3*gc391, 0}},

C[ S[2] , S[2] , S[2] , -S[3] , V[1] , V[3] , V[2] ] == {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {-gc392, 0}, {-gc392, 0}, {-gc392, 0}, {0, 0}, {gc392, 0}, {gc392, 0}, {gc392, 0}, {0, 0}},

C[ S[2] , S[3] , -S[3] , -S[3] , V[1] , V[3] , V[2] ] == {{2*Cphi4n1*gc393*(2*Wmass^2 - Zmass^2), 0}, {2*(Cphi4n1 + Cphi4n3)*gc393*(2*Wmass^2 - Zmass^2), 0}, {gc393*(-2*Cphi4n1*Wmass^2 - 2*Cphi4n3*Wmass^2 + 2*Cphi4n1*Zmass^2 + Cphi4n3*Zmass^2), 0}, {gc393*(-2*Cphi4n1*Wmass^2 - 2*Cphi4n3*Wmass^2 + 2*Cphi4n1*Zmass^2 + Cphi4n3*Zmass^2), 0}, {4*Cphi4n3*gc393*(2*Wmass^2 - Zmass^2), 0}, {-2*Cphi4n1*gc393*Zmass^2, 0}, {-2*(Cphi4n1 + Cphi4n3)*gc393*(2*Wmass^2 - Zmass^2), 0}, {-2*(Cphi4n1 + Cphi4n3)*gc393*(2*Wmass^2 - Zmass^2), 0}, {2*Cphi4n1*gc393*(2*Wmass^2 - Zmass^2), 0}, {2*gc393*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {gc393*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)), 0}, {gc393*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)), 0}},

C[ S[2] , -S[3] , S[1] , V[1] , V[3] , V[2] ] == {{0, 0}, {-(Cphi4n3*gc394), 0}, {Cphi4n1*gc394, 0}, {0, 0}, {-(Cphi4n1*gc394), 0}, {Cphi4n1*gc394, 0}, {0, 0}, {0, 0}, {2*Cphi4n3*gc394, 0}},

C[ S[2] , S[2] , -S[3] , S[1] , V[1] , V[3] , V[2] ] == {{(-I)*Cphi4n3*gc395, 0}, {(-I)*Cphi4n3*gc395, 0}, {0, 0}, {(2*I)*Cphi4n3*gc395, 0}, {(-I)*Cphi4n1*gc395, 0}, {(-I)*Cphi4n1*gc395, 0}, {0, 0}, {I*Cphi4n1*gc395, 0}, {0, 0}, {0, 0}, {0, 0}, {I*Cphi4n1*gc395, 0}},

C[ S[2] , -S[3] , S[1] , S[1] , V[1] , V[3] , V[2] ] == {{2*Cphi4n3*gc396, 0}, {0, 0}, {-(Cphi4n3*gc396), 0}, {-(Cphi4n3*gc396), 0}, {Cphi4n1*gc396, 0}, {0, 0}, {-(Cphi4n1*gc396), 0}, {-(Cphi4n1*gc396), 0}, {Cphi4n1*gc396, 0}, {0, 0}, {0, 0}, {0, 0}},

C[ S[3] , -S[3] , -S[3] , V[1] , V[3] , V[2] ] == {{(-I)*gc397*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - 2*Cphi4n1*Zmass^2 - Cphi4n3*Zmass^2), 0}, {(-I)*gc397*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - 2*Cphi4n1*Zmass^2 - Cphi4n3*Zmass^2), 0}, {(-2*I)*Cphi4n1*gc397*Zmass^2, 0}, {(-2*I)*(Cphi4n1 + Cphi4n3)*gc397*(2*Wmass^2 - Zmass^2), 0}, {(-2*I)*(Cphi4n1 + Cphi4n3)*gc397*(2*Wmass^2 - Zmass^2), 0}, {(2*I)*gc397*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc397*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc397*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(2*I)*(Cphi4n1 + Cphi4n3)*gc397*(2*Wmass^2 - Zmass^2), 0}},

C[ S[3] , -S[3] , -S[3] , S[1] , V[1] , V[3] , V[2] ] == {{(2*I)*(Cphi4n1 + Cphi4n3)*gc398*(2*Wmass^2 - Zmass^2), 0}, {(-I)*gc398*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - 2*Cphi4n1*Zmass^2 - Cphi4n3*Zmass^2), 0}, {(-I)*gc398*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - 2*Cphi4n1*Zmass^2 - Cphi4n3*Zmass^2), 0}, {(2*I)*Cphi4n1*gc398*(2*Wmass^2 - Zmass^2), 0}, {(-2*I)*Cphi4n1*gc398*Zmass^2, 0}, {(-2*I)*(Cphi4n1 + Cphi4n3)*gc398*(2*Wmass^2 - Zmass^2), 0}, {(-2*I)*(Cphi4n1 + Cphi4n3)*gc398*(2*Wmass^2 - Zmass^2), 0}, {(4*I)*Cphi4n3*gc398*(2*Wmass^2 - Zmass^2), 0}, {(2*I)*gc398*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc398*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc398*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(2*I)*Cphi4n1*gc398*(2*Wmass^2 - Zmass^2), 0}},

C[ -S[3] , S[1] , S[1] , V[1] , V[3] , V[2] ] == {{0, 0}, {0, 0}, {0, 0}, {(-I)*gc399, 0}, {(-I)*gc399, 0}, {0, 0}, {I*gc399, 0}, {I*gc399, 0}, {0, 0}},

C[ -S[3] , S[1] , S[1] , S[1] , V[1] , V[3] , V[2] ] == {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {(-I)*gc400, 0}, {(-I)*gc400, 0}, {(-I)*gc400, 0}, {0, 0}, {I*gc400, 0}, {I*gc400, 0}, {I*gc400, 0}},

C[ -S[3] , V[3] , V[2] , V[2] ] == {{0, 0}, {I*CphiWB*gc401*(8*Gf*(Wmass^3 - Wmass*Zmass^2) + Sqrt[2]*Lam*(CphiD*(2*Wmass^3 - Wmass*Zmass^2) + 4*(Wmass^2 - Zmass^2)*(CphiW*Wmass + CphiWB*Sqrt[-Wmass^2 + Zmass^2]))), 0}, {0, 0}, {(-I)*CphiWB*gc401*(8*Gf*(Wmass^3 - Wmass*Zmass^2) + Sqrt[2]*Lam*(CphiD*(2*Wmass^3 - Wmass*Zmass^2) + 4*(Wmass^2 - Zmass^2)*(CphiW*Wmass + CphiWB*Sqrt[-Wmass^2 + Zmass^2]))), 0}, {I*CphiWB*gc401*(8*Gf*(Wmass^3 - Wmass*Zmass^2) + Sqrt[2]*Lam*(CphiD*(2*Wmass^3 - Wmass*Zmass^2) + 4*(Wmass^2 - Zmass^2)*(CphiW*Wmass + CphiWB*Sqrt[-Wmass^2 + Zmass^2]))), 0}, {(-I)*CphiWB*gc401*(8*Gf*(Wmass^3 - Wmass*Zmass^2) + Sqrt[2]*Lam*(CphiD*(2*Wmass^3 - Wmass*Zmass^2) + 4*(Wmass^2 - Zmass^2)*(CphiW*Wmass + CphiWB*Sqrt[-Wmass^2 + Zmass^2]))), 0}, {(2*I)*Cphi4n1*gc401*Gf*Lam*Zmass^4*Sqrt[-Wmass^2 + Zmass^2], 0}, {(4*I)*Cphi4n3*gc401*Gf*Lam*Zmass^4*Sqrt[-Wmass^2 + Zmass^2], 0}, {(2*I)*Cphi4n1*gc401*Gf*Lam*Zmass^4*Sqrt[-Wmass^2 + Zmass^2], 0}},

C[ S[2] , -S[3] , V[3] , V[2] , V[2] ] == {{0, 0}, {CphiWB*gc402*(8*Gf*(Wmass^3 - Wmass*Zmass^2) + Sqrt[2]*Lam*(CphiD*Wmass^3 + Cll2x1x1x2*(-Wmass^3 + Wmass*Zmass^2) + 4*(Wmass^2 - Zmass^2)*(CphiW*Wmass + CphiWB*Sqrt[-Wmass^2 + Zmass^2]))), 0}, {0, 0}, {-(CphiWB*gc402*(8*Gf*(Wmass^3 - Wmass*Zmass^2) + Sqrt[2]*Lam*(-(Cll2x1x1x2*Wmass^3) + CphiD*Wmass^3 + Cll2x1x1x2*Wmass*Zmass^2 + 4*(Wmass^2 - Zmass^2)*(CphiW*Wmass + CphiWB*Sqrt[-Wmass^2 + Zmass^2])))), 0}, {CphiWB*gc402*(8*Gf*(Wmass^3 - Wmass*Zmass^2) + Sqrt[2]*Lam*(-(Cll2x1x1x2*Wmass^3) + CphiD*Wmass^3 + Cll2x1x1x2*Wmass*Zmass^2 + 4*(Wmass^2 - Zmass^2)*(CphiW*Wmass + CphiWB*Sqrt[-Wmass^2 + Zmass^2]))), 0}, {-(CphiWB*gc402*(8*Gf*(Wmass^3 - Wmass*Zmass^2) + Sqrt[2]*Lam*(-(Cll2x1x1x2*Wmass^3) + CphiD*Wmass^3 + Cll2x1x1x2*Wmass*Zmass^2 + 4*(Wmass^2 - Zmass^2)*(CphiW*Wmass + CphiWB*Sqrt[-Wmass^2 + Zmass^2])))), 0}, {2*gc402*Gf*Lam*Zmass^2*Sqrt[-Wmass^2 + Zmass^2]*(2*Cphi4n1*Wmass^2 + 4*Cphi4n3*Wmass^2 - 3*Cphi4n1*Zmass^2 - 4*Cphi4n3*Zmass^2), 0}, {2*Cphi4n1*gc402*Gf*Lam*Zmass^4*Sqrt[-Wmass^2 + Zmass^2], 0}, {-4*gc402*Gf*Lam*Zmass^2*Sqrt[-Wmass^2 + Zmass^2]*(-2*Cphi4n1*Wmass^2 + 2*Cphi4n1*Zmass^2 + Cphi4n3*Zmass^2), 0}, {4*Cphi4n3*gc402*Gf*Lam*Zmass^4*Sqrt[-Wmass^2 + Zmass^2], 0}, {2*gc402*Gf*Lam*Zmass^2*Sqrt[-Wmass^2 + Zmass^2]*(2*Cphi4n1*Wmass^2 + 4*Cphi4n3*Wmass^2 - 3*Cphi4n1*Zmass^2 - 4*Cphi4n3*Zmass^2), 0}, {2*Cphi4n1*gc402*Gf*Lam*Zmass^4*Sqrt[-Wmass^2 + Zmass^2], 0}},

C[ -S[3] , S[1] , V[3] , V[2] , V[2] ] == {{0, 0}, {I*CphiWB*gc403*(8*Gf*(Wmass^3 - Wmass*Zmass^2) + Sqrt[2]*Lam*(-(Cll2x1x1x2*Wmass^3) + 4*CphiBox*Wmass^3 + CphiD*Wmass^3 + 4*CphiW*Wmass^3 + Cll2x1x1x2*Wmass*Zmass^2 - 4*CphiBox*Wmass*Zmass^2 - 4*CphiW*Wmass*Zmass^2 + 4*CphiWB*Wmass^2*Sqrt[-Wmass^2 + Zmass^2] - 4*CphiWB*Zmass^2*Sqrt[-Wmass^2 + Zmass^2])), 0}, {0, 0}, {(-I)*CphiWB*gc403*(8*Gf*(Wmass^3 - Wmass*Zmass^2) + Sqrt[2]*Lam*(-(Cll2x1x1x2*Wmass^3) + 4*CphiBox*Wmass^3 + CphiD*Wmass^3 + 4*CphiW*Wmass^3 + Cll2x1x1x2*Wmass*Zmass^2 - 4*CphiBox*Wmass*Zmass^2 - 4*CphiW*Wmass*Zmass^2 + 4*CphiWB*Wmass^2*Sqrt[-Wmass^2 + Zmass^2] - 4*CphiWB*Zmass^2*Sqrt[-Wmass^2 + Zmass^2])), 0}, {I*CphiWB*gc403*(8*Gf*(Wmass^3 - Wmass*Zmass^2) + Sqrt[2]*Lam*(-(Cll2x1x1x2*Wmass^3) + 4*CphiBox*Wmass^3 + CphiD*Wmass^3 + 4*CphiW*Wmass^3 + Cll2x1x1x2*Wmass*Zmass^2 - 4*CphiBox*Wmass*Zmass^2 - 4*CphiW*Wmass*Zmass^2 + 4*CphiWB*Wmass^2*Sqrt[-Wmass^2 + Zmass^2] - 4*CphiWB*Zmass^2*Sqrt[-Wmass^2 + Zmass^2])), 0}, {(-I)*CphiWB*gc403*(8*Gf*(Wmass^3 - Wmass*Zmass^2) + Sqrt[2]*Lam*(-(Cll2x1x1x2*Wmass^3) + 4*CphiBox*Wmass^3 + CphiD*Wmass^3 + 4*CphiW*Wmass^3 + Cll2x1x1x2*Wmass*Zmass^2 - 4*CphiBox*Wmass*Zmass^2 - 4*CphiW*Wmass*Zmass^2 + 4*CphiWB*Wmass^2*Sqrt[-Wmass^2 + Zmass^2] - 4*CphiWB*Zmass^2*Sqrt[-Wmass^2 + Zmass^2])), 0}, {(6*I)*Cphi4n1*gc403*Gf*Lam*Zmass^4*Sqrt[-Wmass^2 + Zmass^2], 0}, {(-2*I)*Cphi4n1*gc403*Gf*Lam*Zmass^2*(-2*Wmass^2 + Zmass^2)*Sqrt[-Wmass^2 + Zmass^2], 0}, {(12*I)*Cphi4n3*gc403*Gf*Lam*Zmass^4*Sqrt[-Wmass^2 + Zmass^2], 0}, {(-4*I)*gc403*Gf*Lam*Zmass^2*Sqrt[-Wmass^2 + Zmass^2]*(2*Cphi4n1*Wmass^2 + Cphi4n3*Zmass^2), 0}, {(6*I)*Cphi4n1*gc403*Gf*Lam*Zmass^4*Sqrt[-Wmass^2 + Zmass^2], 0}, {(-2*I)*Cphi4n1*gc403*Gf*Lam*Zmass^2*(-2*Wmass^2 + Zmass^2)*Sqrt[-Wmass^2 + Zmass^2], 0}},

C[ -S[3] , -S[3] , V[1] , V[3] , V[3] , V[2] ] == {{(2*I)*Cphi4n1*gc404*Zmass^2, 0}, {(-I)*gc404*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc404*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}},

C[ S[2] , -S[3] , -S[3] , V[1] , V[3] , V[3] , V[2] ] == {{2*Cphi4n1*gc405*Zmass^2, 0}, {gc405*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)), 0}, {gc405*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)), 0}},

C[ S[2] , S[2] , -S[3] , -S[3] , V[1] , V[3] , V[3] , V[2] ] == {{(2*I)*Cphi4n1*gc406*Zmass^2, 0}, {I*gc406*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)), 0}, {(-I)*gc406*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}},

C[ -S[3] , -S[3] , S[1] , V[1] , V[3] , V[3] , V[2] ] == {{(2*I)*Cphi4n1*gc407*Zmass^2, 0}, {(-I)*gc407*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc407*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}},

C[ S[2] , -S[3] , -S[3] , S[1] , V[1] , V[3] , V[3] , V[2] ] == {{2*Cphi4n1*gc408*Zmass^2, 0}, {gc408*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)), 0}, {gc408*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)), 0}},

C[ -S[3] , -S[3] , S[1] , S[1] , V[1] , V[3] , V[3] , V[2] ] == {{(2*I)*Cphi4n1*gc409*Zmass^2, 0}, {(-I)*gc409*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc409*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}},

C[ S[2] , -S[3] , -S[3] , V[3] , V[3] , V[2] ] == {{2*Cphi4n1*gc410*Zmass^2, 0}, {2*Cphi4n1*gc410*Zmass^2, 0}, {gc410*(-(Cphi4n1*Zmass^2) + 2*Cphi4n3*(Wmass^2 - Zmass^2)), 0}, {gc410*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)), 0}, {gc410*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)), 0}, {gc410*(-(Cphi4n1*Zmass^2) + 2*Cphi4n3*(Wmass^2 - Zmass^2)), 0}, {gc410*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)), 0}, {gc410*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)), 0}, {2*Cphi4n1*gc410*(2*Wmass^2 - Zmass^2), 0}},

C[ S[2] , S[2] , -S[3] , -S[3] , V[3] , V[3] , V[2] ] == {{(-2*I)*Cphi4n1*gc411*(2*Wmass^2 - Zmass^2), 0}, {(-2*I)*Cphi4n1*gc411*(2*Wmass^2 - Zmass^2), 0}, {(-2*I)*Cphi4n1*gc411*Zmass^2, 0}, {(-2*I)*Cphi4n1*gc411*Zmass^2, 0}, {I*gc411*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {I*gc411*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {I*gc411*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {I*gc411*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {I*gc411*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {I*gc411*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {I*gc411*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {I*gc411*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}},

C[ S[2] , -S[3] , -S[3] , S[1] , V[3] , V[3] , V[2] ] == {{2*Cphi4n1*gc412*(-2*Wmass^2 + Zmass^2), 0}, {-2*Cphi4n1*gc412*Zmass^2, 0}, {-2*Cphi4n1*gc412*Zmass^2, 0}, {2*Cphi4n1*gc412*(-2*Wmass^2 + Zmass^2), 0}, {gc412*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {gc412*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {gc412*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {gc412*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {gc412*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {gc412*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {gc412*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {gc412*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}},

C[ -S[3] , -S[3] , V[3] , V[3] , V[2] ] == {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {(2*I)*Cphi4n1*gc413*Zmass^2, 0}, {(-I)*gc413*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc413*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc413*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc413*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(2*I)*Cphi4n1*gc413*Zmass^2, 0}},

C[ -S[3] , -S[3] , S[1] , V[3] , V[3] , V[2] ] == {{(2*I)*Cphi4n1*gc414*Zmass^2, 0}, {(2*I)*Cphi4n1*gc414*(2*Wmass^2 - Zmass^2), 0}, {(-I)*gc414*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc414*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc414*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc414*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc414*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc414*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {(2*I)*Cphi4n1*gc414*Zmass^2, 0}},

C[ -S[3] , -S[3] , S[1] , S[1] , V[3] , V[3] , V[2] ] == {{(-2*I)*Cphi4n1*gc415*Zmass^2, 0}, {(-2*I)*Cphi4n1*gc415*Zmass^2, 0}, {(-2*I)*Cphi4n1*gc415*(2*Wmass^2 - Zmass^2), 0}, {(-2*I)*Cphi4n1*gc415*(2*Wmass^2 - Zmass^2), 0}, {I*gc415*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {I*gc415*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {I*gc415*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {I*gc415*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {I*gc415*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {I*gc415*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {I*gc415*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {I*gc415*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}},

C[ S[3] , S[3] , -S[3] , -V[3] , V[2] ] == {{(4*I)*(Cphi4n1 + Cphi4n3)*gc416*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {(4*I)*Cphi4n1*gc416*Gf*Lam*Zmass^2, 0}, {(-4*I)*(Cphi4n1 + Cphi4n3)*gc416*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {(-4*I)*(Cphi4n1 + Cphi4n3)*gc416*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {I*CphiD*gc416*(8*Gf*(2*Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(2*CphiD*Wmass^2 + CphiD*Zmass^2 + Cll2x1x1x2*(-2*Wmass^2 + Zmass^2) + 8*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2])), 0}, {0, 0}, {(-4*I)*gc416*Gf*Lam*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(4*I)*(Cphi4n1 + Cphi4n3)*gc416*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {(-4*I)*gc416*Gf*Lam*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(4*I)*Cphi4n1*gc416*Gf*Lam*Zmass^2, 0}},

C[ S[2] , S[3] , S[3] , -S[3] , -V[3] , V[2] ] == {{0, 0}, {Sqrt[2]*Cphi4n3*gc417*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {0, 0}, {-(Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc417*Gf*Lam*(2*Wmass^2 - Zmass^2)), 0}, {Sqrt[2]*Cphi4n3*gc417*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {-(Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc417*Gf*Lam*(2*Wmass^2 - Zmass^2)), 0}, {-2*Sqrt[2]*Cphi4n1*gc417*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {-(Sqrt[2]*Cphi4n1*gc417*Gf*Lam*Zmass^2), 0}, {-(Sqrt[2]*Cphi4n1*gc417*Gf*Lam*Zmass^2), 0}, {-2*Sqrt[2]*Cphi4n3*gc417*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc417*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc417*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {-(CphiD*gc417*(2*Sqrt[2]*Gf*(2*Wmass^2 - Zmass^2) + Lam*(CphiD*Zmass^2 + Cll2x1x1x2*(-2*Wmass^2 + Zmass^2) + 4*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2]))), 0}, {Sqrt[2]*Cphi4n1*gc417*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {0, 0}, {0, 0}, {Sqrt[2]*gc417*Gf*Lam*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {Sqrt[2]*Cphi4n1*gc417*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {Sqrt[2]*gc417*Gf*Lam*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}},

C[ S[3] , S[3] , -S[3] , S[1] , -V[3] , V[2] ] == {{(-I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc418*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {(-I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc418*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {(-I)*Sqrt[2]*Cphi4n1*gc418*Gf*Lam*Zmass^2, 0}, {(-I)*Sqrt[2]*Cphi4n1*gc418*Gf*Lam*Zmass^2, 0}, {I*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc418*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {I*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc418*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {I*Sqrt[2]*Cphi4n3*gc418*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {I*Sqrt[2]*Cphi4n3*gc418*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {(-2*I)*Sqrt[2]*Cphi4n3*gc418*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {0, 0}, {0, 0}, {(-2*I)*Sqrt[2]*Cphi4n1*gc418*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {(-I)*CphiD*gc418*(2*Sqrt[2]*Gf*(2*Wmass^2 - Zmass^2) + Lam*(4*CphiBox*Wmass^2 - 2*CphiBox*Zmass^2 + CphiD*Zmass^2 + Cll2x1x1x2*(-2*Wmass^2 + Zmass^2) + 4*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2])), 0}, {I*Sqrt[2]*gc418*Gf*Lam*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {I*Sqrt[2]*Cphi4n1*gc418*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {I*Sqrt[2]*gc418*Gf*Lam*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {I*Sqrt[2]*Cphi4n1*gc418*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {0, 0}, {0, 0}},

C[ S[2] , S[2] , S[3] , -V[3] , V[2] ] == {{(4*I)*gc419*Gf*Lam*(2*Cphi4n1*Wmass^2 - 3*Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(8*I)*Cphi4n3*gc419*Gf*Lam*Zmass^2, 0}, {(8*I)*Cphi4n1*gc419*Gf*Lam*Zmass^2, 0}, {(8*I)*Cphi4n1*gc419*Gf*Lam*Zmass^2, 0}, {(-I)*CphiD*gc419*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 + 3*CphiD)*Lam)*Zmass^2, 0}, {(-8*I)*gc419*Gf*Lam*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {0, 0}, {(4*I)*gc419*Gf*Lam*(2*Cphi4n1*Wmass^2 - 3*Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {0, 0}, {(8*I)*Cphi4n3*gc419*Gf*Lam*Zmass^2, 0}},

C[ S[2] , S[2] , S[2] , S[3] , -V[3] , V[2] ] == {{Sqrt[2]*Cphi4n1*gc420*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}, {Sqrt[2]*Cphi4n1*gc420*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}, {-(Sqrt[2]*Cphi4n1*gc420*Gf*Lam*(2*Wmass^2 - Zmass^2)), 0}, {-(Sqrt[2]*Cphi4n1*gc420*Gf*Lam*(2*Wmass^2 - Zmass^2)), 0}, {-(Sqrt[2]*Cphi4n1*gc420*Gf*Lam*(2*Wmass^2 - Zmass^2)), 0}, {-(Sqrt[2]*Cphi4n1*gc420*Gf*Lam*(2*Wmass^2 - Zmass^2)), 0}, {0, 0}, {0, 0}, {0, 0}, {-2*Sqrt[2]*Cphi4n1*gc420*Gf*Lam*Zmass^2, 0}, {-2*Sqrt[2]*Cphi4n1*gc420*Gf*Lam*Zmass^2, 0}, {-2*Sqrt[2]*Cphi4n1*gc420*Gf*Lam*Zmass^2, 0}, {3*CphiD*gc420*(-2*Sqrt[2]*Gf + (Cll2x1x1x2 + 2*CphiD)*Lam)*Zmass^2, 0}, {2*Sqrt[2]*gc420*Gf*Lam*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {2*Sqrt[2]*Cphi4n1*gc420*Gf*Lam*Zmass^2, 0}, {2*Sqrt[2]*gc420*Gf*Lam*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {2*Sqrt[2]*Cphi4n1*gc420*Gf*Lam*Zmass^2, 0}, {2*Sqrt[2]*gc420*Gf*Lam*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {2*Sqrt[2]*Cphi4n1*gc420*Gf*Lam*Zmass^2, 0}},

C[ S[2] , S[3] , S[1] , -V[3] , V[2] ] == {{-8*Cphi4n1*gc421*Gf*Lam*Zmass^2, 0}, {8*Cphi4n1*gc421*Gf*Lam*Zmass^2, 0}, {-4*Cphi4n1*gc421*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {8*Cphi4n3*gc421*Gf*Lam*Zmass^2, 0}, {-(CphiD*gc421*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 - 4*CphiBox + 3*CphiD)*Lam)*Zmass^2), 0}, {-8*Cphi4n1*gc421*Gf*Lam*Zmass^2, 0}, {0, 0}, {-16*Cphi4n3*gc421*Gf*Lam*Zmass^2, 0}, {0, 0}, {4*gc421*Gf*Lam*(2*Cphi4n3*Zmass^2 + Cphi4n1*(2*Wmass^2 + Zmass^2)), 0}},

C[ S[2] , S[2] , S[3] , S[1] , -V[3] , V[2] ] == {{(-I)*Sqrt[2]*gc422*Gf*Lam*(2*Cphi4n1*Wmass^2 - 3*Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*Sqrt[2]*gc422*Gf*Lam*(2*Cphi4n1*Wmass^2 - 3*Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-2*I)*Sqrt[2]*Cphi4n3*gc422*Gf*Lam*Zmass^2, 0}, {(-2*I)*Sqrt[2]*Cphi4n3*gc422*Gf*Lam*Zmass^2, 0}, {(-2*I)*Sqrt[2]*Cphi4n1*gc422*Gf*Lam*Zmass^2, 0}, {(-2*I)*Sqrt[2]*Cphi4n1*gc422*Gf*Lam*Zmass^2, 0}, {I*Sqrt[2]*Cphi4n1*gc422*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {I*Sqrt[2]*Cphi4n1*gc422*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {(2*I)*Sqrt[2]*Cphi4n1*gc422*Gf*Lam*Zmass^2, 0}, {(-I)*Sqrt[2]*gc422*Gf*Lam*(2*Cphi4n3*Zmass^2 + Cphi4n1*(2*Wmass^2 + Zmass^2)), 0}, {(-I)*Sqrt[2]*gc422*Gf*Lam*(2*Cphi4n3*Zmass^2 + Cphi4n1*(2*Wmass^2 + Zmass^2)), 0}, {(4*I)*Sqrt[2]*Cphi4n3*gc422*Gf*Lam*Zmass^2, 0}, {I*CphiD*gc422*(-2*Sqrt[2]*Gf + (Cll2x1x1x2 - 2*CphiBox + 2*CphiD)*Lam)*Zmass^2, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {(2*I)*Sqrt[2]*gc422*Gf*Lam*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {(2*I)*Sqrt[2]*Cphi4n1*gc422*Gf*Lam*Zmass^2, 0}},

C[ S[3] , S[1] , S[1] , -V[3] , V[2] ] == {{0, 0}, {(4*I)*Cphi4n1*gc423*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {0, 0}, {(4*I)*Cphi4n1*gc423*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {(-3*I)*CphiD*gc423*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 - 8*CphiBox + 3*CphiD)*Lam)*Zmass^2, 0}, {(-8*I)*Cphi4n1*gc423*Gf*Lam*Zmass^2, 0}, {(-8*I)*Cphi4n1*gc423*Gf*Lam*Zmass^2, 0}, {(8*I)*Cphi4n1*gc423*Gf*Lam*Zmass^2, 0}, {(-8*I)*gc423*Gf*Lam*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {(8*I)*Cphi4n1*gc423*Gf*Lam*Zmass^2, 0}},

C[ S[2] , S[3] , S[1] , S[1] , -V[3] , V[2] ] == {{-4*Sqrt[2]*Cphi4n3*gc424*Gf*Lam*Zmass^2, 0}, {-2*Sqrt[2]*Cphi4n1*gc424*Gf*Lam*Zmass^2, 0}, {Sqrt[2]*gc424*Gf*Lam*(2*Cphi4n3*Zmass^2 + Cphi4n1*(2*Wmass^2 + Zmass^2)), 0}, {2*Sqrt[2]*Cphi4n1*gc424*Gf*Lam*Zmass^2, 0}, {-(Sqrt[2]*Cphi4n1*gc424*Gf*Lam*(2*Wmass^2 - Zmass^2)), 0}, {2*Sqrt[2]*Cphi4n3*gc424*Gf*Lam*Zmass^2, 0}, {Sqrt[2]*gc424*Gf*Lam*(2*Cphi4n3*Zmass^2 + Cphi4n1*(2*Wmass^2 + Zmass^2)), 0}, {2*Sqrt[2]*Cphi4n1*gc424*Gf*Lam*Zmass^2, 0}, {Sqrt[2]*gc424*Gf*Lam*(2*Cphi4n1*Wmass^2 - 3*Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {-(Sqrt[2]*Cphi4n1*gc424*Gf*Lam*(2*Wmass^2 - Zmass^2)), 0}, {2*Sqrt[2]*Cphi4n3*gc424*Gf*Lam*Zmass^2, 0}, {Sqrt[2]*gc424*Gf*Lam*(2*Cphi4n1*Wmass^2 - 3*Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {-(CphiD*gc424*(-2*Sqrt[2]*Gf + (Cll2x1x1x2 - 4*CphiBox + 2*CphiD)*Lam)*Zmass^2), 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {-2*Sqrt[2]*Cphi4n1*gc424*Gf*Lam*Zmass^2, 0}, {-2*Sqrt[2]*gc424*Gf*Lam*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}},

C[ S[3] , S[1] , S[1] , S[1] , -V[3] , V[2] ] == {{(2*I)*Sqrt[2]*Cphi4n1*gc425*Gf*Lam*Zmass^2, 0}, {0, 0}, {(2*I)*Sqrt[2]*Cphi4n1*gc425*Gf*Lam*Zmass^2, 0}, {I*Sqrt[2]*Cphi4n1*gc425*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {0, 0}, {I*Sqrt[2]*Cphi4n1*gc425*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {(2*I)*Sqrt[2]*Cphi4n1*gc425*Gf*Lam*Zmass^2, 0}, {I*Sqrt[2]*Cphi4n1*gc425*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {I*Sqrt[2]*Cphi4n1*gc425*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {0, 0}, {I*Sqrt[2]*Cphi4n1*gc425*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {I*Sqrt[2]*Cphi4n1*gc425*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {(-3*I)*CphiD*gc425*(-2*Sqrt[2]*Gf + (Cll2x1x1x2 - 6*CphiBox + 2*CphiD)*Lam)*Zmass^2, 0}, {(-2*I)*Sqrt[2]*Cphi4n1*gc425*Gf*Lam*Zmass^2, 0}, {(-2*I)*Sqrt[2]*Cphi4n1*gc425*Gf*Lam*Zmass^2, 0}, {(-2*I)*Sqrt[2]*gc425*Gf*Lam*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {(-2*I)*Sqrt[2]*gc425*Gf*Lam*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {(-2*I)*Sqrt[2]*Cphi4n1*gc425*Gf*Lam*Zmass^2, 0}, {(-2*I)*Sqrt[2]*gc425*Gf*Lam*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}},

C[ S[3] , S[3] , -S[3] , V[1] , V[1] , -V[3] , V[2] ] == {{I*gc426*(4*Cphi4n1*Wmass^2 + 4*Cphi4n3*Wmass^2 - 3*Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {I*gc426*(4*Cphi4n1*Wmass^2 + 4*Cphi4n3*Wmass^2 - 3*Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(2*I)*gc426*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}},

C[ S[2] , S[3] , S[3] , -S[3] , V[1] , V[1] , -V[3] , V[2] ] == {{gc427*(4*Cphi4n1*Wmass^2 + 4*Cphi4n3*Wmass^2 - 3*Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {gc427*(4*Cphi4n1*Wmass^2 + 4*Cphi4n3*Wmass^2 - 3*Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {2*gc427*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}},

C[ S[3] , S[3] , -S[3] , S[1] , V[1] , V[1] , -V[3] , V[2] ] == {{I*gc428*(4*Cphi4n1*Wmass^2 + 4*Cphi4n3*Wmass^2 - 3*Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {I*gc428*(4*Cphi4n1*Wmass^2 + 4*Cphi4n3*Wmass^2 - 3*Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(2*I)*gc428*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}},

C[ S[2] , S[2] , S[3] , V[1] , -V[3] , V[2] ] == {{I*Cphi4n3*gc429, 0}, {0, 0}, {I*Cphi4n1*gc429, 0}, {I*Cphi4n1*gc429, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {I*Cphi4n3*gc429, 0}},

C[ S[2] , S[2] , S[2] , S[3] , V[1] , -V[3] , V[2] ] == {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {-gc430, 0}, {-gc430, 0}, {-gc430, 0}, {0, 0}, {gc430, 0}, {gc430, 0}, {gc430, 0}, {0, 0}},

C[ S[2] , S[3] , S[3] , -S[3] , V[1] , -V[3] , V[2] ] == {{2*Cphi4n1*gc431*(2*Wmass^2 - Zmass^2), 0}, {gc431*(-2*Cphi4n1*Wmass^2 - 2*Cphi4n3*Wmass^2 + 2*Cphi4n1*Zmass^2 + Cphi4n3*Zmass^2), 0}, {gc431*(-2*Cphi4n1*Wmass^2 - 2*Cphi4n3*Wmass^2 + 2*Cphi4n1*Zmass^2 + Cphi4n3*Zmass^2), 0}, {2*(Cphi4n1 + Cphi4n3)*gc431*(2*Wmass^2 - Zmass^2), 0}, {4*Cphi4n3*gc431*(2*Wmass^2 - Zmass^2), 0}, {-2*(Cphi4n1 + Cphi4n3)*gc431*(2*Wmass^2 - Zmass^2), 0}, {-2*(Cphi4n1 + Cphi4n3)*gc431*(2*Wmass^2 - Zmass^2), 0}, {-2*Cphi4n1*gc431*Zmass^2, 0}, {2*Cphi4n1*gc431*(2*Wmass^2 - Zmass^2), 0}, {gc431*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)), 0}, {gc431*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)), 0}, {2*gc431*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}},

C[ S[2] , S[3] , S[1] , V[1] , -V[3] , V[2] ] == {{0, 0}, {-(Cphi4n3*gc432), 0}, {Cphi4n1*gc432, 0}, {0, 0}, {-(Cphi4n1*gc432), 0}, {Cphi4n1*gc432, 0}, {0, 0}, {0, 0}, {2*Cphi4n3*gc432, 0}},

C[ S[2] , S[2] , S[3] , S[1] , V[1] , -V[3] , V[2] ] == {{(-I)*Cphi4n3*gc433, 0}, {(-I)*Cphi4n3*gc433, 0}, {0, 0}, {(2*I)*Cphi4n3*gc433, 0}, {(-I)*Cphi4n1*gc433, 0}, {(-I)*Cphi4n1*gc433, 0}, {0, 0}, {I*Cphi4n1*gc433, 0}, {0, 0}, {0, 0}, {0, 0}, {I*Cphi4n1*gc433, 0}},

C[ S[2] , S[3] , S[1] , S[1] , V[1] , -V[3] , V[2] ] == {{2*Cphi4n3*gc434, 0}, {0, 0}, {-(Cphi4n3*gc434), 0}, {-(Cphi4n3*gc434), 0}, {Cphi4n1*gc434, 0}, {0, 0}, {-(Cphi4n1*gc434), 0}, {-(Cphi4n1*gc434), 0}, {Cphi4n1*gc434, 0}, {0, 0}, {0, 0}, {0, 0}},

C[ S[3] , S[3] , -S[3] , V[1] , -V[3] , V[2] ] == {{I*gc435*(-2*Cphi4n1*Wmass^2 - 2*Cphi4n3*Wmass^2 + 2*Cphi4n1*Zmass^2 + Cphi4n3*Zmass^2), 0}, {(2*I)*(Cphi4n1 + Cphi4n3)*gc435*(2*Wmass^2 - Zmass^2), 0}, {(-2*I)*(Cphi4n1 + Cphi4n3)*gc435*(2*Wmass^2 - Zmass^2), 0}, {(-2*I)*(Cphi4n1 + Cphi4n3)*gc435*(2*Wmass^2 - Zmass^2), 0}, {(-2*I)*Cphi4n1*gc435*Zmass^2, 0}, {(-I)*gc435*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc435*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(2*I)*gc435*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc435*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - 2*Cphi4n1*Zmass^2 - Cphi4n3*Zmass^2), 0}},

C[ S[3] , S[3] , -S[3] , S[1] , V[1] , -V[3] , V[2] ] == {{I*gc436*(-2*Cphi4n1*Wmass^2 - 2*Cphi4n3*Wmass^2 + 2*Cphi4n1*Zmass^2 + Cphi4n3*Zmass^2), 0}, {I*gc436*(-2*Cphi4n1*Wmass^2 - 2*Cphi4n3*Wmass^2 + 2*Cphi4n1*Zmass^2 + Cphi4n3*Zmass^2), 0}, {(2*I)*(Cphi4n1 + Cphi4n3)*gc436*(2*Wmass^2 - Zmass^2), 0}, {(2*I)*Cphi4n1*gc436*(2*Wmass^2 - Zmass^2), 0}, {(-2*I)*(Cphi4n1 + Cphi4n3)*gc436*(2*Wmass^2 - Zmass^2), 0}, {(-2*I)*(Cphi4n1 + Cphi4n3)*gc436*(2*Wmass^2 - Zmass^2), 0}, {(-2*I)*Cphi4n1*gc436*Zmass^2, 0}, {(4*I)*Cphi4n3*gc436*(2*Wmass^2 - Zmass^2), 0}, {(-I)*gc436*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc436*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(2*I)*gc436*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(2*I)*Cphi4n1*gc436*(2*Wmass^2 - Zmass^2), 0}},

C[ S[3] , S[1] , S[1] , V[1] , -V[3] , V[2] ] == {{0, 0}, {0, 0}, {0, 0}, {(-I)*gc437, 0}, {(-I)*gc437, 0}, {0, 0}, {I*gc437, 0}, {I*gc437, 0}, {0, 0}},

C[ S[3] , S[1] , S[1] , S[1] , V[1] , -V[3] , V[2] ] == {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {(-I)*gc438, 0}, {(-I)*gc438, 0}, {(-I)*gc438, 0}, {0, 0}, {I*gc438, 0}, {I*gc438, 0}, {I*gc438, 0}},

C[ S[3] , -V[3] , V[2] , V[2] ] == {{0, 0}, {(-I)*CphiWB*gc439*(-8*Gf*(Wmass^3 - Wmass*Zmass^2) + Sqrt[2]*Lam*(CphiD*(-2*Wmass^3 + Wmass*Zmass^2) - 4*(Wmass^2 - Zmass^2)*(CphiW*Wmass + CphiWB*Sqrt[-Wmass^2 + Zmass^2]))), 0}, {0, 0}, {(-I)*CphiWB*gc439*(8*Gf*(Wmass^3 - Wmass*Zmass^2) + Sqrt[2]*Lam*(CphiD*(2*Wmass^3 - Wmass*Zmass^2) + 4*(Wmass^2 - Zmass^2)*(CphiW*Wmass + CphiWB*Sqrt[-Wmass^2 + Zmass^2]))), 0}, {I*CphiWB*gc439*(8*Gf*(Wmass^3 - Wmass*Zmass^2) + Sqrt[2]*Lam*(CphiD*(2*Wmass^3 - Wmass*Zmass^2) + 4*(Wmass^2 - Zmass^2)*(CphiW*Wmass + CphiWB*Sqrt[-Wmass^2 + Zmass^2]))), 0}, {(-I)*CphiWB*gc439*(8*Gf*(Wmass^3 - Wmass*Zmass^2) + Sqrt[2]*Lam*(CphiD*(2*Wmass^3 - Wmass*Zmass^2) + 4*(Wmass^2 - Zmass^2)*(CphiW*Wmass + CphiWB*Sqrt[-Wmass^2 + Zmass^2]))), 0}, {(2*I)*Cphi4n1*gc439*Gf*Lam*Zmass^4*Sqrt[-Wmass^2 + Zmass^2], 0}, {(4*I)*Cphi4n3*gc439*Gf*Lam*Zmass^4*Sqrt[-Wmass^2 + Zmass^2], 0}, {(2*I)*Cphi4n1*gc439*Gf*Lam*Zmass^4*Sqrt[-Wmass^2 + Zmass^2], 0}},

C[ S[2] , S[3] , -V[3] , V[2] , V[2] ] == {{0, 0}, {CphiWB*gc440*(8*Gf*(Wmass^3 - Wmass*Zmass^2) + Sqrt[2]*Lam*(CphiD*Wmass^3 + Cll2x1x1x2*(-Wmass^3 + Wmass*Zmass^2) + 4*(Wmass^2 - Zmass^2)*(CphiW*Wmass + CphiWB*Sqrt[-Wmass^2 + Zmass^2]))), 0}, {0, 0}, {-(CphiWB*gc440*(8*Gf*(Wmass^3 - Wmass*Zmass^2) + Sqrt[2]*Lam*(-(Cll2x1x1x2*Wmass^3) + CphiD*Wmass^3 + Cll2x1x1x2*Wmass*Zmass^2 + 4*(Wmass^2 - Zmass^2)*(CphiW*Wmass + CphiWB*Sqrt[-Wmass^2 + Zmass^2])))), 0}, {CphiWB*gc440*(8*Gf*(Wmass^3 - Wmass*Zmass^2) + Sqrt[2]*Lam*(-(Cll2x1x1x2*Wmass^3) + CphiD*Wmass^3 + Cll2x1x1x2*Wmass*Zmass^2 + 4*(Wmass^2 - Zmass^2)*(CphiW*Wmass + CphiWB*Sqrt[-Wmass^2 + Zmass^2]))), 0}, {-(CphiWB*gc440*(8*Gf*(Wmass^3 - Wmass*Zmass^2) + Sqrt[2]*Lam*(-(Cll2x1x1x2*Wmass^3) + CphiD*Wmass^3 + Cll2x1x1x2*Wmass*Zmass^2 + 4*(Wmass^2 - Zmass^2)*(CphiW*Wmass + CphiWB*Sqrt[-Wmass^2 + Zmass^2])))), 0}, {2*gc440*Gf*Lam*Zmass^2*Sqrt[-Wmass^2 + Zmass^2]*(2*Cphi4n1*Wmass^2 + 4*Cphi4n3*Wmass^2 - 3*Cphi4n1*Zmass^2 - 4*Cphi4n3*Zmass^2), 0}, {2*Cphi4n1*gc440*Gf*Lam*Zmass^4*Sqrt[-Wmass^2 + Zmass^2], 0}, {-4*gc440*Gf*Lam*Zmass^2*Sqrt[-Wmass^2 + Zmass^2]*(-2*Cphi4n1*Wmass^2 + 2*Cphi4n1*Zmass^2 + Cphi4n3*Zmass^2), 0}, {4*Cphi4n3*gc440*Gf*Lam*Zmass^4*Sqrt[-Wmass^2 + Zmass^2], 0}, {2*gc440*Gf*Lam*Zmass^2*Sqrt[-Wmass^2 + Zmass^2]*(2*Cphi4n1*Wmass^2 + 4*Cphi4n3*Wmass^2 - 3*Cphi4n1*Zmass^2 - 4*Cphi4n3*Zmass^2), 0}, {2*Cphi4n1*gc440*Gf*Lam*Zmass^4*Sqrt[-Wmass^2 + Zmass^2], 0}},

C[ S[3] , S[1] , -V[3] , V[2] , V[2] ] == {{0, 0}, {I*CphiWB*gc441*(8*Gf*(Wmass^3 - Wmass*Zmass^2) + Sqrt[2]*Lam*(-(Cll2x1x1x2*Wmass^3) + 4*CphiBox*Wmass^3 + CphiD*Wmass^3 + 4*CphiW*Wmass^3 + Cll2x1x1x2*Wmass*Zmass^2 - 4*CphiBox*Wmass*Zmass^2 - 4*CphiW*Wmass*Zmass^2 + 4*CphiWB*Wmass^2*Sqrt[-Wmass^2 + Zmass^2] - 4*CphiWB*Zmass^2*Sqrt[-Wmass^2 + Zmass^2])), 0}, {0, 0}, {(-I)*CphiWB*gc441*(8*Gf*(Wmass^3 - Wmass*Zmass^2) + Sqrt[2]*Lam*(-(Cll2x1x1x2*Wmass^3) + 4*CphiBox*Wmass^3 + CphiD*Wmass^3 + 4*CphiW*Wmass^3 + Cll2x1x1x2*Wmass*Zmass^2 - 4*CphiBox*Wmass*Zmass^2 - 4*CphiW*Wmass*Zmass^2 + 4*CphiWB*Wmass^2*Sqrt[-Wmass^2 + Zmass^2] - 4*CphiWB*Zmass^2*Sqrt[-Wmass^2 + Zmass^2])), 0}, {I*CphiWB*gc441*(8*Gf*(Wmass^3 - Wmass*Zmass^2) + Sqrt[2]*Lam*(-(Cll2x1x1x2*Wmass^3) + 4*CphiBox*Wmass^3 + CphiD*Wmass^3 + 4*CphiW*Wmass^3 + Cll2x1x1x2*Wmass*Zmass^2 - 4*CphiBox*Wmass*Zmass^2 - 4*CphiW*Wmass*Zmass^2 + 4*CphiWB*Wmass^2*Sqrt[-Wmass^2 + Zmass^2] - 4*CphiWB*Zmass^2*Sqrt[-Wmass^2 + Zmass^2])), 0}, {(-I)*CphiWB*gc441*(8*Gf*(Wmass^3 - Wmass*Zmass^2) + Sqrt[2]*Lam*(-(Cll2x1x1x2*Wmass^3) + 4*CphiBox*Wmass^3 + CphiD*Wmass^3 + 4*CphiW*Wmass^3 + Cll2x1x1x2*Wmass*Zmass^2 - 4*CphiBox*Wmass*Zmass^2 - 4*CphiW*Wmass*Zmass^2 + 4*CphiWB*Wmass^2*Sqrt[-Wmass^2 + Zmass^2] - 4*CphiWB*Zmass^2*Sqrt[-Wmass^2 + Zmass^2])), 0}, {(6*I)*Cphi4n1*gc441*Gf*Lam*Zmass^4*Sqrt[-Wmass^2 + Zmass^2], 0}, {(-2*I)*Cphi4n1*gc441*Gf*Lam*Zmass^2*(-2*Wmass^2 + Zmass^2)*Sqrt[-Wmass^2 + Zmass^2], 0}, {(12*I)*Cphi4n3*gc441*Gf*Lam*Zmass^4*Sqrt[-Wmass^2 + Zmass^2], 0}, {(-4*I)*gc441*Gf*Lam*Zmass^2*Sqrt[-Wmass^2 + Zmass^2]*(2*Cphi4n1*Wmass^2 + Cphi4n3*Zmass^2), 0}, {(6*I)*Cphi4n1*gc441*Gf*Lam*Zmass^4*Sqrt[-Wmass^2 + Zmass^2], 0}, {(-2*I)*Cphi4n1*gc441*Gf*Lam*Zmass^2*(-2*Wmass^2 + Zmass^2)*Sqrt[-Wmass^2 + Zmass^2], 0}},

C[ V[1] , V[3] , -V[3] , V[2] ] == {{(-2*I)*gc442, 0}, {I*gc442, 0}, {((-I)*Sqrt[2]*gc442*(-64*Gf^2*Wmass*(Wmass^2 - Zmass^2)^2 + Lam^2*(CphiD^2*Wmass*Zmass^4 + 12*Cll2x1x1x2^2*Wmass*(Wmass^2 - Zmass^2)^2 + 32*CphiWB^2*Wmass*(Wmass^2 - Zmass^2)^2 + 32*CphiWB*(-Wmass^2 + Zmass^2)^(3/2)*(CphiD*Wmass^2 + 2*CphiW*Wmass^2 - CphiW*Zmass^2)) + 8*Sqrt[2]*Gf*Lam*(Wmass^2 - Zmass^2)*(2*Cll2x1x1x2*(Wmass^3 - Wmass*Zmass^2) - (2*Wmass^2 - Zmass^2)*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2]))))/(64*Sqrt[2]*Gf^2*Wmass*(Wmass^2 - Zmass^2)^2 - Sqrt[2]*Lam^2*(CphiD^2*Wmass*Zmass^4 + 12*Cll2x1x1x2^2*Wmass*(Wmass^2 - Zmass^2)^2 + 32*CphiWB^2*Wmass*(Wmass^2 - Zmass^2)^2 - 32*CphiWB*(-Wmass^2 + Zmass^2)^(3/2)*(-(CphiD*Wmass^2) + CphiW*(-2*Wmass^2 + Zmass^2))) - 16*Gf*Lam*(Wmass^2 - Zmass^2)*(2*Cll2x1x1x2*(Wmass^3 - Wmass*Zmass^2) - (2*Wmass^2 - Zmass^2)*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2]))), 0}},

C[ S[2] , S[2] , V[1] , V[3] , -V[3] , V[2] ] == {{(-2*I)*gc443, 0}, {I*gc443, 0}, {I*gc443, 0}},

C[ S[3] , -S[3] , V[1] , V[3] , -V[3] , V[2] ] == {{((2*I)*gc444*(Wmass^2 - Zmass^2)*(-8*CphiW^2*Lam*Wmass*(-Wmass^2 + Zmass^2)^(3/2) + Sqrt[2]*(Cphi4n1 + Cphi4n3)*Gf*Lam*Wmass*Sqrt[-Wmass^2 + Zmass^2]*(2*Wmass^4 - 3*Wmass^2*Zmass^2 + Zmass^4) - CphiW*(4*CphiWB*Lam*(2*Wmass^4 - 3*Wmass^2*Zmass^2 + Zmass^4) + Wmass*Sqrt[-Wmass^2 + Zmass^2]*(2*Cll2x1x1x2*Lam*(Wmass^2 - Zmass^2) + CphiD*Lam*(-2*Wmass^2 + Zmass^2) + 4*Sqrt[2]*Gf*(-Wmass^2 + Zmass^2)))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {(I*gc444*(Wmass^2 - Zmass^2)*(8*CphiW^2*Lam*Wmass*(-Wmass^2 + Zmass^2)^(3/2) + 2*Sqrt[2]*(Cphi4n1 + Cphi4n3)*Gf*Lam*Wmass*(-Wmass^2 + Zmass^2)^(5/2) + 4*CphiW*CphiWB*Lam*(2*Wmass^4 - 3*Wmass^2*Zmass^2 + Zmass^4) + CphiW*Wmass*Sqrt[-Wmass^2 + Zmass^2]*(2*Cll2x1x1x2*Lam*(Wmass^2 - Zmass^2) + CphiD*Lam*(-2*Wmass^2 + Zmass^2) + 4*Sqrt[2]*Gf*(-Wmass^2 + Zmass^2))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}, {(I*gc444*(Wmass^2 - Zmass^2)*(8*CphiW^2*Lam*Wmass*(-Wmass^2 + Zmass^2)^(3/2) + 2*Sqrt[2]*(Cphi4n1 + Cphi4n3)*Gf*Lam*Wmass*(-Wmass^2 + Zmass^2)^(5/2) + 4*CphiW*CphiWB*Lam*(2*Wmass^4 - 3*Wmass^2*Zmass^2 + Zmass^4) + CphiW*Wmass*Sqrt[-Wmass^2 + Zmass^2]*(2*Cll2x1x1x2*Lam*(Wmass^2 - Zmass^2) + CphiD*Lam*(-2*Wmass^2 + Zmass^2) + 4*Sqrt[2]*Gf*(-Wmass^2 + Zmass^2))))/((Wmass - Zmass)*(Wmass + Zmass)), 0}},

C[ S[1] , V[1] , V[3] , -V[3] , V[2] ] == {{(-2*I)*gc445, 0}, {I*gc445, 0}, {I*gc445, 0}},

C[ S[1] , S[1] , V[1] , V[3] , -V[3] , V[2] ] == {{(-2*I)*gc446, 0}, {I*gc446, 0}, {I*gc446, 0}},

C[ S[2] , S[2] , S[3] , -S[3] , V[1] , V[3] , -V[3] , V[2] ] == {{I*gc447*(2*Wmass^2 - Zmass^2), 0}, {I*gc447*(Wmass^2 - Zmass^2), 0}, {I*gc447*(Wmass - Zmass)*(Wmass + Zmass), 0}},

C[ S[3] , S[3] , -S[3] , -S[3] , V[1] , V[3] , -V[3] , V[2] ] == {{(2*I)*Cphi4n3*gc448, 0}, {I*Cphi4n1*gc448, 0}, {I*Cphi4n1*gc448, 0}},

C[ S[3] , -S[3] , S[1] , V[1] , V[3] , -V[3] , V[2] ] == {{I*gc449*(2*Wmass^2 - Zmass^2), 0}, {I*gc449*(Wmass^2 - Zmass^2), 0}, {I*gc449*(Wmass - Zmass)*(Wmass + Zmass), 0}},

C[ S[3] , -S[3] , S[1] , S[1] , V[1] , V[3] , -V[3] , V[2] ] == {{I*gc450*(2*Wmass^2 - Zmass^2), 0}, {I*gc450*(Wmass^2 - Zmass^2), 0}, {I*gc450*(Wmass - Zmass)*(Wmass + Zmass), 0}},

C[ S[2] , V[3] , -V[3] , V[2] ] == {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {Cphi4n1*gc451, 0}, {Cphi4n1*gc451, 0}, {2*Cphi4n3*gc451, 0}},

C[ S[2] , S[2] , S[2] , V[3] , -V[3] , V[2] ] == {{2*Cphi4n3*gc452, 0}, {2*Cphi4n3*gc452, 0}, {Cphi4n1*gc452, 0}, {Cphi4n1*gc452, 0}, {Cphi4n1*gc452, 0}, {Cphi4n1*gc452, 0}, {Cphi4n1*gc452, 0}, {Cphi4n1*gc452, 0}, {2*Cphi4n3*gc452, 0}},

C[ S[2] , S[3] , -S[3] , V[3] , -V[3] , V[2] ] == {{0, 0}, {0, 0}, {gc453 - (gc453*Wmass^2)/Zmass^2, 0}, {0, 0}, {0, 0}, {gc453 - (gc453*Wmass^2)/Zmass^2, 0}, {0, 0}, {0, 0}, {gc453, 0}},

C[ S[2] , S[1] , V[3] , -V[3] , V[2] ] == {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {-6*Cphi4n3*gc454, 0}, {Cphi4n1*gc454, 0}, {-3*Cphi4n1*gc454, 0}, {Cphi4n1*gc454, 0}, {-3*Cphi4n1*gc454, 0}, {2*Cphi4n3*gc454, 0}},

C[ S[2] , S[2] , S[2] , S[1] , V[3] , -V[3] , V[2] ] == {{-2*Cphi4n3*gc455, 0}, {-2*Cphi4n3*gc455, 0}, {-2*Cphi4n3*gc455, 0}, {6*Cphi4n3*gc455, 0}, {-(Cphi4n1*gc455), 0}, {-(Cphi4n1*gc455), 0}, {-(Cphi4n1*gc455), 0}, {3*Cphi4n1*gc455, 0}, {-(Cphi4n1*gc455), 0}, {-(Cphi4n1*gc455), 0}, {-(Cphi4n1*gc455), 0}, {3*Cphi4n1*gc455, 0}},

C[ S[2] , S[3] , -S[3] , S[1] , V[3] , -V[3] , V[2] ] == {{-(gc456*Zmass^2), 0}, {0, 0}, {0, 0}, {gc456*Zmass^2, 0}, {gc456*(Wmass - Zmass)*(Wmass + Zmass), 0}, {0, 0}, {0, 0}, {-(gc456*(Wmass - Zmass)*(Wmass + Zmass)), 0}, {gc456*(Wmass - Zmass)*(Wmass + Zmass), 0}, {0, 0}, {0, 0}, {-(gc456*(Wmass - Zmass)*(Wmass + Zmass)), 0}},

C[ S[2] , S[1] , S[1] , V[3] , -V[3] , V[2] ] == {{-2*Cphi4n3*gc457, 0}, {-2*Cphi4n3*gc457, 0}, {3*Cphi4n1*gc457, 0}, {-(Cphi4n1*gc457), 0}, {-(Cphi4n1*gc457), 0}, {3*Cphi4n1*gc457, 0}, {-(Cphi4n1*gc457), 0}, {-(Cphi4n1*gc457), 0}, {6*Cphi4n3*gc457, 0}},

C[ S[2] , S[1] , S[1] , S[1] , V[3] , -V[3] , V[2] ] == {{-6*Cphi4n3*gc458, 0}, {2*Cphi4n3*gc458, 0}, {2*Cphi4n3*gc458, 0}, {2*Cphi4n3*gc458, 0}, {-3*Cphi4n1*gc458, 0}, {Cphi4n1*gc458, 0}, {Cphi4n1*gc458, 0}, {Cphi4n1*gc458, 0}, {-3*Cphi4n1*gc458, 0}, {Cphi4n1*gc458, 0}, {Cphi4n1*gc458, 0}, {Cphi4n1*gc458, 0}},

C[ S[2] , S[2] , S[3] , -S[3] , V[3] , -V[3] , V[2] ] == {{0, 0}, {0, 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc459*(2*Wmass^2 - Zmass^2), 0}, {I*(Cphi4n1 + Cphi4n3)*gc459*(2*Wmass^2 - Zmass^2), 0}, {(-I)*gc459*(Cphi4n1*Wmass^2 + Cphi4n3*(-Wmass^2 + Zmass^2)), 0}, {(-I)*gc459*(Cphi4n1*Wmass^2 + Cphi4n3*(-Wmass^2 + Zmass^2)), 0}, {(-I)*gc459*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*Cphi4n1*gc459*Zmass^2, 0}, {I*gc459*(Cphi4n1*Wmass^2 + Cphi4n3*(-Wmass^2 + Zmass^2)), 0}, {I*gc459*(Cphi4n1*Wmass^2 + Cphi4n3*(-Wmass^2 + Zmass^2)), 0}, {I*Cphi4n1*gc459*Zmass^2, 0}, {I*gc459*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}},

C[ S[3] , S[3] , -S[3] , -S[3] , V[3] , -V[3] , V[2] ] == {{I*Cphi4n3*gc460, 0}, {I*Cphi4n3*gc460, 0}, {(-I)*Cphi4n3*gc460, 0}, {(-I)*Cphi4n3*gc460, 0}, {0, 0}, {0, 0}, {(-I)*Cphi4n1*gc460, 0}, {(-I)*Cphi4n1*gc460, 0}, {I*Cphi4n1*gc460, 0}, {I*Cphi4n1*gc460, 0}, {0, 0}, {0, 0}},

C[ S[3] , -S[3] , S[1] , V[3] , -V[3] , V[2] ] == {{(-I)*(Cphi4n1 + Cphi4n3)*gc461*(2*Wmass^2 - Zmass^2), 0}, {0, 0}, {I*gc461*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {I*Cphi4n1*gc461*Zmass^2, 0}, {I*gc461*(Cphi4n1*Wmass^2 + Cphi4n3*(-Wmass^2 + Zmass^2)), 0}, {(-I)*Cphi4n1*gc461*Zmass^2, 0}, {(-I)*gc461*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc461*(Cphi4n1*Wmass^2 + Cphi4n3*(-Wmass^2 + Zmass^2)), 0}, {I*(Cphi4n1 + Cphi4n3)*gc461*(2*Wmass^2 - Zmass^2), 0}},

C[ S[3] , -S[3] , S[1] , S[1] , V[3] , -V[3] , V[2] ] == {{(-I)*(Cphi4n1 + Cphi4n3)*gc462*(2*Wmass^2 - Zmass^2), 0}, {I*(Cphi4n1 + Cphi4n3)*gc462*(2*Wmass^2 - Zmass^2), 0}, {0, 0}, {0, 0}, {(-I)*gc462*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*Cphi4n1*gc462*Zmass^2, 0}, {(-I)*gc462*(Cphi4n1*Wmass^2 + Cphi4n3*(-Wmass^2 + Zmass^2)), 0}, {(-I)*gc462*(Cphi4n1*Wmass^2 + Cphi4n3*(-Wmass^2 + Zmass^2)), 0}, {I*Cphi4n1*gc462*Zmass^2, 0}, {I*gc462*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {I*gc462*(Cphi4n1*Wmass^2 + Cphi4n3*(-Wmass^2 + Zmass^2)), 0}, {I*gc462*(Cphi4n1*Wmass^2 + Cphi4n3*(-Wmass^2 + Zmass^2)), 0}},

C[ -S[3] , V[3] , V[3] , -V[3] , V[2] ] == {{((I/2)*gc463*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)))/(Cphi4n1*Zmass^2), 0}, {((I/2)*gc463*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)))/(Cphi4n1*Zmass^2), 0}, {I*gc463, 0}},

C[ S[2] , -S[3] , V[3] , V[3] , -V[3] , V[2] ] == {{(gc464*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)))/(2*Cphi4n1*Zmass^2), 0}, {(gc464*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)))/(2*Cphi4n1*Zmass^2), 0}, {gc464, 0}},

C[ S[2] , S[2] , -S[3] , V[3] , V[3] , -V[3] , V[2] ] == {{((I/2)*gc465*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)))/(Cphi4n1*Zmass^2), 0}, {((I/2)*gc465*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)))/(Cphi4n1*Zmass^2), 0}, {I*gc465, 0}},

C[ S[2] , S[2] , S[2] , -S[3] , V[3] , V[3] , -V[3] , V[2] ] == {{(gc466*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)))/(2*Cphi4n1*Zmass^2), 0}, {(gc466*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)))/(2*Cphi4n1*Zmass^2), 0}, {gc466, 0}},

C[ S[3] , -S[3] , -S[3] , V[3] , V[3] , -V[3] , V[2] ] == {{(-I)*gc467*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc467*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {(2*I)*Cphi4n1*gc467*(2*Wmass^2 - Zmass^2), 0}},

C[ S[2] , S[3] , -S[3] , -S[3] , V[3] , V[3] , -V[3] , V[2] ] == {{-(gc468*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2)), 0}, {-(gc468*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2)), 0}, {2*Cphi4n1*gc468*(2*Wmass^2 - Zmass^2), 0}},

C[ -S[3] , S[1] , V[3] , V[3] , -V[3] , V[2] ] == {{((I/2)*gc469*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)))/(Cphi4n1*Zmass^2), 0}, {((I/2)*gc469*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)))/(Cphi4n1*Zmass^2), 0}, {I*gc469, 0}},

C[ S[2] , -S[3] , S[1] , V[3] , V[3] , -V[3] , V[2] ] == {{(gc470*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)))/(2*Cphi4n1*Zmass^2), 0}, {(gc470*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)))/(2*Cphi4n1*Zmass^2), 0}, {gc470, 0}},

C[ S[2] , S[2] , -S[3] , S[1] , V[3] , V[3] , -V[3] , V[2] ] == {{((I/2)*gc471*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)))/(Cphi4n1*Zmass^2), 0}, {((I/2)*gc471*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)))/(Cphi4n1*Zmass^2), 0}, {I*gc471, 0}},

C[ S[3] , -S[3] , -S[3] , S[1] , V[3] , V[3] , -V[3] , V[2] ] == {{(-I)*gc472*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc472*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {(2*I)*Cphi4n1*gc472*(2*Wmass^2 - Zmass^2), 0}},

C[ -S[3] , S[1] , S[1] , V[3] , V[3] , -V[3] , V[2] ] == {{((I/2)*gc473*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)))/(Cphi4n1*Zmass^2), 0}, {((I/2)*gc473*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)))/(Cphi4n1*Zmass^2), 0}, {I*gc473, 0}},

C[ S[2] , -S[3] , S[1] , S[1] , V[3] , V[3] , -V[3] , V[2] ] == {{(gc474*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)))/(2*Cphi4n1*Zmass^2), 0}, {(gc474*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)))/(2*Cphi4n1*Zmass^2), 0}, {gc474, 0}},

C[ -S[3] , S[1] , S[1] , S[1] , V[3] , V[3] , -V[3] , V[2] ] == {{((I/2)*gc475*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)))/(Cphi4n1*Zmass^2), 0}, {((I/2)*gc475*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)))/(Cphi4n1*Zmass^2), 0}, {I*gc475, 0}},

C[ S[3] , S[3] , V[1] , -V[3] , -V[3] , V[2] ] == {{(2*I)*Cphi4n1*gc476*Zmass^2, 0}, {(-I)*gc476*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc476*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}},

C[ S[2] , S[3] , S[3] , V[1] , -V[3] , -V[3] , V[2] ] == {{2*Cphi4n1*gc477*Zmass^2, 0}, {gc477*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)), 0}, {gc477*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)), 0}},

C[ S[2] , S[2] , S[3] , S[3] , V[1] , -V[3] , -V[3] , V[2] ] == {{(2*I)*Cphi4n1*gc478*Zmass^2, 0}, {I*gc478*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)), 0}, {(-I)*gc478*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}},

C[ S[3] , S[3] , S[1] , V[1] , -V[3] , -V[3] , V[2] ] == {{(2*I)*Cphi4n1*gc479*Zmass^2, 0}, {(-I)*gc479*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc479*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}},

C[ S[2] , S[3] , S[3] , S[1] , V[1] , -V[3] , -V[3] , V[2] ] == {{2*Cphi4n1*gc480*Zmass^2, 0}, {gc480*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)), 0}, {gc480*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)), 0}},

C[ S[3] , S[3] , S[1] , S[1] , V[1] , -V[3] , -V[3] , V[2] ] == {{(2*I)*Cphi4n1*gc481*Zmass^2, 0}, {(-I)*gc481*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc481*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}},

C[ S[2] , S[3] , S[3] , -V[3] , -V[3] , V[2] ] == {{2*Cphi4n1*gc482*Zmass^2, 0}, {2*Cphi4n1*gc482*Zmass^2, 0}, {gc482*(-(Cphi4n1*Zmass^2) + 2*Cphi4n3*(Wmass^2 - Zmass^2)), 0}, {gc482*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)), 0}, {gc482*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)), 0}, {gc482*(-(Cphi4n1*Zmass^2) + 2*Cphi4n3*(Wmass^2 - Zmass^2)), 0}, {gc482*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)), 0}, {gc482*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)), 0}, {2*Cphi4n1*gc482*(2*Wmass^2 - Zmass^2), 0}},

C[ S[2] , S[2] , S[3] , S[3] , -V[3] , -V[3] , V[2] ] == {{(-2*I)*Cphi4n1*gc483*(2*Wmass^2 - Zmass^2), 0}, {(-2*I)*Cphi4n1*gc483*(2*Wmass^2 - Zmass^2), 0}, {(-2*I)*Cphi4n1*gc483*Zmass^2, 0}, {(-2*I)*Cphi4n1*gc483*Zmass^2, 0}, {I*gc483*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {I*gc483*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {I*gc483*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {I*gc483*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {I*gc483*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {I*gc483*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {I*gc483*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {I*gc483*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}},

C[ S[2] , S[3] , S[3] , S[1] , -V[3] , -V[3] , V[2] ] == {{2*Cphi4n1*gc484*(-2*Wmass^2 + Zmass^2), 0}, {-2*Cphi4n1*gc484*Zmass^2, 0}, {-2*Cphi4n1*gc484*Zmass^2, 0}, {2*Cphi4n1*gc484*(-2*Wmass^2 + Zmass^2), 0}, {gc484*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {gc484*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {gc484*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {gc484*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {gc484*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {gc484*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {gc484*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {gc484*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}},

C[ S[3] , S[3] , -V[3] , -V[3] , V[2] ] == {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {(2*I)*Cphi4n1*gc485*Zmass^2, 0}, {(-I)*gc485*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc485*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc485*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc485*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(2*I)*Cphi4n1*gc485*Zmass^2, 0}},

C[ S[3] , S[3] , S[1] , -V[3] , -V[3] , V[2] ] == {{(2*I)*Cphi4n1*gc486*Zmass^2, 0}, {(2*I)*Cphi4n1*gc486*(2*Wmass^2 - Zmass^2), 0}, {(-I)*gc486*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc486*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc486*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc486*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc486*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc486*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {(2*I)*Cphi4n1*gc486*Zmass^2, 0}},

C[ S[3] , S[3] , S[1] , S[1] , -V[3] , -V[3] , V[2] ] == {{(2*I)*Cphi4n1*gc487*Zmass^2, 0}, {(2*I)*Cphi4n1*gc487*Zmass^2, 0}, {(2*I)*Cphi4n1*gc487*(2*Wmass^2 - Zmass^2), 0}, {(2*I)*Cphi4n1*gc487*(2*Wmass^2 - Zmass^2), 0}, {(-I)*gc487*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc487*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc487*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc487*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc487*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc487*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc487*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc487*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}},

C[ S[3] , S[3] , -S[3] , V[3] , -V[3] , -V[3] , V[2] ] == {{(-2*I)*Cphi4n1*gc488*(2*Wmass^2 - Zmass^2), 0}, {I*gc488*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {I*gc488*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}},

C[ S[2] , S[3] , S[3] , -S[3] , V[3] , -V[3] , -V[3] , V[2] ] == {{2*Cphi4n1*gc489*(-2*Wmass^2 + Zmass^2), 0}, {gc489*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {gc489*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}},

C[ S[3] , S[3] , -S[3] , S[1] , V[3] , -V[3] , -V[3] , V[2] ] == {{(-2*I)*Cphi4n1*gc490*(2*Wmass^2 - Zmass^2), 0}, {I*gc490*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {I*gc490*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}},

C[ S[3] , V[3] , -V[3] , -V[3] , V[2] ] == {{(2*I)*Cphi4n1*gc491*Zmass^2, 0}, {(-I)*gc491*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc491*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}},

C[ S[2] , S[3] , V[3] , -V[3] , -V[3] , V[2] ] == {{2*Cphi4n1*gc492*Zmass^2, 0}, {gc492*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)), 0}, {gc492*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)), 0}},

C[ S[2] , S[2] , S[3] , V[3] , -V[3] , -V[3] , V[2] ] == {{(2*I)*Cphi4n1*gc493*Zmass^2, 0}, {(-I)*gc493*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc493*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}},

C[ S[2] , S[2] , S[2] , S[3] , V[3] , -V[3] , -V[3] , V[2] ] == {{2*Cphi4n1*gc494*Zmass^2, 0}, {gc494*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)), 0}, {gc494*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)), 0}},

C[ S[3] , S[1] , V[3] , -V[3] , -V[3] , V[2] ] == {{(2*I)*Cphi4n1*gc495*Zmass^2, 0}, {(-I)*gc495*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc495*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}},

C[ S[2] , S[3] , S[1] , V[3] , -V[3] , -V[3] , V[2] ] == {{2*Cphi4n1*gc496*Zmass^2, 0}, {gc496*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)), 0}, {gc496*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)), 0}},

C[ S[2] , S[2] , S[3] , S[1] , V[3] , -V[3] , -V[3] , V[2] ] == {{(2*I)*Cphi4n1*gc497*Zmass^2, 0}, {(-I)*gc497*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc497*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}},

C[ S[3] , S[1] , S[1] , V[3] , -V[3] , -V[3] , V[2] ] == {{(2*I)*Cphi4n1*gc498*Zmass^2, 0}, {(-I)*gc498*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc498*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}},

C[ S[2] , S[3] , S[1] , S[1] , V[3] , -V[3] , -V[3] , V[2] ] == {{2*Cphi4n1*gc499*Zmass^2, 0}, {gc499*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)), 0}, {gc499*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)), 0}},

C[ S[3] , S[1] , S[1] , S[1] , V[3] , -V[3] , -V[3] , V[2] ] == {{(2*I)*Cphi4n1*gc500*Zmass^2, 0}, {(-I)*gc500*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*gc500*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}},

C[ S[2] , S[2] , S[3] , -S[3] , V[2] , V[2] ] == {{(2*I)*Cphi4n1*gc501*Gf*Lam*(-2*Wmass^2 + Zmass^2)^2, 0}, {(2*I)*Cphi4n1*gc501*Gf*Lam*(-2*Wmass^2 + Zmass^2)^2, 0}, {(-I)*Cphi4n1*gc501*Gf*Lam*Zmass^2*(-2*Wmass^2 + Zmass^2), 0}, {(-I)*Cphi4n1*gc501*Gf*Lam*Zmass^2*(-2*Wmass^2 + Zmass^2), 0}, {(-I)*Cphi4n1*gc501*Gf*Lam*Zmass^2*(-2*Wmass^2 + Zmass^2), 0}, {(-I)*Cphi4n1*gc501*Gf*Lam*Zmass^2*(-2*Wmass^2 + Zmass^2), 0}, {(-I)*Cphi4n1*gc501*Gf*Lam*Zmass^2*(-2*Wmass^2 + Zmass^2), 0}, {(-I)*Cphi4n1*gc501*Gf*Lam*Zmass^2*(-2*Wmass^2 + Zmass^2), 0}, {(2*I)*Cphi4n1*gc501*Gf*Lam*Zmass^4, 0}, {(-I)*Cphi4n1*gc501*Gf*Lam*Zmass^2*(-2*Wmass^2 + Zmass^2), 0}, {(-I)*Cphi4n1*gc501*Gf*Lam*Zmass^2*(-2*Wmass^2 + Zmass^2), 0}, {(2*I)*Cphi4n1*gc501*Gf*Lam*Zmass^4, 0}, {I*Sqrt[2]*CphiD*gc501*Zmass^2*(2*Sqrt[2]*Gf*(2*Wmass^2 - Zmass^2) + Lam*(-2*CphiD*Wmass^2 + 2*CphiD*Zmass^2 + Cll2x1x1x2*(-2*Wmass^2 + Zmass^2) + 4*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2])), 0}, {(2*I)*Cphi4n1*gc501*Gf*Lam*Zmass^2*(-2*Wmass^2 + Zmass^2), 0}, {(2*I)*Cphi4n1*gc501*Gf*Lam*Zmass^2*(-2*Wmass^2 + Zmass^2), 0}, {(2*I)*Cphi4n1*gc501*Gf*Lam*Zmass^2*(-2*Wmass^2 + Zmass^2), 0}, {(2*I)*Cphi4n1*gc501*Gf*Lam*Zmass^2*(-2*Wmass^2 + Zmass^2), 0}, {(4*I)*Cphi4n3*gc501*Gf*Lam*(-2*Wmass^2 + Zmass^2)^2, 0}, {(4*I)*Cphi4n3*gc501*Gf*Lam*Zmass^4, 0}},

C[ S[3] , S[3] , -S[3] , -S[3] , V[2] , V[2] ] == {{(2*I)*(Cphi4n1 + Cphi4n3)*gc502*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}, {(2*I)*(Cphi4n1 + Cphi4n3)*gc502*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc502*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc502*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc502*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc502*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc502*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc502*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}, {(2*I)*(Cphi4n1 + Cphi4n3)*gc502*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc502*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc502*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}, {(2*I)*(Cphi4n1 + Cphi4n3)*gc502*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}, {(-I)*CphiD*gc502*(Gf*(8*Wmass^2 - 4*Zmass^2) + Sqrt[2]*Lam*(2*CphiD*Wmass^2 + CphiD*Zmass^2 + Cll2x1x1x2*(-2*Wmass^2 + Zmass^2) + 8*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2])), 0}, {(-2*I)*(Cphi4n1 + Cphi4n3)*gc502*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}, {(-2*I)*(Cphi4n1 + Cphi4n3)*gc502*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}, {(-2*I)*(Cphi4n1 + Cphi4n3)*gc502*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}, {(-2*I)*(Cphi4n1 + Cphi4n3)*gc502*Gf*Lam*(-2*Wmass^2 + Zmass^2), 0}, {0, 0}, {0, 0}},

C[ S[3] , -S[3] , S[1] , V[2] , V[2] ] == {{(4*I)*Cphi4n1*gc503*Gf*Lam*Zmass^2, 0}, {(2*I)*Cphi4n1*gc503*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {(2*I)*Cphi4n1*gc503*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {(2*I)*Cphi4n1*gc503*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {(-I)*CphiD*gc503*(8*Gf*(-2*Wmass^2 + Zmass^2) + Sqrt[2]*Lam*(2*Cll2x1x1x2*Wmass^2 - 8*CphiBox*Wmass^2 + 2*CphiD*Wmass^2 - Cll2x1x1x2*Zmass^2 + 4*CphiBox*Zmass^2 - 3*CphiD*Zmass^2 - 8*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2])), 0}, {(8*I)*Cphi4n3*gc503*Gf*Lam*Zmass^2, 0}, {(-4*I)*Cphi4n1*gc503*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {(4*I)*Cphi4n1*gc503*Gf*Lam*Zmass^2, 0}, {(-4*I)*Cphi4n1*gc503*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}, {(2*I)*Cphi4n1*gc503*Gf*Lam*(2*Wmass^2 - Zmass^2), 0}},

C[ S[3] , -S[3] , S[1] , S[1] , V[2] , V[2] ] == {{(2*I)*Cphi4n1*gc504*Gf*Lam*Zmass^4, 0}, {(2*I)*Cphi4n1*gc504*Gf*Lam*Zmass^4, 0}, {(-I)*Cphi4n1*gc504*Gf*Lam*Zmass^2*(-2*Wmass^2 + Zmass^2), 0}, {(-I)*Cphi4n1*gc504*Gf*Lam*Zmass^2*(-2*Wmass^2 + Zmass^2), 0}, {(-I)*Cphi4n1*gc504*Gf*Lam*Zmass^2*(-2*Wmass^2 + Zmass^2), 0}, {(-I)*Cphi4n1*gc504*Gf*Lam*Zmass^2*(-2*Wmass^2 + Zmass^2), 0}, {(-I)*Cphi4n1*gc504*Gf*Lam*Zmass^2*(-2*Wmass^2 + Zmass^2), 0}, {(-I)*Cphi4n1*gc504*Gf*Lam*Zmass^2*(-2*Wmass^2 + Zmass^2), 0}, {(2*I)*Cphi4n1*gc504*Gf*Lam*(-2*Wmass^2 + Zmass^2)^2, 0}, {(-I)*Cphi4n1*gc504*Gf*Lam*Zmass^2*(-2*Wmass^2 + Zmass^2), 0}, {(-I)*Cphi4n1*gc504*Gf*Lam*Zmass^2*(-2*Wmass^2 + Zmass^2), 0}, {(2*I)*Cphi4n1*gc504*Gf*Lam*(-2*Wmass^2 + Zmass^2)^2, 0}, {I*Sqrt[2]*CphiD*gc504*Zmass^2*(2*Sqrt[2]*Gf*(2*Wmass^2 - Zmass^2) + Lam*(8*CphiBox*Wmass^2 - 2*CphiD*Wmass^2 - 4*CphiBox*Zmass^2 + 2*CphiD*Zmass^2 + Cll2x1x1x2*(-2*Wmass^2 + Zmass^2) + 4*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2])), 0}, {(2*I)*Cphi4n1*gc504*Gf*Lam*Zmass^2*(-2*Wmass^2 + Zmass^2), 0}, {(2*I)*Cphi4n1*gc504*Gf*Lam*Zmass^2*(-2*Wmass^2 + Zmass^2), 0}, {(2*I)*Cphi4n1*gc504*Gf*Lam*Zmass^2*(-2*Wmass^2 + Zmass^2), 0}, {(2*I)*Cphi4n1*gc504*Gf*Lam*Zmass^2*(-2*Wmass^2 + Zmass^2), 0}, {(4*I)*Cphi4n3*gc504*Gf*Lam*Zmass^4, 0}, {(4*I)*Cphi4n3*gc504*Gf*Lam*(-2*Wmass^2 + Zmass^2)^2, 0}},

C[ S[2] , S[2] , S[2] , S[2] , V[2] , V[2] ] == {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {(3*I)*CphiD*gc505*(-2*Sqrt[2]*Gf + (Cll2x1x1x2 + 3*CphiD)*Lam)*(-4*Gf + Sqrt[2]*(Cll2x1x1x2 + 3*CphiD)*Lam), 0}, {(2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc505*Gf*Lam*(-4*Gf + Sqrt[2]*(Cll2x1x1x2 + 3*CphiD)*Lam), 0}, {(2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc505*Gf*Lam*(-4*Gf + Sqrt[2]*(Cll2x1x1x2 + 3*CphiD)*Lam), 0}, {(2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc505*Gf*Lam*(-4*Gf + Sqrt[2]*(Cll2x1x1x2 + 3*CphiD)*Lam), 0}, {(2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc505*Gf*Lam*(-4*Gf + Sqrt[2]*(Cll2x1x1x2 + 3*CphiD)*Lam), 0}, {(2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc505*Gf*Lam*(-4*Gf + Sqrt[2]*(Cll2x1x1x2 + 3*CphiD)*Lam), 0}, {(2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc505*Gf*Lam*(-4*Gf + Sqrt[2]*(Cll2x1x1x2 + 3*CphiD)*Lam), 0}},

C[ S[2] , S[2] , S[1] , V[2] , V[2] ] == {{(-8*I)*(Cphi4n1 + Cphi4n3)*gc506*Gf*Lam, 0}, {(4*I)*(Cphi4n1 + Cphi4n3)*gc506*Gf*Lam, 0}, {(4*I)*(Cphi4n1 + Cphi4n3)*gc506*Gf*Lam, 0}, {(4*I)*(Cphi4n1 + Cphi4n3)*gc506*Gf*Lam, 0}, {(-I)*CphiD*gc506*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 - 4*CphiBox + 5*CphiD)*Lam), 0}, {(-8*I)*(Cphi4n1 + Cphi4n3)*gc506*Gf*Lam, 0}, {0, 0}, {(-8*I)*(Cphi4n1 + Cphi4n3)*gc506*Gf*Lam, 0}, {0, 0}, {(4*I)*(Cphi4n1 + Cphi4n3)*gc506*Gf*Lam, 0}},

C[ S[2] , S[2] , S[1] , S[1] , V[2] , V[2] ] == {{(2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc507*Gf*Lam, 0}, {(2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc507*Gf*Lam, 0}, {(-I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc507*Gf*Lam, 0}, {(-I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc507*Gf*Lam, 0}, {(-I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc507*Gf*Lam, 0}, {(-I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc507*Gf*Lam, 0}, {(-I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc507*Gf*Lam, 0}, {(-I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc507*Gf*Lam, 0}, {(2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc507*Gf*Lam, 0}, {(-I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc507*Gf*Lam, 0}, {(-I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc507*Gf*Lam, 0}, {(2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc507*Gf*Lam, 0}, {I*CphiD*gc507*(-2*Sqrt[2]*Gf + (Cll2x1x1x2 - 4*CphiBox + 3*CphiD)*Lam), 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {(2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc507*Gf*Lam, 0}, {(2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc507*Gf*Lam, 0}},

C[ S[1] , S[1] , S[1] , V[2] , V[2] ] == {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {(3*I)*CphiD*gc508*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 - 12*CphiBox + 5*CphiD)*Lam), 0}, {(8*I)*(Cphi4n1 + Cphi4n3)*gc508*Gf*Lam, 0}, {(8*I)*(Cphi4n1 + Cphi4n3)*gc508*Gf*Lam, 0}, {0, 0}, {(8*I)*(Cphi4n1 + Cphi4n3)*gc508*Gf*Lam, 0}, {0, 0}},

C[ S[1] , S[1] , S[1] , S[1] , V[2] , V[2] ] == {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {(3*I)*CphiD*gc509*(-2*Sqrt[2]*Gf + (Cll2x1x1x2 - 8*CphiBox + 3*CphiD)*Lam)*(-4*Gf + Sqrt[2]*(Cll2x1x1x2 - 8*CphiBox + 3*CphiD)*Lam), 0}, {(2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc509*Gf*Lam*(-4*Gf + Sqrt[2]*(Cll2x1x1x2 - 8*CphiBox + 3*CphiD)*Lam), 0}, {(2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc509*Gf*Lam*(-4*Gf + Sqrt[2]*(Cll2x1x1x2 - 8*CphiBox + 3*CphiD)*Lam), 0}, {(2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc509*Gf*Lam*(-4*Gf + Sqrt[2]*(Cll2x1x1x2 - 8*CphiBox + 3*CphiD)*Lam), 0}, {(2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc509*Gf*Lam*(-4*Gf + Sqrt[2]*(Cll2x1x1x2 - 8*CphiBox + 3*CphiD)*Lam), 0}, {(2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc509*Gf*Lam*(-4*Gf + Sqrt[2]*(Cll2x1x1x2 - 8*CphiBox + 3*CphiD)*Lam), 0}, {(2*I)*Sqrt[2]*(Cphi4n1 + Cphi4n3)*gc509*Gf*Lam*(-4*Gf + Sqrt[2]*(Cll2x1x1x2 - 8*CphiBox + 3*CphiD)*Lam), 0}},

C[ S[2] , S[2] , S[2] , S[2] , V[3] , -V[3] , V[2] ] == {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {(-I)*gc510, 0}, {(-I)*gc510, 0}, {(-I)*gc510, 0}, {(-I)*gc510, 0}, {I*gc510, 0}, {I*gc510, 0}, {I*gc510, 0}, {I*gc510, 0}},

C[ S[2] , S[2] , S[1] , V[3] , -V[3] , V[2] ] == {{0, 0}, {0, 0}, {(-I)*gc511, 0}, {(-I)*gc511, 0}, {(-I)*gc511, 0}, {I*gc511, 0}, {I*gc511, 0}, {I*gc511, 0}, {0, 0}},

C[ S[2] , S[2] , S[1] , S[1] , V[3] , -V[3] , V[2] ] == {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {(-I)*gc512, 0}, {(-I)*gc512, 0}, {(-I)*gc512, 0}, {(-I)*gc512, 0}, {I*gc512, 0}, {I*gc512, 0}, {I*gc512, 0}, {I*gc512, 0}},

C[ S[1] , S[1] , S[1] , V[3] , -V[3] , V[2] ] == {{0, 0}, {0, 0}, {(-I)*gc513, 0}, {(-I)*gc513, 0}, {(-I)*gc513, 0}, {I*gc513, 0}, {I*gc513, 0}, {I*gc513, 0}, {0, 0}},

C[ S[1] , S[1] , S[1] , S[1] , V[3] , -V[3] , V[2] ] == {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {(-I)*gc514, 0}, {(-I)*gc514, 0}, {(-I)*gc514, 0}, {(-I)*gc514, 0}, {I*gc514, 0}, {I*gc514, 0}, {I*gc514, 0}, {I*gc514, 0}},

C[ S[3] , -S[3] , V[1] , V[1] , V[2] , V[2] ] == {{I*Cphi4n1*gc515, 0}, {I*Cphi4n1*gc515, 0}, {(2*I)*Cphi4n3*gc515, 0}},

C[ S[2] , S[2] , S[3] , -S[3] , V[1] , V[1] , V[2] , V[2] ] == {{I*Cphi4n1*gc516, 0}, {I*Cphi4n1*gc516, 0}, {(2*I)*Cphi4n3*gc516, 0}},

C[ S[3] , S[3] , -S[3] , -S[3] , V[1] , V[1] , V[2] , V[2] ] == {{I*gc517, 0}, {I*gc517, 0}, {I*gc517, 0}},

C[ S[3] , -S[3] , S[1] , V[1] , V[1] , V[2] , V[2] ] == {{I*Cphi4n1*gc518, 0}, {I*Cphi4n1*gc518, 0}, {(2*I)*Cphi4n3*gc518, 0}},

C[ S[3] , -S[3] , S[1] , S[1] , V[1] , V[1] , V[2] , V[2] ] == {{I*Cphi4n1*gc519, 0}, {I*Cphi4n1*gc519, 0}, {(2*I)*Cphi4n3*gc519, 0}},

C[ S[2] , S[3] , -S[3] , V[1] , V[2] , V[2] ] == {{0, 0}, {0, 0}, {(Cphi4n1 + 2*Cphi4n3)*gc520, 0}, {0, 0}, {0, 0}, {2*Cphi4n1*gc520, 0}, {0, 0}, {0, 0}, {(Cphi4n1 + 2*Cphi4n3)*gc520, 0}},

C[ S[2] , S[3] , -S[3] , S[1] , V[1] , V[2] , V[2] ] == {{-1/2*((Cphi4n1 + 2*Cphi4n3)*gc521)/Cphi4n1, 0}, {0, 0}, {0, 0}, {(1/2 + Cphi4n3/Cphi4n1)*gc521, 0}, {-1/2*((Cphi4n1 + 2*Cphi4n3)*gc521)/Cphi4n1, 0}, {0, 0}, {0, 0}, {(1/2 + Cphi4n3/Cphi4n1)*gc521, 0}, {-gc521, 0}, {0, 0}, {0, 0}, {gc521, 0}},

C[ S[3] , S[3] , -S[3] , -S[3] , V[1] , V[2] , V[2] ] == {{(-I)*gc522, 0}, {(-I)*gc522, 0}, {I*gc522, 0}, {I*gc522, 0}, {(-I)*gc522, 0}, {(-I)*gc522, 0}, {I*gc522, 0}, {I*gc522, 0}, {(-I)*gc522, 0}, {(-I)*gc522, 0}, {I*gc522, 0}, {I*gc522, 0}},

C[ S[3] , -S[3] , V[1] , V[2] , V[2] ] == {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {(-I)*Cphi4n1*gc523, 0}, {I*Cphi4n1*gc523, 0}, {(-2*I)*Cphi4n3*gc523, 0}, {(2*I)*Cphi4n3*gc523, 0}, {(-I)*Cphi4n1*gc523, 0}, {I*Cphi4n1*gc523, 0}},

C[ S[2] , S[2] , S[3] , -S[3] , V[1] , V[2] , V[2] ] == {{0, 0}, {0, 0}, {(-I)*Cphi4n1*gc524, 0}, {I*Cphi4n1*gc524, 0}, {0, 0}, {0, 0}, {(-I)*Cphi4n1*gc524, 0}, {I*Cphi4n1*gc524, 0}, {0, 0}, {0, 0}, {(-2*I)*Cphi4n3*gc524, 0}, {(2*I)*Cphi4n3*gc524, 0}},

C[ S[3] , -S[3] , S[1] , V[1] , V[2] , V[2] ] == {{(-I)*Cphi4n1*gc525, 0}, {0, 0}, {I*Cphi4n1*gc525, 0}, {(-I)*Cphi4n1*gc525, 0}, {0, 0}, {(2*I)*Cphi4n3*gc525, 0}, {(-2*I)*Cphi4n3*gc525, 0}, {0, 0}, {I*Cphi4n1*gc525, 0}},

C[ S[3] , -S[3] , S[1] , S[1] , V[1] , V[2] , V[2] ] == {{(-I)*Cphi4n1*gc526, 0}, {I*Cphi4n1*gc526, 0}, {0, 0}, {0, 0}, {(-I)*Cphi4n1*gc526, 0}, {I*Cphi4n1*gc526, 0}, {0, 0}, {0, 0}, {(-2*I)*Cphi4n3*gc526, 0}, {(2*I)*Cphi4n3*gc526, 0}, {0, 0}, {0, 0}},

C[ S[2] , S[3] , -S[3] , V[2] , V[2] ] == {{-((Cphi4n1 + 2*Cphi4n3)*gc527), 0}, {0, 0}, {(Cphi4n1 + 2*Cphi4n3)*gc527, 0}, {0, 0}, {0, 0}, {-2*Cphi4n1*gc527, 0}, {2*Cphi4n1*gc527, 0}, {-((Cphi4n1 + 2*Cphi4n3)*gc527), 0}, {0, 0}, {(Cphi4n1 + 2*Cphi4n3)*gc527, 0}},

C[ S[2] , S[3] , -S[3] , S[1] , V[2] , V[2] ] == {{(1/2 + Cphi4n3/Cphi4n1)*gc528, 0}, {(1/2 + Cphi4n3/Cphi4n1)*gc528, 0}, {-1/2*((Cphi4n1 + 2*Cphi4n3)*gc528)/Cphi4n1, 0}, {0, 0}, {-1/2*((Cphi4n1 + 2*Cphi4n3)*gc528)/Cphi4n1, 0}, {0, 0}, {0, 0}, {-1/2*((Cphi4n1 + 2*Cphi4n3)*gc528)/Cphi4n1, 0}, {(1/2 + Cphi4n3/Cphi4n1)*gc528, 0}, {0, 0}, {-1/2*((Cphi4n1 + 2*Cphi4n3)*gc528)/Cphi4n1, 0}, {(1/2 + Cphi4n3/Cphi4n1)*gc528, 0}, {0, 0}, {-gc528, 0}, {0, 0}, {0, 0}, {-gc528, 0}, {gc528, 0}, {gc528, 0}},

C[ S[3] , -S[3] , -S[3] , V[1] , V[3] , V[2] , V[2] ] == {{I*gc529*(4*Cphi4n1*Wmass^2 + 4*Cphi4n3*Wmass^2 - 3*Cphi4n1*Zmass^2 - 4*Cphi4n3*Zmass^2), 0}, {I*gc529*(4*Cphi4n1*Wmass^2 + 4*Cphi4n3*Wmass^2 - 3*Cphi4n1*Zmass^2 - 4*Cphi4n3*Zmass^2), 0}, {(2*I)*gc529*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - 2*Cphi4n1*Zmass^2 - Cphi4n3*Zmass^2), 0}},

C[ S[2] , S[3] , -S[3] , -S[3] , V[1] , V[3] , V[2] , V[2] ] == {{gc530*(4*Cphi4n1*Wmass^2 + 4*Cphi4n3*Wmass^2 - 3*Cphi4n1*Zmass^2 - 4*Cphi4n3*Zmass^2), 0}, {gc530*(4*Cphi4n1*Wmass^2 + 4*Cphi4n3*Wmass^2 - 3*Cphi4n1*Zmass^2 - 4*Cphi4n3*Zmass^2), 0}, {2*gc530*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - 2*Cphi4n1*Zmass^2 - Cphi4n3*Zmass^2), 0}},

C[ S[3] , -S[3] , -S[3] , S[1] , V[1] , V[3] , V[2] , V[2] ] == {{I*gc531*(4*Cphi4n1*Wmass^2 + 4*Cphi4n3*Wmass^2 - 3*Cphi4n1*Zmass^2 - 4*Cphi4n3*Zmass^2), 0}, {I*gc531*(4*Cphi4n1*Wmass^2 + 4*Cphi4n3*Wmass^2 - 3*Cphi4n1*Zmass^2 - 4*Cphi4n3*Zmass^2), 0}, {(2*I)*gc531*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - 2*Cphi4n1*Zmass^2 - Cphi4n3*Zmass^2), 0}},

C[ -S[3] , V[1] , V[3] , V[2] , V[2] ] == {{I*Cphi4n1*gc532, 0}, {I*Cphi4n1*gc532, 0}, {(2*I)*Cphi4n3*gc532, 0}},

C[ S[2] , -S[3] , V[1] , V[3] , V[2] , V[2] ] == {{Cphi4n1*gc533, 0}, {Cphi4n1*gc533, 0}, {2*Cphi4n3*gc533, 0}},

C[ S[2] , S[2] , -S[3] , V[1] , V[3] , V[2] , V[2] ] == {{I*Cphi4n1*gc534, 0}, {I*Cphi4n1*gc534, 0}, {(2*I)*Cphi4n3*gc534, 0}},

C[ S[2] , S[2] , S[2] , -S[3] , V[1] , V[3] , V[2] , V[2] ] == {{Cphi4n1*gc535, 0}, {Cphi4n1*gc535, 0}, {2*Cphi4n3*gc535, 0}},

C[ -S[3] , S[1] , V[1] , V[3] , V[2] , V[2] ] == {{I*Cphi4n1*gc536, 0}, {I*Cphi4n1*gc536, 0}, {(2*I)*Cphi4n3*gc536, 0}},

C[ S[2] , -S[3] , S[1] , V[1] , V[3] , V[2] , V[2] ] == {{Cphi4n1*gc537, 0}, {Cphi4n1*gc537, 0}, {2*Cphi4n3*gc537, 0}},

C[ S[2] , S[2] , -S[3] , S[1] , V[1] , V[3] , V[2] , V[2] ] == {{I*Cphi4n1*gc538, 0}, {I*Cphi4n1*gc538, 0}, {(2*I)*Cphi4n3*gc538, 0}},

C[ -S[3] , S[1] , S[1] , V[1] , V[3] , V[2] , V[2] ] == {{I*Cphi4n1*gc539, 0}, {I*Cphi4n1*gc539, 0}, {(2*I)*Cphi4n3*gc539, 0}},

C[ S[2] , -S[3] , S[1] , S[1] , V[1] , V[3] , V[2] , V[2] ] == {{Cphi4n1*gc540, 0}, {Cphi4n1*gc540, 0}, {2*Cphi4n3*gc540, 0}},

C[ -S[3] , S[1] , S[1] , S[1] , V[1] , V[3] , V[2] , V[2] ] == {{I*Cphi4n1*gc541, 0}, {I*Cphi4n1*gc541, 0}, {(2*I)*Cphi4n3*gc541, 0}},

C[ S[2] , S[2] , -S[3] , V[3] , V[2] , V[2] ] == {{I*gc542*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {I*Cphi4n1*gc542*Zmass^2, 0}, {I*gc542*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {I*gc542*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {I*Cphi4n1*gc542*Zmass^2, 0}, {(-2*I)*Cphi4n1*gc542*(2*Wmass^2 - Zmass^2), 0}, {(-2*I)*Cphi4n1*gc542*(2*Wmass^2 - Zmass^2), 0}, {(2*I)*Cphi4n3*gc542*Zmass^2, 0}, {I*gc542*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}},

C[ S[2] , S[2] , S[2] , -S[3] , V[3] , V[2] , V[2] ] == {{Cphi4n1*gc543*(2*Wmass^2 - Zmass^2), 0}, {Cphi4n1*gc543*(2*Wmass^2 - Zmass^2), 0}, {Cphi4n1*gc543*(2*Wmass^2 - Zmass^2), 0}, {3*Cphi4n1*gc543*Zmass^2, 0}, {Cphi4n1*gc543*(2*Wmass^2 - Zmass^2), 0}, {Cphi4n1*gc543*(2*Wmass^2 - Zmass^2), 0}, {Cphi4n1*gc543*(2*Wmass^2 - Zmass^2), 0}, {3*Cphi4n1*gc543*Zmass^2, 0}, {-2*gc543*(2*Cphi4n1*Wmass^2 + Cphi4n3*Zmass^2), 0}, {-2*gc543*(2*Cphi4n1*Wmass^2 + Cphi4n3*Zmass^2), 0}, {-2*gc543*(2*Cphi4n1*Wmass^2 + Cphi4n3*Zmass^2), 0}, {6*Cphi4n3*gc543*Zmass^2, 0}},

C[ S[2] , S[3] , -S[3] , -S[3] , V[3] , V[2] , V[2] ] == {{Cphi4n1*gc544*(-2*Wmass^2 + Zmass^2), 0}, {gc544*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)), 0}, {(Cphi4n1 + Cphi4n3)*gc544*(Wmass - Zmass)*(Wmass + Zmass), 0}, {(Cphi4n1 + Cphi4n3)*gc544*(Wmass - Zmass)*(Wmass + Zmass), 0}, {Cphi4n1*gc544*(-2*Wmass^2 + Zmass^2), 0}, {gc544*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)), 0}, {(Cphi4n1 + Cphi4n3)*gc544*(Wmass - Zmass)*(Wmass + Zmass), 0}, {(Cphi4n1 + Cphi4n3)*gc544*(Wmass - Zmass)*(Wmass + Zmass), 0}, {2*Cphi4n3*gc544*(-2*Wmass^2 + Zmass^2), 0}, {2*Cphi4n1*gc544*Zmass^2, 0}, {(Cphi4n1 + Cphi4n3)*gc544*(2*Wmass^2 - Zmass^2), 0}, {(Cphi4n1 + Cphi4n3)*gc544*(2*Wmass^2 - Zmass^2), 0}},

C[ S[2] , -S[3] , S[1] , V[3] , V[2] , V[2] ] == {{-(Cphi4n1*gc545*Zmass^2), 0}, {gc545*(-(Cphi4n1*Zmass^2) + 2*Cphi4n3*(Wmass^2 - Zmass^2)), 0}, {-(gc545*(2*Cphi4n1*Wmass^2 + 4*Cphi4n3*Wmass^2 - 3*Cphi4n1*Zmass^2 - 4*Cphi4n3*Zmass^2)), 0}, {-(Cphi4n1*gc545*Zmass^2), 0}, {gc545*(-(Cphi4n1*Zmass^2) + 2*Cphi4n3*(Wmass^2 - Zmass^2)), 0}, {2*gc545*(-2*Cphi4n1*Wmass^2 + 2*Cphi4n1*Zmass^2 + Cphi4n3*Zmass^2), 0}, {-2*Cphi4n3*gc545*Zmass^2, 0}, {2*Cphi4n1*gc545*(2*Wmass^2 - Zmass^2), 0}, {-(gc545*(2*Cphi4n1*Wmass^2 + 4*Cphi4n3*Wmass^2 - 3*Cphi4n1*Zmass^2 - 4*Cphi4n3*Zmass^2)), 0}},

C[ S[2] , S[2] , -S[3] , S[1] , V[3] , V[2] , V[2] ] == {{I*gc546*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {I*gc546*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {I*Cphi4n1*gc546*Zmass^2, 0}, {I*gc546*(2*Cphi4n1*Wmass^2 + 4*Cphi4n3*Wmass^2 - 3*Cphi4n1*Zmass^2 - 4*Cphi4n3*Zmass^2), 0}, {I*gc546*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {I*gc546*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {I*Cphi4n1*gc546*Zmass^2, 0}, {I*gc546*(2*Cphi4n1*Wmass^2 + 4*Cphi4n3*Wmass^2 - 3*Cphi4n1*Zmass^2 - 4*Cphi4n3*Zmass^2), 0}, {(-2*I)*Cphi4n1*gc546*(2*Wmass^2 - Zmass^2), 0}, {(-2*I)*Cphi4n1*gc546*(2*Wmass^2 - Zmass^2), 0}, {(2*I)*Cphi4n3*gc546*Zmass^2, 0}, {(-2*I)*gc546*(-2*Cphi4n1*Wmass^2 + 2*Cphi4n1*Zmass^2 + Cphi4n3*Zmass^2), 0}},

C[ S[2] , -S[3] , S[1] , S[1] , V[3] , V[2] , V[2] ] == {{gc547*(-2*Cphi4n1*Wmass^2 - 4*Cphi4n3*Wmass^2 + 3*Cphi4n1*Zmass^2 + 4*Cphi4n3*Zmass^2), 0}, {-(Cphi4n1*gc547*Zmass^2), 0}, {gc547*(-(Cphi4n1*Zmass^2) + 2*Cphi4n3*(Wmass^2 - Zmass^2)), 0}, {gc547*(-(Cphi4n1*Zmass^2) + 2*Cphi4n3*(Wmass^2 - Zmass^2)), 0}, {-(gc547*(2*Cphi4n1*Wmass^2 + 4*Cphi4n3*Wmass^2 - 3*Cphi4n1*Zmass^2 - 4*Cphi4n3*Zmass^2)), 0}, {-(Cphi4n1*gc547*Zmass^2), 0}, {gc547*(-(Cphi4n1*Zmass^2) + 2*Cphi4n3*(Wmass^2 - Zmass^2)), 0}, {gc547*(-(Cphi4n1*Zmass^2) + 2*Cphi4n3*(Wmass^2 - Zmass^2)), 0}, {2*gc547*(-2*Cphi4n1*Wmass^2 + 2*Cphi4n1*Zmass^2 + Cphi4n3*Zmass^2), 0}, {-2*Cphi4n3*gc547*Zmass^2, 0}, {2*Cphi4n1*gc547*(2*Wmass^2 - Zmass^2), 0}, {2*Cphi4n1*gc547*(2*Wmass^2 - Zmass^2), 0}},

C[ S[3] , -S[3] , -S[3] , V[3] , V[2] , V[2] ] == {{I*(Cphi4n1 + Cphi4n3)*gc548*(Wmass^2 - Zmass^2), 0}, {I*(Cphi4n1 + Cphi4n3)*gc548*(Wmass^2 - Zmass^2), 0}, {(-I)*gc548*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {I*(Cphi4n1 + Cphi4n3)*gc548*(Wmass - Zmass)*(Wmass + Zmass), 0}, {I*(Cphi4n1 + Cphi4n3)*gc548*(Wmass - Zmass)*(Wmass + Zmass), 0}, {(2*I)*Cphi4n1*gc548*Zmass^2, 0}, {I*(Cphi4n1 + Cphi4n3)*gc548*(2*Wmass^2 - Zmass^2), 0}, {I*(Cphi4n1 + Cphi4n3)*gc548*(2*Wmass^2 - Zmass^2), 0}, {(-I)*gc548*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}},

C[ S[3] , -S[3] , -S[3] , S[1] , V[3] , V[2] , V[2] ] == {{I*gc549*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc549*(Wmass^2 - Zmass^2), 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc549*(Wmass - Zmass)*(Wmass + Zmass), 0}, {I*Cphi4n1*gc549*(2*Wmass^2 - Zmass^2), 0}, {I*gc549*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc549*(Wmass - Zmass)*(Wmass + Zmass), 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc549*(Wmass - Zmass)*(Wmass + Zmass), 0}, {I*Cphi4n1*gc549*(2*Wmass^2 - Zmass^2), 0}, {(-2*I)*Cphi4n1*gc549*Zmass^2, 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc549*(2*Wmass^2 - Zmass^2), 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc549*(2*Wmass^2 - Zmass^2), 0}, {(2*I)*Cphi4n3*gc549*(2*Wmass^2 - Zmass^2), 0}},

C[ -S[3] , S[1] , S[1] , V[3] , V[2] , V[2] ] == {{I*Cphi4n1*gc550*(2*Wmass^2 - Zmass^2), 0}, {I*Cphi4n1*gc550*(2*Wmass^2 - Zmass^2), 0}, {(3*I)*Cphi4n1*gc550*Zmass^2, 0}, {I*Cphi4n1*gc550*(2*Wmass^2 - Zmass^2), 0}, {I*Cphi4n1*gc550*(2*Wmass^2 - Zmass^2), 0}, {(6*I)*Cphi4n3*gc550*Zmass^2, 0}, {(-2*I)*gc550*(2*Cphi4n1*Wmass^2 + Cphi4n3*Zmass^2), 0}, {(-2*I)*gc550*(2*Cphi4n1*Wmass^2 + Cphi4n3*Zmass^2), 0}, {(3*I)*Cphi4n1*gc550*Zmass^2, 0}},

C[ -S[3] , S[1] , S[1] , S[1] , V[3] , V[2] , V[2] ] == {{(-3*I)*Cphi4n1*gc551*Zmass^2, 0}, {(-I)*Cphi4n1*gc551*(2*Wmass^2 - Zmass^2), 0}, {(-I)*Cphi4n1*gc551*(2*Wmass^2 - Zmass^2), 0}, {(-I)*Cphi4n1*gc551*(2*Wmass^2 - Zmass^2), 0}, {(-3*I)*Cphi4n1*gc551*Zmass^2, 0}, {(-I)*Cphi4n1*gc551*(2*Wmass^2 - Zmass^2), 0}, {(-I)*Cphi4n1*gc551*(2*Wmass^2 - Zmass^2), 0}, {(-I)*Cphi4n1*gc551*(2*Wmass^2 - Zmass^2), 0}, {(-6*I)*Cphi4n3*gc551*Zmass^2, 0}, {(2*I)*gc551*(2*Cphi4n1*Wmass^2 + Cphi4n3*Zmass^2), 0}, {(2*I)*gc551*(2*Cphi4n1*Wmass^2 + Cphi4n3*Zmass^2), 0}, {(2*I)*gc551*(2*Cphi4n1*Wmass^2 + Cphi4n3*Zmass^2), 0}},

C[ -S[3] , -S[3] , V[3] , V[3] , V[2] , V[2] ] == {{I*gc552*(2*Cphi4n3*(Wmass^2 - Zmass^2)^2 + Cphi4n1*(2*Wmass^4 - 2*Wmass^2*Zmass^2 + Zmass^4)), 0}, {I*gc552*(2*Cphi4n3*(Wmass^2 - Zmass^2)^2 + Cphi4n1*(2*Wmass^4 - 2*Wmass^2*Zmass^2 + Zmass^4)), 0}, {(2*I)*Cphi4n1*gc552*Zmass^2*(-2*Wmass^2 + Zmass^2), 0}},

C[ S[2] , -S[3] , -S[3] , V[3] , V[3] , V[2] , V[2] ] == {{gc553*(2*Cphi4n3*(Wmass^2 - Zmass^2)^2 + Cphi4n1*(2*Wmass^4 - 2*Wmass^2*Zmass^2 + Zmass^4)), 0}, {gc553*(2*Cphi4n3*(Wmass^2 - Zmass^2)^2 + Cphi4n1*(2*Wmass^4 - 2*Wmass^2*Zmass^2 + Zmass^4)), 0}, {2*Cphi4n1*gc553*Zmass^2*(-2*Wmass^2 + Zmass^2), 0}},

C[ S[2] , S[2] , -S[3] , -S[3] , V[3] , V[3] , V[2] , V[2] ] == {{I*gc554*(2*Cphi4n3*(Wmass^2 - Zmass^2)^2 + Cphi4n1*(2*Wmass^4 - 2*Wmass^2*Zmass^2 + Zmass^4)), 0}, {I*gc554*(2*Cphi4n3*(Wmass^2 - Zmass^2)^2 + Cphi4n1*(2*Wmass^4 - 2*Wmass^2*Zmass^2 + Zmass^4)), 0}, {(2*I)*Cphi4n1*gc554*Zmass^2*(-2*Wmass^2 + Zmass^2), 0}},

C[ -S[3] , -S[3] , S[1] , V[3] , V[3] , V[2] , V[2] ] == {{I*gc555*(2*Cphi4n3*(Wmass^2 - Zmass^2)^2 + Cphi4n1*(2*Wmass^4 - 2*Wmass^2*Zmass^2 + Zmass^4)), 0}, {I*gc555*(2*Cphi4n3*(Wmass^2 - Zmass^2)^2 + Cphi4n1*(2*Wmass^4 - 2*Wmass^2*Zmass^2 + Zmass^4)), 0}, {(2*I)*Cphi4n1*gc555*Zmass^2*(-2*Wmass^2 + Zmass^2), 0}},

C[ S[2] , -S[3] , -S[3] , S[1] , V[3] , V[3] , V[2] , V[2] ] == {{gc556*(2*Cphi4n3*(Wmass^2 - Zmass^2)^2 + Cphi4n1*(2*Wmass^4 - 2*Wmass^2*Zmass^2 + Zmass^4)), 0}, {gc556*(2*Cphi4n3*(Wmass^2 - Zmass^2)^2 + Cphi4n1*(2*Wmass^4 - 2*Wmass^2*Zmass^2 + Zmass^4)), 0}, {2*Cphi4n1*gc556*Zmass^2*(-2*Wmass^2 + Zmass^2), 0}},

C[ -S[3] , -S[3] , S[1] , S[1] , V[3] , V[3] , V[2] , V[2] ] == {{I*gc557*(2*Cphi4n3*(Wmass^2 - Zmass^2)^2 + Cphi4n1*(2*Wmass^4 - 2*Wmass^2*Zmass^2 + Zmass^4)), 0}, {I*gc557*(2*Cphi4n3*(Wmass^2 - Zmass^2)^2 + Cphi4n1*(2*Wmass^4 - 2*Wmass^2*Zmass^2 + Zmass^4)), 0}, {(2*I)*Cphi4n1*gc557*Zmass^2*(-2*Wmass^2 + Zmass^2), 0}},

C[ S[3] , S[3] , -S[3] , V[1] , -V[3] , V[2] , V[2] ] == {{I*gc558*(4*Cphi4n1*Wmass^2 + 4*Cphi4n3*Wmass^2 - 3*Cphi4n1*Zmass^2 - 4*Cphi4n3*Zmass^2), 0}, {I*gc558*(4*Cphi4n1*Wmass^2 + 4*Cphi4n3*Wmass^2 - 3*Cphi4n1*Zmass^2 - 4*Cphi4n3*Zmass^2), 0}, {(2*I)*gc558*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - 2*Cphi4n1*Zmass^2 - Cphi4n3*Zmass^2), 0}},

C[ S[2] , S[3] , S[3] , -S[3] , V[1] , -V[3] , V[2] , V[2] ] == {{gc559*(4*Cphi4n1*Wmass^2 + 4*Cphi4n3*Wmass^2 - 3*Cphi4n1*Zmass^2 - 4*Cphi4n3*Zmass^2), 0}, {gc559*(4*Cphi4n1*Wmass^2 + 4*Cphi4n3*Wmass^2 - 3*Cphi4n1*Zmass^2 - 4*Cphi4n3*Zmass^2), 0}, {2*gc559*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - 2*Cphi4n1*Zmass^2 - Cphi4n3*Zmass^2), 0}},

C[ S[3] , S[3] , -S[3] , S[1] , V[1] , -V[3] , V[2] , V[2] ] == {{I*gc560*(4*Cphi4n1*Wmass^2 + 4*Cphi4n3*Wmass^2 - 3*Cphi4n1*Zmass^2 - 4*Cphi4n3*Zmass^2), 0}, {I*gc560*(4*Cphi4n1*Wmass^2 + 4*Cphi4n3*Wmass^2 - 3*Cphi4n1*Zmass^2 - 4*Cphi4n3*Zmass^2), 0}, {(2*I)*gc560*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - 2*Cphi4n1*Zmass^2 - Cphi4n3*Zmass^2), 0}},

C[ S[3] , V[1] , -V[3] , V[2] , V[2] ] == {{I*Cphi4n1*gc561, 0}, {I*Cphi4n1*gc561, 0}, {(2*I)*Cphi4n3*gc561, 0}},

C[ S[2] , S[3] , V[1] , -V[3] , V[2] , V[2] ] == {{Cphi4n1*gc562, 0}, {Cphi4n1*gc562, 0}, {2*Cphi4n3*gc562, 0}},

C[ S[2] , S[2] , S[3] , V[1] , -V[3] , V[2] , V[2] ] == {{I*Cphi4n1*gc563, 0}, {I*Cphi4n1*gc563, 0}, {(2*I)*Cphi4n3*gc563, 0}},

C[ S[2] , S[2] , S[2] , S[3] , V[1] , -V[3] , V[2] , V[2] ] == {{Cphi4n1*gc564, 0}, {Cphi4n1*gc564, 0}, {2*Cphi4n3*gc564, 0}},

C[ S[3] , S[1] , V[1] , -V[3] , V[2] , V[2] ] == {{I*Cphi4n1*gc565, 0}, {I*Cphi4n1*gc565, 0}, {(2*I)*Cphi4n3*gc565, 0}},

C[ S[2] , S[3] , S[1] , V[1] , -V[3] , V[2] , V[2] ] == {{Cphi4n1*gc566, 0}, {Cphi4n1*gc566, 0}, {2*Cphi4n3*gc566, 0}},

C[ S[2] , S[2] , S[3] , S[1] , V[1] , -V[3] , V[2] , V[2] ] == {{I*Cphi4n1*gc567, 0}, {I*Cphi4n1*gc567, 0}, {(2*I)*Cphi4n3*gc567, 0}},

C[ S[3] , S[1] , S[1] , V[1] , -V[3] , V[2] , V[2] ] == {{I*Cphi4n1*gc568, 0}, {I*Cphi4n1*gc568, 0}, {(2*I)*Cphi4n3*gc568, 0}},

C[ S[2] , S[3] , S[1] , S[1] , V[1] , -V[3] , V[2] , V[2] ] == {{Cphi4n1*gc569, 0}, {Cphi4n1*gc569, 0}, {2*Cphi4n3*gc569, 0}},

C[ S[3] , S[1] , S[1] , S[1] , V[1] , -V[3] , V[2] , V[2] ] == {{I*Cphi4n1*gc570, 0}, {I*Cphi4n1*gc570, 0}, {(2*I)*Cphi4n3*gc570, 0}},

C[ S[2] , S[2] , S[3] , -V[3] , V[2] , V[2] ] == {{I*gc571*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {I*Cphi4n1*gc571*Zmass^2, 0}, {I*gc571*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {I*gc571*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {I*Cphi4n1*gc571*Zmass^2, 0}, {(-2*I)*Cphi4n1*gc571*(2*Wmass^2 - Zmass^2), 0}, {(-2*I)*Cphi4n1*gc571*(2*Wmass^2 - Zmass^2), 0}, {(2*I)*Cphi4n3*gc571*Zmass^2, 0}, {I*gc571*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}},

C[ S[2] , S[2] , S[2] , S[3] , -V[3] , V[2] , V[2] ] == {{Cphi4n1*gc572*(2*Wmass^2 - Zmass^2), 0}, {Cphi4n1*gc572*(2*Wmass^2 - Zmass^2), 0}, {Cphi4n1*gc572*(2*Wmass^2 - Zmass^2), 0}, {3*Cphi4n1*gc572*Zmass^2, 0}, {Cphi4n1*gc572*(2*Wmass^2 - Zmass^2), 0}, {Cphi4n1*gc572*(2*Wmass^2 - Zmass^2), 0}, {Cphi4n1*gc572*(2*Wmass^2 - Zmass^2), 0}, {3*Cphi4n1*gc572*Zmass^2, 0}, {-2*gc572*(2*Cphi4n1*Wmass^2 + Cphi4n3*Zmass^2), 0}, {-2*gc572*(2*Cphi4n1*Wmass^2 + Cphi4n3*Zmass^2), 0}, {-2*gc572*(2*Cphi4n1*Wmass^2 + Cphi4n3*Zmass^2), 0}, {6*Cphi4n3*gc572*Zmass^2, 0}},

C[ S[2] , S[3] , S[3] , -S[3] , -V[3] , V[2] , V[2] ] == {{Cphi4n1*gc573*(-2*Wmass^2 + Zmass^2), 0}, {(Cphi4n1 + Cphi4n3)*gc573*(Wmass^2 - Zmass^2), 0}, {(Cphi4n1 + Cphi4n3)*gc573*(Wmass - Zmass)*(Wmass + Zmass), 0}, {gc573*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)), 0}, {Cphi4n1*gc573*(-2*Wmass^2 + Zmass^2), 0}, {(Cphi4n1 + Cphi4n3)*gc573*(Wmass - Zmass)*(Wmass + Zmass), 0}, {(Cphi4n1 + Cphi4n3)*gc573*(Wmass - Zmass)*(Wmass + Zmass), 0}, {gc573*(Cphi4n1*(-2*Wmass^2 + Zmass^2) + 2*Cphi4n3*(-Wmass^2 + Zmass^2)), 0}, {2*Cphi4n3*gc573*(-2*Wmass^2 + Zmass^2), 0}, {(Cphi4n1 + Cphi4n3)*gc573*(2*Wmass^2 - Zmass^2), 0}, {(Cphi4n1 + Cphi4n3)*gc573*(2*Wmass^2 - Zmass^2), 0}, {2*Cphi4n1*gc573*Zmass^2, 0}},

C[ S[2] , S[3] , S[1] , -V[3] , V[2] , V[2] ] == {{-(Cphi4n1*gc574*Zmass^2), 0}, {gc574*(-(Cphi4n1*Zmass^2) + 2*Cphi4n3*(Wmass^2 - Zmass^2)), 0}, {-(gc574*(2*Cphi4n1*Wmass^2 + 4*Cphi4n3*Wmass^2 - 3*Cphi4n1*Zmass^2 - 4*Cphi4n3*Zmass^2)), 0}, {-(Cphi4n1*gc574*Zmass^2), 0}, {gc574*(-(Cphi4n1*Zmass^2) + 2*Cphi4n3*(Wmass^2 - Zmass^2)), 0}, {2*gc574*(-2*Cphi4n1*Wmass^2 + 2*Cphi4n1*Zmass^2 + Cphi4n3*Zmass^2), 0}, {-2*Cphi4n3*gc574*Zmass^2, 0}, {2*Cphi4n1*gc574*(2*Wmass^2 - Zmass^2), 0}, {-(gc574*(2*Cphi4n1*Wmass^2 + 4*Cphi4n3*Wmass^2 - 3*Cphi4n1*Zmass^2 - 4*Cphi4n3*Zmass^2)), 0}},

C[ S[2] , S[2] , S[3] , S[1] , -V[3] , V[2] , V[2] ] == {{I*gc575*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {I*gc575*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {I*Cphi4n1*gc575*Zmass^2, 0}, {I*gc575*(2*Cphi4n1*Wmass^2 + 4*Cphi4n3*Wmass^2 - 3*Cphi4n1*Zmass^2 - 4*Cphi4n3*Zmass^2), 0}, {I*gc575*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {I*gc575*(-2*Cphi4n3*Wmass^2 + Cphi4n1*Zmass^2 + 2*Cphi4n3*Zmass^2), 0}, {I*Cphi4n1*gc575*Zmass^2, 0}, {I*gc575*(2*Cphi4n1*Wmass^2 + 4*Cphi4n3*Wmass^2 - 3*Cphi4n1*Zmass^2 - 4*Cphi4n3*Zmass^2), 0}, {(-2*I)*Cphi4n1*gc575*(2*Wmass^2 - Zmass^2), 0}, {(-2*I)*Cphi4n1*gc575*(2*Wmass^2 - Zmass^2), 0}, {(2*I)*Cphi4n3*gc575*Zmass^2, 0}, {(-2*I)*gc575*(-2*Cphi4n1*Wmass^2 + 2*Cphi4n1*Zmass^2 + Cphi4n3*Zmass^2), 0}},

C[ S[2] , S[3] , S[1] , S[1] , -V[3] , V[2] , V[2] ] == {{gc576*(-2*Cphi4n1*Wmass^2 - 4*Cphi4n3*Wmass^2 + 3*Cphi4n1*Zmass^2 + 4*Cphi4n3*Zmass^2), 0}, {-(Cphi4n1*gc576*Zmass^2), 0}, {gc576*(-(Cphi4n1*Zmass^2) + 2*Cphi4n3*(Wmass^2 - Zmass^2)), 0}, {gc576*(-(Cphi4n1*Zmass^2) + 2*Cphi4n3*(Wmass^2 - Zmass^2)), 0}, {-(gc576*(2*Cphi4n1*Wmass^2 + 4*Cphi4n3*Wmass^2 - 3*Cphi4n1*Zmass^2 - 4*Cphi4n3*Zmass^2)), 0}, {-(Cphi4n1*gc576*Zmass^2), 0}, {gc576*(-(Cphi4n1*Zmass^2) + 2*Cphi4n3*(Wmass^2 - Zmass^2)), 0}, {gc576*(-(Cphi4n1*Zmass^2) + 2*Cphi4n3*(Wmass^2 - Zmass^2)), 0}, {2*gc576*(-2*Cphi4n1*Wmass^2 + 2*Cphi4n1*Zmass^2 + Cphi4n3*Zmass^2), 0}, {-2*Cphi4n3*gc576*Zmass^2, 0}, {2*Cphi4n1*gc576*(2*Wmass^2 - Zmass^2), 0}, {2*Cphi4n1*gc576*(2*Wmass^2 - Zmass^2), 0}},

C[ S[3] , S[3] , -S[3] , -V[3] , V[2] , V[2] ] == {{I*(Cphi4n1 + Cphi4n3)*gc577*(Wmass^2 - Zmass^2), 0}, {(-I)*gc577*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {I*(Cphi4n1 + Cphi4n3)*gc577*(Wmass - Zmass)*(Wmass + Zmass), 0}, {I*(Cphi4n1 + Cphi4n3)*gc577*(Wmass - Zmass)*(Wmass + Zmass), 0}, {(-I)*gc577*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {I*(Cphi4n1 + Cphi4n3)*gc577*(2*Wmass^2 - Zmass^2), 0}, {I*(Cphi4n1 + Cphi4n3)*gc577*(2*Wmass^2 - Zmass^2), 0}, {(2*I)*Cphi4n1*gc577*Zmass^2, 0}, {I*(Cphi4n1 + Cphi4n3)*gc577*(Wmass - Zmass)*(Wmass + Zmass), 0}},

C[ S[3] , S[3] , -S[3] , S[1] , -V[3] , V[2] , V[2] ] == {{(-I)*(Cphi4n1 + Cphi4n3)*gc578*(Wmass^2 - Zmass^2), 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc578*(Wmass^2 - Zmass^2), 0}, {I*gc578*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {I*Cphi4n1*gc578*(2*Wmass^2 - Zmass^2), 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc578*(Wmass - Zmass)*(Wmass + Zmass), 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc578*(Wmass - Zmass)*(Wmass + Zmass), 0}, {I*gc578*(2*Cphi4n1*Wmass^2 + 2*Cphi4n3*Wmass^2 - Cphi4n1*Zmass^2 - 2*Cphi4n3*Zmass^2), 0}, {I*Cphi4n1*gc578*(2*Wmass^2 - Zmass^2), 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc578*(2*Wmass^2 - Zmass^2), 0}, {(-I)*(Cphi4n1 + Cphi4n3)*gc578*(2*Wmass^2 - Zmass^2), 0}, {(-2*I)*Cphi4n1*gc578*Zmass^2, 0}, {(2*I)*Cphi4n3*gc578*(2*Wmass^2 - Zmass^2), 0}},

C[ S[3] , S[1] , S[1] , -V[3] , V[2] , V[2] ] == {{I*Cphi4n1*gc579*(2*Wmass^2 - Zmass^2), 0}, {I*Cphi4n1*gc579*(2*Wmass^2 - Zmass^2), 0}, {(3*I)*Cphi4n1*gc579*Zmass^2, 0}, {I*Cphi4n1*gc579*(2*Wmass^2 - Zmass^2), 0}, {I*Cphi4n1*gc579*(2*Wmass^2 - Zmass^2), 0}, {(6*I)*Cphi4n3*gc579*Zmass^2, 0}, {(-2*I)*gc579*(2*Cphi4n1*Wmass^2 + Cphi4n3*Zmass^2), 0}, {(-2*I)*gc579*(2*Cphi4n1*Wmass^2 + Cphi4n3*Zmass^2), 0}, {(3*I)*Cphi4n1*gc579*Zmass^2, 0}},

C[ S[3] , S[1] , S[1] , S[1] , -V[3] , V[2] , V[2] ] == {{(-3*I)*Cphi4n1*gc580*Zmass^2, 0}, {(-I)*Cphi4n1*gc580*(2*Wmass^2 - Zmass^2), 0}, {(-I)*Cphi4n1*gc580*(2*Wmass^2 - Zmass^2), 0}, {(-I)*Cphi4n1*gc580*(2*Wmass^2 - Zmass^2), 0}, {(-3*I)*Cphi4n1*gc580*Zmass^2, 0}, {(-I)*Cphi4n1*gc580*(2*Wmass^2 - Zmass^2), 0}, {(-I)*Cphi4n1*gc580*(2*Wmass^2 - Zmass^2), 0}, {(-I)*Cphi4n1*gc580*(2*Wmass^2 - Zmass^2), 0}, {(-6*I)*Cphi4n3*gc580*Zmass^2, 0}, {(2*I)*gc580*(2*Cphi4n1*Wmass^2 + Cphi4n3*Zmass^2), 0}, {(2*I)*gc580*(2*Cphi4n1*Wmass^2 + Cphi4n3*Zmass^2), 0}, {(2*I)*gc580*(2*Cphi4n1*Wmass^2 + Cphi4n3*Zmass^2), 0}},

C[ V[3] , -V[3] , V[2] , V[2] ] == {{I*gc581*(8*Sqrt[2]*CphiWB^2*Lam^2*(-Wmass^2 + Zmass^2)^(3/2) - 4*CphiWB*Lam*Wmass*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(2*CphiD*Wmass^2 + 4*CphiW*Wmass^2 - CphiD*Zmass^2 - 4*CphiW*Zmass^2)) + Sqrt[-Wmass^2 + Zmass^2]*(16*Sqrt[2]*Gf^2*Wmass^2 - 3*Sqrt[2]*Cll2x1x1x2^2*Lam^2*Wmass^2 + 4*Gf*Lam*(-2*Cll2x1x1x2*Wmass^2 + 2*CphiD*Wmass^2 + Cphi4n1*Lam*Zmass^4))), 0}, {I*gc581*(8*Sqrt[2]*CphiWB^2*Lam^2*(-Wmass^2 + Zmass^2)^(3/2) - 4*CphiWB*Lam*Wmass*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(2*CphiD*Wmass^2 + 4*CphiW*Wmass^2 - CphiD*Zmass^2 - 4*CphiW*Zmass^2)) + Sqrt[-Wmass^2 + Zmass^2]*(16*Sqrt[2]*Gf^2*Wmass^2 - 3*Sqrt[2]*Cll2x1x1x2^2*Lam^2*Wmass^2 + 4*Gf*Lam*(-2*Cll2x1x1x2*Wmass^2 + 2*CphiD*Wmass^2 + Cphi4n1*Lam*Zmass^4))), 0}, {(2*I)*gc581*(-8*Sqrt[2]*CphiWB^2*Lam^2*(-Wmass^2 + Zmass^2)^(3/2) + 4*CphiWB*Lam*Wmass*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(2*CphiD*Wmass^2 + 4*CphiW*Wmass^2 - CphiD*Zmass^2 - 4*CphiW*Zmass^2)) + Sqrt[-Wmass^2 + Zmass^2]*(-16*Sqrt[2]*Gf^2*Wmass^2 + 3*Sqrt[2]*Cll2x1x1x2^2*Lam^2*Wmass^2 + 4*Gf*Lam*(2*Cll2x1x1x2*Wmass^2 - 2*CphiD*Wmass^2 + Cphi4n3*Lam*Zmass^4))), 0}},

C[ S[3] , -S[3] , V[3] , -V[3] , V[2] , V[2] ] == {{I*gc582*(-4*CphiW^2*Lam*Wmass^2 + Sqrt[2]*(Cphi4n1 + Cphi4n3)*Gf*Lam*(Wmass^2 - Zmass^2)^2 - CphiW*Wmass*(2*Sqrt[2]*Gf*Wmass + Lam*(-(Cll2x1x1x2*Wmass) + CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2]))), 0}, {I*gc582*(-4*CphiW^2*Lam*Wmass^2 + Sqrt[2]*(Cphi4n1 + Cphi4n3)*Gf*Lam*(Wmass^2 - Zmass^2)^2 - CphiW*Wmass*(2*Sqrt[2]*Gf*Wmass + Lam*(-(Cll2x1x1x2*Wmass) + CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2]))), 0}, {I*gc582*(8*CphiW^2*Lam*Wmass^2 + Sqrt[2]*(Cphi4n1 + Cphi4n3)*Gf*Lam*(2*Wmass^4 - 2*Wmass^2*Zmass^2 + Zmass^4) + 2*CphiW*Wmass*(2*Sqrt[2]*Gf*Wmass + Lam*(-(Cll2x1x1x2*Wmass) + CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2]))), 0}},

C[ S[2] , S[2] , S[3] , -S[3] , V[3] , -V[3] , V[2] , V[2] ] == {{I*gc583*(Wmass^2 - Zmass^2)^2, 0}, {I*gc583*(Wmass^2 - Zmass^2)^2, 0}, {I*gc583*(2*Wmass^4 - 2*Wmass^2*Zmass^2 + Zmass^4), 0}},

C[ S[3] , S[3] , -S[3] , -S[3] , V[3] , -V[3] , V[2] , V[2] ] == {{I*Cphi4n1*gc584, 0}, {I*Cphi4n1*gc584, 0}, {(2*I)*Cphi4n3*gc584, 0}},

C[ S[3] , -S[3] , S[1] , V[3] , -V[3] , V[2] , V[2] ] == {{I*gc585*(Wmass^2 - Zmass^2)^2, 0}, {I*gc585*(Wmass^2 - Zmass^2)^2, 0}, {I*gc585*(2*Wmass^4 - 2*Wmass^2*Zmass^2 + Zmass^4), 0}},

C[ S[3] , -S[3] , S[1] , S[1] , V[3] , -V[3] , V[2] , V[2] ] == {{I*gc586*(Wmass^2 - Zmass^2)^2, 0}, {I*gc586*(Wmass^2 - Zmass^2)^2, 0}, {I*gc586*(2*Wmass^4 - 2*Wmass^2*Zmass^2 + Zmass^4), 0}},

C[ S[2] , S[2] , V[3] , -V[3] , V[2] , V[2] ] == {{I*gc587*(-8*CphiW^2*Lam*Wmass^2 + Sqrt[2]*Cphi4n1*Gf*Lam*Zmass^4 + 2*CphiW*Wmass*(-2*Sqrt[2]*Gf*Wmass + Cll2x1x1x2*Lam*Wmass - 4*CphiWB*Lam*Sqrt[-Wmass^2 + Zmass^2])), 0}, {I*gc587*(-8*CphiW^2*Lam*Wmass^2 + Sqrt[2]*Cphi4n1*Gf*Lam*Zmass^4 + 2*CphiW*Wmass*(-2*Sqrt[2]*Gf*Wmass + Cll2x1x1x2*Lam*Wmass - 4*CphiWB*Lam*Sqrt[-Wmass^2 + Zmass^2])), 0}, {(2*I)*gc587*(8*CphiW^2*Lam*Wmass^2 + Sqrt[2]*Cphi4n3*Gf*Lam*Zmass^4 + 2*CphiW*Wmass*(2*Sqrt[2]*Gf*Wmass - Cll2x1x1x2*Lam*Wmass + 4*CphiWB*Lam*Sqrt[-Wmass^2 + Zmass^2])), 0}},

C[ S[1] , V[3] , -V[3] , V[2] , V[2] ] == {{(-I)*gc588*(8*Sqrt[2]*CphiW^2*Lam*Wmass^2 - 2*Cphi4n1*Gf*Lam*Zmass^4 + CphiW*Wmass*(8*Gf*Wmass + Sqrt[2]*Lam*(-(Cll2x1x1x2*Wmass) + 4*CphiBox*Wmass + CphiD*Wmass + 8*CphiWB*Sqrt[-Wmass^2 + Zmass^2]))), 0}, {(-I)*gc588*(8*Sqrt[2]*CphiW^2*Lam*Wmass^2 - 2*Cphi4n1*Gf*Lam*Zmass^4 + CphiW*Wmass*(8*Gf*Wmass + Sqrt[2]*Lam*(-(Cll2x1x1x2*Wmass) + 4*CphiBox*Wmass + CphiD*Wmass + 8*CphiWB*Sqrt[-Wmass^2 + Zmass^2]))), 0}, {(2*I)*gc588*(8*Sqrt[2]*CphiW^2*Lam*Wmass^2 + 2*Cphi4n3*Gf*Lam*Zmass^4 + CphiW*Wmass*(8*Gf*Wmass + Sqrt[2]*Lam*(-(Cll2x1x1x2*Wmass) + 4*CphiBox*Wmass + CphiD*Wmass + 8*CphiWB*Sqrt[-Wmass^2 + Zmass^2]))), 0}},

C[ S[1] , S[1] , V[3] , -V[3] , V[2] , V[2] ] == {{(-I)*gc589*(8*CphiW^2*Lam*Wmass^2 - 3*Sqrt[2]*Cphi4n1*Gf*Lam*Zmass^4 + 2*CphiW*Wmass*(2*Sqrt[2]*Gf*Wmass + Lam*(-(Cll2x1x1x2*Wmass) + 4*CphiBox*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2]))), 0}, {(-I)*gc589*(8*CphiW^2*Lam*Wmass^2 - 3*Sqrt[2]*Cphi4n1*Gf*Lam*Zmass^4 + 2*CphiW*Wmass*(2*Sqrt[2]*Gf*Wmass + Lam*(-(Cll2x1x1x2*Wmass) + 4*CphiBox*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2]))), 0}, {(2*I)*gc589*(8*CphiW^2*Lam*Wmass^2 + 3*Sqrt[2]*Cphi4n3*Gf*Lam*Zmass^4 + 2*CphiW*Wmass*(2*Sqrt[2]*Gf*Wmass + Lam*(-(Cll2x1x1x2*Wmass) + 4*CphiBox*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2]))), 0}},

C[ S[2] , S[2] , S[2] , S[2] , V[3] , -V[3] , V[2] , V[2] ] == {{I*Cphi4n1*gc590, 0}, {I*Cphi4n1*gc590, 0}, {(2*I)*Cphi4n3*gc590, 0}},

C[ S[2] , S[2] , S[1] , V[3] , -V[3] , V[2] , V[2] ] == {{I*Cphi4n1*gc591, 0}, {I*Cphi4n1*gc591, 0}, {(2*I)*Cphi4n3*gc591, 0}},

C[ S[2] , S[2] , S[1] , S[1] , V[3] , -V[3] , V[2] , V[2] ] == {{I*Cphi4n1*gc592, 0}, {I*Cphi4n1*gc592, 0}, {(2*I)*Cphi4n3*gc592, 0}},

C[ S[1] , S[1] , S[1] , V[3] , -V[3] , V[2] , V[2] ] == {{I*Cphi4n1*gc593, 0}, {I*Cphi4n1*gc593, 0}, {(2*I)*Cphi4n3*gc593, 0}},

C[ S[1] , S[1] , S[1] , S[1] , V[3] , -V[3] , V[2] , V[2] ] == {{I*Cphi4n1*gc594, 0}, {I*Cphi4n1*gc594, 0}, {(2*I)*Cphi4n3*gc594, 0}},

C[ S[3] , S[3] , -V[3] , -V[3] , V[2] , V[2] ] == {{I*gc595*(2*Cphi4n3*(Wmass^2 - Zmass^2)^2 + Cphi4n1*(2*Wmass^4 - 2*Wmass^2*Zmass^2 + Zmass^4)), 0}, {I*gc595*(2*Cphi4n3*(Wmass^2 - Zmass^2)^2 + Cphi4n1*(2*Wmass^4 - 2*Wmass^2*Zmass^2 + Zmass^4)), 0}, {(2*I)*Cphi4n1*gc595*Zmass^2*(-2*Wmass^2 + Zmass^2), 0}},

C[ S[2] , S[3] , S[3] , -V[3] , -V[3] , V[2] , V[2] ] == {{gc596*(2*Cphi4n3*(Wmass^2 - Zmass^2)^2 + Cphi4n1*(2*Wmass^4 - 2*Wmass^2*Zmass^2 + Zmass^4)), 0}, {gc596*(2*Cphi4n3*(Wmass^2 - Zmass^2)^2 + Cphi4n1*(2*Wmass^4 - 2*Wmass^2*Zmass^2 + Zmass^4)), 0}, {2*Cphi4n1*gc596*Zmass^2*(-2*Wmass^2 + Zmass^2), 0}},

C[ S[2] , S[2] , S[3] , S[3] , -V[3] , -V[3] , V[2] , V[2] ] == {{I*gc597*(2*Cphi4n3*(Wmass^2 - Zmass^2)^2 + Cphi4n1*(2*Wmass^4 - 2*Wmass^2*Zmass^2 + Zmass^4)), 0}, {I*gc597*(2*Cphi4n3*(Wmass^2 - Zmass^2)^2 + Cphi4n1*(2*Wmass^4 - 2*Wmass^2*Zmass^2 + Zmass^4)), 0}, {(2*I)*Cphi4n1*gc597*Zmass^2*(-2*Wmass^2 + Zmass^2), 0}},

C[ S[3] , S[3] , S[1] , -V[3] , -V[3] , V[2] , V[2] ] == {{I*gc598*(2*Cphi4n3*(Wmass^2 - Zmass^2)^2 + Cphi4n1*(2*Wmass^4 - 2*Wmass^2*Zmass^2 + Zmass^4)), 0}, {I*gc598*(2*Cphi4n3*(Wmass^2 - Zmass^2)^2 + Cphi4n1*(2*Wmass^4 - 2*Wmass^2*Zmass^2 + Zmass^4)), 0}, {(2*I)*Cphi4n1*gc598*Zmass^2*(-2*Wmass^2 + Zmass^2), 0}},

C[ S[2] , S[3] , S[3] , S[1] , -V[3] , -V[3] , V[2] , V[2] ] == {{gc599*(2*Cphi4n3*(Wmass^2 - Zmass^2)^2 + Cphi4n1*(2*Wmass^4 - 2*Wmass^2*Zmass^2 + Zmass^4)), 0}, {gc599*(2*Cphi4n3*(Wmass^2 - Zmass^2)^2 + Cphi4n1*(2*Wmass^4 - 2*Wmass^2*Zmass^2 + Zmass^4)), 0}, {2*Cphi4n1*gc599*Zmass^2*(-2*Wmass^2 + Zmass^2), 0}},

C[ S[3] , S[3] , S[1] , S[1] , -V[3] , -V[3] , V[2] , V[2] ] == {{I*gc600*(2*Cphi4n3*(Wmass^2 - Zmass^2)^2 + Cphi4n1*(2*Wmass^4 - 2*Wmass^2*Zmass^2 + Zmass^4)), 0}, {I*gc600*(2*Cphi4n3*(Wmass^2 - Zmass^2)^2 + Cphi4n1*(2*Wmass^4 - 2*Wmass^2*Zmass^2 + Zmass^4)), 0}, {(2*I)*Cphi4n1*gc600*Zmass^2*(-2*Wmass^2 + Zmass^2), 0}},

C[ S[3] , -S[3] , V[1] , V[2] , V[2] , V[2] ] == {{I*gc601, 0}, {I*gc601, 0}, {I*gc601, 0}},

C[ S[2] , S[2] , S[3] , -S[3] , V[1] , V[2] , V[2] , V[2] ] == {{I*gc602, 0}, {I*gc602, 0}, {I*gc602, 0}},

C[ S[3] , S[3] , -S[3] , -S[3] , V[1] , V[2] , V[2] , V[2] ] == {{I*gc603, 0}, {I*gc603, 0}, {I*gc603, 0}},

C[ S[3] , -S[3] , S[1] , V[1] , V[2] , V[2] , V[2] ] == {{I*gc604, 0}, {I*gc604, 0}, {I*gc604, 0}},

C[ S[3] , -S[3] , S[1] , S[1] , V[1] , V[2] , V[2] , V[2] ] == {{I*gc605, 0}, {I*gc605, 0}, {I*gc605, 0}},

C[ S[2] , S[3] , -S[3] , V[2] , V[2] , V[2] ] == {{0, 0}, {0, 0}, {gc606, 0}, {0, 0}, {0, 0}, {gc606, 0}, {0, 0}, {0, 0}, {gc606, 0}},

C[ S[2] , S[3] , -S[3] , S[1] , V[2] , V[2] , V[2] ] == {{-gc607, 0}, {0, 0}, {0, 0}, {gc607, 0}, {-gc607, 0}, {0, 0}, {0, 0}, {gc607, 0}, {-gc607, 0}, {0, 0}, {0, 0}, {gc607, 0}},

C[ S[2] , V[2] , V[2] , V[2] ] == {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {gc608, 0}, {gc608, 0}, {gc608, 0}},

C[ S[2] , S[2] , S[2] , V[2] , V[2] , V[2] ] == {{gc609, 0}, {gc609, 0}, {gc609, 0}, {gc609, 0}, {gc609, 0}, {gc609, 0}, {gc609, 0}, {gc609, 0}, {gc609, 0}},

C[ S[2] , S[1] , V[2] , V[2] , V[2] ] == {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {-3*gc610, 0}, {gc610, 0}, {-3*gc610, 0}, {gc610, 0}, {-3*gc610, 0}, {gc610, 0}},

C[ S[2] , S[2] , S[2] , S[1] , V[2] , V[2] , V[2] ] == {{-gc611, 0}, {-gc611, 0}, {-gc611, 0}, {3*gc611, 0}, {-gc611, 0}, {-gc611, 0}, {-gc611, 0}, {3*gc611, 0}, {-gc611, 0}, {-gc611, 0}, {-gc611, 0}, {3*gc611, 0}},

C[ S[2] , S[1] , S[1] , V[2] , V[2] , V[2] ] == {{-gc612, 0}, {-gc612, 0}, {3*gc612, 0}, {-gc612, 0}, {-gc612, 0}, {3*gc612, 0}, {-gc612, 0}, {-gc612, 0}, {3*gc612, 0}},

C[ S[2] , S[1] , S[1] , S[1] , V[2] , V[2] , V[2] ] == {{-3*gc613, 0}, {gc613, 0}, {gc613, 0}, {gc613, 0}, {-3*gc613, 0}, {gc613, 0}, {gc613, 0}, {gc613, 0}, {-3*gc613, 0}, {gc613, 0}, {gc613, 0}, {gc613, 0}},

C[ S[3] , S[3] , -S[3] , -S[3] , V[2] , V[2] , V[2] ] == {{(-I)*gc614, 0}, {(-I)*gc614, 0}, {I*gc614, 0}, {I*gc614, 0}, {(-I)*gc614, 0}, {(-I)*gc614, 0}, {I*gc614, 0}, {I*gc614, 0}, {(-I)*gc614, 0}, {(-I)*gc614, 0}, {I*gc614, 0}, {I*gc614, 0}},

C[ S[3] , -S[3] , V[2] , V[2] , V[2] ] == {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {(-I)*gc615, 0}, {I*gc615, 0}, {(-I)*gc615, 0}, {I*gc615, 0}, {(-I)*gc615, 0}, {I*gc615, 0}},

C[ S[2] , S[2] , S[3] , -S[3] , V[2] , V[2] , V[2] ] == {{0, 0}, {0, 0}, {(-I)*gc616, 0}, {I*gc616, 0}, {0, 0}, {0, 0}, {(-I)*gc616, 0}, {I*gc616, 0}, {0, 0}, {0, 0}, {(-I)*gc616, 0}, {I*gc616, 0}},

C[ S[3] , -S[3] , S[1] , V[2] , V[2] , V[2] ] == {{(-I)*gc617, 0}, {0, 0}, {I*gc617, 0}, {(-I)*gc617, 0}, {0, 0}, {I*gc617, 0}, {(-I)*gc617, 0}, {0, 0}, {I*gc617, 0}},

C[ S[3] , -S[3] , S[1] , S[1] , V[2] , V[2] , V[2] ] == {{(-I)*gc618, 0}, {I*gc618, 0}, {0, 0}, {0, 0}, {(-I)*gc618, 0}, {I*gc618, 0}, {0, 0}, {0, 0}, {(-I)*gc618, 0}, {I*gc618, 0}, {0, 0}, {0, 0}},

C[ S[3] , -S[3] , -S[3] , V[3] , V[2] , V[2] , V[2] ] == {{I*gc619, 0}, {I*gc619, 0}, {I*gc619, 0}},

C[ S[2] , S[3] , -S[3] , -S[3] , V[3] , V[2] , V[2] , V[2] ] == {{gc620, 0}, {gc620, 0}, {gc620, 0}},

C[ S[3] , -S[3] , -S[3] , S[1] , V[3] , V[2] , V[2] , V[2] ] == {{I*gc621, 0}, {I*gc621, 0}, {I*gc621, 0}},

C[ -S[3] , V[3] , V[2] , V[2] , V[2] ] == {{I*gc622, 0}, {I*gc622, 0}, {I*gc622, 0}},

C[ S[2] , -S[3] , V[3] , V[2] , V[2] , V[2] ] == {{gc623, 0}, {gc623, 0}, {gc623, 0}},

C[ S[2] , S[2] , -S[3] , V[3] , V[2] , V[2] , V[2] ] == {{I*gc624, 0}, {I*gc624, 0}, {I*gc624, 0}},

C[ S[2] , S[2] , S[2] , -S[3] , V[3] , V[2] , V[2] , V[2] ] == {{gc625, 0}, {gc625, 0}, {gc625, 0}},

C[ -S[3] , S[1] , V[3] , V[2] , V[2] , V[2] ] == {{I*gc626, 0}, {I*gc626, 0}, {I*gc626, 0}},

C[ S[2] , -S[3] , S[1] , V[3] , V[2] , V[2] , V[2] ] == {{gc627, 0}, {gc627, 0}, {gc627, 0}},

C[ S[2] , S[2] , -S[3] , S[1] , V[3] , V[2] , V[2] , V[2] ] == {{I*gc628, 0}, {I*gc628, 0}, {I*gc628, 0}},

C[ -S[3] , S[1] , S[1] , V[3] , V[2] , V[2] , V[2] ] == {{I*gc629, 0}, {I*gc629, 0}, {I*gc629, 0}},

C[ S[2] , -S[3] , S[1] , S[1] , V[3] , V[2] , V[2] , V[2] ] == {{gc630, 0}, {gc630, 0}, {gc630, 0}},

C[ -S[3] , S[1] , S[1] , S[1] , V[3] , V[2] , V[2] , V[2] ] == {{I*gc631, 0}, {I*gc631, 0}, {I*gc631, 0}},

C[ S[3] , S[3] , -S[3] , -V[3] , V[2] , V[2] , V[2] ] == {{I*gc632, 0}, {I*gc632, 0}, {I*gc632, 0}},

C[ S[2] , S[3] , S[3] , -S[3] , -V[3] , V[2] , V[2] , V[2] ] == {{gc633, 0}, {gc633, 0}, {gc633, 0}},

C[ S[3] , S[3] , -S[3] , S[1] , -V[3] , V[2] , V[2] , V[2] ] == {{I*gc634, 0}, {I*gc634, 0}, {I*gc634, 0}},

C[ S[3] , -V[3] , V[2] , V[2] , V[2] ] == {{I*gc635, 0}, {I*gc635, 0}, {I*gc635, 0}},

C[ S[2] , S[3] , -V[3] , V[2] , V[2] , V[2] ] == {{gc636, 0}, {gc636, 0}, {gc636, 0}},

C[ S[2] , S[2] , S[3] , -V[3] , V[2] , V[2] , V[2] ] == {{I*gc637, 0}, {I*gc637, 0}, {I*gc637, 0}},

C[ S[2] , S[2] , S[2] , S[3] , -V[3] , V[2] , V[2] , V[2] ] == {{gc638, 0}, {gc638, 0}, {gc638, 0}},

C[ S[3] , S[1] , -V[3] , V[2] , V[2] , V[2] ] == {{I*gc639, 0}, {I*gc639, 0}, {I*gc639, 0}},

C[ S[2] , S[3] , S[1] , -V[3] , V[2] , V[2] , V[2] ] == {{gc640, 0}, {gc640, 0}, {gc640, 0}},

C[ S[2] , S[2] , S[3] , S[1] , -V[3] , V[2] , V[2] , V[2] ] == {{I*gc641, 0}, {I*gc641, 0}, {I*gc641, 0}},

C[ S[3] , S[1] , S[1] , -V[3] , V[2] , V[2] , V[2] ] == {{I*gc642, 0}, {I*gc642, 0}, {I*gc642, 0}},

C[ S[2] , S[3] , S[1] , S[1] , -V[3] , V[2] , V[2] , V[2] ] == {{gc643, 0}, {gc643, 0}, {gc643, 0}},

C[ S[3] , S[1] , S[1] , S[1] , -V[3] , V[2] , V[2] , V[2] ] == {{I*gc644, 0}, {I*gc644, 0}, {I*gc644, 0}},

C[ S[3] , -S[3] , V[2] , V[2] , V[2] , V[2] ] == {{I*gc645, 0}, {I*gc645, 0}, {I*gc645, 0}},

C[ S[2] , S[2] , S[3] , -S[3] , V[2] , V[2] , V[2] , V[2] ] == {{I*gc646, 0}, {I*gc646, 0}, {I*gc646, 0}},

C[ S[3] , S[3] , -S[3] , -S[3] , V[2] , V[2] , V[2] , V[2] ] == {{I*gc647, 0}, {I*gc647, 0}, {I*gc647, 0}},

C[ S[3] , -S[3] , S[1] , V[2] , V[2] , V[2] , V[2] ] == {{I*gc648, 0}, {I*gc648, 0}, {I*gc648, 0}},

C[ S[3] , -S[3] , S[1] , S[1] , V[2] , V[2] , V[2] , V[2] ] == {{I*gc649, 0}, {I*gc649, 0}, {I*gc649, 0}},

C[ V[2] , V[2] , V[2] , V[2] ] == {{I*gc650, 0}, {I*gc650, 0}, {I*gc650, 0}},

C[ S[2] , S[2] , V[2] , V[2] , V[2] , V[2] ] == {{I*gc651, 0}, {I*gc651, 0}, {I*gc651, 0}},

C[ S[2] , S[2] , S[2] , S[2] , V[2] , V[2] , V[2] , V[2] ] == {{I*gc652, 0}, {I*gc652, 0}, {I*gc652, 0}},

C[ S[1] , V[2] , V[2] , V[2] , V[2] ] == {{I*gc653, 0}, {I*gc653, 0}, {I*gc653, 0}},

C[ S[2] , S[2] , S[1] , V[2] , V[2] , V[2] , V[2] ] == {{I*gc654, 0}, {I*gc654, 0}, {I*gc654, 0}},

C[ S[1] , S[1] , V[2] , V[2] , V[2] , V[2] ] == {{I*gc655, 0}, {I*gc655, 0}, {I*gc655, 0}},

C[ S[2] , S[2] , S[1] , S[1] , V[2] , V[2] , V[2] , V[2] ] == {{I*gc656, 0}, {I*gc656, 0}, {I*gc656, 0}},

C[ S[1] , S[1] , S[1] , V[2] , V[2] , V[2] , V[2] ] == {{I*gc657, 0}, {I*gc657, 0}, {I*gc657, 0}},

C[ S[1] , S[1] , S[1] , S[1] , V[2] , V[2] , V[2] , V[2] ] == {{I*gc658, 0}, {I*gc658, 0}, {I*gc658, 0}},

C[ -F[4, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , V[1] ] == {{I*gc659*IndexDelta[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {I*gc659*IndexDelta[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}},

C[ -F[2, {e1x2}] , F[2, {e2x2}] , V[1] ] == {{I*gc660*IndexDelta[e1x2, e2x2], 0}, {0, 0}, {I*gc660*IndexDelta[e1x2, e2x2], 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}},

C[ -F[3, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , V[1] ] == {{I*gc661*IndexDelta[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {I*gc661*IndexDelta[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {((-3*I)*gc661*Lam*(Wmass - Zmass)*(Wmass + Zmass)*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(Wmass^2 - Zmass^2) + 4*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2]))*Conjugate[CuW[e2x2, e1x2]]*IndexDelta[e1x3, e2x3])/(Wmass*(-64*Gf^2*(Wmass^2 - Zmass^2)^2 + 8*Sqrt[2]*Gf*Lam*(Wmass^2 - Zmass^2)*(Cll2x1x1x2*(Wmass^2 - Zmass^2) - Wmass*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2])) + Lam^2*(7*Cll2x1x1x2^2*(Wmass^2 - Zmass^2)^2 - 2*Cll2x1x1x2*Wmass*(Wmass^2 - Zmass^2)*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2]) + Wmass*(CphiD^2*Wmass^3 + 8*CphiD*CphiWB*(-Wmass^2 + Zmass^2)^(3/2) + 32*CphiW*CphiWB*(-Wmass^2 + Zmass^2)^(3/2))))), 0}, {0, 0}, {((-3*I)*gc661*Lam*(Wmass - Zmass)*(Wmass + Zmass)*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(Wmass^2 - Zmass^2) + 4*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2]))*CuW[e1x2, e2x2]*IndexDelta[e1x3, e2x3])/(Wmass*(-64*Gf^2*(Wmass^2 - Zmass^2)^2 + 8*Sqrt[2]*Gf*Lam*(Wmass^2 - Zmass^2)*(Cll2x1x1x2*(Wmass^2 - Zmass^2) - Wmass*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2])) + Lam^2*(7*Cll2x1x1x2^2*(Wmass^2 - Zmass^2)^2 - 2*Cll2x1x1x2*Wmass*(Wmass^2 - Zmass^2)*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2]) + Wmass*(CphiD^2*Wmass^3 + 8*CphiD*CphiWB*(-Wmass^2 + Zmass^2)^(3/2) + 32*CphiW*CphiWB*(-Wmass^2 + Zmass^2)^(3/2))))), 0}, {0, 0}, {((3*I)*gc661*Lam*(Wmass - Zmass)*(Wmass + Zmass)*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(Wmass^2 - Zmass^2) + 4*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2]))*Conjugate[CuW[e2x2, e1x2]]*IndexDelta[e1x3, e2x3])/(Wmass*(-64*Gf^2*(Wmass^2 - Zmass^2)^2 + 8*Sqrt[2]*Gf*Lam*(Wmass^2 - Zmass^2)*(Cll2x1x1x2*(Wmass^2 - Zmass^2) - Wmass*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2])) + Lam^2*(7*Cll2x1x1x2^2*(Wmass^2 - Zmass^2)^2 - 2*Cll2x1x1x2*Wmass*(Wmass^2 - Zmass^2)*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2]) + Wmass*(CphiD^2*Wmass^3 + 8*CphiD*CphiWB*(-Wmass^2 + Zmass^2)^(3/2) + 32*CphiW*CphiWB*(-Wmass^2 + Zmass^2)^(3/2))))), 0}, {0, 0}, {((3*I)*gc661*Lam*(Wmass - Zmass)*(Wmass + Zmass)*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(Wmass^2 - Zmass^2) + 4*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2]))*CuW[e1x2, e2x2]*IndexDelta[e1x3, e2x3])/(Wmass*(-64*Gf^2*(Wmass^2 - Zmass^2)^2 + 8*Sqrt[2]*Gf*Lam*(Wmass^2 - Zmass^2)*(Cll2x1x1x2*(Wmass^2 - Zmass^2) - Wmass*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2])) + Lam^2*(7*Cll2x1x1x2^2*(Wmass^2 - Zmass^2)^2 - 2*Cll2x1x1x2*Wmass*(Wmass^2 - Zmass^2)*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2]) + Wmass*(CphiD^2*Wmass^3 + 8*CphiD*CphiWB*(-Wmass^2 + Zmass^2)^(3/2) + 32*CphiW*CphiWB*(-Wmass^2 + Zmass^2)^(3/2))))), 0}, {0, 0}},

C[ -F[4, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , V[4, {e3x2}] ] == {{I*gc662*IndexDelta[e1x2, e2x2]*SUNT[e3x2, e1x3, e2x3], 0}, {0, 0}, {I*gc662*IndexDelta[e1x2, e2x2]*SUNT[e3x2, e1x3, e2x3], 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}},

C[ -F[3, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , V[4, {e3x2}] ] == {{I*gc663*IndexDelta[e1x2, e2x2]*SUNT[e3x2, e1x3, e2x3], 0}, {0, 0}, {I*gc663*IndexDelta[e1x2, e2x2]*SUNT[e3x2, e1x3, e2x3], 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}},

C[ -F[1, {e1x2}] , F[2, {e2x2}] , V[3] ] == {{I*gc664[e1x2, e2x2], 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}},

C[ -F[3, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , V[3] ] == {{I*gc665[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {0, 0}, {0, 0}, {((8*I)*Lam*(4*Sqrt[2]*Gf + (Cll2x1x1x2 + 4*CphiW)*Lam)*gc665[e1x2, e2x2]*IndexDelta[e1x3, e2x3]*IndexSum[Conjugate[CuW[Generation$1, e1x2]]*Kq[Generation$1, e2x2], {Generation$1, 1, 3}])/((64*Sqrt[2]*Gf^2 - 16*Cll2x1x1x2*Gf*Lam - 7*Sqrt[2]*Cll2x1x1x2^2*Lam^2)*Wmass*Kq[e1x2, e2x2]), 0}, {0, 0}, {0, 0}, {0, 0}, {((-8*I)*Lam*(4*Sqrt[2]*Gf + (Cll2x1x1x2 + 4*CphiW)*Lam)*gc665[e1x2, e2x2]*IndexDelta[e1x3, e2x3]*IndexSum[Conjugate[CuW[Generation$1, e1x2]]*Kq[Generation$1, e2x2], {Generation$1, 1, 3}])/((64*Sqrt[2]*Gf^2 - 16*Cll2x1x1x2*Gf*Lam - 7*Sqrt[2]*Cll2x1x1x2^2*Lam^2)*Wmass*Kq[e1x2, e2x2]), 0}, {0, 0}, {0, 0}, {0, 0}},

C[ -F[4, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , -V[3] ] == {{I*gc666[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {((8*I)*Lam*(4*Sqrt[2]*Gf + (Cll2x1x1x2 + 4*CphiW)*Lam)*gc666[e1x2, e2x2]*IndexDelta[e1x3, e2x3]*IndexSum[Conjugate[Kq[Generation$1, e1x2]]*CuW[Generation$1, e2x2], {Generation$1, 1, 3}])/((64*Sqrt[2]*Gf^2 - 16*Cll2x1x1x2*Gf*Lam - 7*Sqrt[2]*Cll2x1x1x2^2*Lam^2)*Wmass*Conjugate[Kq[e2x2, e1x2]]), 0}, {0, 0}, {0, 0}, {0, 0}, {((-8*I)*Lam*(4*Sqrt[2]*Gf + (Cll2x1x1x2 + 4*CphiW)*Lam)*gc666[e1x2, e2x2]*IndexDelta[e1x3, e2x3]*IndexSum[Conjugate[Kq[Generation$1, e1x2]]*CuW[Generation$1, e2x2], {Generation$1, 1, 3}])/((64*Sqrt[2]*Gf^2 - 16*Cll2x1x1x2*Gf*Lam - 7*Sqrt[2]*Cll2x1x1x2^2*Lam^2)*Wmass*Conjugate[Kq[e2x2, e1x2]]), 0}, {0, 0}},

C[ -F[2, {e1x2}] , F[1, {e2x2}] , -V[3] ] == {{I*gc667[e1x2, e2x2], 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}},

C[ -F[4, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , V[2] ] == {{I*gc668*IndexDelta[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {((2*I)*gc668*(8*CphiWB*Lam*Wmass*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(Wmass^2 - Zmass^2))) + Sqrt[-Wmass^2 + Zmass^2]*(-64*Gf^2*(Wmass^2 - Zmass^2) + 8*Sqrt[2]*Gf*Lam*(Cll2x1x1x2*(Wmass^2 - Zmass^2) - CphiD*(Wmass^2 + Zmass^2)) + Lam^2*(7*Cll2x1x1x2^2*(Wmass^2 - Zmass^2) - 2*Cll2x1x1x2*CphiD*(Wmass^2 + Zmass^2) + CphiD^2*(Wmass^2 + 3*Zmass^2))))*IndexDelta[e1x2, e2x2]*IndexDelta[e1x3, e2x3])/(16*CphiWB*Lam*Wmass*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(Wmass^2 - Zmass^2))) + Sqrt[-Wmass^2 + Zmass^2]*(-64*Gf^2*(2*Wmass^2 + Zmass^2) + 8*Sqrt[2]*Gf*Lam*(CphiD*(-2*Wmass^2 + Zmass^2) + Cll2x1x1x2*(2*Wmass^2 + Zmass^2)) + Lam^2*(CphiD^2*(2*Wmass^2 - 3*Zmass^2) + 2*Cll2x1x1x2*CphiD*(-2*Wmass^2 + Zmass^2) + 7*Cll2x1x1x2^2*(2*Wmass^2 + Zmass^2)))), 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}},

C[ -F[2, {e1x2}] , F[2, {e2x2}] , V[2] ] == {{I*gc669*IndexDelta[e1x2, e2x2], 0}, {0, 0}, {((-2*I)*gc669*(8*CphiWB*Lam*Wmass*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(Wmass^2 - Zmass^2))) + Sqrt[-Wmass^2 + Zmass^2]*(-64*Gf^2*(Wmass^2 - Zmass^2) + 8*Sqrt[2]*Gf*Lam*(Cll2x1x1x2*(Wmass^2 - Zmass^2) - CphiD*(Wmass^2 + Zmass^2)) + Lam^2*(7*Cll2x1x1x2^2*(Wmass^2 - Zmass^2) - 2*Cll2x1x1x2*CphiD*(Wmass^2 + Zmass^2) + CphiD^2*(Wmass^2 + 3*Zmass^2))))*IndexDelta[e1x2, e2x2])/(-16*CphiWB*Lam*Wmass*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(Wmass^2 - Zmass^2))) + Sqrt[-Wmass^2 + Zmass^2]*(64*Gf^2*(2*Wmass^2 - Zmass^2) + 8*Sqrt[2]*Gf*Lam*(Cll2x1x1x2*(-2*Wmass^2 + Zmass^2) + CphiD*(2*Wmass^2 + Zmass^2)) + Lam^2*(7*Cll2x1x1x2^2*(-2*Wmass^2 + Zmass^2) + 2*Cll2x1x1x2*CphiD*(2*Wmass^2 + Zmass^2) - CphiD^2*(2*Wmass^2 + 3*Zmass^2)))), 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}},

C[ -F[3, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , V[2] ] == {{I*gc670*IndexDelta[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {((4*I)*gc670*(8*CphiWB*Lam*Wmass*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(Wmass^2 - Zmass^2))) + Sqrt[-Wmass^2 + Zmass^2]*(-64*Gf^2*(Wmass^2 - Zmass^2) + 8*Sqrt[2]*Gf*Lam*(Cll2x1x1x2*(Wmass^2 - Zmass^2) - CphiD*(Wmass^2 + Zmass^2)) + Lam^2*(7*Cll2x1x1x2^2*(Wmass^2 - Zmass^2) - 2*Cll2x1x1x2*CphiD*(Wmass^2 + Zmass^2) + CphiD^2*(Wmass^2 + 3*Zmass^2))))*IndexDelta[e1x2, e2x2]*IndexDelta[e1x3, e2x3])/(32*CphiWB*Lam*Wmass*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(Wmass^2 - Zmass^2))) - Sqrt[-Wmass^2 + Zmass^2]*(64*Gf^2*(4*Wmass^2 - Zmass^2) + 8*Sqrt[2]*Gf*Lam*(Cll2x1x1x2*(-4*Wmass^2 + Zmass^2) + CphiD*(4*Wmass^2 + Zmass^2)) + Lam^2*(7*Cll2x1x1x2^2*(-4*Wmass^2 + Zmass^2) + 2*Cll2x1x1x2*CphiD*(4*Wmass^2 + Zmass^2) - CphiD^2*(4*Wmass^2 + 3*Zmass^2)))), 0}, {0, 0}, {((12*I)*gc670*Lam*(4*Sqrt[2]*CphiWB*Lam*(Wmass^2 - Zmass^2) - (8*Gf + Sqrt[2]*(Cll2x1x1x2 + CphiD + 4*CphiW)*Lam)*Wmass*Sqrt[-Wmass^2 + Zmass^2])*Conjugate[CuW[e2x2, e1x2]]*IndexDelta[e1x3, e2x3])/(32*CphiWB*Lam*Wmass*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(Wmass^2 - Zmass^2))) - Sqrt[-Wmass^2 + Zmass^2]*(64*Gf^2*(4*Wmass^2 - Zmass^2) + 8*Sqrt[2]*Gf*Lam*(Cll2x1x1x2*(-4*Wmass^2 + Zmass^2) + CphiD*(4*Wmass^2 + Zmass^2)) + Lam^2*(7*Cll2x1x1x2^2*(-4*Wmass^2 + Zmass^2) + 2*Cll2x1x1x2*CphiD*(4*Wmass^2 + Zmass^2) - CphiD^2*(4*Wmass^2 + 3*Zmass^2)))), 0}, {0, 0}, {((12*I)*gc670*Lam*(4*Sqrt[2]*CphiWB*Lam*(Wmass^2 - Zmass^2) - (8*Gf + Sqrt[2]*(Cll2x1x1x2 + CphiD + 4*CphiW)*Lam)*Wmass*Sqrt[-Wmass^2 + Zmass^2])*CuW[e1x2, e2x2]*IndexDelta[e1x3, e2x3])/(32*CphiWB*Lam*Wmass*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(Wmass^2 - Zmass^2))) - Sqrt[-Wmass^2 + Zmass^2]*(64*Gf^2*(4*Wmass^2 - Zmass^2) + 8*Sqrt[2]*Gf*Lam*(Cll2x1x1x2*(-4*Wmass^2 + Zmass^2) + CphiD*(4*Wmass^2 + Zmass^2)) + Lam^2*(7*Cll2x1x1x2^2*(-4*Wmass^2 + Zmass^2) + 2*Cll2x1x1x2*CphiD*(4*Wmass^2 + Zmass^2) - CphiD^2*(4*Wmass^2 + 3*Zmass^2)))), 0}, {0, 0}, {((-12*I)*gc670*Lam*(4*Sqrt[2]*CphiWB*Lam*(Wmass^2 - Zmass^2) - (8*Gf + Sqrt[2]*(Cll2x1x1x2 + CphiD + 4*CphiW)*Lam)*Wmass*Sqrt[-Wmass^2 + Zmass^2])*Conjugate[CuW[e2x2, e1x2]]*IndexDelta[e1x3, e2x3])/(32*CphiWB*Lam*Wmass*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(Wmass^2 - Zmass^2))) - Sqrt[-Wmass^2 + Zmass^2]*(64*Gf^2*(4*Wmass^2 - Zmass^2) + 8*Sqrt[2]*Gf*Lam*(Cll2x1x1x2*(-4*Wmass^2 + Zmass^2) + CphiD*(4*Wmass^2 + Zmass^2)) + Lam^2*(7*Cll2x1x1x2^2*(-4*Wmass^2 + Zmass^2) + 2*Cll2x1x1x2*CphiD*(4*Wmass^2 + Zmass^2) - CphiD^2*(4*Wmass^2 + 3*Zmass^2)))), 0}, {0, 0}, {((-12*I)*gc670*Lam*(4*Sqrt[2]*CphiWB*Lam*(Wmass^2 - Zmass^2) - (8*Gf + Sqrt[2]*(Cll2x1x1x2 + CphiD + 4*CphiW)*Lam)*Wmass*Sqrt[-Wmass^2 + Zmass^2])*CuW[e1x2, e2x2]*IndexDelta[e1x3, e2x3])/(32*CphiWB*Lam*Wmass*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(Wmass^2 - Zmass^2))) - Sqrt[-Wmass^2 + Zmass^2]*(64*Gf^2*(4*Wmass^2 - Zmass^2) + 8*Sqrt[2]*Gf*Lam*(Cll2x1x1x2*(-4*Wmass^2 + Zmass^2) + CphiD*(4*Wmass^2 + Zmass^2)) + Lam^2*(7*Cll2x1x1x2^2*(-4*Wmass^2 + Zmass^2) + 2*Cll2x1x1x2*CphiD*(4*Wmass^2 + Zmass^2) - CphiD^2*(4*Wmass^2 + 3*Zmass^2)))), 0}, {0, 0}},

C[ -F[1, {e1x2}] , F[1, {e2x2}] , V[2] ] == {{I*gc671*IndexDelta[e1x2, e2x2], 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}},

C[ -F[1, {e1x2}] , -F[1, {e3x2}] , F[1, {e2x2}] , F[1, {e4x2}] ] == {{I*gc672*(IndexSum[IndexSum[Conjugate[Ul[Generation$3, e3x2]]*IndexSum[IndexSum[Cll[Generation$1, Generation$2, Generation$3, Generation$4]*Conjugate[Ul[Generation$1, e1x2]], {Generation$1, 1, 3}]*Ul[Generation$2, e4x2], {Generation$2, 1, 3}], {Generation$3, 1, 3}]*Ul[Generation$4, e2x2], {Generation$4, 1, 3}] + IndexSum[IndexSum[Conjugate[Ul[Generation$3, e1x2]]*IndexSum[IndexSum[Cll[Generation$1, Generation$2, Generation$3, Generation$4]*Conjugate[Ul[Generation$1, e3x2]], {Generation$1, 1, 3}]*Ul[Generation$2, e2x2], {Generation$2, 1, 3}], {Generation$3, 1, 3}]*Ul[Generation$4, e4x2], {Generation$4, 1, 3}]), 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {I*gc672*(IndexSum[IndexSum[Conjugate[Ul[Generation$3, e1x2]]*IndexSum[IndexSum[Cll[Generation$1, Generation$2, Generation$3, Generation$4]*Conjugate[Ul[Generation$1, e3x2]], {Generation$1, 1, 3}]*Ul[Generation$2, e4x2], {Generation$2, 1, 3}], {Generation$3, 1, 3}]*Ul[Generation$4, e2x2], {Generation$4, 1, 3}] + IndexSum[IndexSum[Conjugate[Ul[Generation$3, e3x2]]*IndexSum[IndexSum[Cll[Generation$1, Generation$2, Generation$3, Generation$4]*Conjugate[Ul[Generation$1, e1x2]], {Generation$1, 1, 3}]*Ul[Generation$2, e2x2], {Generation$2, 1, 3}], {Generation$3, 1, 3}]*Ul[Generation$4, e4x2], {Generation$4, 1, 3}]), 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}},

C[ -F[2, {e1x2}] , -F[1, {e3x2}] , F[2, {e2x2}] , F[1, {e4x2}] ] == {{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {I*gc673[e1x2, e3x2, e2x2, e4x2], 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}},

C[ -F[2, {e1x2}] , -F[2, {e3x2}] , F[2, {e2x2}] , F[2, {e4x2}] ] == {{I*gc674*(Cll[e1x2, e4x2, e3x2, e2x2] + Cll[e3x2, e2x2, e1x2, e4x2]), 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {I*gc674*(Cll[e1x2, e2x2, e3x2, e4x2] + Cll[e3x2, e4x2, e1x2, e2x2]), 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 0}},

C[ -F[3, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , S[2] , V[1] ] == {{gc675*Conjugate[CuW[e2x2, e1x2]]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {(gc675*(4*Sqrt[2]*CphiWB*Lam*Wmass*(Wmass^2 - Zmass^2) - Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(4*CphiW*Wmass^2 + CphiD*Zmass^2 - 4*CphiW*Zmass^2)))*CuW[e1x2, e2x2]*IndexDelta[e1x3, e2x3])/(Sqrt[2]*(4*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(CphiD*Lam*Zmass^2 + 4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + 4*CphiW*Lam*(Wmass^2 - Zmass^2)))), 0}, {0, 0}, {(gc675*(4*Sqrt[2]*CphiWB*Lam*Wmass*(Wmass^2 - Zmass^2) - Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(4*CphiW*Wmass^2 + CphiD*Zmass^2 - 4*CphiW*Zmass^2)))*Conjugate[CuW[e2x2, e1x2]]*IndexDelta[e1x3, e2x3])/(Sqrt[2]*(4*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(CphiD*Lam*Zmass^2 + 4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + 4*CphiW*Lam*(Wmass^2 - Zmass^2)))), 0}, {0, 0}, {-((gc675*(4*Sqrt[2]*CphiWB*Lam*Wmass*(Wmass^2 - Zmass^2) - Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(4*CphiW*Wmass^2 + CphiD*Zmass^2 - 4*CphiW*Zmass^2)))*CuW[e1x2, e2x2]*IndexDelta[e1x3, e2x3])/(Sqrt[2]*(4*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(CphiD*Lam*Zmass^2 + 4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + 4*CphiW*Lam*(Wmass^2 - Zmass^2))))), 0}, {0, 0}},

C[ -F[3, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , S[1] , V[1] ] == {{(-I)*gc676*Conjugate[CuW[e2x2, e1x2]]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {(I*gc676*(4*Sqrt[2]*CphiWB*Lam*Wmass*(Wmass^2 - Zmass^2) - Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(4*CphiW*Wmass^2 + CphiD*Zmass^2 - 4*CphiW*Zmass^2 + 4*CphiBox*(Wmass^2 - Zmass^2))))*CuW[e1x2, e2x2]*IndexDelta[e1x3, e2x3])/(Sqrt[2]*(4*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(4*CphiW*Wmass^2 + CphiD*Zmass^2 - 4*CphiW*Zmass^2 + 4*CphiBox*(Wmass^2 - Zmass^2))))), 0}, {0, 0}, {((-I)*gc676*(4*Sqrt[2]*CphiWB*Lam*Wmass*(Wmass^2 - Zmass^2) - Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(4*CphiW*Wmass^2 + CphiD*Zmass^2 - 4*CphiW*Zmass^2 + 4*CphiBox*(Wmass^2 - Zmass^2))))*Conjugate[CuW[e2x2, e1x2]]*IndexDelta[e1x3, e2x3])/(Sqrt[2]*(4*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(4*CphiW*Wmass^2 + CphiD*Zmass^2 - 4*CphiW*Zmass^2 + 4*CphiBox*(Wmass^2 - Zmass^2))))), 0}, {0, 0}, {((-I)*gc676*(4*Sqrt[2]*CphiWB*Lam*Wmass*(Wmass^2 - Zmass^2) - Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(4*CphiW*Wmass^2 + CphiD*Zmass^2 - 4*CphiW*Zmass^2 + 4*CphiBox*(Wmass^2 - Zmass^2))))*CuW[e1x2, e2x2]*IndexDelta[e1x3, e2x3])/(Sqrt[2]*(4*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(4*CphiW*Wmass^2 + CphiD*Zmass^2 - 4*CphiW*Zmass^2 + 4*CphiBox*(Wmass^2 - Zmass^2))))), 0}, {0, 0}},

C[ -F[3, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , S[3] , -V[3] ] == {{(-I)*gc677[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {0, 0}, {0, 0}, {I*gc677[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {0, 0}, {0, 0}},

C[ -F[3, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , S[2] , V[2] ] == {{gc678*Conjugate[CuW[e2x2, e1x2]]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {-(gc678*CuW[e1x2, e2x2]*IndexDelta[e1x3, e2x3]), 0}, {0, 0}, {-(gc678*Conjugate[CuW[e2x2, e1x2]]*IndexDelta[e1x3, e2x3]), 0}, {0, 0}, {gc678*CuW[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}},

C[ -F[3, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , S[1] , V[2] ] == {{(-I)*gc679*Conjugate[CuW[e2x2, e1x2]]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {(-I)*gc679*CuW[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {I*gc679*Conjugate[CuW[e2x2, e1x2]]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {I*gc679*CuW[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}},

C[ -F[3, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , S[3] , V[1] ] == {{(-I)*gc680[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {0, 0}, {0, 0}, {(I*Sqrt[2]*(4*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(CphiD*Lam*Wmass^2 + 4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + 4*CphiW*Lam*(Wmass^2 - Zmass^2)))*gc680[e1x2, e2x2]*IndexDelta[e1x3, e2x3])/(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2))), 0}, {0, 0}, {0, 0}, {0, 0}},

C[ -F[3, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , S[2] , V[3] ] == {{-(gc681[e1x2, e2x2]*IndexDelta[e1x3, e2x3]), 0}, {0, 0}, {0, 0}, {0, 0}, {gc681[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {0, 0}, {0, 0}},

C[ -F[3, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , S[1] , V[3] ] == {{(-I)*gc682[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {0, 0}, {0, 0}, {I*gc682[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {0, 0}, {0, 0}},

C[ -F[3, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , S[3] , V[2] ] == {{(-I)*gc683[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {0, 0}, {0, 0}, {I*gc683[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {0, 0}, {0, 0}},

C[ -F[3, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , V[1] , V[3] ] == {{(-I)*gc684[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {0, 0}, {0, 0}, {(I*Sqrt[2]*(4*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(CphiD*Lam*Wmass^2 + 4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + 4*CphiW*Lam*(Wmass^2 - Zmass^2)))*gc684[e1x2, e2x2]*IndexDelta[e1x3, e2x3])/(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2))), 0}, {0, 0}, {0, 0}, {0, 0}},

C[ -F[3, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , S[2] , V[1] , V[3] ] == {{-(gc685[e1x2, e2x2]*IndexDelta[e1x3, e2x3]), 0}, {0, 0}, {0, 0}, {0, 0}, {-((Sqrt[2]*(4*CphiWB*Lam*Wmass*(Wmass^2 - Zmass^2) - Sqrt[-Wmass^2 + Zmass^2]*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(4*CphiW*Wmass^2 + CphiD*Zmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2))))*gc685[e1x2, e2x2]*IndexDelta[e1x3, e2x3])/(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(4*CphiW*Wmass^2 + CphiD*Zmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2))))), 0}, {0, 0}, {0, 0}, {0, 0}},

C[ -F[3, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , S[1] , V[1] , V[3] ] == {{(-I)*gc686[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {0, 0}, {0, 0}, {(I*Sqrt[2]*(4*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(4*CphiBox*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiBox*Zmass^2 + CphiD*Zmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2))))*gc686[e1x2, e2x2]*IndexDelta[e1x3, e2x3])/(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(4*CphiBox*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiBox*Zmass^2 + CphiD*Zmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2)))), 0}, {0, 0}, {0, 0}, {0, 0}},

C[ -F[3, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , S[3] , V[1] , -V[3] ] == {{(-I)*gc687[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {0, 0}, {0, 0}, {I*gc687[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {0, 0}, {0, 0}},

C[ -F[3, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , V[3] , -V[3] ] == {{(-I)*gc688*Conjugate[CuW[e2x2, e1x2]]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {(-I)*gc688*CuW[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {I*gc688*Conjugate[CuW[e2x2, e1x2]]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {I*gc688*CuW[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}},

C[ -F[3, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , S[2] , V[3] , -V[3] ] == {{gc689*Conjugate[CuW[e2x2, e1x2]]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {-(gc689*CuW[e1x2, e2x2]*IndexDelta[e1x3, e2x3]), 0}, {0, 0}, {-(gc689*Conjugate[CuW[e2x2, e1x2]]*IndexDelta[e1x3, e2x3]), 0}, {0, 0}, {gc689*CuW[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}},

C[ -F[3, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , S[1] , V[3] , -V[3] ] == {{(-I)*gc690*Conjugate[CuW[e2x2, e1x2]]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {(-I)*gc690*CuW[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {I*gc690*Conjugate[CuW[e2x2, e1x2]]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {I*gc690*CuW[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}},

C[ -F[3, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , S[3] , V[3] , -V[3] ] == {{(-I)*gc691[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {0, 0}, {0, 0}, {I*gc691[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {0, 0}, {0, 0}},

C[ -F[3, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , V[3] , V[2] ] == {{(-I)*gc692[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {0, 0}, {0, 0}, {I*gc692[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {0, 0}, {0, 0}},

C[ -F[3, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , S[2] , V[3] , V[2] ] == {{-(gc693[e1x2, e2x2]*IndexDelta[e1x3, e2x3]), 0}, {0, 0}, {0, 0}, {0, 0}, {gc693[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {0, 0}, {0, 0}},

C[ -F[3, {e1x2, e1x3}] , F[4, {e2x2, e2x3}] , S[1] , V[3] , V[2] ] == {{(-I)*gc694[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {0, 0}, {0, 0}, {I*gc694[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {0, 0}, {0, 0}},

C[ -F[3, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , S[3] , -V[3] , V[2] ] == {{(-I)*gc695[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {0, 0}, {0, 0}, {I*gc695[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {0, 0}, {0, 0}},

C[ -F[4, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , -S[3] , V[1] ] == {{0, 0}, {0, 0}, {((-I)*Sqrt[2]*(4*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(CphiD*Lam*Wmass^2 + 4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + 4*CphiW*Lam*(Wmass^2 - Zmass^2)))*gc696[e1x2, e2x2]*IndexDelta[e1x3, e2x3])/(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2))), 0}, {0, 0}, {0, 0}, {0, 0}, {(I*Sqrt[2]*(4*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(CphiD*Lam*Wmass^2 + 4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + 4*CphiW*Lam*(Wmass^2 - Zmass^2)))*gc696[e1x2, e2x2]*IndexDelta[e1x3, e2x3])/(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2))), 0}, {0, 0}},

C[ -F[4, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , S[2] , -V[3] ] == {{0, 0}, {0, 0}, {-(gc697[e1x2, e2x2]*IndexDelta[e1x3, e2x3]), 0}, {0, 0}, {0, 0}, {0, 0}, {gc697[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}},

C[ -F[4, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , S[1] , -V[3] ] == {{0, 0}, {0, 0}, {(-I)*gc698[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {0, 0}, {0, 0}, {I*gc698[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}},

C[ -F[4, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , -S[3] , V[2] ] == {{0, 0}, {0, 0}, {(-I)*gc699[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {0, 0}, {0, 0}, {I*gc699[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}},

C[ -F[3, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , -S[3] , V[3] ] == {{0, 0}, {0, 0}, {(-I)*gc700[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {0, 0}, {0, 0}, {I*gc700[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}},

C[ -F[3, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , -S[3] , V[1] , V[3] ] == {{0, 0}, {0, 0}, {(-I)*gc701[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {0, 0}, {0, 0}, {I*gc701[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}},

C[ -F[4, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , V[1] , -V[3] ] == {{0, 0}, {0, 0}, {((-I)*Sqrt[2]*(4*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(CphiD*Lam*Wmass^2 + 4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + 4*CphiW*Lam*(Wmass^2 - Zmass^2)))*gc702[e1x2, e2x2]*IndexDelta[e1x3, e2x3])/(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2))), 0}, {0, 0}, {0, 0}, {0, 0}, {(I*Sqrt[2]*(4*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(CphiD*Lam*Wmass^2 + 4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + 4*CphiW*Lam*(Wmass^2 - Zmass^2)))*gc702[e1x2, e2x2]*IndexDelta[e1x3, e2x3])/(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2))), 0}, {0, 0}},

C[ -F[4, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , S[2] , V[1] , -V[3] ] == {{0, 0}, {0, 0}, {-((Sqrt[2]*(4*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(4*CphiW*Wmass^2 + CphiD*Zmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2))))*gc703[e1x2, e2x2]*IndexDelta[e1x3, e2x3])/(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(4*CphiW*Wmass^2 + CphiD*Zmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2))))), 0}, {0, 0}, {0, 0}, {0, 0}, {-((Sqrt[2]*(4*CphiWB*Lam*Wmass*(Wmass^2 - Zmass^2) - Sqrt[-Wmass^2 + Zmass^2]*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(4*CphiW*Wmass^2 + CphiD*Zmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2))))*gc703[e1x2, e2x2]*IndexDelta[e1x3, e2x3])/(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(4*CphiW*Wmass^2 + CphiD*Zmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2))))), 0}, {0, 0}},

C[ -F[4, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , S[1] , V[1] , -V[3] ] == {{0, 0}, {0, 0}, {((-I)*Sqrt[2]*(4*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(4*CphiBox*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiBox*Zmass^2 + CphiD*Zmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2))))*gc704[e1x2, e2x2]*IndexDelta[e1x3, e2x3])/(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(4*CphiBox*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiBox*Zmass^2 + CphiD*Zmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2)))), 0}, {0, 0}, {0, 0}, {0, 0}, {(I*Sqrt[2]*(4*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(4*CphiBox*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiBox*Zmass^2 + CphiD*Zmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2))))*gc704[e1x2, e2x2]*IndexDelta[e1x3, e2x3])/(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(4*CphiBox*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiBox*Zmass^2 + CphiD*Zmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2)))), 0}, {0, 0}},

C[ -F[4, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , -S[3] , V[3] , -V[3] ] == {{0, 0}, {0, 0}, {(-I)*gc705[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {0, 0}, {0, 0}, {I*gc705[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}},

C[ -F[3, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , -S[3] , V[3] , V[2] ] == {{0, 0}, {0, 0}, {(-I)*gc706[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {0, 0}, {0, 0}, {I*gc706[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}},

C[ -F[4, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , -V[3] , V[2] ] == {{0, 0}, {0, 0}, {(-I)*gc707[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {0, 0}, {0, 0}, {I*gc707[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}},

C[ -F[4, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , S[2] , -V[3] , V[2] ] == {{0, 0}, {0, 0}, {-(gc708[e1x2, e2x2]*IndexDelta[e1x3, e2x3]), 0}, {0, 0}, {0, 0}, {0, 0}, {gc708[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}},

C[ -F[4, {e1x2, e1x3}] , F[3, {e2x2, e2x3}] , S[1] , -V[3] , V[2] ] == {{0, 0}, {0, 0}, {(-I)*gc709[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}, {0, 0}, {0, 0}, {I*gc709[e1x2, e2x2]*IndexDelta[e1x3, e2x3], 0}, {0, 0}}

}

(* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *)

(* Parameter replacement lists (These lists were created by FeynRules) *)

(* FA Couplings *)

M$FACouplings = {
     gc1 -> -1/16*1/Gf,
     gc2 -> -1/16*1/Gf,
     gc3 -> -1/8*1/Gf,
     gc4 -> -1/32*1/(2^(3/4)*Gf^(3/2)),
     gc5 -> -1/32*1/(2^(3/4)*Gf^(3/2)),
     gc6 -> -1/16*1/Gf^2,
     gc7 -> -1/16*1/Gf^2,
     gc8 -> -1/32*1/(2^(3/4)*Gf^(5/2)),
     gc9 -> -1/16*1/Gf^2,
     gc62 -> (2*Gf*Wmass^2*Zmass^2 - 2*Gf*Zmass^4)^(-1),
     gc63 -> (8*Sqrt[2]*Lam*Wmass^2)/Zmass^2,
     gc64 -> (1024*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass^4*(Wmass^2 - Zmass^2)^2)/Zmass^4,
     gc65 -> (CphiD*Lam*Wmass*(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(Sqrt[2]*CphiD*Lam*Zmass^2 + 8*Gf*(Wmass^2 - Zmass^2))))/(4*Gf*(Wmass - Zmass)*Zmass*(Wmass + Zmass)),
     gc66 -> (Lam*Wmass)/(2^(3/4)*Sqrt[Gf]*(2*Wmass^2*Zmass - 2*Zmass^3)),
     gc67 -> (8*Sqrt[2]*Gf*Lam^2*Wmass^2*(Wmass^2 - Zmass^2))/Zmass^2,
     gc68 -> (Wmass*(-64*Gf^2*(Wmass^2 - Zmass^2)^2 + 8*Sqrt[2]*Gf*Lam*(Wmass^2 - Zmass^2)*(Cll2x1x1x2*(Wmass^2 - Zmass^2) - Wmass*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2])) + Lam^2*(7*Cll2x1x1x2^2*(Wmass^2 - Zmass^2)^2 - 2*Cll2x1x1x2*Wmass*(Wmass^2 - Zmass^2)*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2]) + Wmass*(CphiD^2*Wmass^3 + 8*CphiD*CphiWB*(-Wmass^2 + Zmass^2)^(3/2) + 32*CphiW*CphiWB*(-Wmass^2 + Zmass^2)^(3/2)))))/(16*2^(3/4)*Gf^(3/2)*(Wmass - Zmass)*Zmass*(Wmass + Zmass)*Sqrt[-Wmass^2 + Zmass^2]),
     gc69 -> -1/16*(Wmass*(-64*Gf^2*(Wmass^2 - Zmass^2)^2 + 8*Sqrt[2]*Gf*Lam*(Wmass^2 - Zmass^2)*(Cll2x1x1x2*(Wmass^2 - Zmass^2) - Wmass*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2])) + Lam^2*(7*Cll2x1x1x2^2*(Wmass^2 - Zmass^2)^2 - 2*Cll2x1x1x2*Wmass*(Wmass^2 - Zmass^2)*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2]) + Wmass*(CphiD^2*Wmass^3 + 8*CphiD*CphiWB*(-Wmass^2 + Zmass^2)^(3/2) + 32*CphiW*CphiWB*(-Wmass^2 + Zmass^2)^(3/2)))))/(2^(3/4)*Gf^(3/2)*(Wmass - Zmass)*Zmass*(Wmass + Zmass)*Sqrt[-Wmass^2 + Zmass^2]),
     gc70 -> (Wmass*(-64*Gf^2*(Wmass^2 - Zmass^2)^2 + 8*Sqrt[2]*Gf*Lam*(Wmass^2 - Zmass^2)*(Cll2x1x1x2*(Wmass^2 - Zmass^2) - Wmass*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2])) + Lam^2*(7*Cll2x1x1x2^2*(Wmass^2 - Zmass^2)^2 - 2*Cll2x1x1x2*Wmass*(Wmass^2 - Zmass^2)*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2]) + Wmass*(CphiD^2*Wmass^3 + 8*CphiD*CphiWB*(-Wmass^2 + Zmass^2)^(3/2) + 32*CphiW*CphiWB*(-Wmass^2 + Zmass^2)^(3/2)))))/(16*2^(3/4)*Gf^(3/2)*(Wmass - Zmass)*Zmass*(Wmass + Zmass)*Sqrt[-Wmass^2 + Zmass^2]),
     gc71 -> -((Lam*Wmass)/(2^(3/4)*Sqrt[Gf]*(Wmass^2*Zmass - Zmass^3))),
     gc72 -> (64*2^(3/4)*(Cphi4n1 + Cphi4n3)*Gf^(3/2)*Lam^2*Wmass^3*(-Wmass^2 + Zmass^2)^(3/2))/Zmass^3,
     gc73 -> (CphiD*Lam*(4*Sqrt[2]*Gf + (Cll2x1x1x2 - CphiD)*Lam))/(8*2^(3/4)*Gf^(3/2)),
     gc74 -> Lam/(8*Gf),
     gc75 -> (2*2^(1/4)*Sqrt[Gf]*Lam^2*Wmass*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc76 -> (8*Sqrt[2]*Gf*Lam^2*Wmass^2*(Wmass^2 - Zmass^2))/Zmass^2,
     gc77 -> (-2*2^(1/4)*Sqrt[Gf]*Lam^2*Wmass*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc78 -> (Lam*(8*Sqrt[2]*CphiW^2*Lam*(Wmass^2 - Zmass^2)^2 + CphiWB*Wmass*(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*Wmass^2 - 8*Gf*Zmass^2 + Sqrt[2]*CphiD*Lam*Zmass^2)) + 2*CphiW*(Wmass^2 - Zmass^2)*(4*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Zmass^2 + 6*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2]))))/(2*Gf*(Wmass - Zmass)*Zmass^2*(Wmass + Zmass)),
     gc79 -> (Lam*(8*CphiW^2*Lam*(Wmass^2 - Zmass^2)^2 + CphiW*(Wmass^2 - Zmass^2)*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(Cll2x1x1x2*Wmass^2 + 4*CphiBox*Wmass^2 + CphiD*Wmass^2 - Cll2x1x1x2*Zmass^2 - 4*CphiBox*Zmass^2 + CphiD*Zmass^2 + 12*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2])) + CphiWB*Wmass*(4*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(Cll2x1x1x2*Wmass^2 + 4*CphiBox*Wmass^2 + CphiD*Wmass^2 - Cll2x1x1x2*Zmass^2 - 4*CphiBox*Zmass^2)))))/(2^(3/4)*Gf^(3/2)*(Wmass - Zmass)*Zmass^2*(Wmass + Zmass)),
     gc80 -> (Lam*(8*Sqrt[2]*CphiW^2*Lam*(Wmass^2 - Zmass^2)^2 + 2*CphiW*(Wmass^2 - Zmass^2)*(4*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Zmass^2 + 4*CphiBox*(Wmass^2 - Zmass^2) + 6*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2])) + CphiWB*Wmass*(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(8*CphiBox*Wmass^2 - 8*CphiBox*Zmass^2 + CphiD*Zmass^2)))))/(2*Gf*(Wmass - Zmass)*Zmass^2*(Wmass + Zmass)),
     gc81 -> -1/32*Wmass/(Gf*Zmass*(-Wmass^2 + Zmass^2)^(3/2)),
     gc82 -> -1/16*Wmass/(2^(3/4)*Gf^(3/2)*Zmass*(-Wmass^2 + Zmass^2)^(3/2)),
     gc83 -> Wmass/(32*Gf*Zmass*(-Wmass^2 + Zmass^2)^(3/2)),
     gc84 -> Wmass/(32*Gf*Zmass*(-Wmass^2 + Zmass^2)^(3/2)),
     gc85 -> -1/16*Wmass/(2^(3/4)*Gf^(3/2)*Zmass*(-Wmass^2 + Zmass^2)^(3/2)),
     gc86 -> Wmass/(32*Gf*Zmass*(-Wmass^2 + Zmass^2)^(3/2)),
     gc87 -> -1/8*1/Gf,
     gc88 -> -1/8*1/Gf,
     gc89 -> 1/(16*2^(3/4)*Gf^(3/2)),
     gc90 -> -1/8*1/Gf,
     gc91 -> (Lam*(-4*Sqrt[2]*CphiWB^2*Lam*Wmass*(-Wmass^2 + Zmass^2)^(3/2) + CphiWB*(Wmass^2 - Zmass^2)*(Gf*(8*Wmass^2 - 4*Zmass^2) + Sqrt[2]*Lam*(12*CphiW*Wmass^2 + CphiD*Zmass^2 - 6*CphiW*Zmass^2)) - CphiW*Wmass*Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Zmass^2 + 8*CphiW*(Wmass^2 - Zmass^2)))))/(2*Gf*(Wmass - Zmass)*Zmass^2*(Wmass + Zmass)),
     gc92 -> -1/16*1/(Gf*Zmass^2*(-Wmass^2 + Zmass^2)^(3/2)),
     gc93 -> (Lam*(-8*CphiWB^2*Lam*Wmass*(-Wmass^2 + Zmass^2)^(3/2) + CphiWB*(Wmass^2 - Zmass^2)*(4*Sqrt[2]*Gf*(2*Wmass^2 - Zmass^2) + Lam*(2*Cll2x1x1x2*Wmass^2 + 8*CphiBox*Wmass^2 + 2*CphiD*Wmass^2 + 24*CphiW*Wmass^2 - Cll2x1x1x2*Zmass^2 - 4*CphiBox*Zmass^2 + CphiD*Zmass^2 - 12*CphiW*Zmass^2)) - 2*CphiW*Wmass*Sqrt[-Wmass^2 + Zmass^2]*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(4*CphiBox*Wmass^2 + CphiD*Wmass^2 + 8*CphiW*Wmass^2 - 4*CphiBox*Zmass^2 - 8*CphiW*Zmass^2 + Cll2x1x1x2*(Wmass^2 - Zmass^2)))))/(2*2^(3/4)*Gf^(3/2)*(Wmass - Zmass)*Zmass^2*(Wmass + Zmass)),
     gc94 -> (Lam*(-4*Sqrt[2]*CphiWB^2*Lam*Wmass*(-Wmass^2 + Zmass^2)^(3/2) + CphiWB*(Wmass^2 - Zmass^2)*(Gf*(8*Wmass^2 - 4*Zmass^2) + Sqrt[2]*Lam*(8*CphiBox*Wmass^2 + 12*CphiW*Wmass^2 - 4*CphiBox*Zmass^2 + CphiD*Zmass^2 - 6*CphiW*Zmass^2)) - CphiW*Wmass*Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(8*CphiW*Wmass^2 + CphiD*Zmass^2 - 8*CphiW*Zmass^2 + 8*CphiBox*(Wmass^2 - Zmass^2)))))/(2*Gf*(Wmass - Zmass)*Zmass^2*(Wmass + Zmass)),
     gc95 -> -1/16*1/(2^(3/4)*Gf^(3/2)*Zmass*Sqrt[-Wmass^2 + Zmass^2]),
     gc96 -> -1/8*1/(Gf*Zmass*Sqrt[-Wmass^2 + Zmass^2]),
     gc97 -> 1/(8*Gf*Zmass*Sqrt[-Wmass^2 + Zmass^2]),
     gc98 -> -1/16*1/(2^(3/4)*Gf^(3/2)*Zmass*Sqrt[-Wmass^2 + Zmass^2]),
     gc99 -> 1/(8*Gf*Zmass*Sqrt[-Wmass^2 + Zmass^2]),
     gc100 -> 1/(8*Gf*Zmass*Sqrt[-Wmass^2 + Zmass^2]),
     gc101 -> -1/8*1/(Gf*Zmass^2*Sqrt[-Wmass^2 + Zmass^2]),
     gc102 -> -1/8*1/(Gf*Zmass^2*Sqrt[-Wmass^2 + Zmass^2]),
     gc103 -> 1/(16*2^(3/4)*Gf^(3/2)*Zmass^2*Sqrt[-Wmass^2 + Zmass^2]),
     gc104 -> -1/8*1/(Gf*Zmass^2*Sqrt[-Wmass^2 + Zmass^2]),
     gc105 -> 2*Sqrt[aS]*Sqrt[Pi],
     gc106 -> -4*aS*Pi,
     gc107 -> -2*Sqrt[aS]*Sqrt[Pi],
     gc108 -> (3*Lam*(-4*Sqrt[2]*Gf + 3*CphiD*Lam))/(8*Gf),
     gc109 -> (Lam*(8*Gf + Sqrt[2]*(Cll2x1x1x2 - 2*CphiD)*Lam))/(8*2^(3/4)*Gf^(3/2)),
     gc110 -> (Lam*(-4*Sqrt[2]*Gf + CphiD*Lam))/(8*Gf),
     gc111 -> (Lam*(8*Gf + Sqrt[2]*Cll2x1x1x2*Lam))/(8*2^(3/4)*Gf^(3/2)),
     gc112 -> (Lam*(4*Sqrt[2]*Gf + 4*CphiBox*Lam - 3*CphiD*Lam))/(8*Gf),
     gc113[e1x2_, e2x2_] -> (4*Lam*(8*Gf + Sqrt[2]*(2*Cll2x1x1x2 + 4*CphiBox - CphiD)*Lam)*Conjugate[Cdphi[e2x2, e1x2]] - 2^(1/4)*Sqrt[Gf]*(64*Gf^2 - 8*Sqrt[2]*(Cll2x1x1x2 - 4*CphiBox + CphiD)*Gf*Lam + (-7*Cll2x1x1x2^2 + Cll2x1x1x2*(8*CphiBox - 2*CphiD) + 3*(-4*CphiBox + CphiD)^2)*Lam^2)*fmd[e1x2, e2x2])/(64*Gf^2),
     gc114 -> -1/8*(Lam*(8*Gf + Sqrt[2]*(Cll2x1x1x2 + 4*CphiBox - 2*CphiD)*Lam))/(2^(3/4)*Gf^(3/2)),
     gc115 -> (Lam*(4*Sqrt[2]*Gf + 4*CphiBox*Lam - CphiD*Lam))/(8*Gf),
     gc116 -> -1/8*(Lam*(4*Sqrt[2]*Gf + 8*CphiBox*Lam - 3*CphiD*Lam))/Gf,
     gc117 -> (3*Lam*(8*Gf + Sqrt[2]*(Cll2x1x1x2 + 8*CphiBox - 2*CphiD)*Lam))/(8*2^(3/4)*Gf^(3/2)),
     gc118 -> (3*Lam*(4*Sqrt[2]*Gf + 12*CphiBox*Lam - 3*CphiD*Lam))/(8*Gf),
     gc119[e1x2_, e2x2_] -> (Lam*(4*Gf - Sqrt[2]*CphiD*Lam)*IndexSum[Conjugate[Cdphi[Generation$1, e1x2]]*Conjugate[Kq[e2x2, Generation$1]], {Generation$1, 1, 3}])/(4*Gf),
     gc120[e1x2_, e2x2_] -> 2*Lam*IndexSum[Conjugate[Cdphi[Generation$1, e1x2]]*Conjugate[Kq[e2x2, Generation$1]], {Generation$1, 1, 3}],
     gc121[e1x2_, e2x2_] -> (Lam*(4*Sqrt[2]*Gf + (Cll2x1x1x2 + 4*CphiBox - CphiD)*Lam)*IndexSum[Conjugate[Cdphi[Generation$1, e1x2]]*Conjugate[Kq[e2x2, Generation$1]], {Generation$1, 1, 3}])/(4*2^(3/4)*Gf^(3/2)),
     gc122[e1x2_, e2x2_] -> (Lam*(4*Gf + Sqrt[2]*(4*CphiBox - CphiD)*Lam)*IndexSum[Conjugate[Cdphi[Generation$1, e1x2]]*Conjugate[Kq[e2x2, Generation$1]], {Generation$1, 1, 3}])/(4*Gf),
     gc123[e1x2_, e2x2_] -> ((-64*Gf^2 + 8*Sqrt[2]*(Cll2x1x1x2 + CphiD)*Gf*Lam + (7*Cll2x1x1x2^2 + 2*Cll2x1x1x2*CphiD - 3*CphiD^2)*Lam^2)*fmd[e1x2, e2x2])/(32*2^(3/4)*Gf^(3/2)),
     gc124[e1x2_, e2x2_] -> -1/32*((64*Sqrt[2]*Gf^2 - 16*Cll2x1x1x2*Gf*Lam - 7*Sqrt[2]*Cll2x1x1x2^2*Lam^2)*IndexSum[Conjugate[Kq[e2x2, Generation$1]]*fmd[e1x2, Generation$1], {Generation$1, 1, 3}])/(2^(3/4)*Gf^(3/2)),
     gc125[e1x2_, e2x2_] -> ((-64*Gf^2 + 8*Sqrt[2]*(Cll2x1x1x2 + CphiD)*Gf*Lam + (7*Cll2x1x1x2^2 + 2*Cll2x1x1x2*CphiD - 3*CphiD^2)*Lam^2)*fml[e1x2, e2x2])/(32*2^(3/4)*Gf^(3/2)),
     gc126[e1x2_, e2x2_] -> ((-64*Gf^2 + 8*Sqrt[2]*(Cll2x1x1x2 - 4*CphiBox + CphiD)*Gf*Lam + (7*Cll2x1x1x2^2 - 3*(-4*CphiBox + CphiD)^2 + Cll2x1x1x2*(-8*CphiBox + 2*CphiD))*Lam^2)*fml[e1x2, e2x2])/(32*2^(3/4)*Gf^(3/2)),
     gc127[e1x2_, e2x2_] -> -1/32*((-64*Gf^2 + 8*Sqrt[2]*(Cll2x1x1x2 + CphiD)*Gf*Lam + (7*Cll2x1x1x2^2 + 2*Cll2x1x1x2*CphiD - 3*CphiD^2)*Lam^2)*fmu[e1x2, e2x2])/(2^(3/4)*Gf^(3/2)),
     gc128[e1x2_, e2x2_] -> ((-64*Gf^2 + 8*Sqrt[2]*(Cll2x1x1x2 - 4*CphiBox + CphiD)*Gf*Lam + (7*Cll2x1x1x2^2 - 3*(-4*CphiBox + CphiD)^2 + Cll2x1x1x2*(-8*CphiBox + 2*CphiD))*Lam^2)*fmu[e1x2, e2x2])/(32*2^(3/4)*Gf^(3/2)),
     gc129[e1x2_, e2x2_] -> ((64*Sqrt[2]*Gf^2 - 16*Cll2x1x1x2*Gf*Lam - 7*Sqrt[2]*Cll2x1x1x2^2*Lam^2)*IndexSum[fmu[e1x2, Generation$1]*Kq[Generation$1, e2x2], {Generation$1, 1, 3}])/(32*2^(3/4)*Gf^(3/2)),
     gc131[e1x2_, e2x2_] -> (Lam*(4*Gf - Sqrt[2]*CphiD*Lam)*IndexSum[Cdphi[Generation$1, e2x2]*Kq[e1x2, Generation$1], {Generation$1, 1, 3}])/(4*Gf),
     gc132[e1x2_, e2x2_] -> 2*Lam*IndexSum[Cdphi[Generation$1, e2x2]*Kq[e1x2, Generation$1], {Generation$1, 1, 3}],
     gc133[e1x2_, e2x2_] -> (Lam*(4*Sqrt[2]*Gf + (Cll2x1x1x2 + 4*CphiBox - CphiD)*Lam)*IndexSum[Cdphi[Generation$1, e2x2]*Kq[e1x2, Generation$1], {Generation$1, 1, 3}])/(4*2^(3/4)*Gf^(3/2)),
     gc134[e1x2_, e2x2_] -> (Lam*(4*Gf + Sqrt[2]*(4*CphiBox - CphiD)*Lam)*IndexSum[Cdphi[Generation$1, e2x2]*Kq[e1x2, Generation$1], {Generation$1, 1, 3}])/(4*Gf),
     gc135[e1x2_, e2x2_] -> -1/32*((64*Sqrt[2]*Gf^2 - 16*Cll2x1x1x2*Gf*Lam - 7*Sqrt[2]*Cll2x1x1x2^2*Lam^2)*IndexSum[fml[e1x2, Generation$1]*Ul[Generation$1, e2x2], {Generation$1, 1, 3}])/(2^(3/4)*Gf^(3/2)),
     gc136 -> (2*Lam*Wmass^2)/(Wmass^2*Zmass - Zmass^3),
     gc137 -> -((2^(1/4)*Lam*Wmass^2)/(Sqrt[Gf]*(Wmass^2*Zmass - Zmass^3))),
     gc138 -> (2*Lam*Wmass^2)/(Wmass^2*Zmass - Zmass^3),
     gc139 -> (64*2^(3/4)*(Cphi4n1 + Cphi4n3)*Gf^(3/2)*Lam^2*Wmass^4*(-Wmass^2 + Zmass^2)^(3/2))/Zmass^3,
     gc140 -> (-128*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass^4*(-Wmass^2 + Zmass^2)^(3/2))/Zmass^3,
     gc141 -> (128*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass^4*(-Wmass^2 + Zmass^2)^(3/2))/Zmass^3,
     gc142 -> Wmass/(32*2^(3/4)*Gf^(3/2)),
     gc143 -> -1/4*(Lam*Wmass)/Gf,
     gc144 -> (Lam*Wmass)/(4*Gf),
     gc145 -> -1/4*(Lam*Wmass)/(2^(3/4)*Sqrt[Gf]),
     gc146 -> (Lam*Wmass)/(4*2^(3/4)*Sqrt[Gf]),
     gc147 -> (8*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^3*(Wmass^2 - Zmass^2))/Zmass^2,
     gc148 -> (-2*2^(1/4)*Sqrt[Gf]*Lam^2*Wmass^2*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc149 -> (2*Sqrt[2]*Gf*Lam^2*Wmass^2*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc150 -> (-2*Sqrt[2]*Gf*Lam^2*Wmass^2*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc151 -> 2^(1/4)*Sqrt[Gf]*Lam^2*Wmass,
     gc152 -> (Wmass*(64*Gf^2*(Wmass^2 - Zmass^2)^2 + 8*Sqrt[2]*Gf*Lam*(Wmass^2 - Zmass^2)*(CphiD*Wmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2)) - Lam^2*(CphiD^2*Wmass^4 + 7*Cll2x1x1x2^2*(Wmass^2 - Zmass^2)^2 + 2*Cll2x1x1x2*CphiD*Wmass^2*(-Wmass^2 + Zmass^2))))/(16*2^(3/4)*Gf^(3/2)*(Wmass - Zmass)*Zmass*(Wmass + Zmass)*Sqrt[-Wmass^2 + Zmass^2]),
     gc153 -> -1/16*(Wmass*((-64*Gf^2 + 8*Sqrt[2]*(Cll2x1x1x2 - CphiD)*Gf*Lam + (7*Cll2x1x1x2^2 - 2*Cll2x1x1x2*CphiD + CphiD^2)*Lam^2)*Wmass*Sqrt[-Wmass^2 + Zmass^2] + 8*CphiWB*Lam*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(Cll2x1x1x2*Wmass^2 + CphiD*Wmass^2 + 4*CphiW*Wmass^2 - Cll2x1x1x2*Zmass^2 - 4*CphiW*Zmass^2))))/(2^(3/4)*Gf^(3/2)*Zmass*Sqrt[-Wmass^2 + Zmass^2]),
     gc154 -> (Wmass*(-64*Gf^2*(Wmass^2 - Zmass^2)^2 + 8*Sqrt[2]*Gf*Lam*(Wmass^2 - Zmass^2)*(Cll2x1x1x2*(Wmass^2 - Zmass^2) - Wmass*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2])) + Lam^2*(7*Cll2x1x1x2^2*(Wmass^2 - Zmass^2)^2 - 2*Cll2x1x1x2*Wmass*(Wmass^2 - Zmass^2)*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2]) + Wmass*(CphiD^2*Wmass^3 + 8*CphiD*CphiWB*(-Wmass^2 + Zmass^2)^(3/2) + 32*CphiW*CphiWB*(-Wmass^2 + Zmass^2)^(3/2)))))/(16*2^(3/4)*Gf^(3/2)*(Wmass - Zmass)*Zmass*(Wmass + Zmass)*Sqrt[-Wmass^2 + Zmass^2]),
     gc155 -> ((-64*Gf^2 + 8*Sqrt[2]*(Cll2x1x1x2 - CphiD)*Gf*Lam + (7*Cll2x1x1x2^2 - 2*Cll2x1x1x2*CphiD + CphiD^2)*Lam^2)*Wmass^2)/(16*2^(3/4)*Gf^(3/2)*Zmass),
     gc156 -> Lam*Wmass,
     gc157 -> (Lam*Wmass)/(4*2^(3/4)*Sqrt[Gf]),
     gc158 -> -1/4*(Lam*Wmass)/(2^(3/4)*Sqrt[Gf]),
     gc159 -> (-8*Sqrt[2]*(Cphi4n1 + Cphi4n3)*Gf*Lam^2*Wmass^3*(Wmass^2 - Zmass^2))/Zmass^2,
     gc160 -> (8*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^3*(Wmass^2 - Zmass^2))/Zmass^2,
     gc161 -> ((-64*Gf^2 + 8*Sqrt[2]*(Cll2x1x1x2 - 4*CphiBox + CphiD)*Gf*Lam + (7*Cll2x1x1x2^2 - 3*(-4*CphiBox + CphiD)^2 + Cll2x1x1x2*(-8*CphiBox + 2*CphiD))*Lam^2)*Wmass)/(32*2^(3/4)*Gf^(3/2)),
     gc162 -> (-2*2^(1/4)*Sqrt[Gf]*Lam^2*Wmass^2*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc163 -> (2*Sqrt[2]*Gf*Lam^2*Wmass^2*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc164 -> (-2*Sqrt[2]*Gf*Lam^2*Wmass^2*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc165 -> -(Lam^2*Wmass),
     gc166 -> 2^(1/4)*Sqrt[Gf]*Lam^2*Wmass,
     gc167 -> 2*Lam*Wmass^2,
     gc168 -> (2^(1/4)*Lam*Wmass^2)/Sqrt[Gf],
     gc169 -> 2*Sqrt[2]*Lam*Wmass^2,
     gc170 -> -((2^(1/4)*Lam*Wmass^2)/Sqrt[Gf]),
     gc171 -> 2*Sqrt[2]*Lam*Wmass^2,
     gc172 -> -2*Sqrt[2]*Lam*Wmass^2,
     gc173 -> (-2*2^(1/4)*Cphi4n1*Sqrt[Gf]*Lam^2*Wmass^2*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc174 -> -1/2*(CphiWB*Lam*Wmass^2*(4*Sqrt[2]*CphiWB*Lam*Wmass*(Wmass^2 - Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(-8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*(-2*Wmass^2 + Zmass^2) + 4*CphiW*(-Wmass^2 + Zmass^2)))))/(Gf*(Wmass - Zmass)*Zmass^2*(Wmass + Zmass)),
     gc175 -> -((CphiWB*Lam*Wmass^2*(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2)))))/(2^(3/4)*Sqrt[Gf]*(Wmass - Zmass)*Zmass^2*(Wmass + Zmass))),
     gc176 -> (CphiWB*Lam*Wmass^2*(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(4*CphiBox*Wmass^2 + CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiBox*Zmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2)))))/(2^(3/4)*Sqrt[Gf]*(Wmass - Zmass)*Zmass^2*(Wmass + Zmass)),
     gc177 -> -1/16*Wmass/(2^(3/4)*Gf^(3/2)*Zmass*(-Wmass^2 + Zmass^2)^(3/2)),
     gc178 -> (Lam*Wmass)/(2^(3/4)*Sqrt[Gf]*(Wmass^2*Zmass - Zmass^3)),
     gc179 -> (Lam*Wmass)/(2^(3/4)*Sqrt[Gf]*(Wmass^2*Zmass - Zmass^3)),
     gc180 -> (Lam*Wmass)/(Gf*Wmass^2*Zmass - Gf*Zmass^3),
     gc181 -> (Lam*Wmass)/(2^(3/4)*Sqrt[Gf]*(Wmass^2*Zmass - Zmass^3)),
     gc182 -> (CphiWB*Lam*Wmass)/(Gf*Zmass^2),
     gc183 -> -((Lam*Wmass)/(2^(3/4)*Sqrt[Gf]*Zmass^2)),
     gc184 -> (Lam*Wmass)/(2^(3/4)*Sqrt[Gf]*Zmass^2),
     gc185 -> (-16*Sqrt[2]*(Cphi4n1 + Cphi4n3)*Gf*Lam^2*Wmass^4*(Wmass^2 - Zmass^2))/Zmass^2,
     gc186 -> (32*2^(3/4)*(Cphi4n1 + Cphi4n3)*Gf^(3/2)*Lam^2*Wmass^4*(Wmass^2 - Zmass^2))/Zmass^2,
     gc187 -> (64*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass^4*(Wmass^2 - Zmass^2))/Zmass^2,
     gc188 -> (-32*2^(3/4)*(Cphi4n1 + Cphi4n3)*Gf^(3/2)*Lam^2*Wmass^4*(Wmass^2 - Zmass^2))/Zmass^2,
     gc189 -> (64*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass^4*(Wmass^2 - Zmass^2))/Zmass^2,
     gc190 -> (-64*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass^4*(Wmass^2 - Zmass^2))/Zmass^2,
     gc191 -> (8*Sqrt[2]*Gf*Lam^2*Wmass^3*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc192 -> (8*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^3*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc193 -> (8*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^3*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc194 -> (4*2^(1/4)*(Cphi4n1 + Cphi4n3)*Sqrt[Gf]*Lam^2*Wmass^3*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc195 -> (8*Sqrt[2]*Gf*Lam^2*Wmass^3*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc196 -> (-8*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^3*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc197 -> (-2*Lam*Wmass^2)/(Wmass^2*Zmass - Zmass^3),
     gc198 -> -((2^(1/4)*Lam*Wmass^2)/(Sqrt[Gf]*(Wmass^2*Zmass - Zmass^3))),
     gc199 -> (2*Lam*Wmass^2)/(Wmass^2*Zmass - Zmass^3),
     gc200 -> (64*2^(3/4)*(Cphi4n1 + Cphi4n3)*Gf^(3/2)*Lam^2*Wmass^4*(-Wmass^2 + Zmass^2)^(3/2))/Zmass^3,
     gc201 -> (128*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass^4*(-Wmass^2 + Zmass^2)^(3/2))/Zmass^3,
     gc202 -> (128*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass^4*(-Wmass^2 + Zmass^2)^(3/2))/Zmass^3,
     gc203 -> Wmass/(32*2^(3/4)*Gf^(3/2)),
     gc204 -> (Lam*Wmass)/(4*Gf),
     gc205 -> (Lam*Wmass)/(4*Gf),
     gc206 -> (Lam*Wmass)/(4*2^(3/4)*Sqrt[Gf]),
     gc207 -> (Lam*Wmass)/(4*2^(3/4)*Sqrt[Gf]),
     gc208 -> (8*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^3*(-Wmass^2 + Zmass^2))/Zmass^2,
     gc209 -> (-2*2^(1/4)*Sqrt[Gf]*Lam^2*Wmass^2*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc210 -> (-2*Sqrt[2]*Gf*Lam^2*Wmass^2*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc211 -> (-2*Sqrt[2]*Gf*Lam^2*Wmass^2*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc212 -> 2^(1/4)*Sqrt[Gf]*Lam^2*Wmass,
     gc213 -> (Wmass*(-64*Gf^2*(Wmass^2 - Zmass^2)^2 - 8*Sqrt[2]*Gf*Lam*(Wmass^2 - Zmass^2)*(CphiD*Wmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2)) + Lam^2*(CphiD^2*Wmass^4 + 7*Cll2x1x1x2^2*(Wmass^2 - Zmass^2)^2 + 2*Cll2x1x1x2*CphiD*Wmass^2*(-Wmass^2 + Zmass^2))))/(16*2^(3/4)*Gf^(3/2)*(Wmass - Zmass)*Zmass*(Wmass + Zmass)*Sqrt[-Wmass^2 + Zmass^2]),
     gc214 -> (Wmass*((-64*Gf^2 + 8*Sqrt[2]*(Cll2x1x1x2 - CphiD)*Gf*Lam + (7*Cll2x1x1x2^2 - 2*Cll2x1x1x2*CphiD + CphiD^2)*Lam^2)*Wmass*Sqrt[-Wmass^2 + Zmass^2] + 8*CphiWB*Lam*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(Cll2x1x1x2*Wmass^2 + CphiD*Wmass^2 + 4*CphiW*Wmass^2 - Cll2x1x1x2*Zmass^2 - 4*CphiW*Zmass^2))))/(16*2^(3/4)*Gf^(3/2)*Zmass*Sqrt[-Wmass^2 + Zmass^2]),
     gc215 -> -1/16*(Wmass*(-64*Gf^2*(Wmass^2 - Zmass^2)^2 + 8*Sqrt[2]*Gf*Lam*(Wmass^2 - Zmass^2)*(Cll2x1x1x2*(Wmass^2 - Zmass^2) - Wmass*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2])) + Lam^2*(7*Cll2x1x1x2^2*(Wmass^2 - Zmass^2)^2 - 2*Cll2x1x1x2*Wmass*(Wmass^2 - Zmass^2)*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2]) + Wmass*(CphiD^2*Wmass^3 + 8*CphiD*CphiWB*(-Wmass^2 + Zmass^2)^(3/2) + 32*CphiW*CphiWB*(-Wmass^2 + Zmass^2)^(3/2)))))/(2^(3/4)*Gf^(3/2)*(Wmass - Zmass)*Zmass*(Wmass + Zmass)*Sqrt[-Wmass^2 + Zmass^2]),
     gc216 -> -1/16*((-64*Gf^2 + 8*Sqrt[2]*(Cll2x1x1x2 - CphiD)*Gf*Lam + (7*Cll2x1x1x2^2 - 2*Cll2x1x1x2*CphiD + CphiD^2)*Lam^2)*Wmass^2)/(2^(3/4)*Gf^(3/2)*Zmass),
     gc217 -> ((64*Gf^2 - 8*Sqrt[2]*(Cll2x1x1x2 - 4*CphiBox + CphiD)*Gf*Lam + (-7*Cll2x1x1x2^2 + Cll2x1x1x2*(8*CphiBox - 2*CphiD) + 3*(-4*CphiBox + CphiD)^2)*Lam^2)*Wmass)/(32*2^(3/4)*Gf^(3/2)),
     gc218 -> Lam*Wmass,
     gc219 -> (Lam*Wmass)/(4*2^(3/4)*Sqrt[Gf]),
     gc220 -> -1/4*(Lam*Wmass)/(2^(3/4)*Sqrt[Gf]),
     gc221 -> (8*Sqrt[2]*(Cphi4n1 + Cphi4n3)*Gf*Lam^2*Wmass^3*(Wmass^2 - Zmass^2))/Zmass^2,
     gc222 -> (-8*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^3*(Wmass^2 - Zmass^2))/Zmass^2,
     gc223 -> (-2*2^(1/4)*Sqrt[Gf]*Lam^2*Wmass^2*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc224 -> (-2*Sqrt[2]*Gf*Lam^2*Wmass^2*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc225 -> (-2*Sqrt[2]*Gf*Lam^2*Wmass^2*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc226 -> Lam^2*Wmass,
     gc227 -> -(2^(1/4)*Sqrt[Gf]*Lam^2*Wmass),
     gc228 -> -2*Lam*Wmass^2,
     gc229 -> (Lam*Wmass^2)/(2^(3/4)*Sqrt[Gf]),
     gc230 -> -2*Lam*Wmass^2,
     gc231 -> (Wmass^2*(16*Sqrt[2]*Gf^2*(Wmass^2 - Zmass^2)^2 - 8*Gf*Lam*(Wmass^2 - Zmass^2)*(Cll2x1x1x2*(Wmass^2 - Zmass^2) - Wmass*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2])) + Sqrt[2]*Lam^2*(-3*Cll2x1x1x2^2*(Wmass^2 - Zmass^2)^2 - 4*CphiWB*Wmass*(Sqrt[-Wmass^2 + Zmass^2]*(-2*CphiD*Wmass^2 - 4*CphiW*Wmass^2 + CphiD*Zmass^2 + 4*CphiW*Zmass^2) + 2*CphiWB*(Wmass^3 - Wmass*Zmass^2)))))/(4*Gf*(Wmass - Zmass)*Zmass^2*(Wmass + Zmass)),
     gc232 -> (-8*CphiW*Lam*Wmass^2*(2*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(4*CphiW*Wmass^2 + CphiD*Zmass^2 - 4*CphiW*Zmass^2 + 4*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2] + Cll2x1x1x2*(-Wmass^2 + Zmass^2))))/Zmass^2,
     gc233 -> (-8*Lam*Wmass^2)/Zmass^2,
     gc234 -> (-2*2^(1/4)*CphiW*Lam*Wmass^2*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(4*CphiBox*Wmass^2 + CphiD*Wmass^2 + 8*CphiW*Wmass^2 - 4*CphiBox*Zmass^2 + CphiD*Zmass^2 - 8*CphiW*Zmass^2 + 8*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2] + Cll2x1x1x2*(-Wmass^2 + Zmass^2))))/(Sqrt[Gf]*Zmass^2),
     gc235 -> (-8*CphiW*Lam*Wmass^2*(2*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(4*CphiBox*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiBox*Zmass^2 + CphiD*Zmass^2 - 4*CphiW*Zmass^2 + 4*CphiWB*Wmass*Sqrt[-Wmass^2 + Zmass^2] + Cll2x1x1x2*(-Wmass^2 + Zmass^2))))/Zmass^2,
     gc236 -> (-32*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass^4*(Wmass^2 - Zmass^2))/Zmass^2,
     gc237 -> (-128*Gf^2*Lam^2*Wmass^4*(Wmass^2 - Zmass^2))/Zmass^2,
     gc238 -> (-16*2^(3/4)*(Cphi4n1 + Cphi4n3)*Gf^(3/2)*Lam^2*Wmass^4*(Wmass^2 - Zmass^2))/Zmass^2,
     gc239 -> (-32*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass^4*(Wmass^2 - Zmass^2))/Zmass^2,
     gc240 -> (4*Sqrt[2]*(Cphi4n1 + Cphi4n3)*Gf*Lam^2*Wmass^3*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc241 -> (4*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^3*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc242 -> (-4*2^(3/4)*(Cphi4n1 + Cphi4n3)*Gf^(3/2)*Lam^2*Wmass^3*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc243 -> -2*Sqrt[2]*Gf*Lam^2*Wmass^2,
     gc244 -> -2*2^(1/4)*Sqrt[Gf]*Lam^2*Wmass^2,
     gc245 -> -2*Sqrt[2]*Gf*Lam^2*Wmass^2,
     gc246 -> (16*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^3*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc247 -> 2*2^(1/4)*Sqrt[Gf]*Lam^2*Wmass^2,
     gc248 -> -2*Sqrt[2]*Gf*Lam^2*Wmass^2,
     gc249 -> (-4*Sqrt[2]*Gf*Lam^2*Wmass^3*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc250 -> (4*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^3*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc251 -> -(Cphi4n1*Lam^2*Wmass^2),
     gc252 -> -2*Sqrt[2]*Cphi4n1*Gf*Lam^2*Wmass^2,
     gc253 -> 2*2^(1/4)*Cphi4n1*Sqrt[Gf]*Lam^2*Wmass^2,
     gc254 -> -2*Sqrt[2]*Cphi4n1*Gf*Lam^2*Wmass^2,
     gc255 -> -2*2^(1/4)*Sqrt[Gf]*Lam^2*Wmass^2,
     gc256 -> -2*Sqrt[2]*Gf*Lam^2*Wmass^2,
     gc257 -> Wmass/(16*2^(3/4)*Gf^(3/2)*Zmass*Sqrt[-Wmass^2 + Zmass^2]),
     gc258 -> (Lam*Wmass)/(2^(3/4)*Sqrt[Gf]*Zmass*Sqrt[-Wmass^2 + Zmass^2]),
     gc259 -> (Lam*Wmass)/(2^(3/4)*Sqrt[Gf]*Zmass*Sqrt[-Wmass^2 + Zmass^2]),
     gc260 -> -1/2*(Lam*Wmass)/(Gf*Zmass),
     gc261 -> (Lam*Wmass)/(2^(3/4)*Sqrt[Gf]*Zmass*Sqrt[-Wmass^2 + Zmass^2]),
     gc262 -> (16*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^4*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc263 -> (-32*Gf^2*Lam^2*Wmass^4*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc264 -> (32*Gf^2*Lam^2*Wmass^4*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc265 -> 2*2^(1/4)*Sqrt[Gf]*Lam^2*Wmass^3,
     gc266 -> -4*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^3,
     gc267 -> 4*Sqrt[2]*Gf*Lam^2*Wmass^3,
     gc268 -> -4*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^3,
     gc269 -> 4*Sqrt[2]*Gf*Lam^2*Wmass^3,
     gc270 -> -4*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^3,
     gc271 -> -4*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^3,
     gc272 -> -2*2^(1/4)*Sqrt[Gf]*Lam^2*Wmass^3,
     gc273 -> -4*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^3,
     gc274 -> -4*Sqrt[2]*Gf*Lam^2*Wmass^3,
     gc275 -> -4*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^3,
     gc276 -> 2*Lam*Wmass^2,
     gc277 -> -((2^(1/4)*Lam*Wmass^2)/Sqrt[Gf]),
     gc278 -> 2*Sqrt[2]*Lam*Wmass^2,
     gc279 -> -((2^(1/4)*Lam*Wmass^2)/Sqrt[Gf]),
     gc280 -> -2*Sqrt[2]*Lam*Wmass^2,
     gc281 -> -2*Sqrt[2]*Lam*Wmass^2,
     gc282 -> (2*2^(1/4)*Cphi4n1*Sqrt[Gf]*Lam^2*Wmass^2*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc283 -> (CphiWB*Lam*Wmass^2*(4*Sqrt[2]*CphiWB*Lam*Wmass*(Wmass^2 - Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(-8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*(-2*Wmass^2 + Zmass^2) + 4*CphiW*(-Wmass^2 + Zmass^2)))))/(2*Gf*(Wmass - Zmass)*Zmass^2*(Wmass + Zmass)),
     gc284 -> -((CphiWB*Lam*Wmass^2*(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2)))))/(2^(3/4)*Sqrt[Gf]*(Wmass - Zmass)*Zmass^2*(Wmass + Zmass))),
     gc285 -> -((CphiWB*Lam*Wmass^2*(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(4*CphiBox*Wmass^2 + CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiBox*Zmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2)))))/(2^(3/4)*Sqrt[Gf]*(Wmass - Zmass)*Zmass^2*(Wmass + Zmass))),
     gc286 -> -((CphiWB*Lam*Wmass)/(Gf*Zmass^2)),
     gc287 -> -((Lam*Wmass)/(2^(3/4)*Sqrt[Gf]*Zmass^2)),
     gc288 -> -((Lam*Wmass)/(2^(3/4)*Sqrt[Gf]*Zmass^2)),
     gc289 -> -4*Sqrt[2]*Gf*Lam^2*Wmass^2,
     gc290 -> (4*2^(1/4)*(Cphi4n1 + Cphi4n3)*Sqrt[Gf]*Lam^2*Wmass^4*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc291 -> (-4*Sqrt[2]*(Cphi4n1 + Cphi4n3)*Gf*Lam^2*Wmass^4*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc292 -> (8*2^(3/4)*(Cphi4n1 + Cphi4n3)*Gf^(3/2)*Lam^2*Wmass^4*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc293 -> (-48*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass^4*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc294 -> (12*Sqrt[2]*(Cphi4n1 + Cphi4n3)*Gf*Lam^2*Wmass^4*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc295 -> (-8*2^(3/4)*(Cphi4n1 + Cphi4n3)*Gf^(3/2)*Lam^2*Wmass^4*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc296 -> (16*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass^4*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc297 -> (24*2^(3/4)*(Cphi4n1 + Cphi4n3)*Gf^(3/2)*Lam^2*Wmass^4*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc298 -> (-16*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass^4*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc299 -> (48*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass^4*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc300 -> 2*(Cphi4n1 + Cphi4n3)*Lam^2*Wmass^3,
     gc301 -> 4*Sqrt[2]*(Cphi4n1 + Cphi4n3)*Gf*Lam^2*Wmass^3,
     gc302 -> (-16*Sqrt[2]*(Cphi4n1 + Cphi4n3)*Gf*Lam^2*Wmass^4*(Wmass^2 - Zmass^2))/Zmass^2,
     gc303 -> (-32*2^(3/4)*(Cphi4n1 + Cphi4n3)*Gf^(3/2)*Lam^2*Wmass^4*(Wmass^2 - Zmass^2))/Zmass^2,
     gc304 -> (64*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass^4*(Wmass^2 - Zmass^2))/Zmass^2,
     gc305 -> (-32*2^(3/4)*(Cphi4n1 + Cphi4n3)*Gf^(3/2)*Lam^2*Wmass^4*(Wmass^2 - Zmass^2))/Zmass^2,
     gc306 -> (-64*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass^4*(Wmass^2 - Zmass^2))/Zmass^2,
     gc307 -> (-64*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass^4*(Wmass^2 - Zmass^2))/Zmass^2,
     gc308 -> (8*Sqrt[2]*Gf*Lam^2*Wmass^3*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc309 -> (-8*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^3*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc310 -> (8*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^3*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc311 -> (-4*2^(1/4)*(Cphi4n1 + Cphi4n3)*Sqrt[Gf]*Lam^2*Wmass^3*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc312 -> (-8*Sqrt[2]*Gf*Lam^2*Wmass^3*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc313 -> (8*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^3*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc314 -> (4*2^(1/4)*(Cphi4n1 + Cphi4n3)*Sqrt[Gf]*Lam^2*Wmass^4*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc315 -> (4*Sqrt[2]*(Cphi4n1 + Cphi4n3)*Gf*Lam^2*Wmass^4*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc316 -> (8*2^(3/4)*(Cphi4n1 + Cphi4n3)*Gf^(3/2)*Lam^2*Wmass^4*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc317 -> (48*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass^4*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc318 -> (16*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^4*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc319 -> (32*Gf^2*Lam^2*Wmass^4*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc320 -> (12*Sqrt[2]*(Cphi4n1 + Cphi4n3)*Gf*Lam^2*Wmass^4*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc321 -> (8*2^(3/4)*(Cphi4n1 + Cphi4n3)*Gf^(3/2)*Lam^2*Wmass^4*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc322 -> (16*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass^4*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc323 -> (32*Gf^2*Lam^2*Wmass^4*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc324 -> (24*2^(3/4)*(Cphi4n1 + Cphi4n3)*Gf^(3/2)*Lam^2*Wmass^4*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc325 -> (16*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass^4*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc326 -> (48*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass^4*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc327 -> -2*2^(1/4)*Sqrt[Gf]*Lam^2*Wmass^3,
     gc328 -> 4*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^3,
     gc329 -> -4*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^3,
     gc330 -> 4*Sqrt[2]*Gf*Lam^2*Wmass^3,
     gc331 -> 4*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^3,
     gc332 -> -2*(Cphi4n1 + Cphi4n3)*Lam^2*Wmass^3,
     gc333 -> -4*Sqrt[2]*(Cphi4n1 + Cphi4n3)*Gf*Lam^2*Wmass^3,
     gc334 -> -4*Sqrt[2]*Gf*Lam^2*Wmass^3,
     gc335 -> 2*2^(1/4)*Sqrt[Gf]*Lam^2*Wmass^3,
     gc336 -> 4*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^3,
     gc337 -> -4*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^3,
     gc338 -> -4*Sqrt[2]*Gf*Lam^2*Wmass^3,
     gc339 -> 4*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^3,
     gc340 -> Wmass^2/(4*Gf),
     gc341 -> -8*Lam*Wmass^2,
     gc342 -> 8*Lam*Wmass^2,
     gc343 -> (-2*2^(1/4)*Lam*Wmass^2)/Sqrt[Gf],
     gc344 -> -8*Lam*Wmass^2,
     gc345 -> 96*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass^4,
     gc346 -> 32*Gf^2*Lam^2*Wmass^4,
     gc347 -> 64*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass^4,
     gc348 -> 16*2^(3/4)*(Cphi4n1 + Cphi4n3)*Gf^(3/2)*Lam^2*Wmass^4,
     gc349 -> 16*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^4,
     gc350 -> 32*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass^4,
     gc351 -> 32*Gf^2*Lam^2*Wmass^4,
     gc352 -> 48*2^(3/4)*(Cphi4n1 + Cphi4n3)*Gf^(3/2)*Lam^2*Wmass^4,
     gc353 -> 96*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass^4,
     gc354 -> (Lam*Wmass)/(-(Wmass^2*Zmass^2) + Zmass^4),
     gc355 -> (4*Lam*Wmass)/(-(Wmass^2*Zmass^2) + Zmass^4),
     gc356 -> (Lam*Wmass)/(2^(3/4)*Sqrt[Gf]*(Wmass^2 - Zmass^2)),
     gc357 -> (Lam*Wmass)/(-(Wmass^2*Zmass^2) + Zmass^4),
     gc358 -> (-512*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass^3*Sqrt[-Wmass^2 + Zmass^2]*(2*Wmass^4 - 3*Wmass^2*Zmass^2 + Zmass^4))/Zmass^4,
     gc359 -> Lam/(4*Gf*Zmass),
     gc360 -> -1/4*Lam/(2^(3/4)*Sqrt[Gf]*Zmass),
     gc361 -> Zmass/(32*2^(3/4)*Gf^(3/2)),
     gc362 -> (Lam*Zmass)/(2*Gf),
     gc363 -> (Lam*Zmass)/(4*2^(3/4)*Sqrt[Gf]),
     gc364 -> -1/2*(Lam*Zmass)/Gf,
     gc365 -> -1/4*(Lam*Zmass)/(2^(3/4)*Sqrt[Gf]),
     gc366 -> (8*Sqrt[2]*Gf*Lam^2*Wmass^2*(Wmass^2 - Zmass^2))/Zmass,
     gc367 -> (-8*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^2*(Wmass^2 - Zmass^2))/Zmass,
     gc368 -> -1/16*(Wmass*((-64*Gf^2 + 8*Sqrt[2]*(Cll2x1x1x2 - CphiD)*Gf*Lam + (7*Cll2x1x1x2^2 - 2*Cll2x1x1x2*CphiD + CphiD^2)*Lam^2)*Wmass*Sqrt[-Wmass^2 + Zmass^2] + 8*CphiWB*Lam*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(Cll2x1x1x2*Wmass^2 + CphiD*Wmass^2 + 4*CphiW*Wmass^2 - Cll2x1x1x2*Zmass^2 - 4*CphiW*Zmass^2))))/(2^(3/4)*Gf^(3/2)*Zmass*Sqrt[-Wmass^2 + Zmass^2]),
     gc369 -> (Wmass*((-64*Gf^2 + 8*Sqrt[2]*(Cll2x1x1x2 - CphiD)*Gf*Lam + (7*Cll2x1x1x2^2 - 2*Cll2x1x1x2*CphiD + CphiD^2)*Lam^2)*Wmass*Sqrt[-Wmass^2 + Zmass^2] + 8*CphiWB*Lam*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(Cll2x1x1x2*Wmass^2 + CphiD*Wmass^2 + 4*CphiW*Wmass^2 - Cll2x1x1x2*Zmass^2 - 4*CphiW*Zmass^2))))/(16*2^(3/4)*Gf^(3/2)*Zmass*Sqrt[-Wmass^2 + Zmass^2]),
     gc370 -> ((64*Gf^2 + 8*Sqrt[2]*(-Cll2x1x1x2 + CphiD)*Gf*Lam - (7*Cll2x1x1x2^2 - 2*Cll2x1x1x2*CphiD + CphiD^2)*Lam^2)*(2*Wmass^2 - Zmass^2)*Sqrt[-Wmass^2 + Zmass^2] - 16*CphiWB*Lam*Wmass*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(Wmass^2 - Zmass^2))))/(32*2^(3/4)*Gf^(3/2)*Zmass*Sqrt[-Wmass^2 + Zmass^2]),
     gc371 -> Lam/(2*2^(3/4)*Sqrt[Gf]*Zmass),
     gc372 -> Lam/(4*2^(3/4)*Sqrt[Gf]*Zmass),
     gc373 -> -1/4*(Lam*Zmass)/Gf,
     gc374 -> -1/4*Lam/(2^(3/4)*Sqrt[Gf]*Zmass),
     gc375 -> (-32*2^(3/4)*(Cphi4n1 + Cphi4n3)*Gf^(3/2)*Lam^2*Wmass^2*(2*Wmass^4 - 3*Wmass^2*Zmass^2 + Zmass^4))/Zmass^3,
     gc376 -> -2*2^(1/4)*Sqrt[Gf]*Lam^2*Wmass*Sqrt[-Wmass^2 + Zmass^2],
     gc377 -> 2*Sqrt[2]*Gf*Lam^2*Wmass*Sqrt[-Wmass^2 + Zmass^2],
     gc378 -> -((Lam*Wmass)/(2^(3/4)*Sqrt[Gf]*Zmass)),
     gc379 -> (2*Lam*Wmass)/Zmass,
     gc380 -> (-2*Lam*Wmass)/Zmass,
     gc381 -> -1/2*(Lam*Wmass)/(2^(3/4)*Sqrt[Gf]*Zmass),
     gc382 -> -((Lam*Wmass)/Zmass),
     gc383 -> (Lam*Wmass)/(2*2^(3/4)*Sqrt[Gf]*Zmass),
     gc384 -> (Lam*Wmass)/Zmass,
     gc385 -> -1/2*(Lam*Wmass)/(2^(3/4)*Sqrt[Gf]*Zmass),
     gc386 -> (Lam*Wmass)/Zmass,
     gc387 -> -((Lam*Wmass)/Zmass),
     gc388 -> (-16*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^3*(Wmass^2 - Zmass^2))/Zmass^3,
     gc389 -> (32*Gf^2*Lam^2*Wmass^3*(Wmass^2 - Zmass^2))/Zmass^3,
     gc390 -> (-32*Gf^2*Lam^2*Wmass^3*(Wmass^2 - Zmass^2))/Zmass^3,
     gc391 -> -4*Sqrt[2]*Gf*Lam^2*Wmass^2*Sqrt[-Wmass^2 + Zmass^2],
     gc392 -> -4*2^(3/4)*Cphi4n1*Gf^(3/2)*Lam^2*Wmass^2*Sqrt[-Wmass^2 + Zmass^2],
     gc393 -> (4*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^2*Sqrt[-Wmass^2 + Zmass^2])/Zmass^2,
     gc394 -> -4*Sqrt[2]*Gf*Lam^2*Wmass^2*Sqrt[-Wmass^2 + Zmass^2],
     gc395 -> 4*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^2*Sqrt[-Wmass^2 + Zmass^2],
     gc396 -> -4*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^2*Sqrt[-Wmass^2 + Zmass^2],
     gc397 -> (-4*Sqrt[2]*Gf*Lam^2*Wmass^2*Sqrt[-Wmass^2 + Zmass^2])/Zmass^2,
     gc398 -> (-4*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^2*Sqrt[-Wmass^2 + Zmass^2])/Zmass^2,
     gc399 -> 4*Sqrt[2]*Cphi4n1*Gf*Lam^2*Wmass^2*Sqrt[-Wmass^2 + Zmass^2],
     gc400 -> 4*2^(3/4)*Cphi4n1*Gf^(3/2)*Lam^2*Wmass^2*Sqrt[-Wmass^2 + Zmass^2],
     gc401 -> (Lam*Wmass)/(2*Gf*Zmass^2*Sqrt[-Wmass^2 + Zmass^2]),
     gc402 -> -((Lam*Wmass)/(2^(3/4)*Sqrt[Gf]*Zmass^2*Sqrt[-Wmass^2 + Zmass^2])),
     gc403 -> (Lam*Wmass)/(2^(3/4)*Sqrt[Gf]*Zmass^2*Sqrt[-Wmass^2 + Zmass^2]),
     gc404 -> (-8*Sqrt[2]*Gf*Lam^2*Wmass^3*Sqrt[-Wmass^2 + Zmass^2])/Zmass^2,
     gc405 -> (16*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^3*Sqrt[-Wmass^2 + Zmass^2])/Zmass^2,
     gc406 -> (32*Gf^2*Lam^2*Wmass^3*Sqrt[-Wmass^2 + Zmass^2])/Zmass^2,
     gc407 -> (-16*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^3*Sqrt[-Wmass^2 + Zmass^2])/Zmass^2,
     gc408 -> (32*Gf^2*Lam^2*Wmass^3*Sqrt[-Wmass^2 + Zmass^2])/Zmass^2,
     gc409 -> (-32*Gf^2*Lam^2*Wmass^3*Sqrt[-Wmass^2 + Zmass^2])/Zmass^2,
     gc410 -> (4*Sqrt[2]*Gf*Lam^2*Wmass^2)/Zmass,
     gc411 -> (-4*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^2)/Zmass,
     gc412 -> (-4*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^2)/Zmass,
     gc413 -> (-2*2^(1/4)*Sqrt[Gf]*Lam^2*Wmass^2)/Zmass,
     gc414 -> (-4*Sqrt[2]*Gf*Lam^2*Wmass^2)/Zmass,
     gc415 -> (4*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^2)/Zmass,
     gc416 -> (Lam*Wmass)/(2^(3/4)*Sqrt[Gf]*Zmass),
     gc417 -> (-2*Lam*Wmass)/Zmass,
     gc418 -> (-2*Lam*Wmass)/Zmass,
     gc419 -> -1/2*(Lam*Wmass)/(2^(3/4)*Sqrt[Gf]*Zmass),
     gc420 -> (Lam*Wmass)/Zmass,
     gc421 -> -1/2*(Lam*Wmass)/(2^(3/4)*Sqrt[Gf]*Zmass),
     gc422 -> (Lam*Wmass)/Zmass,
     gc423 -> -1/2*(Lam*Wmass)/(2^(3/4)*Sqrt[Gf]*Zmass),
     gc424 -> -((Lam*Wmass)/Zmass),
     gc425 -> -((Lam*Wmass)/Zmass),
     gc426 -> (-16*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^3*(Wmass^2 - Zmass^2))/Zmass^3,
     gc427 -> (-32*Gf^2*Lam^2*Wmass^3*(Wmass^2 - Zmass^2))/Zmass^3,
     gc428 -> (-32*Gf^2*Lam^2*Wmass^3*(Wmass^2 - Zmass^2))/Zmass^3,
     gc429 -> 4*Sqrt[2]*Gf*Lam^2*Wmass^2*Sqrt[-Wmass^2 + Zmass^2],
     gc430 -> -4*2^(3/4)*Cphi4n1*Gf^(3/2)*Lam^2*Wmass^2*Sqrt[-Wmass^2 + Zmass^2],
     gc431 -> (4*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^2*Sqrt[-Wmass^2 + Zmass^2])/Zmass^2,
     gc432 -> -4*Sqrt[2]*Gf*Lam^2*Wmass^2*Sqrt[-Wmass^2 + Zmass^2],
     gc433 -> -4*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^2*Sqrt[-Wmass^2 + Zmass^2],
     gc434 -> -4*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^2*Sqrt[-Wmass^2 + Zmass^2],
     gc435 -> (4*Sqrt[2]*Gf*Lam^2*Wmass^2*Sqrt[-Wmass^2 + Zmass^2])/Zmass^2,
     gc436 -> (4*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^2*Sqrt[-Wmass^2 + Zmass^2])/Zmass^2,
     gc437 -> -4*Sqrt[2]*Cphi4n1*Gf*Lam^2*Wmass^2*Sqrt[-Wmass^2 + Zmass^2],
     gc438 -> -4*2^(3/4)*Cphi4n1*Gf^(3/2)*Lam^2*Wmass^2*Sqrt[-Wmass^2 + Zmass^2],
     gc439 -> -1/2*(Lam*Wmass)/(Gf*Zmass^2*Sqrt[-Wmass^2 + Zmass^2]),
     gc440 -> -((Lam*Wmass)/(2^(3/4)*Sqrt[Gf]*Zmass^2*Sqrt[-Wmass^2 + Zmass^2])),
     gc441 -> -((Lam*Wmass)/(2^(3/4)*Sqrt[Gf]*Zmass^2*Sqrt[-Wmass^2 + Zmass^2])),
     gc442 -> -1/16*(Wmass^2*(64*Sqrt[2]*Gf^2*Wmass*(Wmass^2 - Zmass^2)^2 - Sqrt[2]*Lam^2*(CphiD^2*Wmass*Zmass^4 + 12*Cll2x1x1x2^2*Wmass*(Wmass^2 - Zmass^2)^2 + 32*CphiWB^2*Wmass*(Wmass^2 - Zmass^2)^2 - 32*CphiWB*(-Wmass^2 + Zmass^2)^(3/2)*(-(CphiD*Wmass^2) + CphiW*(-2*Wmass^2 + Zmass^2))) - 16*Gf*Lam*(Wmass^2 - Zmass^2)*(2*Cll2x1x1x2*(Wmass^3 - Wmass*Zmass^2) - (2*Wmass^2 - Zmass^2)*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2]))))/(Gf*(Wmass - Zmass)*Zmass^2*(Wmass + Zmass)*Sqrt[-Wmass^2 + Zmass^2]),
     gc443 -> (-4*CphiW*Lam*Wmass^2*(-4*CphiWB*Lam*(2*Wmass^4 - 3*Wmass^2*Zmass^2 + Zmass^4) + Wmass*Sqrt[-Wmass^2 + Zmass^2]*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(-2*Cll2x1x1x2*Wmass^2 + 8*CphiW*Wmass^2 + 2*Cll2x1x1x2*Zmass^2 + CphiD*Zmass^2 - 8*CphiW*Zmass^2))))/((Wmass - Zmass)*Zmass^2*(Wmass + Zmass)),
     gc444 -> (4*Lam*Wmass^2)/(Zmass^2*(Wmass^2 - Zmass^2)),
     gc445 -> (-2*2^(1/4)*CphiW*Lam*Wmass^2*(-4*Sqrt[2]*CphiWB*Lam*(2*Wmass^4 - 3*Wmass^2*Zmass^2 + Zmass^4) + Wmass*Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(4*CphiBox*Wmass^2 + CphiD*Wmass^2 + 8*CphiW*Wmass^2 - 4*CphiBox*Zmass^2 - 8*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2)))))/(Sqrt[Gf]*(Wmass - Zmass)*Zmass^2*(Wmass + Zmass)),
     gc446 -> (-4*CphiW*Lam*Wmass^2*(-4*CphiWB*Lam*(2*Wmass^4 - 3*Wmass^2*Zmass^2 + Zmass^4) + Wmass*Sqrt[-Wmass^2 + Zmass^2]*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(-2*Cll2x1x1x2*Wmass^2 + 8*CphiBox*Wmass^2 + 8*CphiW*Wmass^2 + 2*Cll2x1x1x2*Zmass^2 - 8*CphiBox*Zmass^2 + CphiD*Zmass^2 - 8*CphiW*Zmass^2))))/((Wmass - Zmass)*Zmass^2*(Wmass + Zmass)),
     gc447 -> (32*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass^3*Sqrt[-Wmass^2 + Zmass^2])/Zmass^2,
     gc448 -> (64*Gf^2*Lam^2*Wmass^3*(2*Wmass^2 - Zmass^2)*Sqrt[-Wmass^2 + Zmass^2])/Zmass^2,
     gc449 -> (16*2^(3/4)*(Cphi4n1 + Cphi4n3)*Gf^(3/2)*Lam^2*Wmass^3*Sqrt[-Wmass^2 + Zmass^2])/Zmass^2,
     gc450 -> (32*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass^3*Sqrt[-Wmass^2 + Zmass^2])/Zmass^2,
     gc451 -> -(Lam^2*Wmass^2*Zmass),
     gc452 -> -2*Sqrt[2]*Gf*Lam^2*Wmass^2*Zmass,
     gc453 -> -4*Sqrt[2]*(Cphi4n1 + Cphi4n3)*Gf*Lam^2*Wmass^2*Zmass,
     gc454 -> 2^(1/4)*Sqrt[Gf]*Lam^2*Wmass^2*Zmass,
     gc455 -> 2*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^2*Zmass,
     gc456 -> (4*2^(3/4)*(Cphi4n1 + Cphi4n3)*Gf^(3/2)*Lam^2*Wmass^2)/Zmass,
     gc457 -> -2*Sqrt[2]*Gf*Lam^2*Wmass^2*Zmass,
     gc458 -> 2*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^2*Zmass,
     gc459 -> (4*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^2)/Zmass,
     gc460 -> (-8*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^2*(2*Wmass^2 - Zmass^2))/Zmass,
     gc461 -> (-4*Sqrt[2]*Gf*Lam^2*Wmass^2)/Zmass,
     gc462 -> (4*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^2)/Zmass,
     gc463 -> -4*2^(1/4)*Cphi4n1*Sqrt[Gf]*Lam^2*Wmass^3*Zmass,
     gc464 -> 4*Sqrt[2]*Cphi4n1*Gf*Lam^2*Wmass^3*Zmass,
     gc465 -> -8*2^(3/4)*Cphi4n1*Gf^(3/2)*Lam^2*Wmass^3*Zmass,
     gc466 -> 48*Cphi4n1*Gf^2*Lam^2*Wmass^3*Zmass,
     gc467 -> (8*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^3)/Zmass,
     gc468 -> (-16*Gf^2*Lam^2*Wmass^3)/Zmass,
     gc469 -> -12*Sqrt[2]*Cphi4n1*Gf*Lam^2*Wmass^3*Zmass,
     gc470 -> 8*2^(3/4)*Cphi4n1*Gf^(3/2)*Lam^2*Wmass^3*Zmass,
     gc471 -> -16*Cphi4n1*Gf^2*Lam^2*Wmass^3*Zmass,
     gc472 -> (16*Gf^2*Lam^2*Wmass^3)/Zmass,
     gc473 -> -24*2^(3/4)*Cphi4n1*Gf^(3/2)*Lam^2*Wmass^3*Zmass,
     gc474 -> 16*Cphi4n1*Gf^2*Lam^2*Wmass^3*Zmass,
     gc475 -> -48*Cphi4n1*Gf^2*Lam^2*Wmass^3*Zmass,
     gc476 -> (-8*Sqrt[2]*Gf*Lam^2*Wmass^3*Sqrt[-Wmass^2 + Zmass^2])/Zmass^2,
     gc477 -> (-16*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^3*Sqrt[-Wmass^2 + Zmass^2])/Zmass^2,
     gc478 -> (32*Gf^2*Lam^2*Wmass^3*Sqrt[-Wmass^2 + Zmass^2])/Zmass^2,
     gc479 -> (-16*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^3*Sqrt[-Wmass^2 + Zmass^2])/Zmass^2,
     gc480 -> (-32*Gf^2*Lam^2*Wmass^3*Sqrt[-Wmass^2 + Zmass^2])/Zmass^2,
     gc481 -> (-32*Gf^2*Lam^2*Wmass^3*Sqrt[-Wmass^2 + Zmass^2])/Zmass^2,
     gc482 -> (4*Sqrt[2]*Gf*Lam^2*Wmass^2)/Zmass,
     gc483 -> (4*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^2)/Zmass,
     gc484 -> (-4*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^2)/Zmass,
     gc485 -> (2*2^(1/4)*Sqrt[Gf]*Lam^2*Wmass^2)/Zmass,
     gc486 -> (4*Sqrt[2]*Gf*Lam^2*Wmass^2)/Zmass,
     gc487 -> (4*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^2)/Zmass,
     gc488 -> (-8*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^3)/Zmass,
     gc489 -> (-16*Gf^2*Lam^2*Wmass^3)/Zmass,
     gc490 -> (-16*Gf^2*Lam^2*Wmass^3)/Zmass,
     gc491 -> (-2*2^(1/4)*Sqrt[Gf]*Lam^2*Wmass^3)/Zmass,
     gc492 -> (-2*Sqrt[2]*Gf*Lam^2*Wmass^3)/Zmass,
     gc493 -> (-4*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^3)/Zmass,
     gc494 -> (-24*Gf^2*Lam^2*Wmass^3)/Zmass,
     gc495 -> (-6*Sqrt[2]*Gf*Lam^2*Wmass^3)/Zmass,
     gc496 -> (-4*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^3)/Zmass,
     gc497 -> (-8*Gf^2*Lam^2*Wmass^3)/Zmass,
     gc498 -> (-12*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^3)/Zmass,
     gc499 -> (-8*Gf^2*Lam^2*Wmass^3)/Zmass,
     gc500 -> (-24*Gf^2*Lam^2*Wmass^3)/Zmass,
     gc501 -> -((Sqrt[2]*Lam)/Zmass^2),
     gc502 -> (2*Sqrt[2]*Lam*(-2*Wmass^2 + Zmass^2))/Zmass^2,
     gc503 -> -(Lam/(2^(3/4)*Sqrt[Gf])),
     gc504 -> -((Sqrt[2]*Lam)/Zmass^2),
     gc505 -> (-2*Lam*Zmass^2)/(-4*Gf + Sqrt[2]*(Cll2x1x1x2 + 3*CphiD)*Lam),
     gc506 -> (Lam*Zmass^2)/(2^(3/4)*Sqrt[Gf]),
     gc507 -> -2*Lam*Zmass^2,
     gc508 -> -((Lam*Zmass^2)/(2^(3/4)*Sqrt[Gf])),
     gc509 -> (-2*Lam*Zmass^2)/(-4*Gf + Sqrt[2]*(Cll2x1x1x2 - 8*CphiBox + 3*CphiD)*Lam),
     gc510 -> -6*2^(3/4)*Cphi4n1*Gf^(3/2)*Lam^2*Wmass^2*Zmass,
     gc511 -> -2*Sqrt[2]*Cphi4n1*Gf*Lam^2*Wmass^2*Zmass,
     gc512 -> -2*2^(3/4)*Cphi4n1*Gf^(3/2)*Lam^2*Wmass^2*Zmass,
     gc513 -> -6*Sqrt[2]*Cphi4n1*Gf*Lam^2*Wmass^2*Zmass,
     gc514 -> -6*2^(3/4)*Cphi4n1*Gf^(3/2)*Lam^2*Wmass^2*Zmass,
     gc515 -> -8*Sqrt[2]*Gf*Lam^2*Wmass^2*(Wmass^2 - Zmass^2),
     gc516 -> -32*Gf^2*Lam^2*Wmass^2*(Wmass^2 - Zmass^2),
     gc517 -> (-256*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass^2*(Wmass^2 - Zmass^2)*(-2*Wmass^2 + Zmass^2)^2)/Zmass^4,
     gc518 -> -16*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^2*(Wmass^2 - Zmass^2),
     gc519 -> -32*Gf^2*Lam^2*Wmass^2*(Wmass^2 - Zmass^2),
     gc520 -> (-4*Sqrt[2]*Gf*Lam^2*Wmass*(2*Wmass^2 - Zmass^2)*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc521 -> (8*2^(3/4)*Cphi4n1*Gf^(3/2)*Lam^2*Wmass*(2*Wmass^2 - Zmass^2)*Sqrt[-Wmass^2 + Zmass^2])/Zmass,
     gc522 -> (16*2^(3/4)*(Cphi4n1 + Cphi4n3)*Gf^(3/2)*Lam^2*Wmass*(-2*Wmass^2 + Zmass^2)^2*Sqrt[-Wmass^2 + Zmass^2])/Zmass^3,
     gc523 -> 2*2^(1/4)*Sqrt[Gf]*Lam^2*Wmass*Zmass*Sqrt[-Wmass^2 + Zmass^2],
     gc524 -> 4*2^(3/4)*Gf^(3/2)*Lam^2*Wmass*Zmass*Sqrt[-Wmass^2 + Zmass^2],
     gc525 -> -4*Sqrt[2]*Gf*Lam^2*Wmass*Zmass*Sqrt[-Wmass^2 + Zmass^2],
     gc526 -> 4*2^(3/4)*Gf^(3/2)*Lam^2*Wmass*Zmass*Sqrt[-Wmass^2 + Zmass^2],
     gc527 -> -(2^(1/4)*Sqrt[Gf]*Lam^2*(2*Wmass^2 - Zmass^2)),
     gc528 -> 2*Sqrt[2]*Cphi4n1*Gf*Lam^2*(2*Wmass^2 - Zmass^2),
     gc529 -> (8*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^2*(2*Wmass^2 - Zmass^2)*Sqrt[-Wmass^2 + Zmass^2])/Zmass^3,
     gc530 -> (-16*Gf^2*Lam^2*Wmass^2*(2*Wmass^2 - Zmass^2)*Sqrt[-Wmass^2 + Zmass^2])/Zmass^3,
     gc531 -> (16*Gf^2*Lam^2*Wmass^2*(2*Wmass^2 - Zmass^2)*Sqrt[-Wmass^2 + Zmass^2])/Zmass^3,
     gc532 -> 2*2^(1/4)*Sqrt[Gf]*Lam^2*Wmass^2*Zmass*Sqrt[-Wmass^2 + Zmass^2],
     gc533 -> -2*Sqrt[2]*Gf*Lam^2*Wmass^2*Zmass*Sqrt[-Wmass^2 + Zmass^2],
     gc534 -> 4*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^2*Zmass*Sqrt[-Wmass^2 + Zmass^2],
     gc535 -> -24*Gf^2*Lam^2*Wmass^2*Zmass*Sqrt[-Wmass^2 + Zmass^2],
     gc536 -> 6*Sqrt[2]*Gf*Lam^2*Wmass^2*Zmass*Sqrt[-Wmass^2 + Zmass^2],
     gc537 -> -4*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^2*Zmass*Sqrt[-Wmass^2 + Zmass^2],
     gc538 -> 8*Gf^2*Lam^2*Wmass^2*Zmass*Sqrt[-Wmass^2 + Zmass^2],
     gc539 -> 12*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^2*Zmass*Sqrt[-Wmass^2 + Zmass^2],
     gc540 -> -8*Gf^2*Lam^2*Wmass^2*Zmass*Sqrt[-Wmass^2 + Zmass^2],
     gc541 -> 24*Gf^2*Lam^2*Wmass^2*Zmass*Sqrt[-Wmass^2 + Zmass^2],
     gc542 -> 2*Sqrt[2]*Gf*Lam^2*Wmass,
     gc543 -> -2*2^(3/4)*Gf^(3/2)*Lam^2*Wmass,
     gc544 -> (-4*2^(3/4)*Gf^(3/2)*Lam^2*Wmass*(2*Wmass^2 - Zmass^2))/Zmass^2,
     gc545 -> 2*Sqrt[2]*Gf*Lam^2*Wmass,
     gc546 -> 2*2^(3/4)*Gf^(3/2)*Lam^2*Wmass,
     gc547 -> 2*2^(3/4)*Gf^(3/2)*Lam^2*Wmass,
     gc548 -> (4*Sqrt[2]*Gf*Lam^2*Wmass*(2*Wmass^2 - Zmass^2))/Zmass^2,
     gc549 -> (-4*2^(3/4)*Gf^(3/2)*Lam^2*Wmass*(2*Wmass^2 - Zmass^2))/Zmass^2,
     gc550 -> 2*Sqrt[2]*Gf*Lam^2*Wmass,
     gc551 -> -2*2^(3/4)*Gf^(3/2)*Lam^2*Wmass,
     gc552 -> (8*Sqrt[2]*Gf*Lam^2*Wmass^2)/Zmass^2,
     gc553 -> (-16*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^2)/Zmass^2,
     gc554 -> (-32*Gf^2*Lam^2*Wmass^2)/Zmass^2,
     gc555 -> (16*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^2)/Zmass^2,
     gc556 -> (-32*Gf^2*Lam^2*Wmass^2)/Zmass^2,
     gc557 -> (32*Gf^2*Lam^2*Wmass^2)/Zmass^2,
     gc558 -> (8*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^2*(2*Wmass^2 - Zmass^2)*Sqrt[-Wmass^2 + Zmass^2])/Zmass^3,
     gc559 -> (16*Gf^2*Lam^2*Wmass^2*(2*Wmass^2 - Zmass^2)*Sqrt[-Wmass^2 + Zmass^2])/Zmass^3,
     gc560 -> (16*Gf^2*Lam^2*Wmass^2*(2*Wmass^2 - Zmass^2)*Sqrt[-Wmass^2 + Zmass^2])/Zmass^3,
     gc561 -> 2*2^(1/4)*Sqrt[Gf]*Lam^2*Wmass^2*Zmass*Sqrt[-Wmass^2 + Zmass^2],
     gc562 -> 2*Sqrt[2]*Gf*Lam^2*Wmass^2*Zmass*Sqrt[-Wmass^2 + Zmass^2],
     gc563 -> 4*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^2*Zmass*Sqrt[-Wmass^2 + Zmass^2],
     gc564 -> 24*Gf^2*Lam^2*Wmass^2*Zmass*Sqrt[-Wmass^2 + Zmass^2],
     gc565 -> 6*Sqrt[2]*Gf*Lam^2*Wmass^2*Zmass*Sqrt[-Wmass^2 + Zmass^2],
     gc566 -> 4*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^2*Zmass*Sqrt[-Wmass^2 + Zmass^2],
     gc567 -> 8*Gf^2*Lam^2*Wmass^2*Zmass*Sqrt[-Wmass^2 + Zmass^2],
     gc568 -> 12*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^2*Zmass*Sqrt[-Wmass^2 + Zmass^2],
     gc569 -> 8*Gf^2*Lam^2*Wmass^2*Zmass*Sqrt[-Wmass^2 + Zmass^2],
     gc570 -> 24*Gf^2*Lam^2*Wmass^2*Zmass*Sqrt[-Wmass^2 + Zmass^2],
     gc571 -> -2*Sqrt[2]*Gf*Lam^2*Wmass,
     gc572 -> -2*2^(3/4)*Gf^(3/2)*Lam^2*Wmass,
     gc573 -> (4*2^(3/4)*Gf^(3/2)*Lam^2*Wmass*(-2*Wmass^2 + Zmass^2))/Zmass^2,
     gc574 -> 2*Sqrt[2]*Gf*Lam^2*Wmass,
     gc575 -> -2*2^(3/4)*Gf^(3/2)*Lam^2*Wmass,
     gc576 -> 2*2^(3/4)*Gf^(3/2)*Lam^2*Wmass,
     gc577 -> (-4*Sqrt[2]*Gf*Lam^2*Wmass*(2*Wmass^2 - Zmass^2))/Zmass^2,
     gc578 -> (4*2^(3/4)*Gf^(3/2)*Lam^2*Wmass*(2*Wmass^2 - Zmass^2))/Zmass^2,
     gc579 -> -2*Sqrt[2]*Gf*Lam^2*Wmass,
     gc580 -> 2*2^(3/4)*Gf^(3/2)*Lam^2*Wmass,
     gc581 -> Wmass^2/(4*Gf*Zmass^2*Sqrt[-Wmass^2 + Zmass^2]),
     gc582 -> (8*Lam*Wmass^2)/Zmass^2,
     gc583 -> (32*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass^2)/Zmass^2,
     gc584 -> (32*Gf^2*Lam^2*Wmass^2*(-2*Wmass^2 + Zmass^2)^2)/Zmass^2,
     gc585 -> (16*2^(3/4)*(Cphi4n1 + Cphi4n3)*Gf^(3/2)*Lam^2*Wmass^2)/Zmass^2,
     gc586 -> (32*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass^2)/Zmass^2,
     gc587 -> (4*Lam*Wmass^2)/Zmass^2,
     gc588 -> (2*2^(1/4)*Lam*Wmass^2)/(Sqrt[Gf]*Zmass^2),
     gc589 -> (4*Lam*Wmass^2)/Zmass^2,
     gc590 -> 48*Gf^2*Lam^2*Wmass^2*Zmass^2,
     gc591 -> 8*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^2*Zmass^2,
     gc592 -> 16*Gf^2*Lam^2*Wmass^2*Zmass^2,
     gc593 -> 24*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^2*Zmass^2,
     gc594 -> 48*Gf^2*Lam^2*Wmass^2*Zmass^2,
     gc595 -> (8*Sqrt[2]*Gf*Lam^2*Wmass^2)/Zmass^2,
     gc596 -> (16*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^2)/Zmass^2,
     gc597 -> (-32*Gf^2*Lam^2*Wmass^2)/Zmass^2,
     gc598 -> (16*2^(3/4)*Gf^(3/2)*Lam^2*Wmass^2)/Zmass^2,
     gc599 -> (32*Gf^2*Lam^2*Wmass^2)/Zmass^2,
     gc600 -> (32*Gf^2*Lam^2*Wmass^2)/Zmass^2,
     gc601 -> 8*Sqrt[2]*(Cphi4n1 + Cphi4n3)*Gf*Lam^2*Wmass*(2*Wmass^2 - Zmass^2)*Sqrt[-Wmass^2 + Zmass^2],
     gc602 -> 32*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass*(2*Wmass^2 - Zmass^2)*Sqrt[-Wmass^2 + Zmass^2],
     gc603 -> (128*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass*(2*Wmass^2 - Zmass^2)^3*Sqrt[-Wmass^2 + Zmass^2])/Zmass^4,
     gc604 -> 16*2^(3/4)*(Cphi4n1 + Cphi4n3)*Gf^(3/2)*Lam^2*Wmass*(2*Wmass^2 - Zmass^2)*Sqrt[-Wmass^2 + Zmass^2],
     gc605 -> 32*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass*(2*Wmass^2 - Zmass^2)*Sqrt[-Wmass^2 + Zmass^2],
     gc606 -> (-4*Sqrt[2]*(Cphi4n1 + Cphi4n3)*Gf*Lam^2*(-2*Wmass^2 + Zmass^2)^2)/Zmass,
     gc607 -> (4*2^(3/4)*(Cphi4n1 + Cphi4n3)*Gf^(3/2)*Lam^2*(-2*Wmass^2 + Zmass^2)^2)/Zmass,
     gc608 -> -2*(Cphi4n1 + Cphi4n3)*Lam^2*Zmass^3,
     gc609 -> -4*Sqrt[2]*(Cphi4n1 + Cphi4n3)*Gf*Lam^2*Zmass^3,
     gc610 -> 2*2^(1/4)*(Cphi4n1 + Cphi4n3)*Sqrt[Gf]*Lam^2*Zmass^3,
     gc611 -> 4*2^(3/4)*(Cphi4n1 + Cphi4n3)*Gf^(3/2)*Lam^2*Zmass^3,
     gc612 -> -4*Sqrt[2]*(Cphi4n1 + Cphi4n3)*Gf*Lam^2*Zmass^3,
     gc613 -> 4*2^(3/4)*(Cphi4n1 + Cphi4n3)*Gf^(3/2)*Lam^2*Zmass^3,
     gc614 -> (-8*2^(3/4)*(Cphi4n1 + Cphi4n3)*Gf^(3/2)*Lam^2*(-2*Wmass^2 + Zmass^2)^3)/Zmass^3,
     gc615 -> -2*2^(1/4)*(Cphi4n1 + Cphi4n3)*Sqrt[Gf]*Lam^2*Zmass*(-2*Wmass^2 + Zmass^2),
     gc616 -> -4*2^(3/4)*(Cphi4n1 + Cphi4n3)*Gf^(3/2)*Lam^2*Zmass*(-2*Wmass^2 + Zmass^2),
     gc617 -> 4*Sqrt[2]*(Cphi4n1 + Cphi4n3)*Gf*Lam^2*Zmass*(-2*Wmass^2 + Zmass^2),
     gc618 -> -4*2^(3/4)*(Cphi4n1 + Cphi4n3)*Gf^(3/2)*Lam^2*Zmass*(-2*Wmass^2 + Zmass^2),
     gc619 -> (16*2^(3/4)*(Cphi4n1 + Cphi4n3)*Gf^(3/2)*Lam^2*Wmass*(Wmass^2 - Zmass^2)*(-2*Wmass^2 + Zmass^2)^2)/Zmass^3,
     gc620 -> (-32*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass*(Wmass^2 - Zmass^2)*(-2*Wmass^2 + Zmass^2)^2)/Zmass^3,
     gc621 -> (32*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass*(Wmass^2 - Zmass^2)*(-2*Wmass^2 + Zmass^2)^2)/Zmass^3,
     gc622 -> 4*2^(1/4)*(Cphi4n1 + Cphi4n3)*Sqrt[Gf]*Lam^2*Wmass*Zmass*(Wmass^2 - Zmass^2),
     gc623 -> -4*Sqrt[2]*(Cphi4n1 + Cphi4n3)*Gf*Lam^2*Wmass*Zmass*(Wmass^2 - Zmass^2),
     gc624 -> 8*2^(3/4)*(Cphi4n1 + Cphi4n3)*Gf^(3/2)*Lam^2*Wmass*Zmass*(Wmass^2 - Zmass^2),
     gc625 -> -48*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass*Zmass*(Wmass^2 - Zmass^2),
     gc626 -> 12*Sqrt[2]*(Cphi4n1 + Cphi4n3)*Gf*Lam^2*Wmass*Zmass*(Wmass^2 - Zmass^2),
     gc627 -> -8*2^(3/4)*(Cphi4n1 + Cphi4n3)*Gf^(3/2)*Lam^2*Wmass*Zmass*(Wmass^2 - Zmass^2),
     gc628 -> 16*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass*Zmass*(Wmass^2 - Zmass^2),
     gc629 -> 24*2^(3/4)*(Cphi4n1 + Cphi4n3)*Gf^(3/2)*Lam^2*Wmass*Zmass*(Wmass^2 - Zmass^2),
     gc630 -> -16*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass*Zmass*(Wmass^2 - Zmass^2),
     gc631 -> 48*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass*Zmass*(Wmass^2 - Zmass^2),
     gc632 -> (16*2^(3/4)*(Cphi4n1 + Cphi4n3)*Gf^(3/2)*Lam^2*Wmass*(Wmass^2 - Zmass^2)*(-2*Wmass^2 + Zmass^2)^2)/Zmass^3,
     gc633 -> (32*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass*(Wmass^2 - Zmass^2)*(-2*Wmass^2 + Zmass^2)^2)/Zmass^3,
     gc634 -> (32*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass*(Wmass^2 - Zmass^2)*(-2*Wmass^2 + Zmass^2)^2)/Zmass^3,
     gc635 -> 4*2^(1/4)*(Cphi4n1 + Cphi4n3)*Sqrt[Gf]*Lam^2*Wmass*Zmass*(Wmass^2 - Zmass^2),
     gc636 -> 4*Sqrt[2]*(Cphi4n1 + Cphi4n3)*Gf*Lam^2*Wmass*Zmass*(Wmass^2 - Zmass^2),
     gc637 -> 8*2^(3/4)*(Cphi4n1 + Cphi4n3)*Gf^(3/2)*Lam^2*Wmass*Zmass*(Wmass^2 - Zmass^2),
     gc638 -> 48*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass*Zmass*(Wmass^2 - Zmass^2),
     gc639 -> 12*Sqrt[2]*(Cphi4n1 + Cphi4n3)*Gf*Lam^2*Wmass*Zmass*(Wmass^2 - Zmass^2),
     gc640 -> 8*2^(3/4)*(Cphi4n1 + Cphi4n3)*Gf^(3/2)*Lam^2*Wmass*Zmass*(Wmass^2 - Zmass^2),
     gc641 -> 16*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass*Zmass*(Wmass^2 - Zmass^2),
     gc642 -> 24*2^(3/4)*(Cphi4n1 + Cphi4n3)*Gf^(3/2)*Lam^2*Wmass*Zmass*(Wmass^2 - Zmass^2),
     gc643 -> 16*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass*Zmass*(Wmass^2 - Zmass^2),
     gc644 -> 48*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Wmass*Zmass*(Wmass^2 - Zmass^2),
     gc645 -> 8*Sqrt[2]*(Cphi4n1 + Cphi4n3)*Gf*Lam^2*(-2*Wmass^2 + Zmass^2)^2,
     gc646 -> 32*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*(-2*Wmass^2 + Zmass^2)^2,
     gc647 -> (64*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*(-2*Wmass^2 + Zmass^2)^4)/Zmass^4,
     gc648 -> 16*2^(3/4)*(Cphi4n1 + Cphi4n3)*Gf^(3/2)*Lam^2*(-2*Wmass^2 + Zmass^2)^2,
     gc649 -> 32*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*(-2*Wmass^2 + Zmass^2)^2,
     gc650 -> 2*(Cphi4n1 + Cphi4n3)*Lam^2*Zmass^4,
     gc651 -> 8*Sqrt[2]*(Cphi4n1 + Cphi4n3)*Gf*Lam^2*Zmass^4,
     gc652 -> 96*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Zmass^4,
     gc653 -> 8*2^(1/4)*(Cphi4n1 + Cphi4n3)*Sqrt[Gf]*Lam^2*Zmass^4,
     gc654 -> 16*2^(3/4)*(Cphi4n1 + Cphi4n3)*Gf^(3/2)*Lam^2*Zmass^4,
     gc655 -> 24*Sqrt[2]*(Cphi4n1 + Cphi4n3)*Gf*Lam^2*Zmass^4,
     gc656 -> 32*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Zmass^4,
     gc657 -> 48*2^(3/4)*(Cphi4n1 + Cphi4n3)*Gf^(3/2)*Lam^2*Zmass^4,
     gc658 -> 96*(Cphi4n1 + Cphi4n3)*Gf^2*Lam^2*Zmass^4,
     gc659 -> (Wmass*(-64*Gf^2*(Wmass^2 - Zmass^2)^2 + 8*Sqrt[2]*Gf*Lam*(Wmass^2 - Zmass^2)*(Cll2x1x1x2*(Wmass^2 - Zmass^2) - Wmass*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2])) + Lam^2*(7*Cll2x1x1x2^2*(Wmass^2 - Zmass^2)^2 - 2*Cll2x1x1x2*Wmass*(Wmass^2 - Zmass^2)*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2]) + Wmass*(CphiD^2*Wmass^3 + 8*CphiD*CphiWB*(-Wmass^2 + Zmass^2)^(3/2) + 32*CphiW*CphiWB*(-Wmass^2 + Zmass^2)^(3/2)))))/(48*2^(3/4)*Gf^(3/2)*(Wmass - Zmass)*Zmass*(Wmass + Zmass)*Sqrt[-Wmass^2 + Zmass^2]),
     gc660 -> (Wmass*(-64*Gf^2*(Wmass^2 - Zmass^2)^2 + 8*Sqrt[2]*Gf*Lam*(Wmass^2 - Zmass^2)*(Cll2x1x1x2*(Wmass^2 - Zmass^2) - Wmass*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2])) + Lam^2*(7*Cll2x1x1x2^2*(Wmass^2 - Zmass^2)^2 - 2*Cll2x1x1x2*Wmass*(Wmass^2 - Zmass^2)*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2]) + Wmass*(CphiD^2*Wmass^3 + 8*CphiD*CphiWB*(-Wmass^2 + Zmass^2)^(3/2) + 32*CphiW*CphiWB*(-Wmass^2 + Zmass^2)^(3/2)))))/(16*2^(3/4)*Gf^(3/2)*(Wmass - Zmass)*Zmass*(Wmass + Zmass)*Sqrt[-Wmass^2 + Zmass^2]),
     gc661 -> -1/24*(Wmass*(-64*Gf^2*(Wmass^2 - Zmass^2)^2 + 8*Sqrt[2]*Gf*Lam*(Wmass^2 - Zmass^2)*(Cll2x1x1x2*(Wmass^2 - Zmass^2) - Wmass*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2])) + Lam^2*(7*Cll2x1x1x2^2*(Wmass^2 - Zmass^2)^2 - 2*Cll2x1x1x2*Wmass*(Wmass^2 - Zmass^2)*(CphiD*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2]) + Wmass*(CphiD^2*Wmass^3 + 8*CphiD*CphiWB*(-Wmass^2 + Zmass^2)^(3/2) + 32*CphiW*CphiWB*(-Wmass^2 + Zmass^2)^(3/2)))))/(2^(3/4)*Gf^(3/2)*(Wmass - Zmass)*Zmass*(Wmass + Zmass)*Sqrt[-Wmass^2 + Zmass^2]),
     gc662 -> -2*Sqrt[aS]*Sqrt[Pi],
     gc663 -> -2*Sqrt[aS]*Sqrt[Pi],
     gc664[e1x2_, e2x2_] -> -1/32*((64*Sqrt[2]*Gf^2 - 16*Cll2x1x1x2*Gf*Lam - 7*Sqrt[2]*Cll2x1x1x2^2*Lam^2)*Wmass*Conjugate[Ul[e2x2, e1x2]])/(2^(3/4)*Gf^(3/2)),
     gc665[e1x2_, e2x2_] -> -1/32*((64*Sqrt[2]*Gf^2 - 16*Cll2x1x1x2*Gf*Lam - 7*Sqrt[2]*Cll2x1x1x2^2*Lam^2)*Wmass*Kq[e1x2, e2x2])/(2^(3/4)*Gf^(3/2)),
     gc666[e1x2_, e2x2_] -> -1/32*((64*Sqrt[2]*Gf^2 - 16*Cll2x1x1x2*Gf*Lam - 7*Sqrt[2]*Cll2x1x1x2^2*Lam^2)*Wmass*Conjugate[Kq[e2x2, e1x2]])/(2^(3/4)*Gf^(3/2)),
     gc667[e1x2_, e2x2_] -> -1/32*((64*Sqrt[2]*Gf^2 - 16*Cll2x1x1x2*Gf*Lam - 7*Sqrt[2]*Cll2x1x1x2^2*Lam^2)*Wmass*Ul[e1x2, e2x2])/(2^(3/4)*Gf^(3/2)),
     gc668 -> (-16*CphiWB*Lam*Wmass*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(Wmass^2 - Zmass^2))) - Sqrt[-Wmass^2 + Zmass^2]*(-64*Gf^2*(2*Wmass^2 + Zmass^2) + 8*Sqrt[2]*Gf*Lam*(CphiD*(-2*Wmass^2 + Zmass^2) + Cll2x1x1x2*(2*Wmass^2 + Zmass^2)) + Lam^2*(CphiD^2*(2*Wmass^2 - 3*Zmass^2) + 2*Cll2x1x1x2*CphiD*(-2*Wmass^2 + Zmass^2) + 7*Cll2x1x1x2^2*(2*Wmass^2 + Zmass^2))))/(96*2^(3/4)*Gf^(3/2)*Zmass*Sqrt[-Wmass^2 + Zmass^2]),
     gc669 -> (-16*CphiWB*Lam*Wmass*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(Wmass^2 - Zmass^2))) + Sqrt[-Wmass^2 + Zmass^2]*(64*Gf^2*(2*Wmass^2 - Zmass^2) + 8*Sqrt[2]*Gf*Lam*(Cll2x1x1x2*(-2*Wmass^2 + Zmass^2) + CphiD*(2*Wmass^2 + Zmass^2)) + Lam^2*(7*Cll2x1x1x2^2*(-2*Wmass^2 + Zmass^2) + 2*Cll2x1x1x2*CphiD*(2*Wmass^2 + Zmass^2) - CphiD^2*(2*Wmass^2 + 3*Zmass^2))))/(32*2^(3/4)*Gf^(3/2)*Zmass*Sqrt[-Wmass^2 + Zmass^2]),
     gc670 -> (32*CphiWB*Lam*Wmass*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(Wmass^2 - Zmass^2))) - Sqrt[-Wmass^2 + Zmass^2]*(64*Gf^2*(4*Wmass^2 - Zmass^2) + 8*Sqrt[2]*Gf*Lam*(Cll2x1x1x2*(-4*Wmass^2 + Zmass^2) + CphiD*(4*Wmass^2 + Zmass^2)) + Lam^2*(7*Cll2x1x1x2^2*(-4*Wmass^2 + Zmass^2) + 2*Cll2x1x1x2*CphiD*(4*Wmass^2 + Zmass^2) - CphiD^2*(4*Wmass^2 + 3*Zmass^2))))/(96*2^(3/4)*Gf^(3/2)*Zmass*Sqrt[-Wmass^2 + Zmass^2]),
     gc671 -> ((-64*Gf^2 + 8*Sqrt[2]*(Cll2x1x1x2 + CphiD)*Gf*Lam + (7*Cll2x1x1x2^2 + 2*Cll2x1x1x2*CphiD - 3*CphiD^2)*Lam^2)*Zmass)/(32*2^(3/4)*Gf^(3/2)),
     gc672 -> Lam,
     gc673[e1x2_, e3x2_, e2x2_, e4x2_] -> Lam*(IndexSum[IndexSum[Cll[e1x2, e2x2, Generation$1, Generation$2]*Conjugate[Ul[Generation$1, e3x2]], {Generation$1, 1, 3}]*Ul[Generation$2, e4x2], {Generation$2, 1, 3}] + IndexSum[IndexSum[Cll[Generation$1, Generation$2, e1x2, e2x2]*Conjugate[Ul[Generation$1, e3x2]], {Generation$1, 1, 3}]*Ul[Generation$2, e4x2], {Generation$2, 1, 3}]),
     gc674 -> Lam,
     gc675 -> (Lam*(4*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(CphiD*Lam*Zmass^2 + 4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + 4*CphiW*Lam*(Wmass^2 - Zmass^2))))/(8*Gf*(Wmass - Zmass)*Zmass*(Wmass + Zmass)),
     gc676 -> (Lam*(4*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(4*CphiW*Wmass^2 + CphiD*Zmass^2 - 4*CphiW*Zmass^2 + 4*CphiBox*(Wmass^2 - Zmass^2)))))/(8*Gf*(Wmass - Zmass)*Zmass*(Wmass + Zmass)),
     gc677[e1x2_, e2x2_] -> -((Lam*(Sqrt[2]*Gf + CphiW*Lam)*Conjugate[CuW[e2x2, e1x2]])/Gf),
     gc678 -> (Lam*(Sqrt[2]*Gf*Wmass + CphiW*Lam*Wmass + CphiWB*Lam*Sqrt[-Wmass^2 + Zmass^2]))/(2*Gf*Zmass),
     gc679 -> (Lam*(Sqrt[2]*Gf*Wmass + Lam*(CphiBox*Wmass + CphiW*Wmass + CphiWB*Sqrt[-Wmass^2 + Zmass^2])))/(2*Gf*Zmass),
     gc680[e1x2_, e2x2_] -> (Lam*(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2)))*IndexSum[Conjugate[CuW[Generation$1, e1x2]]*Kq[Generation$1, e2x2], {Generation$1, 1, 3}])/(8*Gf*(Wmass - Zmass)*Zmass*(Wmass + Zmass)),
     gc681[e1x2_, e2x2_] -> (Lam*(-8*Gf + Sqrt[2]*(CphiD - 4*CphiW)*Lam)*IndexSum[Conjugate[CuW[Generation$1, e1x2]]*Kq[Generation$1, e2x2], {Generation$1, 1, 3}])/(8*Gf),
     gc682[e1x2_, e2x2_] -> (Lam*(8*Gf + Sqrt[2]*(4*CphiBox - CphiD + 4*CphiW)*Lam)*IndexSum[Conjugate[CuW[Generation$1, e1x2]]*Kq[Generation$1, e2x2], {Generation$1, 1, 3}])/(8*Gf),
     gc683[e1x2_, e2x2_] -> (Lam*(8*Gf*Wmass + Sqrt[2]*Lam*(CphiD*Wmass + 4*CphiW*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2]))*IndexSum[Conjugate[CuW[Generation$1, e1x2]]*Kq[Generation$1, e2x2], {Generation$1, 1, 3}])/(8*Gf*Zmass),
     gc684[e1x2_, e2x2_] -> (Lam*Wmass*(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2)))*IndexSum[Conjugate[CuW[Generation$1, e1x2]]*Kq[Generation$1, e2x2], {Generation$1, 1, 3}])/(4*Gf*(Wmass - Zmass)*Zmass*(Wmass + Zmass)),
     gc685[e1x2_, e2x2_] -> -1/2*(Lam*Wmass*(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(4*CphiW*Wmass^2 + CphiD*Zmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2))))*IndexSum[Conjugate[CuW[Generation$1, e1x2]]*Kq[Generation$1, e2x2], {Generation$1, 1, 3}])/(2^(3/4)*Sqrt[Gf]*(Wmass - Zmass)*Zmass*(Wmass + Zmass)),
     gc686[e1x2_, e2x2_] -> (Lam*Wmass*(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(4*CphiBox*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiBox*Zmass^2 + CphiD*Zmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2))))*IndexSum[Conjugate[CuW[Generation$1, e1x2]]*Kq[Generation$1, e2x2], {Generation$1, 1, 3}])/(2*2^(3/4)*Sqrt[Gf]*(Wmass - Zmass)*Zmass*(Wmass + Zmass)),
     gc687[e1x2_, e2x2_] -> (Lam*Wmass*(4*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2))))*Conjugate[CuW[e2x2, e1x2]])/(2^(3/4)*Sqrt[Gf]*(Wmass - Zmass)*Zmass*(Wmass + Zmass)),
     gc688 -> (Lam*(Sqrt[2]*Gf + CphiW*Lam)*Wmass)/Gf,
     gc689 -> (Lam*(4*Sqrt[2]*Gf - (Cll2x1x1x2 + CphiD - 4*CphiW)*Lam)*Wmass)/(2*2^(3/4)*Sqrt[Gf]),
     gc690 -> -1/2*(Lam*(-4*Sqrt[2]*Gf + (Cll2x1x1x2 - 4*CphiBox + CphiD - 4*CphiW)*Lam)*Wmass)/(2^(3/4)*Sqrt[Gf]),
     gc691[e1x2_, e2x2_] -> -1/2*(Lam*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 - 4*CphiW)*Lam)*Wmass*IndexSum[Conjugate[CuW[Generation$1, e1x2]]*Kq[Generation$1, e2x2], {Generation$1, 1, 3}])/(2^(3/4)*Sqrt[Gf]),
     gc692[e1x2_, e2x2_] -> -1/4*(Lam*Wmass*(8*Gf*Wmass + Sqrt[2]*Lam*(CphiD*Wmass + 4*CphiW*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2]))*IndexSum[Conjugate[CuW[Generation$1, e1x2]]*Kq[Generation$1, e2x2], {Generation$1, 1, 3}])/(Gf*Zmass),
     gc693[e1x2_, e2x2_] -> -1/2*(Lam*Wmass*(-8*Gf*Wmass + Sqrt[2]*Lam*(Cll2x1x1x2*Wmass - 4*(CphiW*Wmass + CphiWB*Sqrt[-Wmass^2 + Zmass^2])))*IndexSum[Conjugate[CuW[Generation$1, e1x2]]*Kq[Generation$1, e2x2], {Generation$1, 1, 3}])/(2^(3/4)*Sqrt[Gf]*Zmass),
     gc694[e1x2_, e2x2_] -> (Lam*Wmass*(-8*Gf*Wmass + Sqrt[2]*Lam*(Cll2x1x1x2*Wmass - 4*(CphiBox*Wmass + CphiW*Wmass + CphiWB*Sqrt[-Wmass^2 + Zmass^2])))*IndexSum[Conjugate[CuW[Generation$1, e1x2]]*Kq[Generation$1, e2x2], {Generation$1, 1, 3}])/(2*2^(3/4)*Sqrt[Gf]*Zmass),
     gc695[e1x2_, e2x2_] -> -((Lam*Wmass*(4*Sqrt[2]*Gf*Wmass + Lam*(-(Cll2x1x1x2*Wmass) + CphiD*Wmass + 4*CphiW*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2]))*Conjugate[CuW[e2x2, e1x2]])/(2^(3/4)*Sqrt[Gf]*Zmass)),
     gc696[e1x2_, e2x2_] -> (Lam*(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2)))*IndexSum[Conjugate[Kq[Generation$1, e1x2]]*CuW[Generation$1, e2x2], {Generation$1, 1, 3}])/(8*Gf*(Wmass - Zmass)*Zmass*(Wmass + Zmass)),
     gc697[e1x2_, e2x2_] -> -1/8*(Lam*(-8*Gf + Sqrt[2]*(CphiD - 4*CphiW)*Lam)*IndexSum[Conjugate[Kq[Generation$1, e1x2]]*CuW[Generation$1, e2x2], {Generation$1, 1, 3}])/Gf,
     gc698[e1x2_, e2x2_] -> (Lam*(8*Gf + Sqrt[2]*(4*CphiBox - CphiD + 4*CphiW)*Lam)*IndexSum[Conjugate[Kq[Generation$1, e1x2]]*CuW[Generation$1, e2x2], {Generation$1, 1, 3}])/(8*Gf),
     gc699[e1x2_, e2x2_] -> (Lam*(8*Gf*Wmass + Sqrt[2]*Lam*(CphiD*Wmass + 4*CphiW*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2]))*IndexSum[Conjugate[Kq[Generation$1, e1x2]]*CuW[Generation$1, e2x2], {Generation$1, 1, 3}])/(8*Gf*Zmass),
     gc700[e1x2_, e2x2_] -> -((Lam*(Sqrt[2]*Gf + CphiW*Lam)*CuW[e1x2, e2x2])/Gf),
     gc701[e1x2_, e2x2_] -> -((Lam*Wmass*(4*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(4*Sqrt[2]*Gf*(Wmass^2 - Zmass^2) + Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2))))*CuW[e1x2, e2x2])/(2^(3/4)*Sqrt[Gf]*(Wmass - Zmass)*Zmass*(Wmass + Zmass))),
     gc702[e1x2_, e2x2_] -> -1/4*(Lam*Wmass*(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(CphiD*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiW*Zmass^2)))*IndexSum[Conjugate[Kq[Generation$1, e1x2]]*CuW[Generation$1, e2x2], {Generation$1, 1, 3}])/(Gf*(Wmass - Zmass)*Zmass*(Wmass + Zmass)),
     gc703[e1x2_, e2x2_] -> -1/2*(Lam*Wmass*(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(4*CphiW*Wmass^2 + CphiD*Zmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2))))*IndexSum[Conjugate[Kq[Generation$1, e1x2]]*CuW[Generation$1, e2x2], {Generation$1, 1, 3}])/(2^(3/4)*Sqrt[Gf]*(Wmass - Zmass)*Zmass*(Wmass + Zmass)),
     gc704[e1x2_, e2x2_] -> -1/2*(Lam*Wmass*(4*Sqrt[2]*CphiWB*Lam*Wmass*(-Wmass^2 + Zmass^2) + Sqrt[-Wmass^2 + Zmass^2]*(8*Gf*(Wmass^2 - Zmass^2) + Sqrt[2]*Lam*(4*CphiBox*Wmass^2 + 4*CphiW*Wmass^2 - 4*CphiBox*Zmass^2 + CphiD*Zmass^2 - 4*CphiW*Zmass^2 + Cll2x1x1x2*(-Wmass^2 + Zmass^2))))*IndexSum[Conjugate[Kq[Generation$1, e1x2]]*CuW[Generation$1, e2x2], {Generation$1, 1, 3}])/(2^(3/4)*Sqrt[Gf]*(Wmass - Zmass)*Zmass*(Wmass + Zmass)),
     gc705[e1x2_, e2x2_] -> -1/2*(Lam*(-8*Gf + Sqrt[2]*(Cll2x1x1x2 - 4*CphiW)*Lam)*Wmass*IndexSum[Conjugate[Kq[Generation$1, e1x2]]*CuW[Generation$1, e2x2], {Generation$1, 1, 3}])/(2^(3/4)*Sqrt[Gf]),
     gc706[e1x2_, e2x2_] -> (Lam*Wmass*(4*Sqrt[2]*Gf*Wmass + Lam*(-(Cll2x1x1x2*Wmass) + CphiD*Wmass + 4*CphiW*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2]))*CuW[e1x2, e2x2])/(2^(3/4)*Sqrt[Gf]*Zmass),
     gc707[e1x2_, e2x2_] -> (Lam*Wmass*(8*Gf*Wmass + Sqrt[2]*Lam*(CphiD*Wmass + 4*CphiW*Wmass + 4*CphiWB*Sqrt[-Wmass^2 + Zmass^2]))*IndexSum[Conjugate[Kq[Generation$1, e1x2]]*CuW[Generation$1, e2x2], {Generation$1, 1, 3}])/(4*Gf*Zmass),
     gc708[e1x2_, e2x2_] -> -1/2*(Lam*Wmass*(-8*Gf*Wmass + Sqrt[2]*Lam*(Cll2x1x1x2*Wmass - 4*(CphiW*Wmass + CphiWB*Sqrt[-Wmass^2 + Zmass^2])))*IndexSum[Conjugate[Kq[Generation$1, e1x2]]*CuW[Generation$1, e2x2], {Generation$1, 1, 3}])/(2^(3/4)*Sqrt[Gf]*Zmass),
     gc709[e1x2_, e2x2_] -> -1/2*(Lam*Wmass*(-8*Gf*Wmass + Sqrt[2]*Lam*(Cll2x1x1x2*Wmass - 4*(CphiBox*Wmass + CphiW*Wmass + CphiWB*Sqrt[-Wmass^2 + Zmass^2])))*IndexSum[Conjugate[Kq[Generation$1, e1x2]]*CuW[Generation$1, e2x2], {Generation$1, 1, 3}])/(2^(3/4)*Sqrt[Gf]*Zmass)};

