(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18889,        414]
NotebookOptionsPosition[     16487,        372]
NotebookOutlinePosition[     16900,        388]
CellTagsIndexPosition[     16857,        385]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "SmeftFR v2.01  \n ",
 StyleBox["Feynman rule generator in SMEFT",
  FontSize->36],
 " \n",
 StyleBox[" Initialization and generation of mass basis Lagrangian and \
Feynman rules in Mathematica format", "Section",
  FontTracking->"Plain",
  FontColor->GrayLevel[0]]
}], "Title",
 CellChangeTimes->{{3.4126590568924417`*^9, 3.412659075768538*^9}, {
  3.423416384793591*^9, 3.423416395796236*^9}, {3.4234174151520243`*^9, 
  3.423417420076274*^9}, {3.760600931373452*^9, 3.760600938564866*^9}, {
  3.760600980116218*^9, 3.7606010342731333`*^9}, {3.760601110546075*^9, 
  3.7606011157457647`*^9}, {3.760965916750543*^9, 3.7609659226892*^9}, {
  3.760969333036388*^9, 3.760969456832159*^9}, {3.76096949468789*^9, 
  3.760969497616509*^9}, {3.760969597787758*^9, 3.7609696028087606`*^9}, {
  3.7626081111625757`*^9, 3.7626081133046713`*^9}, {3.7627061470597277`*^9, 
  3.762706201161648*^9}, {3.7765899500613956`*^9, 3.776589950243178*^9}},
 TextAlignment->Center,ExpressionUUID->"68b8f4ae-1b50-45fc-8fb7-0768ce1acaea"],

Cell[CellGroupData[{

Cell["Set proper paths and load package ", "Section",
 CellChangeTimes->{{3.760969789646365*^9, 3.760969816962785*^9}, {
   3.760969884414713*^9, 3.760969885436679*^9}, 3.760969946661951*^9, 
   3.76260770692522*^9, {3.762607786766529*^9, 
   3.762607803901524*^9}},ExpressionUUID->"d8e28858-48c3-45e1-85e5-\
ba933fc1c3a2"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Remove", "[", "\"\<Global`*\>\"", "]"}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "FeynRules", " ", "and", " ", "SmeftFR", " ", "package", " ", 
     "installation", " ", "paths"}], "-", 
    RowBox[{"edit", " ", "if", " ", "necessary"}]}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$FeynRulesPath", " ", "=", " ", 
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
     "\"\</home\>\"", ",", "\"\<rosiek\>\"", ",", "\"\<FeynRules\>\""}], 
     "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SMEFT$MajorVersion", "=", "\"\<2\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SMEFT$MinorVersion", "=", "\"\<01\>\""}], ";"}], "\n", 
 RowBox[{
  RowBox[{"SMEFT$Path", " ", "=", " ", 
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{"$FeynRulesPath", ",", "\"\<Models\>\"", ",", 
      RowBox[{
      "\"\<SMEFT_\>\"", "<>", "SMEFT$MajorVersion", "<>", "\"\<_\>\"", "<>", 
       "SMEFT$MinorVersion"}]}], "}"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.4126590568924417`*^9, 3.412659075768538*^9}, {
   3.423416384793591*^9, 3.423416395796236*^9}, {3.4234174151520243`*^9, 
   3.423417420076274*^9}, {3.760600931373452*^9, 3.760600938564866*^9}, {
   3.760600980116218*^9, 3.7606010342731333`*^9}, {3.760601110546075*^9, 
   3.7606011157457647`*^9}, {3.760965916750543*^9, 3.7609659226892*^9}, {
   3.760969333036388*^9, 3.760969352713992*^9}, {3.762607743744027*^9, 
   3.762607779329927*^9}, {3.762608122223051*^9, 3.762608126633313*^9}, 
   3.7627067766351833`*^9, {3.7627088786850967`*^9, 3.762708880723909*^9}, {
   3.7765899575524054`*^9, 
   3.776589957582139*^9}},ExpressionUUID->"eec34924-11ca-48a1-b401-\
77b9b8b2dc0f"],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
   "Load", " ", "FeynRules", " ", "and", " ", "SMEFT", " ", "packages"}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Get", "[", 
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{"$FeynRulesPath", ",", "\"\<FeynRules.m\>\""}], "}"}], "]"}], 
     "]"}], ";"}], "\n", 
   RowBox[{
    RowBox[{"Get", "[", 
     RowBox[{"FileNameJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "SMEFT$Path", ",", "\"\<code\>\"", ",", "\"\<smeft_package.m\>\""}], 
       "}"}], "]"}], "]"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.760601085197588*^9, 3.760601106029333*^9}, 
   3.762706773810341*^9},ExpressionUUID->"665e8197-75cc-4cc9-9080-\
ac98cfaa0526"]
}, Open  ]],

Cell[CellGroupData[{

Cell["The operator choice", "Section",
 CellChangeTimes->{{3.405056344594654*^9, 3.405056350062855*^9}, {
  3.76060120013032*^9, 3.760601215304221*^9}, {3.762607825232381*^9, 
  3.7626078276764383`*^9}},ExpressionUUID->"e96c696a-2112-41de-8ea0-\
9c7f435d2c86"],

Cell["\<\
Define first operator list we want the Feynman rules for.  Operator names can \
be chosen from the list 
OpList = { \[OpenCurlyDoubleQuote]G\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]Gtilde\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]W\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]Wtilde\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]phi\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]phiBox\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]phiD\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]phiW\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]phiB\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]phiWB\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]phiWtilde\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]phiBtilde\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]phiWtildeB\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]phiGtilde\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]phiG\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]ephi\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]dphi\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]uphi\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]eW\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]eB\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]uG\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]uW\[CloseCurlyDoubleQuote],\[OpenCurlyDoubleQuote]uB\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]dG\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]dW\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]dB\
\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]phil1\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]phil3\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]phie\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]phiq1\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]phiq3\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]phiu\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]phid\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]phiud\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]ll\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]qq1\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]qq3\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]lq1\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]lq3\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]ee\
\[CloseCurlyDoubleQuote],\[OpenCurlyDoubleQuote]uu\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]dd\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]eu\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]ed\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]ud1\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]ud8\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]le\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]lu\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]ld\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]qe\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]qu1\[CloseCurlyDoubleQuote],\
\[OpenCurlyDoubleQuote]qu8\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]qd1\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]qd8\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]ledq\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]quqd1\[CloseCurlyDoubleQuote],\[OpenCurlyDoubleQuote]\
quqd8\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]lequ1\
\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]lequ3\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]vv\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]duq\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]qqu\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]qqq\[CloseCurlyDoubleQuote], \
\[OpenCurlyDoubleQuote]duu\[CloseCurlyDoubleQuote] };\
\>", "Text",
 CellChangeTimes->{{3.40505595685706*^9, 3.405055957006489*^9}, {
  3.4050559897639112`*^9, 3.4050560009412193`*^9}, {3.760601225070943*^9, 
  3.760601268371007*^9}, {3.762607834436572*^9, 3.762607872982188*^9}, {
  3.762607939113989*^9, 
  3.762607974324449*^9}},ExpressionUUID->"97700b4e-1d9c-426c-b9dc-\
bf15e463b8df"],

Cell[BoxData[
 RowBox[{
  RowBox[{"OpList", "=", 
   RowBox[{"{", 
    RowBox[{
    "\"\<W\>\"", ",", "\"\<phiD\>\"", ",", "\"\<phiWB\>\"", ",", 
     "\"\<phil1\>\"", ",", "\"\<vv\>\"", ",", "\"\<ledq\>\""}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.405056007497719*^9, 3.405056021457884*^9}, {
  3.760601285948007*^9, 3.760601297674923*^9}, {3.762607988016385*^9, 
  3.762607990002861*^9}, {3.762706812965577*^9, 3.762706852288767*^9}, {
  3.7631368135694*^9, 3.763136814320786*^9}, {3.776589972320962*^9, 
  3.7765899784323053`*^9}, {3.776756611600007*^9, 
  3.77675661377184*^9}},ExpressionUUID->"0cfe60d7-00d7-4b2f-acbb-\
84bd78366b43"],

Cell["\<\
Define the file with numerical values of  Wilson coefficients in WCxf format.
If this is not given all Wilson coefficients are assigned to zero.\
\>", "Text",
 CellChangeTimes->{{3.405056036651124*^9, 3.4050562183720837`*^9}, {
  3.760601383498855*^9, 3.7606014986063213`*^9}, {3.760602427533204*^9, 
  3.760602433485485*^9}, {3.762607892418675*^9, 
  3.76260791725264*^9}},ExpressionUUID->"836a4c87-506e-4704-8cbf-\
f6b2fe1ce40d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"WCXFInput", "=", 
   RowBox[{"FileNameJoin", "[", 
    RowBox[{"{", 
     RowBox[{
     "SMEFT$Path", ",", "\"\<definitions\>\"", ",", 
      "\"\<wcxf_example.json\>\""}], "}"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.405056219218893*^9, 3.405056236551928*^9}, {
   3.760601508559561*^9, 3.760601512739525*^9}, 
   3.7627067686244583`*^9},ExpressionUUID->"1aff9ba6-77fc-4532-9a9b-\
57f8c4824de1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Initialize the Lagrangian, define gauge fixing and calculate Feynman rules\
\>", "Section",
 CellChangeTimes->{{3.405056363448367*^9, 3.40505636561475*^9}, {
  3.760601635804414*^9, 3.7606016604681253`*^9}, {3.76098076352841*^9, 
  3.760980764515277*^9}},ExpressionUUID->"bb8d404a-6d65-4d09-9078-\
5b1d41277730"],

Cell["\<\
After defining operator set, gauge choice, and neutrino type,  FeynRules \
model files must be generated first:\
\>", "Text",
 CellChangeTimes->{{3.4050562932761497`*^9, 3.405056293480383*^9}, {
  3.405056384742694*^9, 3.405056391703071*^9}, {3.405056448676361*^9, 
  3.405056453888558*^9}, {3.760601837506948*^9, 3.760601909069393*^9}, {
  3.760602394121232*^9, 3.760602409638089*^9}, {3.7626080130026073`*^9, 
  3.762608034544642*^9}},ExpressionUUID->"5c80957a-c351-45ae-afd8-\
bc6b567ce250"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SMEFTInitializeModel", "[", 
   RowBox[{
    RowBox[{"Operators", "\[Rule]", "OpList"}], ",", 
    RowBox[{"Gauge", "\[Rule]", "Rxi"}], ",", 
    RowBox[{"MajoranaNeutrino", "\[Rule]", "True"}], ",", 
    RowBox[{"WCXFInitFile", "\[Rule]", "WCXFInput"}]}], "]"}], ";"}]], "Input",\

 CellChangeTimes->{{3.4050564602005167`*^9, 3.405056646301014*^9}, {
   3.405056909869131*^9, 3.405056916498315*^9}, {3.423416634663773*^9, 
   3.42341665572878*^9}, {3.423416720554686*^9, 3.423416722086699*^9}, {
   3.453996904704235*^9, 3.453996912367002*^9}, {3.556421383059156*^9, 
   3.556421389539173*^9}, {3.556421557985771*^9, 3.556421560473724*^9}, {
   3.760601800366572*^9, 3.7606018032102222`*^9}, {3.760602333982429*^9, 
   3.760602350461622*^9}, 3.762706764938404*^9, {3.776591722027504*^9, 
   3.776591724661594*^9}},ExpressionUUID->"da57e83a-0f4e-4f5c-9a9d-\
4abe589d4239"],

Cell["\<\
Load parameters model file and calculate the Lagrangian in Warsaw basis\
\>", "Text",
 CellChangeTimes->{{3.405056665564649*^9, 3.405056825676083*^9}, {
   3.556421353921274*^9, 3.556421364809576*^9}, 3.760601997373733*^9, {
   3.7609663397182827`*^9, 3.760966373590445*^9}, {3.760966428033393*^9, 
   3.760966432719287*^9}, {3.760966478858766*^9, 
   3.760966496168911*^9}},ExpressionUUID->"03e8600d-52b8-43f0-9a80-\
f7be3ae8c54a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SMEFTLoadModel", "[", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.760966507812666*^9, 3.760966563354701*^9}},
 CellLabel->"In[10]:=",ExpressionUUID->"e0cb00e0-a2e0-4254-a24d-c26028725f11"],

Cell["Find field bilinear  and diagonalize matrices", "Text",
 CellChangeTimes->{{3.760966566870287*^9, 3.760966593259328*^9}, 
   3.760966634252749*^9, {3.760966673888075*^9, 3.7609667327822638`*^9}, {
   3.760966793210009*^9, 3.76096680084822*^9}, {3.760966921186386*^9, 
   3.7609669213228693`*^9}},ExpressionUUID->"13e460bb-6d9d-44a6-80d1-\
620651015275"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SMEFTFindMassBasis", "[", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.7609667556485367`*^9, 3.760966768351441*^9}},
 CellLabel->"In[11]:=",ExpressionUUID->"3aa68edc-d9be-42df-8329-4dffe9fc417d"],

Cell["Finds SMEFT Lagrangian in mass basis and Feynman rules ", "Text",
 CellChangeTimes->{{3.760966929980798*^9, 
  3.760966997260377*^9}},ExpressionUUID->"8d5215b7-5020-4eb9-86f5-\
bdb3de2155c3"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SMEFTFeynmanRules", "[", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.760967001917963*^9, 3.760967026489355*^9}, {
   3.760967323127953*^9, 3.7609673240073233`*^9}, 
   3.762608091197962*^9},ExpressionUUID->"969602b1-d41a-4c1b-9aba-\
6a066885134c"],

Cell[TextData[{
 "\nNow the SMEFT Lagrangian and interaction vertices have  been created. The \
Lagrangian contains the pieces:\n",
 StyleBox["LeptonGaugeLagrangian\nLeptonHiggsGaugeLagrangian\n\
QuarkGluonLagrangian\nGaugeSelfLagrangian\nGluonSelfLagrangian\n\
GhostLagrangian\nFourLeptonLagrangian\nTwoQuarkTwoLeptonLagrangian\n\
DeltaLTwoLagrangian \nQuarkGaugeLagrangian\nQuarkHiggsGaugeLagrangian\n\
GaugeHiggsLagrangian\nGluonHiggsLagrangian\nFourQuarkLagrangian\n\
BLViolatingLagrangian\n\n",
  FontColor->RGBColor[1, 0.5, 0]],
 StyleBox["Feynman rules in Mathematica format are stored in variables with \
names which created replacing the name Lagrangian with Vertices e.g., ",
  FontColor->GrayLevel[0]],
 StyleBox["LeptonGaugeLagrangian",
  FontColor->RGBColor[1, 0.5, 0]],
 StyleBox[" --> ",
  FontColor->GrayLevel[0]],
 StyleBox["LeptonGaugeVertices.  ",
  FontColor->RGBColor[1, 0.5, 0]],
 StyleBox["See manual for more details.",
  FontColor->GrayLevel[0]]
}], "Text",
 CellChangeTimes->{{3.760967700121757*^9, 3.760967837832458*^9}, {
  3.760967892457384*^9, 3.760967942131999*^9}, {3.760967978167095*^9, 
  3.76096806112604*^9}, {3.76096865074478*^9, 3.760968669078927*^9}, {
  3.760968745411091*^9, 3.76096885676199*^9}, {3.760968902399165*^9, 
  3.7609690174538593`*^9}, {3.762608050819755*^9, 3.7626080608956337`*^9}, {
  3.762706589582067*^9, 3.762706678485591*^9}, {3.7627067257937307`*^9, 
  3.7627067432962103`*^9}},ExpressionUUID->"f313350c-1d2c-4368-bfe5-\
6b96e5fa8a28"],

Cell[TextData[StyleBox["In order to produce other output formats (Latex, \
WCxf, standard FeynRules interfaces)  it is now necessary to quit this \
session and run SmeftFR-interfaces.nb in new kernel. ", "Subsubsection",
 FontSize->18,
 FontColor->RGBColor[1, 0, 0]]], "Text",
 CellChangeTimes->{{3.7609718516030073`*^9, 3.760971884126149*^9}, {
   3.760972019693426*^9, 3.760972035541988*^9}, {3.760972264216045*^9, 
   3.76097229924479*^9}, {3.760972397547883*^9, 3.7609724005973063`*^9}, {
   3.7609764034779463`*^9, 3.760976406513885*^9}, {3.760976444313013*^9, 
   3.76097646068989*^9}, {3.76260806832465*^9, 3.7626080799267387`*^9}, {
   3.7627062596679897`*^9, 3.762706379479287*^9}, 3.7627065254191103`*^9, {
   3.762708845446312*^9, 
   3.762708845506092*^9}},ExpressionUUID->"09da4d35-4dea-4636-8fee-\
3250601a6016"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.7609718237924223`*^9, 3.760971832638661*^9}, 
   3.760972016377096*^9, {3.760976456243935*^9, 3.7609764569457407`*^9}, {
   3.7626080825748987`*^9, 3.7626080832330437`*^9}, 
   3.762708840723981*^9},ExpressionUUID->"7bb0c62f-5d58-40ff-a65d-\
38b7d9e103b9"]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1280, 681},
WindowMargins->{{2, Automatic}, {Automatic, 167}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
FrontEndVersion->"12.0 for Linux x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 1031, 19, 549, "Title",ExpressionUUID->"68b8f4ae-1b50-45fc-8fb7-0768ce1acaea"],
Cell[CellGroupData[{
Cell[1623, 45, 323, 5, 135, "Section",ExpressionUUID->"d8e28858-48c3-45e1-85e5-ba933fc1c3a2"],
Cell[1949, 52, 1783, 41, 414, "Input",ExpressionUUID->"eec34924-11ca-48a1-b401-77b9b8b2dc0f"],
Cell[3735, 95, 775, 22, 194, "Input",ExpressionUUID->"665e8197-75cc-4cc9-9080-ac98cfaa0526"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4547, 122, 260, 4, 135, "Section",ExpressionUUID->"e96c696a-2112-41de-8ea0-9c7f435d2c86"],
Cell[4810, 128, 3939, 65, 438, "Text",ExpressionUUID->"97700b4e-1d9c-426c-b9dc-bf15e463b8df"],
Cell[8752, 195, 651, 14, 61, "Input",ExpressionUUID->"0cfe60d7-00d7-4b2f-acbb-84bd78366b43"],
Cell[9406, 211, 441, 8, 116, "Text",ExpressionUUID->"836a4c87-506e-4704-8cbf-f6b2fe1ce40d"],
Cell[9850, 221, 441, 11, 106, "Input",ExpressionUUID->"1aff9ba6-77fc-4532-9a9b-57f8c4824de1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10328, 237, 322, 6, 212, "Section",ExpressionUUID->"bb8d404a-6d65-4d09-9078-5b1d41277730"],
Cell[10653, 245, 504, 9, 116, "Text",ExpressionUUID->"5c80957a-c351-45ae-afd8-bc6b567ce250"],
Cell[11160, 256, 907, 17, 106, "Input",ExpressionUUID->"da57e83a-0f4e-4f5c-9a9d-4abe589d4239"],
Cell[12070, 275, 442, 8, 70, "Text",ExpressionUUID->"03e8600d-52b8-43f0-9a80-f7be3ae8c54a"],
Cell[12515, 285, 225, 4, 61, "Input",ExpressionUUID->"e0cb00e0-a2e0-4254-a24d-c26028725f11"],
Cell[12743, 291, 359, 5, 70, "Text",ExpressionUUID->"13e460bb-6d9d-44a6-80d1-620651015275"],
Cell[13105, 298, 231, 4, 61, "Input",ExpressionUUID->"3aa68edc-d9be-42df-8329-4dffe9fc417d"],
Cell[13339, 304, 197, 3, 70, "Text",ExpressionUUID->"8d5215b7-5020-4eb9-86f5-bdb3de2155c3"],
Cell[13539, 309, 284, 6, 61, "Input",ExpressionUUID->"969602b1-d41a-4c1b-9aba-6a066885134c"],
Cell[13826, 317, 1496, 29, 1036, "Text",ExpressionUUID->"f313350c-1d2c-4368-bfe5-6b96e5fa8a28"],
Cell[15325, 348, 826, 13, 186, "Text",ExpressionUUID->"09da4d35-4dea-4636-8fee-3250601a6016"],
Cell[16154, 363, 305, 5, 61, "Input",ExpressionUUID->"7bb0c62f-5d58-40ff-a65d-38b7d9e103b9"]
}, Open  ]]
}, Open  ]]
}
]
*)

